// Targeted by JavaCPP version 1.5.6: DO NOT EDIT THIS FILE

package org.bytedeco.tensorflow;

import org.bytedeco.tensorflow.Allocator;
import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.tensorflow.global.tensorflow.*;


/** For each key, assigns the respective value to the specified component.
 * 
 *  If a key is not found in the barrier, this operation will create a new
 *  incomplete element. If a key is found in the barrier, and the element
 *  already has a value at component_index, this operation will fail with
 *  INVALID_ARGUMENT, and leave the barrier in an undefined state.
 * 
 *  Arguments:
 *  * scope: A Scope object
 *  * handle: The handle to a barrier.
 *  * keys: A one-dimensional tensor of keys, with length n.
 *  * values: An any-dimensional tensor of values, which are associated with the
 *  respective keys. The 0th dimension must have length n.
 *  * component_index: The component of the barrier elements that is being assigned.
 * 
 *  Returns:
 *  * the created {@code Operation} */
@Namespace("tensorflow::ops") @NoOffset @Properties(inherit = org.bytedeco.tensorflow.presets.tensorflow.class)
public class BarrierInsertMany extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public BarrierInsertMany(Pointer p) { super(p); }

  public BarrierInsertMany(@Const @ByRef Scope scope, @ByVal Input handle,
                    @ByVal Input keys, @ByVal Input values, @Cast("tensorflow::int64") long component_index) { super((Pointer)null); allocate(scope, handle, keys, values, component_index); }
  private native void allocate(@Const @ByRef Scope scope, @ByVal Input handle,
                    @ByVal Input keys, @ByVal Input values, @Cast("tensorflow::int64") long component_index);
  public native @ByVal @Name("operator tensorflow::Operation") Operation asOperation();

  public native @ByRef Operation operation(); public native BarrierInsertMany operation(Operation setter);
}
