// Targeted by JavaCPP version 1.5.6: DO NOT EDIT THIS FILE

package org.bytedeco.tensorflow;

import org.bytedeco.tensorflow.Allocator;
import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.tensorflow.global.tensorflow.*;


/** \defgroup logging_ops Logging Ops
 *  \{
 <p>
 *  Asserts that the given condition is true.
 * 
 *  If {@code condition} evaluates to false, print the list of tensors in {@code data}.
 *  {@code summarize} determines how many entries of the tensors to print.
 * 
 *  Arguments:
 *  * scope: A Scope object
 *  * condition: The condition to evaluate.
 *  * data: The tensors to print out when condition is false.
 * 
 *  Optional attributes (see {@code Attrs}):
 *  * summarize: Print this many entries of each tensor.
 * 
 *  Returns:
 *  * the created {@code Operation} */
@Namespace("tensorflow::ops") @NoOffset @Properties(inherit = org.bytedeco.tensorflow.presets.tensorflow.class)
public class Assert extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public Assert(Pointer p) { super(p); }

  /** Optional attribute setters for Assert */
  public static class Attrs extends Pointer {
      static { Loader.load(); }
      /** Default native constructor. */
      public Attrs() { super((Pointer)null); allocate(); }
      /** Native array allocator. Access with {@link Pointer#position(long)}. */
      public Attrs(long size) { super((Pointer)null); allocateArray(size); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public Attrs(Pointer p) { super(p); }
      private native void allocate();
      private native void allocateArray(long size);
      @Override public Attrs position(long position) {
          return (Attrs)super.position(position);
      }
      @Override public Attrs getPointer(long i) {
          return new Attrs((Pointer)this).offsetAddress(i);
      }
  
    /** Print this many entries of each tensor.
     * 
     *  Defaults to 3 */
    public native @ByVal Attrs Summarize(@Cast("tensorflow::int64") long x);

    public native @Cast("tensorflow::int64") long summarize_(); public native Attrs summarize_(long setter);
  }
  public Assert(@Const @ByRef Scope scope, @ByVal Input condition,
         @ByVal InputList data) { super((Pointer)null); allocate(scope, condition, data); }
  private native void allocate(@Const @ByRef Scope scope, @ByVal Input condition,
         @ByVal InputList data);
  public Assert(@Const @ByRef Scope scope, @ByVal Input condition,
         @ByVal InputList data, @Const @ByRef Attrs attrs) { super((Pointer)null); allocate(scope, condition, data, attrs); }
  private native void allocate(@Const @ByRef Scope scope, @ByVal Input condition,
         @ByVal InputList data, @Const @ByRef Attrs attrs);
  public native @ByVal @Name("operator tensorflow::Operation") Operation asOperation();

  public static native @ByVal Attrs Summarize(@Cast("tensorflow::int64") long x);

  public native @ByRef Operation operation(); public native Assert operation(Operation setter);
}
