// Targeted by JavaCPP version 1.5.6: DO NOT EDIT THIS FILE

package org.bytedeco.dnnl.global;

import org.bytedeco.dnnl.*;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.opencl.*;
import static org.bytedeco.opencl.global.OpenCL.*;

public class dnnl extends org.bytedeco.dnnl.presets.dnnl {
    static { Loader.load(); }

// Targeting ../dnnl_primitive_desc_vector.java


// Targeting ../primitive_vector.java


// Targeting ../IntMemoryMap.java


// Parsed from oneapi/dnnl/dnnl_types.h

/*******************************************************************************
* Copyright 2016-2021 Intel Corporation
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*******************************************************************************/

/** \file
/** C API types definitions */

// #ifndef ONEAPI_DNNL_DNNL_TYPES_H
// #define ONEAPI_DNNL_DNNL_TYPES_H

// #ifdef __cplusplus
// #endif

/** \cond DO_NOT_DOCUMENT_THIS */
// #include <stddef.h>
// #include <stdint.h>
/** \endcond
 <p>
 *  \addtogroup dnnl_api
 *  \{
 <p>
 *  \addtogroup dnnl_api_utils
 *  \{
 <p>
 *  Status values returned by the library functions. */
/** enum dnnl_status_t */
public static final int
    /** The operation was successful */
    dnnl_success = 0,
    /** The operation failed due to an out-of-memory condition */
    dnnl_out_of_memory = 1,
    /** The operation failed because of incorrect function arguments */
    dnnl_invalid_arguments = 2,
    /** The operation failed because requested functionality is not implemented */
    dnnl_unimplemented = 3,
    /** Primitive iterator passed over last primitive descriptor */
    dnnl_iterator_ends = 4,
    /** Primitive or engine failed on execution */
    dnnl_runtime_error = 5,
    /** Queried element is not required for given primitive */
    dnnl_not_required = 6;

/** \} dnnl_api_utils
 <p>
 *  \addtogroup dnnl_api_memory
 *  \{
 <p>
 *  Data type specification */
/** enum dnnl_data_type_t */
public static final int
    /** Undefined data type, used for empty memory descriptors. */
    dnnl_data_type_undef = 0,
    /** 16-bit/half-precision floating point. */
    dnnl_f16 = 1,
    /** non-standard 16-bit (bfloat16 w/ 7 bit mantissa) floating point. */
    dnnl_bf16 = 2,
    /** 32-bit/single-precision floating point. */
    dnnl_f32 = 3,
    /** 32-bit signed integer. */
    dnnl_s32 = 4,
    /** 8-bit signed integer. */
    dnnl_s8 = 5,
    /** 8-bit unsigned integer. */
    dnnl_u8 = 6;

/** Memory format kind */
/** enum dnnl_format_kind_t */
public static final int
    /** Undefined memory format kind, used for empty memory descriptors. */
    dnnl_format_kind_undef = 0,
    /** Unspecified format kind.
     *  The primitive selects a format automatically. */
    dnnl_format_kind_any = 1,
    /** A tensor in a generic format described by the stride and blocking
     *  values in each dimension. See \ref dnnl_blocking_desc_t for more
     *  information. */
    dnnl_blocked = 2,
    /** Weights format used in 8bit Winograd convolution */
    dnnl_format_kind_wino = 3,
    /** Packed weights format used in RNN */
    dnnl_format_kind_rnn_packed = 4;

/** Memory format tag specification.
 * 
 *  oneDNN formats describe physical data layout. The physical layout
 *  is described as a sequence of the dimensions as they are laid out in the
 *  memory (from the outer-most to the inner-most). Note that this order
 *  doesn't affect the logical order of the dimensions that is kept in the
 *  {@code dims} field of the dnnl_memory_desc_t structure. The logical order of the
 *  dimensions is specified by the primitive that uses the tensor.
 * 
 *  For example, CNN 5D tensor always has its logical dimensions in the order
 *  {@code (batch, channels, depth, height, width)}, while the physical layout might be
 *  {@code NCDHW} (corresponds to #dnnl_ncdhw format tag) or
 *  {@code NDHWC} (corresponds to #dnnl_ndhwc format tag).
 * 
 *  ~~~cpp
 *  int batch = 2, channels = 16, depth = 13, height = 13, width = 13;
 * 
 *  int ndims = 5; // 5D tensor
 *  dnnl_dims_t dims = {batch, channels, depth, height, width};
 *  dnnl_memory_desc_t data_in_ncdhw;
 *  dnnl_memory_desc_init_by_tag(
 *       &data_in_ncdhw, 5, dims, dnnl_f32, dnnl_ncdhw);
 * 
 *  // note that in both cases dims passed are the same
 *  dnnl_memory_desc_t data_in_ndhwc;
 *  dnnl_memory_desc_init_by_tag(
 *       &data_in_ndhwc, 5, dims, dnnl_f32, dnnl_ndhwc);
 *  ~~~
 * 
 *  Memory format tags can be further divided into two categories:
 *   - Domain-agnostic names, i.e. names the do not depend on the tensor usage
 *     in the specific primitive. These names use letters from {@code a} to {@code l} to
 *     denote logical dimension from 1 to 12, and form the order in which the
 *     dimensions are laid in memory. For instance, #dnnl_ab is used to denote
 *     2D tensor where the second logical dimension (aka {@code b}) is the innermost,
 *     i.e. has stride = 1, and the first logical dimension ({@code a}) laid out in
 *     memory with stride equal to the size of second dimension. On the other
 *     hand, #dnnl_ba is just transposed version of the same tensor: the
 *     first dimension ({@code a}) becomes the innermost one.
 *   - Domain-specific names, i.e. names that make sense only in the context of
 *     a certain domain, such as CNN. This names are just aliases to the
 *     corresponding domain-agnostic tags and used mostly for the convenience.
 *     For example, #dnnl_nc is used to denote 2D CNN activations tensor
 *     memory format, where channels are the innermost dimension and batch is an
 *     outermost one. Moreover, #dnnl_nc is just an alias to #dnnl_ab,
 *     since for oneDNN CNN primitives the logical dimensions of
 *     activations tensors come in order: batch, channels, spatial.
 *     In other words, batch corresponds to the first logical dimension ({@code a}),
 *     channels correspond to the second one ({@code b}).
 * 
 *  The following domain-specific notation applies to memory format tags:
 *   - \c 'n' denotes the mini-batch dimension
 *   - \c 'c' denotes a channels dimension
 *   - When there are multiple channel dimensions (for example, in convolution
 *     weights tensor), \c 'i' and \c 'o' denote dimensions of input and output
 *     channels
 *   - \c 'd', \c 'h', and \c 'w' denote spatial depth, height, and width
 *     respectively
 * 
 *  Upper-case letters indicate that the data is laid out in blocks for a
 *  particular dimension. In such cases, the format name contains both upper-
 *  and lower-case letters for that dimension with a lower-case letter preceded
 *  by the block size. For example: #dnnl_nChw8c describes a format where the
 *  outermost dimension is mini-batch, followed by the channel block number,
 *  followed by the spatial height and width, and finally followed by 8-element
 *  channel blocks.
 * 
 *  @see \ref dev_guide_understanding_memory_formats */
/** enum dnnl_format_tag_t */
public static final int
    /** Undefined memory format tag */
    dnnl_format_tag_undef = 0,
    /** Undefined memory format tag.
     *  The primitive selects a format automatically. */
    dnnl_format_tag_any = 1,

    // Semantic agnostic section
    // The physical order of dimensions is defined by the permutation of the
    // characters, assuming that ab..z defines the natural order.

    // Plain formats

    /** plain 1D tensor */
    dnnl_a = 2,
    /** plain 2D tensor */
    dnnl_ab = 3,
    /** plain 3D tensor */
    dnnl_abc = 4,
    /** plain 4D tensor */
    dnnl_abcd = 5,
    /** plain 4D tensor */
    dnnl_acbd = 6,
    /** plain 5D tensor */
    dnnl_abcde = 7,
    /** plain 6D tensor */
    dnnl_abcdef = 8,
    /** plain 7D tensor */
    dnnl_abcdefg = 9,
    /** plain 8D tensor */
    dnnl_abcdefgh = 10,
    /** plain 9D tensor */
    dnnl_abcdefghi = 11,
    /** plain 10D tensor */
    dnnl_abcdefghij = 12,
    /** plain 11D tensor */
    dnnl_abcdefghijk = 13,
    /** plain 12D tensor */
    dnnl_abcdefghijkl = 14,

    // Permuted plain formats

    /** permuted 4D tensor */
    dnnl_abdc = 15,
    /** permuted 5D tensor */
    dnnl_abdec = 16,
    /** permuted 3D tensor */
    dnnl_acb = 17,
    /** permuted 5D tensor */
    dnnl_acbde = 18,
    /** permuted 6D tensor */
    dnnl_acbdef = 19,
    /** permuted 4D tensor */
    dnnl_acdb = 20,
    /** permuted 5D tensor */
    dnnl_acdeb = 21,
    /** permuted 2D tensor */
    dnnl_ba = 22,
    /** permuted 3D tensor */
    dnnl_bac = 23,
    /** permuted 4D tensor */
    dnnl_bacd = 24,
    /** permuted 5D tensor */
    dnnl_bacde = 25,
    /** permuted 3D tensor */
    dnnl_bca = 26,
    /** permuted 4D tensor */
    dnnl_bcda = 27,
    /** permuted 5D tensor */
    dnnl_bcdea = 28,
    /** permuted 3D tensor */
    dnnl_cba = 29,
    /** permuted 4D tensor */
    dnnl_cdba = 30,
    /** permuted 4D tensor */
    dnnl_dcab = 31,
    /** permuted 5D tensor */
    dnnl_cdeba = 32,
    /** permuted 5D tensor */
    dnnl_decab = 33,
    /** permuted 6D tensor */
    dnnl_defcab = 34,
    /** permuted 5D tensor */
    dnnl_abced = 35,
    /** permuted 6D tensor */
    dnnl_abcdfe = 36,
    /** permuted 7D tensor */
    dnnl_abcdegf = 37,
    /** permuted 8D tensor */
    dnnl_abcdefhg = 38,
    /** permuted 9D tensor */
    dnnl_abcdefgih = 39,
    /** permuted 10D tensor */
    dnnl_abcdefghji = 40,
    /** permuted 11D tensor */
    dnnl_abcdefghikj = 41,
    /** permuted 12D tensor */
    dnnl_abcdefghijlk = 42,

    // Opaque blocked formats

    dnnl_Abc16a = 43,
    dnnl_ABc16a16b = 44,
    dnnl_ABc32a32b = 45,
    dnnl_ABc4a4b = 46,
    /** 3D tensor blocked by 2nd dimension with block size 16 */
    dnnl_aBc16b = 47,
    dnnl_ABc16b16a = 48,
    dnnl_Abc4a = 49,
    /** 3D tensor blocked by 2nd dimension with block size 32 */
    dnnl_aBc32b = 50,
    /** 3D tensor blocked by 2nd dimension with block size 4 */
    dnnl_aBc4b = 51,
    dnnl_ABc4b16a4b = 52,
    dnnl_ABc2b8a4b = 53,
    dnnl_ABc16b16a4b = 54,
    dnnl_ABc16b16a2b = 55,
    dnnl_ABc4b4a = 56,
    dnnl_ABc8a16b2a = 57,
    dnnl_ABc8a8b = 58,
    dnnl_ABc8a4b = 59,
    /** 3D tensor blocked by 2nd dimension with block size 8 */
    dnnl_aBc8b = 60,
    dnnl_ABc8b16a2b = 61,
    dnnl_BAc8a16b2a = 62,
    dnnl_ABc8b8a = 63,
    dnnl_Abcd16a = 64,
    dnnl_Abcd8a = 65,
    dnnl_ABcd16a16b = 66,
    dnnl_Abcd32a = 67,
    dnnl_ABcd32a32b = 68,
    /** 4D tensor blocked by 2nd dimension with block size 16 */
    dnnl_aBcd16b = 69,
    dnnl_ABcd16b16a = 70,
    dnnl_aBCd16b16c = 71,
    dnnl_aBCd16c16b = 72,
    dnnl_Abcd4a = 73,
    /** 4D tensor blocked by 2nd dimension with block size 32 */
    dnnl_aBcd32b = 74,
    /** 4D tensor blocked by 2nd dimension with block size 4 */
    dnnl_aBcd4b = 75,
    dnnl_ABcd4b16a4b = 76,
    dnnl_ABcd16b16a4b = 77,
    dnnl_ABcd16b16a2b = 78,
    dnnl_ABcd4b4a = 79,
    dnnl_ABcd4a4b = 80,
    dnnl_aBCd2c4b2c = 81,
    dnnl_aBCd4b8c2b = 82,
    dnnl_aBCd4c16b4c = 83,
    dnnl_aBCd2c8b4c = 84,
    dnnl_aBCd16c16b4c = 85,
    dnnl_aBCd16c16b2c = 86,
    dnnl_aBCd4c4b = 87,
    dnnl_aBCd4b4c = 88,
    dnnl_ABcd8a16b2a = 89,
    dnnl_ABcd2b8a4b = 90,
    dnnl_ABcd8a8b = 91,
    dnnl_ABcd8a4b = 92,
    /** 4D tensor blocked by 2nd dimension with block size 8 */
    dnnl_aBcd8b = 93,
    dnnl_aBCd4c8b2c = 94,
    dnnl_ABcd8b16a2b = 95,
    dnnl_aBCd8b16c2b = 96,
    dnnl_BAcd8a16b2a = 97,
    /** 4D tensor blocked by 1st and 2nd dimension with block size 8 */
    dnnl_ABcd8b8a = 98,
    dnnl_aBCd8b8c = 99,
    dnnl_aBCd8b4c = 100,
    dnnl_aBCd8c16b2c = 101,
    dnnl_ABcde8a16b2a = 102,
    dnnl_aCBd8b16c2b = 103,
    dnnl_aBCd8c8b = 104,
    dnnl_Abcde16a = 105,
    dnnl_Abcde32a = 106,
    dnnl_ABcde16a16b = 107,
    dnnl_BAcde8a16b2a = 108,
    /** 4D tensor blocked by 3rd dimension with block size 4 */
    dnnl_aBCd2b4c2b = 109,
    /** 5D tensor blocked by 1st dimension with block size 16 */
    dnnl_ABcde4b16a4b = 110,
    /** 5D tensor blocked by 1st dimension with block size 8 */
    dnnl_ABcde2b8a4b = 111,
    /** 5D tensor blocked by 2nd dimension with block size 16 */
    dnnl_aBcde16b = 112,
    dnnl_ABcde16b16a = 113,
    dnnl_aBCde16b16c = 114,
    dnnl_aBCde16c16b = 115,
    dnnl_aBCde2c8b4c = 116,
    dnnl_Abcde4a = 117,
    /** 5D tensor blocked by 2nd dimension with block size 32 */
    dnnl_aBcde32b = 118,
    /** 5D tensor blocked by 2nd dimension with block size 4 */
    dnnl_aBcde4b = 119,
    dnnl_ABcde4b4a = 120,
    dnnl_ABcde4a4b = 121,
    dnnl_aBCde4b4c = 122,
    dnnl_aBCde2c4b2c = 123,
    dnnl_aBCde4b8c2b = 124,
    dnnl_aBCde4c16b4c = 125,
    dnnl_aBCde16c16b4c = 126,
    dnnl_aBCde16c16b2c = 127,
    dnnl_aBCde4c4b = 128,
    dnnl_Abcde8a = 129,
    dnnl_ABcde8a8b = 130,
    dnnl_ABcde8a4b = 131,
    dnnl_BAcde16b16a = 132,
    /** 5D tensor blocked by 2nd dimension with block size 8 */
    dnnl_aBcde8b = 133,
    dnnl_ABcde8b16a2b = 134,
    dnnl_aBCde8b16c2b = 135,
    dnnl_aBCde4c8b2c = 136,
    dnnl_aCBde8b16c2b = 137,
    dnnl_ABcde8b8a = 138,
    dnnl_ABcde32a32b = 139,
    dnnl_aBCde8b8c = 140,
    dnnl_aBCde8b4c = 141,
    dnnl_ABc4a8b8a4b = 142,
    dnnl_ABcd4a8b8a4b = 143,
    dnnl_ABcde4a8b8a4b = 144,
    dnnl_BAc4b8a8b4a = 145,
    dnnl_BAcd4b8a8b4a = 146,
    dnnl_BAcde4b8a8b4a = 147,
    dnnl_ABcd2a8b8a2b = 148,
    dnnl_aBCd4b8c8b4c = 149,
    dnnl_aBCde4b8c8b4c = 150,
    dnnl_aBCde2b8c8b2c = 151,
    dnnl_aBCde8c16b2c = 152,
    dnnl_aBCde8c8b = 153,
    /** 5D tensor blocked by 3rd dimension with block size 4 */
    dnnl_aBCde2b4c2b = 154,
    /** 6D tensor blocked by 2nd dimension with block size 16 */
    dnnl_aBcdef16b = 155,
    dnnl_aBCdef16b16c = 156,
    dnnl_aBCdef16c16b = 157,
    dnnl_aBCdef4c16b4c = 158,
    /** 6D tensor blocked by 2nd dimension with block size 8 */
    dnnl_aBCdef2c8b4c = 159,
    dnnl_aBCdef4c8b2c = 160,
    /** 6D tensor blocked by 3rd dimension with block size 4 */
    dnnl_aBCdef2b4c2b = 161,
    /** 6D tensor blocked by 2nd dimension with block size 4 */
    dnnl_aBcdef4b = 162,
    dnnl_aBCdef4c4b = 163,
    dnnl_aBCdef4b4c = 164,
    dnnl_aBCdef2c4b2c = 165,
    dnnl_aBCdef4b8c2b = 166,
    dnnl_aBCdef8b8c = 167,
    dnnl_aBCdef8b4c = 168,
    dnnl_aBCdef8c16b2c = 169,
    dnnl_aBCdef4b8c8b4c = 170,
    dnnl_aBCdef8b16c2b = 171,
    dnnl_aCBdef8b16c2b = 172,
    dnnl_aBCdef8c8b = 173,
    dnnl_aBdc16b = 174,
    dnnl_aBdC16b2c = 175,
    dnnl_aBdC16b4c = 176,
    dnnl_aBdc4b = 177,
    dnnl_aBdc8b = 178,
    dnnl_aBdec16b = 179,
    dnnl_aBdeC16b2c = 180,
    dnnl_aBdeC16b4c = 181,
    dnnl_aBdec32b = 182,
    dnnl_aBdec4b = 183,
    dnnl_aBdec8b = 184,
    dnnl_aBdefc16b = 185,
    dnnl_aBdefC16b2c = 186,
    dnnl_aCBdef16c16b = 187,
    dnnl_aBdefc4b = 188,
    dnnl_aBdefc8b = 189,
    dnnl_Abcdef16a = 190,
    dnnl_Abcdef32a = 191,
    dnnl_aBedc16b = 192,
    dnnl_Acb16a = 193,
    dnnl_AcB16a2b = 194,
    dnnl_AcB16a4b = 195,
    dnnl_Acb4a = 196,
    dnnl_Acb8a = 197,
    dnnl_aCBd16b16c = 198,
    dnnl_aCBd16c16b = 199,
    dnnl_aCBde16b16c = 200,
    dnnl_aCBde16c16b = 201,
    dnnl_Acdb16a = 202,
    dnnl_AcdB16a2b = 203,
    dnnl_AcdB16a4b = 204,
    dnnl_Acdb32a = 205,
    dnnl_Acdb4a = 206,
    dnnl_Acdb8a = 207,
    dnnl_Acdeb16a = 208,
    dnnl_AcdeB16a2b = 209,
    dnnl_Acdeb4a = 210,
    dnnl_Acdeb8a = 211,
    dnnl_Adcb16a = 212,
    dnnl_BAc16a16b = 213,
    dnnl_BAc16b16a = 214,
    dnnl_BAcd16a16b = 215,
    dnnl_BAcd16b16a = 216,
    dnnl_aCBd4c8b8c4b = 217,
    dnnl_aCBde4c8b8c4b = 218,
    dnnl_aCBdef4c8b8c4b = 219,
    dnnl_BAcde16a16b = 220,
    dnnl_aCBdef16b16c = 221,
    /** permuted 6D tensor */
    dnnl_abdfce = 222,
    /** permuted 6D tensor */
    dnnl_abdefc = 223,
    dnnl_ABc16b32a = 224,
    dnnl_ABc16b64a = 225,
    dnnl_ABc4b32a4b = 226,
    dnnl_ABc4b64a4b = 227,
    dnnl_ABc8b32a2b = 228,
    dnnl_ABc8b64a2b = 229,
    dnnl_AB16b16a = 230,
    dnnl_AB16b32a = 231,
    dnnl_AB16b64a = 232,
    dnnl_AB8b16a2b = 233,
    dnnl_AB8b32a2b = 234,
    dnnl_AB8b64a2b = 235,
    dnnl_AB4b16a4b = 236,
    dnnl_AB4b32a4b = 237,
    dnnl_AB4b64a4b = 238,
    dnnl_AB16b16a4b = 239,
    dnnl_ABcd16b32a = 240,
    dnnl_ABcd16b64a = 241,
    dnnl_ABcd4b32a4b = 242,
    dnnl_ABcd4b64a4b = 243,
    dnnl_ABcd8b32a2b = 244,
    dnnl_ABcd8b64a2b = 245,
    dnnl_ABcde4b32a4b = 246,
    dnnl_ABcde4b64a4b = 247,
    dnnl_ABcde16b16a4b = 248,
    dnnl_ABcde16b16a2b = 249,
    dnnl_ABcde16b32a = 250,
    dnnl_ABcde16b64a = 251,
    dnnl_ABcde8b32a2b = 252,
    dnnl_ABcde8b64a2b = 253,
    dnnl_aBCdef16c16b4c = 254,
    dnnl_aBCdef16c16b2c = 255,
    dnnl_AB32a32b8a4b = 256,
    dnnl_AB8a4b = 257,
    dnnl_AB32a32b8a2b = 258,
    dnnl_AB8a2b = 259,
    dnnl_abDc32d = 260,
    dnnl_abDC32d4c = 261,
    dnnl_abdEc32e = 262,
    dnnl_abdEC32e2c = 263,
    dnnl_abdEC32e4c = 264,
    dnnl_aBdefC16b4c = 265,
    dnnl_AcdeB16a4b = 266,
    dnnl_ABcd16a16b2a = 267,
    dnnl_ABc16a16b2a = 268,
    dnnl_aBCd16b16c2b = 269,
    dnnl_aBCde16b16c2b = 270,
    dnnl_Acb32a = 271,
    dnnl_AcB32a2b = 272,
    dnnl_AcB32a4b = 273,
    dnnl_Acb48a = 274,
    dnnl_AcB48a2b = 275,
    dnnl_AcB48a4b = 276,
    dnnl_Acb64a = 277,
    dnnl_AcB64a2b = 278,
    dnnl_AcB64a4b = 279,
    dnnl_cBa2b = 280,
    dnnl_cBa4b = 281,
    dnnl_aBdc32b = 282,
    dnnl_aBdC32b2c = 283,
    dnnl_aBdC32b4c = 284,
    dnnl_aBdc48b = 285,
    dnnl_aBdC48b2c = 286,
    dnnl_aBdC48b4c = 287,
    dnnl_aBdc64b = 288,
    dnnl_aBdC64b2c = 289,
    dnnl_aBdC64b4c = 290,
    dnnl_adcb = 291,
    dnnl_adCb2c = 292,
    dnnl_adCb4c = 293,
    dnnl_AcdB32a2b = 294,
    dnnl_AcdB32a4b = 295,
    dnnl_Acdb48a = 296,
    dnnl_AcdB48a2b = 297,
    dnnl_AcdB48a4b = 298,
    dnnl_Acdb64a = 299,
    dnnl_AcdB64a2b = 300,
    dnnl_AcdB64a4b = 301,
    dnnl_cdBa2b = 302,
    dnnl_cdBa4b = 303,
    dnnl_aBdeC32b2c = 304,
    dnnl_aBdeC32b4c = 305,
    dnnl_aBdec48b = 306,
    dnnl_aBdeC48b2c = 307,
    dnnl_aBdeC48b4c = 308,
    dnnl_aBdec64b = 309,
    dnnl_aBdeC64b2c = 310,
    dnnl_aBdeC64b4c = 311,
    dnnl_adecb = 312,
    dnnl_adeCb2c = 313,
    dnnl_adeCb4c = 314,
    dnnl_Acdeb32a = 315,
    dnnl_AcdeB32a2b = 316,
    dnnl_AcdeB32a4b = 317,
    dnnl_Acdeb48a = 318,
    dnnl_AcdeB48a2b = 319,
    dnnl_AcdeB48a4b = 320,
    dnnl_Acdeb64a = 321,
    dnnl_AcdeB64a2b = 322,
    dnnl_AcdeB64a4b = 323,
    dnnl_cdeBa2b = 324,
    dnnl_cdeBa4b = 325,
    dnnl_aBdefc32b = 326,
    dnnl_aBdefC32b2c = 327,
    dnnl_aBdefC32b4c = 328,
    dnnl_aBdefc48b = 329,
    dnnl_aBdefC48b2c = 330,
    dnnl_aBdefC48b4c = 331,
    dnnl_aBdefc64b = 332,
    dnnl_aBdefC64b2c = 333,
    dnnl_aBdefC64b4c = 334,
    dnnl_adefcb = 335,
    dnnl_adefCb2c = 336,
    dnnl_adefCb4c = 337,
    dnnl_AB16b32a4b = 338,
    dnnl_AB16b48a4b = 339,
    dnnl_AB16b64a4b = 340,
    dnnl_AB16b16a2b = 341,
    dnnl_AB16b32a2b = 342,
    dnnl_AB16b48a2b = 343,
    dnnl_AB16b64a2b = 344,
    dnnl_ABc16b32a4b = 345,
    dnnl_ABc16b48a4b = 346,
    dnnl_ABc16b64a4b = 347,
    dnnl_ABc16b32a2b = 348,
    dnnl_ABc16b48a2b = 349,
    dnnl_ABc16b64a2b = 350,
    dnnl_ABcd16b32a4b = 351,
    dnnl_ABcd16b48a4b = 352,
    dnnl_ABcd16b64a4b = 353,
    dnnl_ABcd16b32a2b = 354,
    dnnl_ABcd16b48a2b = 355,
    dnnl_ABcd16b64a2b = 356,
    dnnl_ABcde16b32a4b = 357,
    dnnl_ABcde16b48a4b = 358,
    dnnl_ABcde16b64a4b = 359,
    dnnl_ABcde16b32a2b = 360,
    dnnl_ABcde16b48a2b = 361,
    dnnl_ABcde16b64a2b = 362,
    dnnl_ABc32a16b = 363,
    dnnl_ABcd32a16b = 364,
    dnnl_ABcde32a16b = 365,
    dnnl_AB48a16b = 366,
    dnnl_AB48a32b = 367,
    dnnl_ABc40a16b = 368,
    dnnl_ABc40a32b = 369,
    dnnl_aBC48b16c = 370,
    dnnl_aBC48b32c = 371,
    dnnl_ABcd40a16b = 372,
    dnnl_ABcd40a32b = 373,
    dnnl_abCd32c = 374,
    dnnl_abdCe32c = 375,
    dnnl_abdCE32c2e = 376,
    dnnl_BA16a16b2a = 377,
    dnnl_BA16a32b2a = 378,
    dnnl_BA16a48b2a = 379,
    dnnl_BA16a64b2a = 380,
    dnnl_BA16a16b4a = 381,
    dnnl_BA16a32b4a = 382,
    dnnl_BA16a48b4a = 383,
    dnnl_BA16a64b4a = 384,

    /** Just a sentinel, not real memory format tag. Must be changed after new
     *  format tag is added. */
    dnnl_format_tag_last = 385,

    // Aliases

    /** 1D tensor, an alias to #dnnl_a */
    dnnl_x = dnnl_a,
    /** 2D CNN activations tensor, an alias to #dnnl_ab */
    dnnl_nc = dnnl_ab,
    /** 2D CNN activations tensor, an alias to #dnnl_ba */
    dnnl_cn = dnnl_ba,
    /** 2D RNN statistics tensor, an alias to #dnnl_ab */
    dnnl_tn = dnnl_ab,
    /** 2D RNN statistics tensor, an alias to #dnnl_ba */
    dnnl_nt = dnnl_ba,
    /** 3D CNN activations tensor, an alias to #dnnl_abc */
    dnnl_ncw = dnnl_abc,
    /** 3D CNN activations tensor, an alias to #dnnl_acb */
    dnnl_nwc = dnnl_acb,
    /** 4D CNN activations tensor, an alias to #dnnl_abcd */
    dnnl_nchw = dnnl_abcd,
    /** 4D CNN activations tensor, an alias to #dnnl_acdb */
    dnnl_nhwc = dnnl_acdb,
    /** 4D CNN activations tensor, an alias to #dnnl_bcda */
    dnnl_chwn = dnnl_bcda,
    /** 5D CNN activations tensor, an alias to #dnnl_abcde */
    dnnl_ncdhw = dnnl_abcde,
    /** 5D CNN activations tensor, an alias to #dnnl_acdeb */
    dnnl_ndhwc = dnnl_acdeb,

    /** 2D CNN weights tensor, an alias to #dnnl_ab */
    dnnl_oi = dnnl_ab,
    /** 2D CNN weights tensor, an alias to #dnnl_ba */
    dnnl_io = dnnl_ba,
    /** 3D CNN weights tensor, an alias to #dnnl_abc */
    dnnl_oiw = dnnl_abc,
    /** 3D CNN weights tensor, an alias to #dnnl_acb */
    dnnl_owi = dnnl_acb,
    /** 3D CNN weights tensor, an alias to #dnnl_cba */
    dnnl_wio = dnnl_cba,
    /** 3D CNN weights tensor, an alias to #dnnl_bca */
    dnnl_iwo = dnnl_bca,
    /** 4D CNN weights tensor, an alias to #dnnl_abcd */
    dnnl_oihw = dnnl_abcd,
    /** 4D CNN weights tensor, an alias to #dnnl_cdba */
    dnnl_hwio = dnnl_cdba,
    /** 4D CNN weights tensor, an alias to #dnnl_acdb */
    dnnl_ohwi = dnnl_acdb,
    /** 4D CNN weights tensor, an alias to #dnnl_bcda */
    dnnl_ihwo = dnnl_bcda,
    /** 4D CNN weights tensor, an alias to #dnnl_bacd */
    dnnl_iohw = dnnl_bacd,
    /** 5D CNN weights tensor, an alias to #dnnl_abcde */
    dnnl_oidhw = dnnl_abcde,
    /** 5D CNN weights tensor, an alias to #dnnl_bacde */
    dnnl_iodhw = dnnl_bacde,
    /** 5D CNN weights tensor, an alias to #dnnl_cdeba */
    dnnl_dhwio = dnnl_cdeba,
    /** 5D CNN weights tensor, an alias to #dnnl_acdeb */
    dnnl_odhwi = dnnl_acdeb,
    /** 5D CNN weights tensor, an alias to #dnnl_bcdea */
    dnnl_idhwo = dnnl_bcdea,

    /** 4D CNN weights tensor (incl. groups), an alias to #dnnl_abcd */
    dnnl_goiw = dnnl_abcd,
    /** 4D CNN weights tensor (incl. groups), an alias to #dnnl_abdc */
    dnnl_gowi = dnnl_abdc,
    /** 4D CNN weights tensor (incl. groups), an alias to #dnnl_dcab */
    dnnl_wigo = dnnl_dcab,
    /** 5D CNN weights tensor (incl. groups), an alias to #dnnl_abcde */
    dnnl_goihw = dnnl_abcde,
    /** 5D CNN weights tensor (incl. groups), an alias to #dnnl_abdec */
    dnnl_gohwi = dnnl_abdec,
    /** 5D CNN weights tensor (incl. groups), an alias to #dnnl_decab */
    dnnl_hwigo = dnnl_decab,
    /** 5D CNN weights tensor (incl. groups), an alias to #dnnl_acbde */
    dnnl_giohw = dnnl_acbde,
    /** 6D CNN weights tensor (incl. groups), an alias to #dnnl_abcdef */
    dnnl_goidhw = dnnl_abcdef,
    /** 6D CNN weights tensor (incl. groups), an alias to #dnnl_abdefc */
    dnnl_godhwi = dnnl_abdefc,
    /** 6D CNN weights tensor (incl. groups), an alias to #dnnl_acbdef */
    dnnl_giodhw = dnnl_acbdef,
    /** 6D CNN weights tensor (incl. groups), an alias to #dnnl_defcab */
    dnnl_dhwigo = dnnl_defcab,

    /** 3D RNN data tensor in the format (seq_length, batch, input channels),
     *  an alias to #dnnl_abc. */
    dnnl_tnc = dnnl_abc,
    /** 3D RNN data tensor in the format (batch, seq_length, input channels),
     *  an alias to #dnnl_bac. */
    dnnl_ntc = dnnl_bac,
    /** 4D RNN states tensor in the format (num_layers, num_directions,
     *  batch, state channels), an alias to #dnnl_abcd. */
    
///
    dnnl_ldnc = dnnl_abcd,
    /** 5D RNN weights tensor in the format (num_layers, num_directions,
     *  input_channels, num_gates, output_channels), an alias to #dnnl_abcde.
     * 
     *   - For LSTM cells, the gates order is input, forget, candidate
     *     and output gate.
     *   - For GRU cells, the gates order is update, reset and output gate. */
    
///
    dnnl_ldigo = dnnl_abcde,
    /** 5D RNN weights tensor in the format (num_layers, num_directions,
     *  num_gates, output_channels, input_channels), an alias to #dnnl_abdec.
     * 
     *   - For LSTM cells, the gates order is input, forget, candidate
     *     and output gate.
     *   - For GRU cells, the gates order is update, reset and output gate. */
    dnnl_ldgoi = dnnl_abdec,
    /** 4D LSTM projection tensor in the format (num_layers, num_directions,
     *  num_channels_in_hidden_state, num_channels_in_recurrent_projection),
     *  an alias to #dnnl_abcd. */
    dnnl_ldio = dnnl_abcd,
    /** 4D LSTM projection tensor in the format (num_layers, num_directions,
     *  num_channels_in_recurrent_projection, num_channels_in_hidden_state),
     *  an alias to #dnnl_abdc. */
    
///
    dnnl_ldoi = dnnl_abdc,
    /** 4D RNN bias tensor in the format (num_layers, num_directions,
     *  num_gates, output_channels), an alias to #dnnl_abcd.
     * 
     *   - For LSTM cells, the gates order is input, forget, candidate
     *     and output gate.
     *   - For GRU cells, the gates order is update, reset and output gate. */
    dnnl_ldgo = dnnl_abcd,
    /** 5D LSTM projection tensor */
    dnnl_ldOi32o = dnnl_abDc32d,
    dnnl_ldOI32o4i = dnnl_abDC32d4c,
    dnnl_ldIo32i = dnnl_abCd32c,
    /** 6D RNN weights tensor */
    dnnl_ldgOi32o = dnnl_abdEc32e,
    dnnl_ldgOI32o2i = dnnl_abdEC32e2c,
    dnnl_ldgOI32o4i = dnnl_abdEC32e4c,
    dnnl_ldgIo32i = dnnl_abdCe32c,
    dnnl_ldgIO32i2o = dnnl_abdCE32c2e,

    // Opaque data types, are not to be used explicitly

    // data
    /** 5D CNN activations tensor blocked by channels with block size 32,
     *  an alias to #dnnl_aBcde32b */
    dnnl_nCdhw32c = dnnl_aBcde32b,
    /** 5D CNN activations tensor blocked by channels with block size 16,
     *  an alias to #dnnl_aBcde16b */
    dnnl_nCdhw16c = dnnl_aBcde16b,
    /** 5D CNN activations tensor blocked by channels with block size 4,
     *  an alias to #dnnl_aBcde4b */
    dnnl_nCdhw4c = dnnl_aBcde4b,
    /** 5D CNN activations tensor blocked by channels with block size 8,
     *  an alias to #dnnl_aBcde8b */
    dnnl_nCdhw8c = dnnl_aBcde8b,
    /** 4D CNN activations tensor blocked by channels with block size 32,
     *  an alias to #dnnl_aBcd32b */
    dnnl_nChw32c = dnnl_aBcd32b,
    /** 4D CNN activations tensor blocked by channels with block size 16,
     *  an alias to #dnnl_aBcd16b */
    dnnl_nChw16c = dnnl_aBcd16b,
    /** 4D CNN activations tensor blocked by channels with block size 4,
     *  an alias to #dnnl_aBcd4b */
    dnnl_nChw4c = dnnl_aBcd4b,
    /** 4D CNN activations tensor blocked by channels with block size 8,
     *  an alias to #dnnl_aBcd8b */
    dnnl_nChw8c = dnnl_aBcd8b,
    /** 3D CNN activations tensor blocked by channels with block size 32,
     *  an alias to #dnnl_aBc32b */
    dnnl_nCw32c = dnnl_aBc32b,
    /** 3D CNN activations tensor blocked by channels with block size 16,
     *  an alias to #dnnl_aBc16b */
    dnnl_nCw16c = dnnl_aBc16b,
    /** 3D CNN activations tensor blocked by channels with block size 4,
     *  an alias to #dnnl_aBc4b */
    dnnl_nCw4c = dnnl_aBc4b,
    /** 3D CNN activations tensor blocked by channels with block size 8,
     *  an alias to #dnnl_aBc8b */
    dnnl_nCw8c = dnnl_aBc8b,
    dnnl_NCw16n16c = dnnl_ABc16a16b,
    dnnl_NCdhw16n16c = dnnl_ABcde16a16b,
    dnnl_NChw16n16c = dnnl_ABcd16a16b,
    dnnl_NCw32n16c = dnnl_ABc32a16b,
    dnnl_NChw32n16c = dnnl_ABcd32a16b,
    dnnl_NCdhw32n16c = dnnl_ABcde32a16b,
    dnnl_NCw32n32c = dnnl_ABc32a32b,
    dnnl_NChw32n32c = dnnl_ABcd32a32b,
    dnnl_NCdhw32n32c = dnnl_ABcde32a32b,

    // weights, 2D
    dnnl_OI16i16o = dnnl_AB16b16a,
    dnnl_OI16i32o = dnnl_AB16b32a,
    dnnl_OI16i64o = dnnl_AB16b64a,
    dnnl_OI8i16o2i = dnnl_AB8b16a2b,
    dnnl_OI8i32o2i = dnnl_AB8b32a2b,
    dnnl_OI8i64o2i = dnnl_AB8b64a2b,
    dnnl_OI4i16o4i = dnnl_AB4b16a4b,
    dnnl_OI4i32o4i = dnnl_AB4b32a4b,
    dnnl_OI4i64o4i = dnnl_AB4b64a4b,
    dnnl_OI16i16o4i = dnnl_AB16b16a4b,
    // weights, 3D
    dnnl_IOw16o16i = dnnl_BAc16a16b,
    dnnl_IOw16i16o = dnnl_BAc16b16a,
    dnnl_OIw16i16o = dnnl_ABc16b16a,
    dnnl_OIw16i32o = dnnl_ABc16b32a,
    dnnl_OIw16i64o = dnnl_ABc16b64a,
    dnnl_OIw16o16i = dnnl_ABc16a16b,
    dnnl_Oiw16o = dnnl_Abc16a,
    dnnl_OIw4i16o4i = dnnl_ABc4b16a4b,
    dnnl_OIw4i32o4i = dnnl_ABc4b32a4b,
    dnnl_OIw4i64o4i = dnnl_ABc4b64a4b,
    dnnl_OIw2i8o4i = dnnl_ABc2b8a4b,
    dnnl_OIw16i16o4i = dnnl_ABc16b16a4b,
    dnnl_OIw16i16o2i = dnnl_ABc16b16a2b,
    dnnl_OIw16o16i2o = dnnl_ABc16a16b2a,
    dnnl_OIw4i4o = dnnl_ABc4b4a,
    dnnl_OIw4o4i = dnnl_ABc4a4b,
    dnnl_Oiw4o = dnnl_Abc4a,
    dnnl_OIw8i16o2i = dnnl_ABc8b16a2b,
    dnnl_OIw8i32o2i = dnnl_ABc8b32a2b,
    dnnl_OIw8i64o2i = dnnl_ABc8b64a2b,
    dnnl_OIw8i8o = dnnl_ABc8b8a,
    dnnl_OIw8o16i2o = dnnl_ABc8a16b2a,
    dnnl_IOw8o16i2o = dnnl_BAc8a16b2a,
    dnnl_OIw8o8i = dnnl_ABc8a8b,
    dnnl_OIw8o4i = dnnl_ABc8a4b,
    dnnl_Owi16o = dnnl_Acb16a,
    dnnl_OwI16o2i = dnnl_AcB16a2b,
    dnnl_OwI16o4i = dnnl_AcB16a4b,
    dnnl_Owi4o = dnnl_Acb4a,
    dnnl_Owi8o = dnnl_Acb8a,

    // weights, 4D
    dnnl_IOhw16i16o = dnnl_BAcd16b16a,
    dnnl_IOhw16o16i = dnnl_BAcd16a16b,
    dnnl_Ohwi16o = dnnl_Acdb16a,
    dnnl_OhwI16o2i = dnnl_AcdB16a2b,
    dnnl_OhwI16o4i = dnnl_AcdB16a4b,
    dnnl_Ohwi32o = dnnl_Acdb32a,
    dnnl_Ohwi4o = dnnl_Acdb4a,
    dnnl_Ohwi8o = dnnl_Acdb8a,
    dnnl_OIhw16i16o = dnnl_ABcd16b16a,
    dnnl_OIhw16i32o = dnnl_ABcd16b32a,
    dnnl_OIhw16i64o = dnnl_ABcd16b64a,
    dnnl_OIhw16o16i = dnnl_ABcd16a16b,
    dnnl_Oihw16o = dnnl_Abcd16a,
    dnnl_OIhw4i16o4i = dnnl_ABcd4b16a4b,
    dnnl_OIhw4i32o4i = dnnl_ABcd4b32a4b,
    dnnl_OIhw4i64o4i = dnnl_ABcd4b64a4b,
    dnnl_OIhw16i16o4i = dnnl_ABcd16b16a4b,
    dnnl_OIhw16i16o2i = dnnl_ABcd16b16a2b,
    dnnl_OIhw16o16i2o = dnnl_ABcd16a16b2a,
    dnnl_OIhw4i4o = dnnl_ABcd4b4a,
    dnnl_OIhw4o4i = dnnl_ABcd4a4b,
    dnnl_Oihw4o = dnnl_Abcd4a,
    dnnl_OIhw8i16o2i = dnnl_ABcd8b16a2b,
    dnnl_OIhw8i32o2i = dnnl_ABcd8b32a2b,
    dnnl_OIhw8i64o2i = dnnl_ABcd8b64a2b,
    dnnl_OIhw8i8o = dnnl_ABcd8b8a,
    dnnl_OIhw8o16i2o = dnnl_ABcd8a16b2a,
    dnnl_OIhw2i8o4i = dnnl_ABcd2b8a4b,
    dnnl_IOhw8o16i2o = dnnl_BAcd8a16b2a,
    dnnl_OIhw8o8i = dnnl_ABcd8a8b,
    dnnl_OIhw8o4i = dnnl_ABcd8a4b,
    dnnl_Owhi16o = dnnl_Adcb16a,

    // weights, 5D
    dnnl_Odhwi16o = dnnl_Acdeb16a,
    dnnl_OdhwI16o2i = dnnl_AcdeB16a2b,
    dnnl_OdhwI16o4i = dnnl_AcdeB16a4b,
    dnnl_Odhwi4o = dnnl_Acdeb4a,
    dnnl_Odhwi8o = dnnl_Acdeb8a,
    dnnl_OIdhw16i16o = dnnl_ABcde16b16a,
    dnnl_OIdhw16i32o = dnnl_ABcde16b32a,
    dnnl_OIdhw16i64o = dnnl_ABcde16b64a,
    dnnl_OIdhw16o16i = dnnl_ABcde16a16b,
    dnnl_Oidhw16o = dnnl_Abcde16a,
    dnnl_OIdhw4i4o = dnnl_ABcde4b4a,
    dnnl_OIdhw4o4i = dnnl_ABcde4a4b,
    dnnl_Oidhw4o = dnnl_Abcde4a,
    dnnl_OIdhw8i16o2i = dnnl_ABcde8b16a2b,
    dnnl_OIdhw8i32o2i = dnnl_ABcde8b32a2b,
    dnnl_OIdhw8i64o2i = dnnl_ABcde8b64a2b,
    dnnl_OIdhw8i8o = dnnl_ABcde8b8a,
    dnnl_OIdhw8o16i2o = dnnl_ABcde8a16b2a,
    dnnl_IOdhw8o16i2o = dnnl_BAcde8a16b2a,
    dnnl_OIdhw4i16o4i = dnnl_ABcde4b16a4b,
    dnnl_OIdhw4i32o4i = dnnl_ABcde4b32a4b,
    dnnl_OIdhw4i64o4i = dnnl_ABcde4b64a4b,
    dnnl_OIdhw16i16o4i = dnnl_ABcde16b16a4b,
    dnnl_OIdhw16i16o2i = dnnl_ABcde16b16a2b,
    dnnl_OIdhw2i8o4i = dnnl_ABcde2b8a4b,
    dnnl_OIdhw8o8i = dnnl_ABcde8a8b,
    dnnl_OIdhw8o4i = dnnl_ABcde8a4b,
    dnnl_IOdhw16i16o = dnnl_BAcde16b16a,
    dnnl_OIdhw4o8i8o4i = dnnl_ABcde4a8b8a4b,
    dnnl_IOdhw16o16i = dnnl_BAcde16a16b,

    // weights w/ groups, 3D
    dnnl_Goiw16g = dnnl_Abcd16a,
    dnnl_Goiw8g = dnnl_Abcd8a,
    dnnl_Goiw4g = dnnl_Abcd4a,
    dnnl_gIOw16o16i = dnnl_aCBd16b16c,
    dnnl_gIOw16i16o = dnnl_aCBd16c16b,
    dnnl_gOIw16i16o = dnnl_aBCd16c16b,
    dnnl_gOIw16o16i = dnnl_aBCd16b16c,
    dnnl_gOiw16o = dnnl_aBcd16b,
    dnnl_gOIw4i16o4i = dnnl_aBCd4c16b4c,
    dnnl_gOIw2i8o4i = dnnl_aBCd2c8b4c,
    dnnl_gOIw16i16o4i = dnnl_aBCd16c16b4c,
    dnnl_gOIw16i16o2i = dnnl_aBCd16c16b2c,
    dnnl_gOIw16o16i2o = dnnl_aBCd16b16c2b,
    dnnl_gOIw4i4o = dnnl_aBCd4c4b,
    dnnl_gOIw4o4i = dnnl_aBCd4b4c,
    dnnl_gOiw4o = dnnl_aBcd4b,
    dnnl_gOIw8i16o2i = dnnl_aBCd8c16b2c,
    dnnl_gOIw8i8o = dnnl_aBCd8c8b,
    dnnl_gOIw8o16i2o = dnnl_aBCd8b16c2b,
    dnnl_gIOw8o16i2o = dnnl_aCBd8b16c2b,
    dnnl_gOIw8o8i = dnnl_aBCd8b8c,
    dnnl_gOIw8o4i = dnnl_aBCd8b4c,
    dnnl_gOwi16o = dnnl_aBdc16b,
    dnnl_gOwI16o2i = dnnl_aBdC16b2c,
    dnnl_gOwI16o4i = dnnl_aBdC16b4c,
    dnnl_gOwi4o = dnnl_aBdc4b,
    dnnl_gOwi8o = dnnl_aBdc8b,
    dnnl_Goiw32g = dnnl_Abcd32a,
    dnnl_gOIw2i4o2i = dnnl_aBCd2c4b2c,
    dnnl_gOIw2o4i2o = dnnl_aBCd2b4c2b,
    dnnl_gOIw4i8o2i = dnnl_aBCd4c8b2c,
    dnnl_gOIw4o8i2o = dnnl_aBCd4b8c2b,

    // weights w/ groups, 4D
    dnnl_gIOhw16i16o = dnnl_aCBde16c16b,
    dnnl_gIOhw16o16i = dnnl_aCBde16b16c,
    dnnl_gOhwi16o = dnnl_aBdec16b,
    dnnl_gOhwI16o2i = dnnl_aBdeC16b2c,
    dnnl_gOhwI16o4i = dnnl_aBdeC16b4c,
    dnnl_gOhwi32o = dnnl_aBdec32b,
    dnnl_gOhwi4o = dnnl_aBdec4b,
    dnnl_gOhwi8o = dnnl_aBdec8b,
    dnnl_Goihw16g = dnnl_Abcde16a,
    dnnl_gOIhw16i16o = dnnl_aBCde16c16b,
    dnnl_gOIhw16o16i = dnnl_aBCde16b16c,
    dnnl_gOihw16o = dnnl_aBcde16b,
    dnnl_gOIhw2i8o4i = dnnl_aBCde2c8b4c,
    dnnl_gOIhw4i16o4i = dnnl_aBCde4c16b4c,
    dnnl_gOIhw16i16o4i = dnnl_aBCde16c16b4c,
    dnnl_gOIhw16i16o2i = dnnl_aBCde16c16b2c,
    dnnl_gOIhw16o16i2o = dnnl_aBCde16b16c2b,
    dnnl_gOIhw4i4o = dnnl_aBCde4c4b,
    dnnl_gOIhw4o4i = dnnl_aBCde4b4c,
    dnnl_gOihw4o = dnnl_aBcde4b,
    dnnl_Goihw8g = dnnl_Abcde8a,
    dnnl_Goihw4g = dnnl_Abcde4a,
    dnnl_gOIhw8i16o2i = dnnl_aBCde8c16b2c,
    dnnl_gOIhw8i8o = dnnl_aBCde8c8b,
    dnnl_gOIhw8o16i2o = dnnl_aBCde8b16c2b,
    dnnl_gIOhw8o16i2o = dnnl_aCBde8b16c2b,
    dnnl_gOIhw8o8i = dnnl_aBCde8b8c,
    dnnl_gOIhw8o4i = dnnl_aBCde8b4c,
    dnnl_Goihw32g = dnnl_Abcde32a,
    dnnl_gOwhi16o = dnnl_aBedc16b,

    dnnl_OIw4o8i8o4i = dnnl_ABc4a8b8a4b,
    dnnl_OIhw4o8i8o4i = dnnl_ABcd4a8b8a4b,
    dnnl_IOw4i8o8i4o = dnnl_BAc4b8a8b4a,
    dnnl_IOhw4i8o8i4o = dnnl_BAcd4b8a8b4a,
    dnnl_IOdhw4i8o8i4o = dnnl_BAcde4b8a8b4a,

    dnnl_OIhw2o8i8o2i = dnnl_ABcd2a8b8a2b,
    dnnl_gOIw4o8i8o4i = dnnl_aBCd4b8c8b4c,
    dnnl_gOIhw4o8i8o4i = dnnl_aBCde4b8c8b4c,
    dnnl_gOIdhw4o8i8o4i = dnnl_aBCdef4b8c8b4c,
    dnnl_gIOw4i8o8i4o = dnnl_aCBd4c8b8c4b,
    dnnl_gIOhw4i8o8i4o = dnnl_aCBde4c8b8c4b,
    dnnl_gIOdhw4i8o8i4o = dnnl_aCBdef4c8b8c4b,
    dnnl_gOIhw2o8i8o2i = dnnl_aBCde2b8c8b2c,
    dnnl_gOIhw2i4o2i = dnnl_aBCde2c4b2c,
    dnnl_gOIhw2o4i2o = dnnl_aBCde2b4c2b,
    dnnl_gOIhw4i8o2i = dnnl_aBCde4c8b2c,
    dnnl_gOIhw4o8i2o = dnnl_aBCde4b8c2b,

    // weights w/ groups, 6D
    dnnl_gIOdhw16i16o = dnnl_aCBdef16c16b,
    dnnl_gIOdhw16o16i = dnnl_aCBdef16b16c,
    dnnl_gOdhwi16o = dnnl_aBdefc16b,
    dnnl_gOdhwI16o2i = dnnl_aBdefC16b2c,
    dnnl_gOdhwI16o4i = dnnl_aBdefC16b4c,
    dnnl_gOdhwi4o = dnnl_aBdefc4b,
    dnnl_gOdhwi8o = dnnl_aBdefc8b,
    dnnl_gOIdhw16i16o = dnnl_aBCdef16c16b,
    dnnl_gOIdhw4i16o4i = dnnl_aBCdef4c16b4c,
    dnnl_gOIdhw16i16o4i = dnnl_aBCdef16c16b4c,
    dnnl_gOIdhw2i8o4i = dnnl_aBCdef2c8b4c,
    dnnl_gOIdhw16i16o2i = dnnl_aBCdef16c16b2c,
    dnnl_gOIdhw16o16i = dnnl_aBCdef16b16c,
    dnnl_gOidhw16o = dnnl_aBcdef16b,
    dnnl_gOIdhw4i4o = dnnl_aBCdef4c4b,
    dnnl_gOIdhw4o4i = dnnl_aBCdef4b4c,
    dnnl_gOidhw4o = dnnl_aBcdef4b,
    dnnl_gOIdhw8i16o2i = dnnl_aBCdef8c16b2c,
    dnnl_gOIdhw8i8o = dnnl_aBCdef8c8b,
    dnnl_gOIdhw8o16i2o = dnnl_aBCdef8b16c2b,
    dnnl_gIOdhw8o16i2o = dnnl_aCBdef8b16c2b,
    dnnl_gOIdhw8o8i = dnnl_aBCdef8b8c,
    dnnl_gOIdhw8o4i = dnnl_aBCdef8b4c,
    dnnl_Goidhw16g = dnnl_Abcdef16a,
    dnnl_Goidhw32g = dnnl_Abcdef32a,
    dnnl_gOIdhw2i4o2i = dnnl_aBCdef2c4b2c,
    dnnl_gOIdhw4i8o2i = dnnl_aBCdef4c8b2c,
    dnnl_gOIdhw2o4i2o = dnnl_aBCdef2b4c2b,
    dnnl_gOIdhw4o8i2o = dnnl_aBCdef4b8c2b,
    // weights, 3D
    dnnl_Owi32o = dnnl_Acb32a,
    dnnl_OwI32o2i = dnnl_AcB32a2b,
    dnnl_OwI32o4i = dnnl_AcB32a4b,
    dnnl_Owi48o = dnnl_Acb48a,
    dnnl_OwI48o2i = dnnl_AcB48a2b,
    dnnl_OwI48o4i = dnnl_AcB48a4b,
    dnnl_Owi64o = dnnl_Acb64a,
    dnnl_OwI64o2i = dnnl_AcB64a2b,
    dnnl_OwI64o4i = dnnl_AcB64a4b,
    dnnl_wIo2i = dnnl_cBa2b,
    dnnl_wIo4i = dnnl_cBa4b,
    dnnl_gOwi32o = dnnl_aBdc32b,
    dnnl_gOwI32o2i = dnnl_aBdC32b2c,
    dnnl_gOwI32o4i = dnnl_aBdC32b4c,
    dnnl_gOwi48o = dnnl_aBdc48b,
    dnnl_gOwI48o2i = dnnl_aBdC48b2c,
    dnnl_gOwI48o4i = dnnl_aBdC48b4c,
    dnnl_gOwi64o = dnnl_aBdc64b,
    dnnl_gOwI64o2i = dnnl_aBdC64b2c,
    dnnl_gOwI64o4i = dnnl_aBdC64b4c,
    dnnl_gwio = dnnl_adcb,
    dnnl_gwIo2i = dnnl_adCb2c,
    dnnl_gwIo4i = dnnl_adCb4c,
    // weights, 4D
    dnnl_OhwI32o = dnnl_Acdb32a,
    dnnl_OhwI32o2i = dnnl_AcdB32a2b,
    dnnl_OhwI32o4i = dnnl_AcdB32a4b,
    dnnl_Ohwi48o = dnnl_Acdb48a,
    dnnl_OhwI48o2i = dnnl_AcdB48a2b,
    dnnl_OhwI48o4i = dnnl_AcdB48a4b,
    dnnl_Ohwi64o = dnnl_Acdb64a,
    dnnl_OhwI64o2i = dnnl_AcdB64a2b,
    dnnl_OhwI64o4i = dnnl_AcdB64a4b,
    dnnl_hwIo2i = dnnl_cdBa2b,
    dnnl_hwIo4i = dnnl_cdBa4b,
    dnnl_gOhwI32o = dnnl_aBdec32b,
    dnnl_gOhwI32o2i = dnnl_aBdeC32b2c,
    dnnl_gOhwI32o4i = dnnl_aBdeC32b4c,
    dnnl_gOhwi48o = dnnl_aBdec48b,
    dnnl_gOhwI48o2i = dnnl_aBdeC48b2c,
    dnnl_gOhwI48o4i = dnnl_aBdeC48b4c,
    dnnl_gOhwi64o = dnnl_aBdec64b,
    dnnl_gOhwI64o2i = dnnl_aBdeC64b2c,
    dnnl_gOhwI64o4i = dnnl_aBdeC64b4c,
    dnnl_ghwio = dnnl_adecb,
    dnnl_ghwIo2i = dnnl_adeCb2c,
    dnnl_ghwIo4i = dnnl_adeCb4c,
    // weights, 5D
    dnnl_Odhwi32o = dnnl_Acdeb32a,
    dnnl_OdhwI32o2i = dnnl_AcdeB32a2b,
    dnnl_OdhwI32o4i = dnnl_AcdeB32a4b,
    dnnl_Odhwi48o = dnnl_Acdeb48a,
    dnnl_OdhwI48o2i = dnnl_AcdeB48a2b,
    dnnl_OdhwI48o4i = dnnl_AcdeB48a4b,
    dnnl_Odhwi64o = dnnl_Acdeb64a,
    dnnl_OdhwI64o2i = dnnl_AcdeB64a2b,
    dnnl_OdhwI64o4i = dnnl_AcdeB64a4b,
    dnnl_dhwIo2i = dnnl_cdeBa2b,
    dnnl_dhwIo4i = dnnl_cdeBa4b,
    dnnl_gOdhwi32o = dnnl_aBdefc32b,
    dnnl_gOdhwI32o2i = dnnl_aBdefC32b2c,
    dnnl_gOdhwI32o4i = dnnl_aBdefC32b4c,
    dnnl_gOdhwi48o = dnnl_aBdefc48b,
    dnnl_gOdhwI48o2i = dnnl_aBdefC48b2c,
    dnnl_gOdhwI48o4i = dnnl_aBdefC48b4c,
    dnnl_gOdhwi64o = dnnl_aBdefc64b,
    dnnl_gOdhwI64o2i = dnnl_aBdefC64b2c,
    dnnl_gOdhwI64o4i = dnnl_aBdefC64b4c,
    dnnl_gdhwio = dnnl_adefcb,
    dnnl_gdhwIo2i = dnnl_adefCb2c,
    dnnl_gdhwIo4i = dnnl_adefCb4c,
    dnnl_OI16i32o4i = dnnl_AB16b32a4b,
    dnnl_OI16i48o4i = dnnl_AB16b48a4b,
    dnnl_OI16i64o4i = dnnl_AB16b64a4b,
    dnnl_OI16i16o2i = dnnl_AB16b16a2b,
    dnnl_OI16i32o2i = dnnl_AB16b32a2b,
    dnnl_OI16i48o2i = dnnl_AB16b48a2b,
    dnnl_OI16i64o2i = dnnl_AB16b64a2b,
    dnnl_OIw16i32o4i = dnnl_ABc16b32a4b,
    dnnl_OIw16i48o4i = dnnl_ABc16b48a4b,
    dnnl_OIw16i64o4i = dnnl_ABc16b64a4b,
    dnnl_OIw16i32o2i = dnnl_ABc16b32a2b,
    dnnl_OIw16i48o2i = dnnl_ABc16b48a2b,
    dnnl_OIw16i64o2i = dnnl_ABc16b64a2b,
    dnnl_OIhw16i32o4i = dnnl_ABcd16b32a4b,
    dnnl_OIhw16i48o4i = dnnl_ABcd16b48a4b,
    dnnl_OIhw16i64o4i = dnnl_ABcd16b64a4b,
    dnnl_OIhw16i32o2i = dnnl_ABcd16b32a2b,
    dnnl_OIhw16i48o2i = dnnl_ABcd16b48a2b,
    dnnl_OIhw16i64o2i = dnnl_ABcd16b64a2b,
    dnnl_OIdhw16i32o4i = dnnl_ABcde16b32a4b,
    dnnl_OIdhw16i48o4i = dnnl_ABcde16b48a4b,
    dnnl_OIdhw16i64o4i = dnnl_ABcde16b64a4b,
    dnnl_OIdhw16i32o2i = dnnl_ABcde16b32a2b,
    dnnl_OIdhw16i48o2i = dnnl_ABcde16b48a2b,
    dnnl_OIdhw16i64o2i = dnnl_ABcde16b64a2b;

/** \} dnnl_api_memory
 <p>
 *  \addtogroup dnnl_api_primitives
 *  \{
 *  \addtogroup dnnl_api_primitives_common
 *  \{
 <p>
 *  Kinds of propagation. */
/** enum dnnl_prop_kind_t */
public static final int
    // TODO: suggest renames
    /** Undefined propagation type. */
    dnnl_prop_kind_undef = 0,
    /** Forward data propagation (training mode). In this mode primitives
     *  perform computations necessary for subsequent backward propagation. */
    dnnl_forward_training = 64,
    /** Forward data propagation (inference mode). In this mode primitives
     *  perform only computations that are necessary for inference and omit
     *  computations that are necessary only for backward propagation. */
    dnnl_forward_inference = 96,
    /** Forward data propagation (alias for \c dnnl_forward_inference). */
    dnnl_forward_scoring = dnnl_forward_inference,
    /** Forward data propagation (alias for \c dnnl_forward_training). */
    dnnl_forward = dnnl_forward_training,
    /** Backward propagation (with respect to all parameters). */
    dnnl_backward = 128,
    /** Backward data propagation. */
    dnnl_backward_data = 160,
    /** Backward weights propagation. */
    dnnl_backward_weights = 192,
    /** Backward bias propagation. */
    dnnl_backward_bias = 193;

/** Kinds of primitives. Used to implement a way to extend the library with new
 *  primitives without changing the ABI. */
/** enum dnnl_primitive_kind_t */
public static final int
    /** Undefined primitive */
    dnnl_undefined_primitive = 0,
    /** A reorder primitive. */
    dnnl_reorder = 1,
    /** A shuffle primitive. */
    dnnl_shuffle = 2,
    /** A (out-of-place) concat primitive. */
    dnnl_concat = 3,
    /** A sum primitive. */
    dnnl_sum = 4,
    /** A convolution primitive. */
    dnnl_convolution = 5,
    /** A deconvolution primitive. */
    dnnl_deconvolution = 6,
    /** An element-wise primitive. */
    dnnl_eltwise = 7,
    /** A softmax primitive. */
    dnnl_softmax = 8,
    /** A pooling primitive. */
    dnnl_pooling = 9,
    /** An LRN primitive. */
    dnnl_lrn = 10,
    /** A batch normalization primitive. */
    dnnl_batch_normalization = 11,
    /** A layer normalization primitive. */
    dnnl_layer_normalization = 12,
    /** An inner product primitive. */
    dnnl_inner_product = 13,
    /** A rnn primitive. */
    dnnl_rnn = 14,
    /** A matrix multiplication primitive (internal). */
    dnnl_gemm = 15,
    /** A binary primitive. */
    dnnl_binary = 16,
    /** A logsoftmax primitive. */
    dnnl_logsoftmax = 17,
    /** A matrix multiplication primitive. */
    dnnl_matmul = 18,
    /** A resampling primitive. */
    dnnl_resampling = 19,
    /** A pooling version 2 primitive (pooling with dilation support). */
    dnnl_pooling_v2 = 20,
    /** A reduction primitive. */
    dnnl_reduction = 21,
    /** A PReLU primitive. */
    dnnl_prelu = 22,

    /** Parameter to allow internal only primitives without undefined behavior.
     *  This parameter is chosen to be valid for so long as sizeof(int) >= 2. */
    dnnl_primitive_kind_max = 0x7fff;

/** Kinds of algorithms. */
/** enum dnnl_alg_kind_t */
public static final int
    dnnl_alg_kind_undef = 0,
    /** Direct convolution */
    dnnl_convolution_direct = 0x1,
    /** Winograd convolution */
    dnnl_convolution_winograd = 0x2,
    /** Convolution algorithm(either direct or Winograd) is chosen just in time */
    dnnl_convolution_auto = 0x3,
    /** Direct deconvolution */
    dnnl_deconvolution_direct = 0xa,
    /** Winograd deconvolution */
    dnnl_deconvolution_winograd = 0xb,
    /** Eltwise: ReLU */
    dnnl_eltwise_relu = 0x1f,
    /** Eltwise: hyperbolic tangent non-linearity (tanh) */
    dnnl_eltwise_tanh = 0x2f,
    /** Eltwise: exponential linear unit (elu) */
    dnnl_eltwise_elu = 0x3f,
    /** Eltwise: square */
    dnnl_eltwise_square = 0x4f,
    /** Eltwise: abs */
    dnnl_eltwise_abs = 0x5f,
    /** Eltwise: square root */
    dnnl_eltwise_sqrt = 0x6f,
    /** Eltwise: linear */
    dnnl_eltwise_linear = 0x7f,
    /** Eltwise: bounded_relu */
    dnnl_eltwise_bounded_relu = 0x8f,
    /** Eltwise: soft_relu */
    dnnl_eltwise_soft_relu = 0x9f,
    /** Eltwise: logistic */
    dnnl_eltwise_logistic = 0xaf,
    /** Eltwise: exponent */
    
///
    dnnl_eltwise_exp = 0xbf,
    /** Eltwise: gelu
     * 
     *  \note Tanh approximation formula is used to approximate
     *  the cumulative distribution function of a Gaussian here */
    dnnl_eltwise_gelu_tanh = 0xcf,
    /** Eltwise: tanh-based gelu (alias for dnnl_eltwise_gelu_tanh) */
    dnnl_eltwise_gelu = dnnl_eltwise_gelu_tanh,
    /** Eltwise: swish */
    dnnl_eltwise_swish = 0xdf,
    /** Eltwise: natural logarithm */
    dnnl_eltwise_log = 0xef,
    /** Eltwise: clip */
    dnnl_eltwise_clip = 0xff,
    /** Eltwise: clip version 2 */
    dnnl_eltwise_clip_v2 = 0x10,
    /** Eltwise: pow */
    dnnl_eltwise_pow = 0x20,
    /** Eltwise: erf-based gelu */
    dnnl_eltwise_gelu_erf = 0x30,
    /** Eltwise: round */
    dnnl_eltwise_round = 0x40,
    /** Eltwise: logsigmoid */
    dnnl_eltwise_logsigmoid = 0x50,
    /** Eltwise: mish */
    dnnl_eltwise_mish = 0x60,
    /** Eltwise: hardswish */
    dnnl_eltwise_hardswish = 0x70,
    /** Eltwise: ReLU (dst for backward) */
    dnnl_eltwise_relu_use_dst_for_bwd = 0x100,
    /** Eltwise: hyperbolic tangent non-linearity (tanh) (dst for backward) */
    dnnl_eltwise_tanh_use_dst_for_bwd = 0x101,
    /** Eltwise: exponential linear unit (elu) (dst for backward) */
    dnnl_eltwise_elu_use_dst_for_bwd = 0x102,
    /** Eltwise: square root (dst for backward) */
    dnnl_eltwise_sqrt_use_dst_for_bwd = 0x103,
    /** Eltwise: logistic (dst for backward) */
    dnnl_eltwise_logistic_use_dst_for_bwd = 0x104,
    /** Eltwise: exp (dst for backward) */
    dnnl_eltwise_exp_use_dst_for_bwd = 0x105,
    /** Eltwise: clip version 2 (dst for backward) */
    dnnl_eltwise_clip_v2_use_dst_for_bwd = 0x106,
    /** Max pooling */
    dnnl_pooling_max = 0x1ff,
    /** Average pooling include padding */
    dnnl_pooling_avg_include_padding = 0x2ff,
    /** Average pooling exclude padding */
    dnnl_pooling_avg_exclude_padding = 0x3ff,
    /** Average pooling (alias for #dnnl_pooling_avg_exclude_padding) */
    dnnl_pooling_avg = dnnl_pooling_avg_exclude_padding,
    /** Local response normalization (LRN) across multiple channels */
    dnnl_lrn_across_channels = 0xaff,
    /** LRN within a single channel */
    dnnl_lrn_within_channel = 0xbff,
    /** RNN cell */
    dnnl_vanilla_rnn = 0x1fff,
    /** LSTM cell */
    dnnl_vanilla_lstm = 0x2fff,
    /** GRU cell */
    
///
    dnnl_vanilla_gru = 0x3fff,
    /** GRU cell with linear before reset
     * 
     *  Modification of original GRU cell. Differs from #dnnl_vanilla_gru
     *  in how the new memory gate is calculated:
     *  <pre>{@code \[ c_t = tanh(W_c*x_t + b_{c_x} + r_t*(U_c*h_{t-1}+b_{c_h})) \]}</pre>
     *  Primitive expects 4 biases on input:
     *  {@code [b_{u}, b_{r}, b_{c_x}, b_{c_h}]} */
    dnnl_lbr_gru = 0x4fff,
    /** Binary add */
    dnnl_binary_add = 0x1fff0,
    /** Binary mul */
    dnnl_binary_mul = 0x1fff1,
    /** Binary max */
    dnnl_binary_max = 0x1fff2,
    /** Binary min */
    dnnl_binary_min = 0x1fff3,
    /** Binary div */
    dnnl_binary_div = 0x1fff4,
    /** Binary sub */
    dnnl_binary_sub = 0x1fff5,
    /** Binary greater or equal */
    dnnl_binary_ge = 0x1fff6,
    /** Binary greater than */
    dnnl_binary_gt = 0x1fff7,
    /** Binary less or equal */
    dnnl_binary_le = 0x1fff8,
    /** Binary less than */
    dnnl_binary_lt = 0x1fff9,
    /** Binary equal */
    dnnl_binary_eq = 0x1fffa,
    /** Binary not equal */
    dnnl_binary_ne = 0x1fffb,
    /** Nearest Neighbor Resampling Method */
    dnnl_resampling_nearest = 0x2fff0,
    /** Linear Resampling Method */
    dnnl_resampling_linear = 0x2fff1,
    /** Reduction using max */
    dnnl_reduction_max = 0x2fff1 + 1,
    /** Reduction using min */
    dnnl_reduction_min = 0x2fff1 + 2,
    /** Reduction using sum */
    dnnl_reduction_sum = 0x2fff1 + 3,
    /** Reduction using mul */
    dnnl_reduction_mul = 0x2fff1 + 4,
    /** Reduction using mean */
    dnnl_reduction_mean = 0x2fff1 + 5,
    /** Reduction using lp norm */
    dnnl_reduction_norm_lp_max = 0x2fff1 + 6,
    /** Reduction using lp norm */
    dnnl_reduction_norm_lp_sum = 0x2fff1 + 7,
    /** Reduction using lp norm without final pth-root */
    dnnl_reduction_norm_lp_power_p_max = 0x2fff1 + 8,
    /** Reduction using lp norm without final pth-root */
    dnnl_reduction_norm_lp_power_p_sum = 0x2fff1 + 9;

/** Flags for normalization primitives. */
/** enum dnnl_normalization_flags_t */
public static final int
    /** Use no normalization flags
     * 
     *  If specified
     *   - on forward training propagation mean and variance are computed and
     *     stored as output
     *   - on backward propagation compute full derivative wrt data
     *   - on backward propagation prop_kind == #dnnl_backward_data has the same
     *     behavior as prop_kind == #dnnl_backward */
    
///
///
    dnnl_normalization_flags_none = 0x0,

    /** Use global statistics
     * 
     *  If specified
     *   - on forward propagation use mean and variance provided by user (input)
     *   - on backward propagation reduces the amount of computations, since
     *     mean and variance are considered as constants
     * 
     *   If not specified:
     *    - on forward propagation mean and variance are computed and stored as
     *      output
     *    - on backward propagation compute full derivative wrt data */
    
///
///
    dnnl_use_global_stats = 0x1,

    /** Use scale and shift parameters
     * 
     *  If specified:
     *   - on forward propagation use scale and shift (aka scale and bias) for
     *     the batch normalization results
     *   - on backward propagation (for prop_kind == #dnnl_backward) compute
     *     diff wrt scale and shift (hence one extra output used)
     * 
     *  If no specified:
     *   - on backward propagation prop_kind == #dnnl_backward_data has the
     *     same behavior as prop_kind == #dnnl_backward */
    
///
///
    dnnl_use_scaleshift = 0x2,

    /** Fuse with ReLU
     * 
     *  The flag implies negative slope being 0. On training this is the only
     *  configuration supported. For inference, to use non-zero negative slope
     *  consider using \ref dev_guide_attributes_post_ops.
     * 
     *  If specified:
     *   - on inference this option behaves the same as if the primitive were
     *     fused with ReLU using post ops API with zero negative slope.
     *   - on training primitive requires workspace (required to be able to
     *     perform backward pass) */
    
///
    dnnl_fuse_norm_relu = 0x4,

    /** Use scale parameter
     * 
     *  If specified:
     *   - on forward propagation use scale for the batch normalization results
     *   - on backward propagation (for prop_kind == #dnnl_backward) compute
     *     diff wrt scale (hence one extra output used) */
    
///
    dnnl_use_scale = 0x8,

    /** Use shift parameter
     * 
     *  If specified:
     *   - on forward propagation use shift (aka bias) for the batch
     *     normalization results
     *   - on backward propagation (for prop_kind == #dnnl_backward) compute
     *     diff wrt shift (hence one extra output used) */
    dnnl_use_shift = 0x10;

/** \} dnnl_api_primitives_common
 *  \} dnnl_api_primitives
 <p>
 *  \addtogroup dnnl_api_memory
 *  \{
 <p>
 *  Maximum number of dimensions a tensor can have. Only restricts the amount
 *  of space used for the tensor description. Individual computational
 *  primitives may support only tensors of certain dimensions. */
public static final int DNNL_MAX_NDIMS = 12;

/** A wildcard value for dimensions that are unknown at a primitive creation
 *  time. */
public static native @MemberGetter long DNNL_RUNTIME_DIM_VAL();
public static final long DNNL_RUNTIME_DIM_VAL = DNNL_RUNTIME_DIM_VAL();

/** A {@code size_t} counterpart of the DNNL_RUNTIME_DIM_VAL.
 *  For instance, this value is returned by dnnl_memory_desc_get_size() if
 *  either of the dimensions or strides equal to #DNNL_RUNTIME_DIM_VAL. */
public static native @MemberGetter long DNNL_RUNTIME_SIZE_VAL();
public static final long DNNL_RUNTIME_SIZE_VAL = DNNL_RUNTIME_SIZE_VAL();

/** \cond DO_NOT_DOCUMENT_THIS
 *  Hex representation for a **special** quiet NAN (!= NAN from math.h) */
    
    
/** \endcond
 <p>
 *  A wildcard value for floating point values that are unknown at a primitive
 *  creation time. */
public static native @MemberGetter double DNNL_RUNTIME_F32_VAL();
public static final double DNNL_RUNTIME_F32_VAL = DNNL_RUNTIME_F32_VAL();

/** \cond DO_NOT_DOCUMENT_THIS */
@MemberGetter public static native int DNNL_RUNTIME_S32_VAL_REP();
public static final int DNNL_RUNTIME_S32_VAL_REP = DNNL_RUNTIME_S32_VAL_REP();
/** \endcond
 <p>
 *  A wildcard value for int32_t values that are unknown at a primitive creation
 *  time. */
public static final int DNNL_RUNTIME_S32_VAL = DNNL_RUNTIME_S32_VAL_REP;

/** A type to describe tensor dimension. */

/** A type to describe tensor dimensions. */

///
// Targeting ../dnnl_blocking_desc_t.java



/** Winograd-specific formats */
/** enum dnnl_wino_memory_format_t */
public static final int
    /** Undefined memory format, used for empty memory descriptors. */
    dnnl_wino_undef = 0,
    // Tensors of weights for 2x3 winograd convolutions.
    /** Internal weights format for 2x3 Winograd */
    dnnl_wino_wei_aaOIoi = 1,
    /** Internal weights format for 2x3 Winograd */
    dnnl_wino_wei_aaOio = 2,
    /** Internal weights format for 2x3 Winograd */
    dnnl_wino_wei_aaOBiOo = 3,
    // Tensor of weights for 4x3 convolution.
    /** Internal weights format for 4x3 Winograd */
    dnnl_wino_wei_OBaaIBOIio = 4;
// Targeting ../dnnl_wino_desc_t.java



/** enum dnnl_rnn_packed_memory_format_t */
public static final int
    dnnl_packed_format_undef = 0,
    dnnl_ldigo_p = 1,
    dnnl_ldgoi_p = 2,
    dnnl_ldio_p = 3;

/** Maximum number of parts of RNN weights tensor that require separate
 *  computation. */
public static final int DNNL_RNN_MAX_N_PARTS = 4;
// Targeting ../dnnl_rnn_packed_desc_t.java



/** Flags for memory special features */
/** enum dnnl_memory_extra_flags_t */
public static final int
    
///
    dnnl_memory_extra_flag_none = 0x0,
    /** Indicates the weights have an additional buffer, that depends on the
     *  \p compensation_mask.
     * 
     *  For instance, in 4D case with the compensation mask equals (1 << 0)
     *  the additional buffer would consist of OC values:
     *  O[oc : 0,OC] =
     *   -128 * SUM(ic : 0,IC; kh : 0,KH; kw : 0,KW){ weights(oc, ic, kh, kw) } */
    dnnl_memory_extra_flag_compensation_conv_s8s8 = 0x1,
    dnnl_memory_extra_flag_scale_adjust = 0x2,
    dnnl_memory_extra_flag_rnn_u8s8_compensation = 0x4,
    dnnl_memory_extra_flag_gpu_rnn_u8s8_compensation
     = dnnl_memory_extra_flag_rnn_u8s8_compensation,
    dnnl_memory_extra_flag_compensation_conv_asymmetric_src = 0x8,
    dnnl_memory_extra_flag_rnn_s8s8_compensation = 0x16;
// Targeting ../dnnl_memory_extra_desc_t.java


// Targeting ../dnnl_memory_desc_t.java


// Targeting ../dnnl_memory.java



/** A memory handle. */

/** A constant memory handle. */

/** Special pointer value that indicates that a memory object should not have
 *  an underlying buffer. */
// #define DNNL_MEMORY_NONE (NULL)

/** Special pointer value that indicates that the library needs to allocate an
 *  underlying buffer for a memory object. */
// #define DNNL_MEMORY_ALLOCATE ((void *)(size_t)-1)
// Targeting ../dnnl_op_desc_t.java


// Targeting ../const_dnnl_op_desc_t.java


// Targeting ../dnnl_convolution_desc_t.java



/** \} dnnl_api_convolution
 <p>
 *  \addtogroup dnnl_api_deconvolution
 *  \{
 <p>
 *  A descriptor of a deconvolution operation. */
// Targeting ../dnnl_shuffle_desc_t.java


// Targeting ../dnnl_eltwise_desc_t.java


// Targeting ../dnnl_softmax_desc_t.java



/** \} dnnl_api_softmax
 <p>
 *  \addtogroup dnnl_api_logsoftmax
 *  \{
 <p>
 *  A descriptor of a LogSoftmax operation. An alias of Softmax structure, but
 *  primitive_kind must be #dnnl_logsoftmax. */
// Targeting ../dnnl_pooling_desc_t.java


// Targeting ../dnnl_pooling_v2_desc_t.java


// Targeting ../dnnl_prelu_desc_t.java


// Targeting ../dnnl_lrn_desc_t.java


// Targeting ../dnnl_batch_normalization_desc_t.java


// Targeting ../dnnl_layer_normalization_desc_t.java


// Targeting ../dnnl_inner_product_desc_t.java



/** \} dnnl_api_inner_product
 <p>
 *  \addtogroup dnnl_api_rnn
 *  \{
 <p>
 *  Flags for RNN cell. */
/** enum dnnl_rnn_flags_t */
public static final int
    /** Undefined RNN flags */
    dnnl_rnn_flags_undef = 0x0;

/** A direction of RNN primitive execution. */
/** enum dnnl_rnn_direction_t */
public static final int
    /** Unidirectional execution of RNN primitive from left to right. */
    dnnl_unidirectional_left2right = 0,
    /** Unidirectional execution of RNN primitive from right to left. */
    dnnl_unidirectional_right2left = 1,
    /** Bidirectional execution of RNN primitive with concatenation of the
     *  results. */
    dnnl_bidirectional_concat = 2,
    /** Bidirectional execution of RNN primitive with summation of the
     *  results. */
    dnnl_bidirectional_sum = 3,
    /** Alias for #dnnl_unidirectional_left2right. */
    dnnl_unidirectional = dnnl_unidirectional_left2right;
// Targeting ../dnnl_rnn_desc_t.java


// Targeting ../dnnl_binary_desc_t.java


// Targeting ../dnnl_matmul_desc_t.java


// Targeting ../dnnl_resampling_desc_t.java


// Targeting ../dnnl_reduction_desc_t.java



/** \} dnnl_api_reduction
 <p>
 *  \} dnnl_api_primitives
 <p>
 *  \addtogroup dnnl_api_engine
 *  \{
 <p>
 *  \brief Kinds of engines. */
/** enum dnnl_engine_kind_t */
public static final int
    /** An unspecified engine. */
    dnnl_any_engine = 0,
    /** CPU engine. */
    dnnl_cpu = 1,
    /** GPU engine. */
    dnnl_gpu = 2;
// Targeting ../dnnl_engine.java


/** \brief An engine handle. */
// Targeting ../dnnl_primitive_desc_iterator.java



/** \brief A primitive descriptor iterator handle. */

/** \brief A constant primitive descriptor iterator handle. */
// Targeting ../dnnl_primitive_desc.java



/** \brief A primitive descriptor handle. */

/** \brief A constant primitive descriptor handle. */

/** \} dnnl_api_primitives_common
 <p>
 *  \addtogroup dnnl_api_attributes
 *  \{
 <p>
 *  Scratchpad mode */
/** enum dnnl_scratchpad_mode_t */
public static final int
    /** The library manages the scratchpad allocation according to the policy
     *  specified by the {@code DNNL_ENABLE_CONCURRENT_EXEC}
     *  [build option](\ref dev_guide_build_options) (default).
     * 
     *  When {@code DNNL_ENABLE_CONCURRENT_EXEC=OFF} (default), the library
     *  scratchpad is common to all primitives to reduce the memory footprint.
     *  This configuration comes with limited thread-safety properties, namely
     *  primitives can be created and executed in parallel but cannot migrate
     *  between threads (in other words, each primitive should be executed in
     *  the same thread it was created in).
     * 
     *  When {@code DNNL_ENABLE_CONCURRENT_EXEC=ON}, the library scratchpad is
     *  private to each primitive. The memory footprint is larger than when
     *  using {@code DNNL_ENABLE_CONCURRENT_EXEC=OFF} but different primitives can be
     *  created and run concurrently (the same primitive cannot be run
     *  concurrently from two different threads though). */
    dnnl_scratchpad_mode_library = 0,
    /** The user manages the scratchpad allocation by querying and providing
     *  the scratchpad memory to primitives. This mode is thread-safe as long
     *  as the scratchpad buffers are not used concurrently by two primitive
     *  executions. */
    dnnl_scratchpad_mode_user = 1;
// Targeting ../dnnl_primitive_attr.java



/** \brief A primitive descriptor attributes handle that controls primitive
 *  behavior. */

/** \brief A constant primitive descriptor attributes handle. */
// Targeting ../dnnl_post_ops.java



/** \brief A post operation chain handle. */

/** \brief A constant post operation chain handle. */
// Targeting ../dnnl_primitive.java


/** A primitive handle. */
/** A constant primitive handle. */

/** Source argument #0. */
public static final int DNNL_ARG_SRC_0 = 1;
/** A special mnemonic for source argument for primitives that have a
 *  single source. An alias for #DNNL_ARG_SRC_0. */
public static final int DNNL_ARG_SRC = DNNL_ARG_SRC_0;
/** A special mnemonic for RNN input vector. An alias for
 *  #DNNL_ARG_SRC_0. */
public static final int DNNL_ARG_SRC_LAYER = DNNL_ARG_SRC_0;
/** A special mnemonic for reorder source argument. An alias for
 *  #DNNL_ARG_SRC_0. */
public static final int DNNL_ARG_FROM = DNNL_ARG_SRC_0;

/** Source argument #1. */
public static final int DNNL_ARG_SRC_1 = 2;
/** A special mnemonic for RNN input recurrent hidden state vector. An alias
 *  for #DNNL_ARG_SRC_1. */
public static final int DNNL_ARG_SRC_ITER = DNNL_ARG_SRC_1;

/** Source argument #2. */
public static final int DNNL_ARG_SRC_2 = 3;
/** A special mnemonic for RNN input recurrent cell state vector. An alias for
 *  #DNNL_ARG_SRC_2. */
public static final int DNNL_ARG_SRC_ITER_C = DNNL_ARG_SRC_2;

/** Destination argument #0. */
public static final int DNNL_ARG_DST_0 = 17;
/** A special mnemonic for destination argument for primitives that have a
 *  single destination. An alias for #DNNL_ARG_DST_0. */
public static final int DNNL_ARG_DST = DNNL_ARG_DST_0;
/** A special mnemonic for reorder destination argument. An alias for
 *  #DNNL_ARG_DST_0. */
public static final int DNNL_ARG_TO = DNNL_ARG_DST_0;
/** A special mnemonic for RNN output vector. An alias for #DNNL_ARG_DST_0. */
public static final int DNNL_ARG_DST_LAYER = DNNL_ARG_DST_0;

/** Destination argument #1. */
public static final int DNNL_ARG_DST_1 = 18;
/** A special mnemonic for RNN input recurrent hidden state vector. An
 *  alias for #DNNL_ARG_DST_1. */
public static final int DNNL_ARG_DST_ITER = DNNL_ARG_DST_1;

/** Destination argument #2. */
public static final int DNNL_ARG_DST_2 = 19;
/** A special mnemonic for LSTM output recurrent cell state vector. An
 *  alias for #DNNL_ARG_DST_2. */
public static final int DNNL_ARG_DST_ITER_C = DNNL_ARG_DST_2;

/** Weights argument #0. */
public static final int DNNL_ARG_WEIGHTS_0 = 33;
/** A special mnemonic for primitives that have a single weights
 *  argument. Alias for #DNNL_ARG_WEIGHTS_0. */
public static final int DNNL_ARG_WEIGHTS = DNNL_ARG_WEIGHTS_0;
/** A special mnemonic for scale and shift argument of normalization
 *  primitives. Alias for #DNNL_ARG_WEIGHTS_0. */
public static final int DNNL_ARG_SCALE_SHIFT = DNNL_ARG_WEIGHTS_0;
/** A special mnemonic for RNN weights applied to the layer input. An
 *  alias for #DNNL_ARG_WEIGHTS_0. */
public static final int DNNL_ARG_WEIGHTS_LAYER = DNNL_ARG_WEIGHTS_0;

/** Weights argument #1. */
public static final int DNNL_ARG_WEIGHTS_1 = 34;
/** A special mnemonic for RNN weights applied to the recurrent input.
 *  An alias for #DNNL_ARG_WEIGHTS_1. */
public static final int DNNL_ARG_WEIGHTS_ITER = DNNL_ARG_WEIGHTS_1;

/** Weights argument #2. */
public static final int DNNL_ARG_WEIGHTS_2 = 35;
/** A special mnemonic for RNN weights applied to the peephole weights.
 *  An alias for #DNNL_ARG_WEIGHTS_2. */
public static final int DNNL_ARG_WEIGHTS_PEEPHOLE = DNNL_ARG_WEIGHTS_2;

/** Weights argument #3. */
public static final int DNNL_ARG_WEIGHTS_3 = 36;
/** A special mnemonic for RNN weights applied to the projection weights.
 *  An alias for #DNNL_ARG_WEIGHTS_3. */
public static final int DNNL_ARG_WEIGHTS_PROJECTION = DNNL_ARG_WEIGHTS_3;

/** Bias tensor argument. */
public static final int DNNL_ARG_BIAS = 41;

/** Mean values tensor argument. */
public static final int DNNL_ARG_MEAN = 49;
/** Variance values tensor argument. */
public static final int DNNL_ARG_VARIANCE = 50;

/** A special mnemonic for scale argument of normalization primitives. */
public static final int DNNL_ARG_SCALE = 51;
/** A special mnemonic for shift argument of normalization primitives. */
public static final int DNNL_ARG_SHIFT = 52;

/** Workspace tensor argument. Workspace is used to pass information
 *  from forward propagation to backward propagation computations. */
public static final int DNNL_ARG_WORKSPACE = 64;
/** Scratchpad (temporary storage) tensor argument. */
public static final int DNNL_ARG_SCRATCHPAD = 80;

/** Gradient (diff) of the source argument #0. */
public static final int DNNL_ARG_DIFF_SRC_0 = 129;
/** A special mnemonic for primitives that have a single diff source argument.
 *  An alias for #DNNL_ARG_DIFF_SRC_0. */
public static final int DNNL_ARG_DIFF_SRC = DNNL_ARG_DIFF_SRC_0;
/** A special mnemonic for gradient (diff) of RNN input vector. An alias for
 *  #DNNL_ARG_DIFF_SRC_0. */
public static final int DNNL_ARG_DIFF_SRC_LAYER = DNNL_ARG_DIFF_SRC_0;

/** Gradient (diff) of the source argument #1. */
public static final int DNNL_ARG_DIFF_SRC_1 = 130;
/** A special mnemonic for gradient (diff) of RNN input recurrent hidden state
 *  vector. An alias for #DNNL_ARG_DIFF_SRC_1. */
public static final int DNNL_ARG_DIFF_SRC_ITER = DNNL_ARG_DIFF_SRC_1;

/** Gradient (diff) of the source argument #2. */
public static final int DNNL_ARG_DIFF_SRC_2 = 131;
/** A special mnemonic for gradient (diff) of RNN input recurrent cell state
 *  vector. An alias for #DNNL_ARG_DIFF_SRC_1. */
public static final int DNNL_ARG_DIFF_SRC_ITER_C = DNNL_ARG_DIFF_SRC_2;

/** Gradient (diff) of the destination argument #0. */
public static final int DNNL_ARG_DIFF_DST_0 = 145;
/** A special mnemonic for primitives that have a single diff destination
 *  argument. An alias for #DNNL_ARG_DIFF_DST_0. */
public static final int DNNL_ARG_DIFF_DST = DNNL_ARG_DIFF_DST_0;
/** A special mnemonic for gradient (diff) of RNN output vector. An alias for
 *  #DNNL_ARG_DIFF_DST_0. */
public static final int DNNL_ARG_DIFF_DST_LAYER = DNNL_ARG_DIFF_DST_0;

/** Gradient (diff) of the destination argument #1. */
public static final int DNNL_ARG_DIFF_DST_1 = 146;
/** A special mnemonic for gradient (diff) of RNN input recurrent hidden state
 *  vector. An alias for #DNNL_ARG_DIFF_DST_1. */
public static final int DNNL_ARG_DIFF_DST_ITER = DNNL_ARG_DIFF_DST_1;

/** Gradient (diff) of the destination argument #2. */
public static final int DNNL_ARG_DIFF_DST_2 = 147;
/** A special mnemonic for gradient (diff) of RNN input recurrent cell state
 *  vector. An alias for #DNNL_ARG_DIFF_DST_2. */
public static final int DNNL_ARG_DIFF_DST_ITER_C = DNNL_ARG_DIFF_DST_2;

/** Gradient (diff) of the weights argument #0. */
public static final int DNNL_ARG_DIFF_WEIGHTS_0 = 161;
/** A special mnemonic for primitives that have a single diff weights
 *  argument. Alias for #DNNL_ARG_DIFF_WEIGHTS_0. */
public static final int DNNL_ARG_DIFF_WEIGHTS = DNNL_ARG_DIFF_WEIGHTS_0;
/** A special mnemonic for diff of scale and shift argument of normalization
 *  primitives. Alias for #DNNL_ARG_DIFF_WEIGHTS_0. */
public static final int DNNL_ARG_DIFF_SCALE_SHIFT = DNNL_ARG_DIFF_WEIGHTS_0;
/** A special mnemonic for diff of RNN weights applied to the layer input. An
 *  alias for #DNNL_ARG_DIFF_WEIGHTS_0. */
public static final int DNNL_ARG_DIFF_WEIGHTS_LAYER = DNNL_ARG_DIFF_WEIGHTS_0;

/** Gradient (diff) of the weights argument #1. */
public static final int DNNL_ARG_DIFF_WEIGHTS_1 = 162;
/** A special mnemonic for diff of RNN weights applied to the recurrent input.
 *  An alias for #DNNL_ARG_DIFF_WEIGHTS_1. */
public static final int DNNL_ARG_DIFF_WEIGHTS_ITER = DNNL_ARG_DIFF_WEIGHTS_1;

/** Gradient (diff) of the weights argument #2. */
public static final int DNNL_ARG_DIFF_WEIGHTS_2 = 163;
/** A special mnemonic for diff of RNN weights applied to the peephole weights.
 *  An alias for #DNNL_ARG_DIFF_WEIGHTS_2. */
public static final int DNNL_ARG_DIFF_WEIGHTS_PEEPHOLE = DNNL_ARG_DIFF_WEIGHTS_2;

/** Gradient (diff) of the weights argument #3. */
public static final int DNNL_ARG_DIFF_WEIGHTS_3 = 164;
/** A special mnemonic for diff of RNN weights applied to the projection
 *  weights. An alias for #DNNL_ARG_DIFF_WEIGHTS_3. */
public static final int DNNL_ARG_DIFF_WEIGHTS_PROJECTION = DNNL_ARG_DIFF_WEIGHTS_3;

/** Gradient (diff) of the bias tensor argument. */
public static final int DNNL_ARG_DIFF_BIAS = 169;

/** A special mnemonic for scale argument of normalization primitives. */
public static final int DNNL_ARG_DIFF_SCALE = 255;
/** A special mnemonic for shift argument of normalization primitives. */
public static final int DNNL_ARG_DIFF_SHIFT = 256;

/** Output scaling factors provided at execution time. */
public static final int DNNL_ARG_ATTR_OUTPUT_SCALES = 513;

/** Starting index for source arguments for primitives that take a variable
 *  number of source arguments. */
public static final int DNNL_ARG_MULTIPLE_SRC = 1024;
/** Starting index for destination arguments for primitives that produce a
 *  variable number of destination arguments. */
public static final int DNNL_ARG_MULTIPLE_DST = 2048;

/** Zero points provided at execution time. */
public static final int DNNL_ARG_ATTR_ZERO_POINTS = 4096;

/** Arguments for fused depthwise convolution.
 *  See \ref dev_guide_attributes_post_ops_depthwise_fusion */
public static final int DNNL_ARG_ATTR_POST_OP_DW = 8192;

/** Starting point for a binary post operation. */
public static final int DNNL_ARG_ATTR_MULTIPLE_POST_OP_BASE = 16384;

/** Arguments for a binary post operation. Up to 32 arguments are supported.
 *  See \ref dev_guide_attributes_post_ops_binary_fusion */
// #define DNNL_ARG_ATTR_MULTIPLE_POST_OP(idx)
//     (DNNL_ARG_ATTR_MULTIPLE_POST_OP_BASE * ((idx) + 1))

/** Input scaling factors provided at execution time. */
public static final int DNNL_ARG_ATTR_INPUT_SCALES = 1048576;
// Targeting ../dnnl_exec_arg_t.java



/** \} dnnl_api_primitives_common
 <p>
 *  \addtogroup dnnl_api_primitives_common
 *  \{
 <p>
 *  Primitive descriptor query specification
 * 
 *  For generic function dnnl_primitive_desc_query(), the type of result must
 *  agree with the queried argument. The correspondence table:
 * 
 *  Query kind                      | Type of query result
 *  --------------------------------|-----------------------------
 *  #dnnl_query_engine              | #dnnl_engine_t *
 *  #dnnl_query_scratchpad_engine   | #dnnl_engine_t *
 *  #dnnl_query_primitive_kind      | #dnnl_primitive_kind_t *
 *  dnnl_query_*_s32                | int *
 *  dnnl_query_*_s64                | #dnnl_dim_t * (same as int64_t *)
 *  dnnl_query_*_f64                | double *
 *  dnnl_query_*_str                | const char **
 *  #dnnl_query_op_d                | #const_dnnl_op_desc_t *
 *  dnnl_query_*_md                 | const #dnnl_memory_desc_t **
 *  dnnl_query_*_\<op\>_d           | const dnnl_\<op\>_desc_t **
 *  dnnl_query_*_pd                 | #const_dnnl_primitive_desc_t *
 * 
 *  \note
 *      Rule of thumb: all opaque types and structures are returned by
 *      reference. All numbers are returned by value.
 * 
 *  \warning
 *      All returned references point to constant objects and are valid only
 *      during the lifetime of the queried primitive descriptor. Returned objects
 *      must not be destroyed by the user. If you need to keep the object longer
 *      than the lifetime of the queried primitive descriptor, use
 *      dnnl_primitive_desc_clone() to make a copy. */
/** enum dnnl_query_t */
public static final int
    /** no query */
    dnnl_query_undef = 0,

    /** execution engine */
    dnnl_query_engine = 1,
    /** primitive kind */
    dnnl_query_primitive_kind = 2,

    /** number of inputs expected */
    dnnl_query_num_of_inputs_s32 = 3,
    /** number of outputs expected */
    dnnl_query_num_of_outputs_s32 = 4,

    /** runtime estimation (seconds) */
    dnnl_query_time_estimate_f64 = 5,
    /** memory consumption -- extra */
    dnnl_query_memory_consumption_s64 = 6,
    /**  (scratch) memory, additional to
     *   all inputs and outputs memory
     *   (bytes) */

    /** scratchpad engine -- engine to be used */
    dnnl_query_scratchpad_engine = 7,
    /**  for creating scratchpad memory */

    /** implementation name */
    dnnl_query_impl_info_str = 8,

    /** source engine */
    dnnl_query_reorder_src_engine = 9,
    /** destination engine */
    dnnl_query_reorder_dst_engine = 10,

    /** propagation kind */
    dnnl_query_prop_kind = 11,

    // memory and op descriptor section
    /** stub */
    dnnl_query_some_d = 64,
    /** op descriptor */
    dnnl_query_op_d = 65,
    /** convolution descriptor */
    dnnl_query_convolution_d = 66,
    /** deconvolution descriptor */
    dnnl_query_deconvolution_d = 67,
    /** shuffle descriptor */
    dnnl_query_shuffle_d = 68,
    /** eltwise descriptor */
    dnnl_query_eltwise_d = 69,
    /** softmax descriptor */
    dnnl_query_softmax_d = 70,
    /** pooling descriptor */
    dnnl_query_pooling_d = 71,
    /** lrn descriptor */
    dnnl_query_lrn_d = 72,
    /** batch normalization descriptor */
    dnnl_query_batch_normalization_d = 73,
    /** layer normalization descriptor */
    dnnl_query_layer_normalization_d = 74,
    /** inner product descriptor */
    dnnl_query_inner_product_d = 75,
    /** rnn descriptor */
    dnnl_query_rnn_d = 76,
    /** GEMM descriptor (internal) */
    dnnl_query_gemm_d = 77,
    /** binary descriptor */
    dnnl_query_binary_d = 78,
    /** logsoftmax descriptor */
    dnnl_query_logsoftmax_d = 79,
    /** matrix multiplication (matmul) descriptor */
    dnnl_query_matmul_d = 80,
    /** resampling descriptor */
    dnnl_query_resampling_d = 81,
    /** pooling version 2 descriptor */
    dnnl_query_pooling_v2_d = 82,
    /** reduction descriptor */
    dnnl_query_reduction_d = 83,
    /** prelu descriptor */
    dnnl_query_prelu_d = 84,

    // memory descriptor section
    /** stub */
    dnnl_query_some_md = 128,
    /** source memory desc */
    dnnl_query_src_md = 129,
    /** source gradient memory desc */
    dnnl_query_diff_src_md = 130,
    /** weights memory descriptor desc */
    dnnl_query_weights_md = 131,
    /** weights grad. memory desc */
    dnnl_query_diff_weights_md = 132,
    /** destination memory desc */
    dnnl_query_dst_md = 133,
    /** destination grad. memory desc */
    dnnl_query_diff_dst_md = 134,
    /** workspace memory desc */
    dnnl_query_workspace_md = 135,
    /** scratchpad memory desc */
    dnnl_query_scratchpad_md = 136,
    /** memory desc of an execute argument */
    dnnl_query_exec_arg_md = 255,

    // Max value to prevent UB for internal use only dnnl_query_t
    dnnl_query_max = 0x7fff;

/** \} dnnl_api_primitives_common
 <p>
 *  \} dnnl_api_primitives
 <p>
 *  \addtogroup dnnl_api_stream
 *  \{
 <p>
 *  \brief Stream flags. */
/** enum dnnl_stream_flags_t */
public static final int
    // In-order execution.
    dnnl_stream_in_order = 0x1,
    /** Out-of-order execution. */
    dnnl_stream_out_of_order = 0x2,
    /** Default stream configuration. */
    dnnl_stream_default_flags = dnnl_stream_in_order;
// Targeting ../dnnl_stream.java


/** An execution stream handle. */
/** A constant execution stream handle. */

/** \} dnnl_api_stream
 <p>
 *  \addtogroup dnnl_api_service
 *  \{
 <p>
 *  No runtime (disabled) */
public static final int DNNL_RUNTIME_NONE = 0;

/** Sequential runtime (CPU only) */
public static final int DNNL_RUNTIME_SEQ = 1;

/** OpenMP runtime (CPU only) */
public static final int DNNL_RUNTIME_OMP = 2;

/** TBB runtime (CPU only) */
public static final int DNNL_RUNTIME_TBB = 4;

/** Threadpool runtime (CPU only) */
public static final int DNNL_RUNTIME_THREADPOOL = 8;

/** OpenCL runtime */
public static final int DNNL_RUNTIME_OCL = 256;

/** SYCL runtime */
public static final int DNNL_RUNTIME_SYCL = 512;

/** DPC++ runtime */
public static final int DNNL_RUNTIME_DPCPP = DNNL_RUNTIME_SYCL;
// Targeting ../dnnl_version_t.java



/** Disable profiling completely */
public static final int DNNL_JIT_PROFILE_NONE = 0;

/** Enable VTune Amplifier integration */
public static final int DNNL_JIT_PROFILE_VTUNE = 1;

/** Enable Linux perf integration via perfmap files */
public static final int DNNL_JIT_PROFILE_LINUX_PERFMAP = 2;

/** Enable Linux perf integration via jitdump files */
public static final int DNNL_JIT_PROFILE_LINUX_JITDUMP = 4;

/** Instruct Linux perf integration via jitdump files to use TSC. \ref
 *  DNNL_JIT_PROFILE_LINUX_JITDUMP must be set too for this to take effect. */
public static final int DNNL_JIT_PROFILE_LINUX_JITDUMP_USE_TSC = 8;

/** Enable Linux perf integration (both jitdump and perfmap) */
public static final int DNNL_JIT_PROFILE_LINUX_PERF = 
    (DNNL_JIT_PROFILE_LINUX_JITDUMP | DNNL_JIT_PROFILE_LINUX_PERFMAP);

/** CPU instruction set flags */
/** enum dnnl_cpu_isa_t */
public static final int
    /** Any ISA (excepting those listed as initial support) */
    dnnl_cpu_isa_all = 0x0,

    /** Intel Streaming SIMD Extensions 4.1 (Intel SSE4.1) */
    dnnl_cpu_isa_sse41 = 0x1,

    /** Intel Advanced Vector Extensions (Intel AVX) */
    dnnl_cpu_isa_avx = 0x3,

    /** Intel Advanced Vector Extensions 2 (Intel AVX2) */
    dnnl_cpu_isa_avx2 = 0x7,

    /** Intel Advanced Vector Extensions 512 (Intel AVX-512) subset
     *  for Intel Xeon Phi processors x200 Series. */
    dnnl_cpu_isa_avx512_mic = 0xf,

    /** Intel AVX-512 subset
     *  for Intel Xeon Phi processors 7235, 7285, 7295 Series. */
    dnnl_cpu_isa_avx512_mic_4ops = 0x1f,

    /** Intel AVX-512 subset for Intel Xeon Scalable processor family
     *  and Intel Core processor family. */
    dnnl_cpu_isa_avx512_core = 0x27,

    /** Intel AVX-512 and Intel Deep Learning Boost (Intel DL Boost) support
     *  for Intel Xeon Scalable processor family
     *  and Intel Core processor family. */
    dnnl_cpu_isa_avx512_core_vnni = 0x67,

    /** Intel AVX-512, Intel DL Boost and bfloat16 support
     *  for Intel Xeon Scalable processor family
     *  and Intel Core processor family. */
    dnnl_cpu_isa_avx512_core_bf16 = 0xe7,

    /** Intel AVX-512, Intel DL Boost and bfloat16 support and
     *  Intel AMX with 8-bit integer and bfloat16 support
     *  (initial support) */
    dnnl_cpu_isa_avx512_core_amx = 0x3e7,

    /** Intel AVX2 and Intel Deep Learning Boost (Intel DL Boost) support */
    dnnl_cpu_isa_avx2_vnni = 0x407;

/** CPU ISA hints flags */
/** enum dnnl_cpu_isa_hints_t */
public static final int
    /** No hints (use default features) */
    dnnl_cpu_isa_no_hints = 0x0,

    /** Prefer to exclusively use Ymm registers for computations */
    dnnl_cpu_isa_prefer_ymm = 0x1;

/** \} dnnl_api_service
 <p>
 *  \} dnnl_api */

// #ifdef __cplusplus
// #endif

// #endif /* ONEAPI_DNNL_TYPES_H */


// Parsed from oneapi/dnnl/dnnl_config.h

/*******************************************************************************
* Copyright 2019-2021 Intel Corporation
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*******************************************************************************/

// #ifndef ONEAPI_DNNL_DNNL_CONFIG_H
// #define ONEAPI_DNNL_DNNL_CONFIG_H

// #include "oneapi/dnnl/dnnl_types.h"

/** \cond DO_NOT_DOCUMENT_THIS */

// All symbols shall be internal unless marked as DNNL_API
// #if defined _WIN32 || defined __CYGWIN__
// #define DNNL_HELPER_DLL_IMPORT __declspec(dllimport)
// #define DNNL_HELPER_DLL_EXPORT __declspec(dllexport)
// #else
// #if __GNUC__ >= 4
// #define DNNL_HELPER_DLL_IMPORT __attribute__((visibility("default")))
// #define DNNL_HELPER_DLL_EXPORT __attribute__((visibility("default")))
// #else
// #define DNNL_HELPER_DLL_IMPORT
// #define DNNL_HELPER_DLL_EXPORT
// #endif
// #endif

// #ifdef DNNL_DLL
// #ifdef DNNL_DLL_EXPORTS
// #define DNNL_API DNNL_HELPER_DLL_EXPORT
// #else
// #define DNNL_API DNNL_HELPER_DLL_IMPORT
// #endif
// #else
// #define DNNL_API
// #endif

// #if defined(__GNUC__)
// #define DNNL_DEPRECATED __attribute__((deprecated))
// #elif defined(_MSC_VER)
// #define DNNL_DEPRECATED __declspec(deprecated)
// #else
// #define DNNL_DEPRECATED
// #endif

/** \endcond */

// clang-format off

// oneDNN CPU threading runtime
public static final int DNNL_CPU_THREADING_RUNTIME = DNNL_RUNTIME_OMP;

// oneDNN CPU engine runtime
public static final int DNNL_CPU_RUNTIME = DNNL_RUNTIME_OMP;

// oneDNN GPU engine runtime
public static final int DNNL_GPU_RUNTIME = DNNL_RUNTIME_OCL;

// clang-format on

// #if defined(DNNL_CPU_RUNTIME) && defined(DNNL_GPU_RUNTIME)
// #if (DNNL_CPU_RUNTIME == DNNL_RUNTIME_OCL)
// #error "Unexpected DNNL_CPU_RUNTIME"
// #endif
// #if (DNNL_GPU_RUNTIME != DNNL_RUNTIME_NONE)
//         && (DNNL_GPU_RUNTIME != DNNL_RUNTIME_OCL)
//         && (DNNL_GPU_RUNTIME != DNNL_RUNTIME_SYCL)
// #error "Unexpected DNNL_GPU_RUNTIME"
// #endif
// #if (DNNL_CPU_RUNTIME == DNNL_RUNTIME_NONE
//         && DNNL_GPU_RUNTIME == DNNL_RUNTIME_NONE)
// #error "At least one runtime must be specified"
// #endif
// #else
// #error "BOTH DNNL_CPU_RUNTIME and DNNL_GPU_RUNTIME must be defined"
// #endif

// For SYCL CPU, a primitive may be created and executed in different threads
// hence the global scratchpad does not work. This enables concurrent execution
// when CPU runtime is SYCL to avoid the issue.
// #if DNNL_CPU_RUNTIME == DNNL_RUNTIME_SYCL
// #ifndef DNNL_ENABLE_CONCURRENT_EXEC
// #define DNNL_ENABLE_CONCURRENT_EXEC
// #endif
// #endif

// When defined, primitive cache stores runtime objects.
/* #undef DNNL_USE_RT_OBJECTS_IN_PRIMITIVE_CACHE */

// When defined, DPCPP is supported.
/* #undef DNNL_WITH_SYCL */

// When defined, Level Zero is supported.
/* #undef DNNL_WITH_LEVEL_ZERO */

// When defined, SYCL CUDA backend is used.
/* #undef DNNL_SYCL_CUDA */

// #endif


// Parsed from oneapi/dnnl/dnnl_version.h

/*******************************************************************************
* Copyright 2019-2020 Intel Corporation
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*******************************************************************************/

// #ifndef ONEAPI_DNNL_DNNL_VERSION_H
// #define ONEAPI_DNNL_DNNL_VERSION_H

// clang-format off

/** Major version */
public static final int DNNL_VERSION_MAJOR = 2;

/** Minor version */
public static final int DNNL_VERSION_MINOR = 3;

/** Patch version */
public static final int DNNL_VERSION_PATCH = 0;

/** Git commit hash */
public static native @MemberGetter String DNNL_VERSION_HASH();
public static final String DNNL_VERSION_HASH = DNNL_VERSION_HASH();

// clang-format on

// #endif


// Parsed from oneapi/dnnl/dnnl.h

/*******************************************************************************
* Copyright 2016-2021 Intel Corporation
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*******************************************************************************/

/** \file
/** C API */

// #ifndef ONEAPI_DNNL_DNNL_H
// #define ONEAPI_DNNL_DNNL_H

// #include "oneapi/dnnl/dnnl_config.h"
// #include "oneapi/dnnl/dnnl_types.h"
// #include "oneapi/dnnl/dnnl_version.h"

// #ifdef __cplusplus
// #endif

/** \addtogroup dnnl_api
 *  \{
 <p>
 *  \addtogroup dnnl_api_primitives
 *  \{
 <p>
 *  \addtogroup dnnl_api_primitives_common
 *  \{
 <p>
 *  Creates a primitive descriptor iterator.
 * 
 *  @param iterator Output primitive descriptor iterator.
 *  @param op_desc Operation descriptor.
 *  @param attr Primitive attributes (can be NULL).
 *  @param engine Engine to use.
 *  @param hint_forward_primitive_desc For backward propagation: primitive
 *      descriptor for a respective forward propagation primitive. Pass NULL
 *      for forward propagation.
 *  @return #dnnl_success on success and a status describing the error
 *      otherwise. */

///
public static native @Cast("dnnl_status_t") int dnnl_primitive_desc_iterator_create(
        @ByPtrPtr dnnl_primitive_desc_iterator iterator, const_dnnl_op_desc_t op_desc,
        @Const dnnl_primitive_attr attr, dnnl_engine engine,
        @Const dnnl_primitive_desc hint_forward_primitive_desc);
public static native @Cast("dnnl_status_t") int dnnl_primitive_desc_iterator_create(
        @Cast("dnnl_primitive_desc_iterator_t*") PointerPointer iterator, const_dnnl_op_desc_t op_desc,
        @Const dnnl_primitive_attr attr, dnnl_engine engine,
        @Const dnnl_primitive_desc hint_forward_primitive_desc);

/** Advances the primitive descriptor iterator to point to the next available
 *  implementation.
 * 
 *  @param iterator A primitive descriptor iterator to advance.
 *  @return #dnnl_success on success and a status describing the error
 *      otherwise.
 *  @return #dnnl_iterator_ends if no more implementations available. */

///
///
public static native @Cast("dnnl_status_t") int dnnl_primitive_desc_iterator_next(
        dnnl_primitive_desc_iterator iterator);

/** Fetches the current primitive descriptor from a primitive descriptor
 *  iterator.
 * 
 *  \note
 *      The user is responsible for deleting the resulting primitive
 *      descriptor using dnnl_primitive_desc_destroy().
 * 
 *  @param iterator A primitive descriptor iterator.
 *  @return A primitive descriptor. */

///
public static native dnnl_primitive_desc dnnl_primitive_desc_iterator_fetch(
        @Const dnnl_primitive_desc_iterator iterator);

/** Destroys a primitive descriptor iterator.
 * 
 *  @param iterator Primitive descriptor iterator to destroy.
 *  @return #dnnl_success on success and a status describing the error
 *      otherwise. */

///
public static native @Cast("dnnl_status_t") int dnnl_primitive_desc_iterator_destroy(
        dnnl_primitive_desc_iterator iterator);

/** Creates a primitive descriptor. This function is equivalent to a sequence
 *  of #dnnl_primitive_desc_iterator_create() and
 *  #dnnl_primitive_desc_iterator_fetch(). In other words, the library will
 *  pick the first suitable implementation.
 * 
 *  @param primitive_desc Output primitive descriptor.
 *  @param op_desc Operation descriptor.
 *  @param attr Primitive attributes (can be NULL).
 *  @param engine Engine to use.
 *  @param hint_forward_primitive_desc For backward propagation: primitive
 *      descriptor for a respective forward propagation primitive. Pass NULL
 *      for forward propagation.
 *  @return #dnnl_success on success and a status describing the error
 *      otherwise. */

///
public static native @Cast("dnnl_status_t") int dnnl_primitive_desc_create(
        @ByPtrPtr dnnl_primitive_desc primitive_desc, const_dnnl_op_desc_t op_desc,
        @Const dnnl_primitive_attr attr, dnnl_engine engine,
        @Const dnnl_primitive_desc hint_forward_primitive_desc);
public static native @Cast("dnnl_status_t") int dnnl_primitive_desc_create(
        @Cast("dnnl_primitive_desc_t*") PointerPointer primitive_desc, const_dnnl_op_desc_t op_desc,
        @Const dnnl_primitive_attr attr, dnnl_engine engine,
        @Const dnnl_primitive_desc hint_forward_primitive_desc);

/** Clones a primitive descriptor. The resulting primitive descriptor must be
 *  destroyed separately.
 * 
 *  @param primitive_desc Output primitive descriptor.
 *  @param existing_primitive_desc Primitive descriptor to clone.
 *  @return #dnnl_success on success and a status describing the error
 *      otherwise. */

///
///
///
public static native @Cast("dnnl_status_t") int dnnl_primitive_desc_clone(
        @ByPtrPtr dnnl_primitive_desc primitive_desc,
        @Const dnnl_primitive_desc existing_primitive_desc);
public static native @Cast("dnnl_status_t") int dnnl_primitive_desc_clone(
        @Cast("dnnl_primitive_desc_t*") PointerPointer primitive_desc,
        @Const dnnl_primitive_desc existing_primitive_desc);

/** Returns a constant reference to the attributes of a primitive descriptor.
 * 
 *  \warning
 *      It is an error to destroy the resulting \p attr.
 * 
 *  \warning
 *      The lifetime of an \p attr is the same as that of a \p
 *      primitive_desc, so it is an error to use the \p attr once the \p
 *      primitive_desc has been destroyed.
 * 
 *  @param primitive_desc Primitive descriptor.
 *  @param attr Output primitive attributes.
 *  @return #dnnl_success on success and a status describing the error
 *      otherwise. */

///
public static native @Cast("dnnl_status_t") int dnnl_primitive_desc_get_attr(
        @Const dnnl_primitive_desc primitive_desc,
        @Const @ByPtrPtr dnnl_primitive_attr attr);
public static native @Cast("dnnl_status_t") int dnnl_primitive_desc_get_attr(
        @Const dnnl_primitive_desc primitive_desc,
        @Cast("const_dnnl_primitive_attr_t*") PointerPointer attr);

/** Destroys a primitive descriptor.
 * 
 *  @param primitive_desc Primitive descriptor to destroy.
 *  @return #dnnl_success on success and a status describing the error
 *      otherwise. */

///
///
///
///
///
///
public static native @Cast("dnnl_status_t") int dnnl_primitive_desc_destroy(
        dnnl_primitive_desc primitive_desc);

/** Queries a primitive descriptor for various pieces of information.
 * 
 *  The most common use case is to query a primitive descriptor, created with
 *  source, weights, and destination memory descriptors with format tags set
 *  to #dnnl_format_tag_any, for the corresponding memory descriptors (in this
 *  case the \p what is set to #dnnl_query_src_md, #dnnl_query_weights_md, and
 *  #dnnl_query_dst_md respectively) so that it is possible to create memory
 *  objects and reorder primitives if necessary.
 * 
 *  Another typical use case is to query a primitive descriptor for workspace
 *  memory descriptor (with \p what set to #dnnl_query_workspace_md). If this
 *  query returns #dnnl_not_required status, then workspace memory is not
 *  required.
 * 
 *  \note
 *      When querying for a memory descriptor for a scratchpad, a workspace,
 *      or an optional parameter, the query will return a pointer to a zero
 *      memory descriptor if the parameter is not needed.
 * 
 *  A few other use cases:
 *   - query a primitive descriptor for the underlying operation descriptor
 *     (#dnnl_query_convolution_d, #dnnl_query_eltwise_d, #dnnl_query_rnn_d,
 *     etc.)
 *   - query a primitive descriptor for the implementation information string
 *     (#dnnl_query_impl_info_str)
 *   - query a primitive descriptor for the number of inputs and outputs
 *     (#dnnl_query_num_of_inputs_s32 and #dnnl_query_num_of_outputs_s32
 *     respectively)
 * 
 *  @see dnnl_query_t for more options
 * 
 *  @param primitive_desc Primitive descriptor.
 *  @param what Parameter to query.
 *  @param index Index of the parameter to query for.
 *  @param result Output result. The type depends on the query. For example,
 *      it must be a \c dnnl_memory_desc_t* if querying for a memory
 *      descriptor.
 *  @return #dnnl_success on success and a status describing the error
 *      otherwise. */

///
///
///
public static native @Cast("dnnl_status_t") int dnnl_primitive_desc_query(
        @Const dnnl_primitive_desc primitive_desc, @Cast("dnnl_query_t") int what,
        int index, Pointer result);

/** Queries primitive descriptor for a memory descriptor.
 * 
 *  \note
 *      This function is a convenience version of
 *      #dnnl_primitive_desc_query().
 * 
 *  @param primitive_desc Primitive descriptor.
 *  @param what Kind of memory descriptor parameter to query for.
 *  @param index Index of the parameter to query.
 *  @return A pointer to the requested memory descriptor.
 *  @return A pointer to a zero memory descriptor if the parameter is not
 *           needed.
 *  @return NULL in case of any error.
 *  */

///
///
public static native @Const dnnl_memory_desc_t dnnl_primitive_desc_query_md(
        @Const dnnl_primitive_desc primitive_desc, @Cast("dnnl_query_t") int what,
        int index);

/** Queries primitive descriptor for a signed 32bit int.
 * 
 *  \note
 *      This function is a convenience version of
 *      #dnnl_primitive_desc_query().
 * 
 *  @param primitive_desc Primitive descriptor.
 *  @param what Kind of the value to query for.
 *  @param index Index of the parameter to query.
 *  @return The requested value.
 *  @return 0 in case of any error (in particular if the queried entity is
 *      not of type int32_t). Note that 0 may also be the actual returned
 *      value. */

///
public static native int dnnl_primitive_desc_query_s32(
        @Const dnnl_primitive_desc primitive_desc, @Cast("dnnl_query_t") int what,
        int index);

/** Creates a primitive.
 * 
 *  @param primitive Output primitive.
 *  @param primitive_desc Primitive descriptor used to create the primitive.
 *  @return #dnnl_success on success and a status describing the error
 *      otherwise. */

///
public static native @Cast("dnnl_status_t") int dnnl_primitive_create(@ByPtrPtr dnnl_primitive primitive,
        @Const dnnl_primitive_desc primitive_desc);
public static native @Cast("dnnl_status_t") int dnnl_primitive_create(@Cast("dnnl_primitive_t*") PointerPointer primitive,
        @Const dnnl_primitive_desc primitive_desc);

/** Executes a primitive.
 * 
 *  @param primitive Primitive to execute.
 *  @param stream Stream to use.
 *  @param nargs Number of arguments.
 *  @param args Array of arguments. Each argument is an
 *      <index, #dnnl_memory_t> pair. The index is one of the {@code DNNL_ARG_*}
 *      values such as {@code DNNL_ARG_SRC}. Unless runtime shapes are used (see
 *      #DNNL_RUNTIME_DIM_VAL), the memory object must have the same memory
 *      descriptor as that returned by
 *      #dnnl_primitive_desc_query_md(#dnnl_query_exec_arg_md, index).
 *  @return #dnnl_success on success and a status describing the error
 *      otherwise.
 <p>
 *  \note If any argument in @param args is padded (padded_dims >
 *  dims), the primitive execution will assume properly zero-padded
 *  input arguments, and produce zero-padded output arguments. */

///
///
public static native @Cast("dnnl_status_t") int dnnl_primitive_execute(@Const dnnl_primitive primitive,
        dnnl_stream stream, int nargs, @Const dnnl_exec_arg_t args);

/** Retrieves a constant reference to the primitive descriptor of a given
 *  primitive.
 * 
 *  \warning
 *      It is an error to destroy the returned object. It is owned by the
 *      primitive. The \c const qualifier of the returned object prevents
 *      such attempts.
 * 
 *  @param primitive Primitive to query for the primitive descriptor.
 *  @param primitive_desc Output primitive descriptor.
 *  @return #dnnl_success on success and a status describing the error
 *      otherwise. */

///
public static native @Cast("dnnl_status_t") int dnnl_primitive_get_primitive_desc(
        @Const dnnl_primitive primitive,
        @Const @ByPtrPtr dnnl_primitive_desc primitive_desc);
public static native @Cast("dnnl_status_t") int dnnl_primitive_get_primitive_desc(
        @Const dnnl_primitive primitive,
        @Cast("const_dnnl_primitive_desc_t*") PointerPointer primitive_desc);

/** Destroys a primitive.
 * 
 *  @param primitive The primitive to destroy.
 *  @return #dnnl_success on success and a status describing the error
 *      otherwise. */

///
///
public static native @Cast("dnnl_status_t") int dnnl_primitive_destroy(dnnl_primitive primitive);

/** \} dnnl_api_primitives_common
 <p>
 *  \addtogroup dnnl_api_attributes
 *  \{
 <p>
 *  Creates an empty (default) primitive attributes with all the parameters
 *  set to their default values.
 * 
 *  Empty attributes are implied whenever the respective argument is NULL.
 * 
 *  @param attr Output primitive attributes.
 *  @return #dnnl_success on success and a status describing the error
 *      otherwise. */

///
public static native @Cast("dnnl_status_t") int dnnl_primitive_attr_create(@ByPtrPtr dnnl_primitive_attr attr);
public static native @Cast("dnnl_status_t") int dnnl_primitive_attr_create(@Cast("dnnl_primitive_attr_t*") PointerPointer attr);

/** Clones primitive attributes.
 * 
 *  @param attr Output primitive attributes.
 *  @param existing_attr Primitive attributes to clone.
 *  @return #dnnl_success on success and a status describing the error
 *      otherwise. */

///
public static native @Cast("dnnl_status_t") int dnnl_primitive_attr_clone(
        @ByPtrPtr dnnl_primitive_attr attr, @Const dnnl_primitive_attr existing_attr);
public static native @Cast("dnnl_status_t") int dnnl_primitive_attr_clone(
        @Cast("dnnl_primitive_attr_t*") PointerPointer attr, @Const dnnl_primitive_attr existing_attr);

/** Destroys primitive attributes.
 * 
 *  @param attr Primitive attributes to destroy.
 *  @return #dnnl_success on success and a status describing the error
 *      otherwise. */

///
public static native @Cast("dnnl_status_t") int dnnl_primitive_attr_destroy(dnnl_primitive_attr attr);

/** Returns the primitive attributes scratchpad mode.
 * 
 *  @param attr Primitive attributes.
 *  @param mode Output scratchpad mode.
 *  @return #dnnl_success on success and a status describing the error
 *      otherwise. */

///
public static native @Cast("dnnl_status_t") int dnnl_primitive_attr_get_scratchpad_mode(
        @Const dnnl_primitive_attr attr, @Cast("dnnl_scratchpad_mode_t*") IntPointer mode);
public static native @Cast("dnnl_status_t") int dnnl_primitive_attr_get_scratchpad_mode(
        @Const dnnl_primitive_attr attr, @Cast("dnnl_scratchpad_mode_t*") IntBuffer mode);
public static native @Cast("dnnl_status_t") int dnnl_primitive_attr_get_scratchpad_mode(
        @Const dnnl_primitive_attr attr, @Cast("dnnl_scratchpad_mode_t*") int[] mode);

/** Sets primitive attributes scratchpad mode.
 * 
 *  @param attr Primitive attributes.
 *  @param mode Scratchpad mode. The possible values are:
 *      #dnnl_scratchpad_mode_library (default) and
 *      #dnnl_scratchpad_mode_user.
 *  @return #dnnl_success on success and a status describing the error
 *      otherwise. */

///
///
///
public static native @Cast("dnnl_status_t") int dnnl_primitive_attr_set_scratchpad_mode(
        dnnl_primitive_attr attr, @Cast("dnnl_scratchpad_mode_t") int mode);

/** Returns primitive attributes output scaling factors correspondence mask
 *  and values.
 * 
 *  \warning
 *      The \p scales array is an internal part of the primitive attributes
 *      \p attr, so it is an error to modify or destroy the \p scales array.
 * 
 *  \warning
 *      The lifetime of \p scales array is the same as that of the primitive
 *      attributes \p attr to which it belongs, so it is an error to use
 *      \p scales after \p attr is destroyed.
 * 
 *  @param attr Primitive attributes.
 *  @param count Output length of the array of scaling factors \p scales.
 *  @param mask Output scaling factors correspondence mask that defines the
 *      correspondence between the output tensor dimensions and the \p scales
 *      vector. The set i-th bit indicates that a dedicated output scaling
 *      factor is used for each index along that dimension. The mask value of
 *      0 implies a common output scaling factor for the whole output tensor.
 *  @param scales Output pointer to a constant array of scaling factors.
 *  @return #dnnl_success on success and a status describing the error
 *      otherwise. */

///
///
///
///
///
///
public static native @Cast("dnnl_status_t") int dnnl_primitive_attr_get_output_scales(
        @Const dnnl_primitive_attr attr, @Cast("dnnl_dim_t*") LongPointer count, IntPointer mask,
        @Cast("const float**") PointerPointer scales);
public static native @Cast("dnnl_status_t") int dnnl_primitive_attr_get_output_scales(
        @Const dnnl_primitive_attr attr, @Cast("dnnl_dim_t*") LongPointer count, IntPointer mask,
        @Const @ByPtrPtr FloatPointer scales);
public static native @Cast("dnnl_status_t") int dnnl_primitive_attr_get_output_scales(
        @Const dnnl_primitive_attr attr, @Cast("dnnl_dim_t*") LongBuffer count, IntBuffer mask,
        @Const @ByPtrPtr FloatBuffer scales);
public static native @Cast("dnnl_status_t") int dnnl_primitive_attr_get_output_scales(
        @Const dnnl_primitive_attr attr, @Cast("dnnl_dim_t*") long[] count, int[] mask,
        @Const @ByPtrPtr float[] scales);

/** Sets output scaling factors correspondence mask and values.
 * 
 *  \note
 *      The order of dimensions does not depend on how elements are laid
 *      out in memory. For example:
 *      - for a 2D CNN activations tensor the order is always (n, c)
 *      - for a 4D CNN activations tensor the order is always (n, c, h, w)
 *      - for a 5D CNN weights tensor the order is always
 *         (g, oc, ic, kh, kw)
 * 
 *  Example usage:
 *  <pre>{@code
 *      int mb = 32, oc = 32, oh = 14, ow = 14; // convolution output params
 *      float scales[oc] = { ... }; // unique output scales per output channel
 *      int oc_dim = 1; // mb_dim = 0, channel_dim = 1, height_dim = 2, ...
 * 
 *      dnnl_convolution_desc_t conv_d; // create a convolution descriptor
 * 
 *      dnnl_primitive_attr_t attr;
 *      dnnl_primitive_attr_create(&attr); // create primitive attributes
 *      dnnl_primitive_attr_set_output_scales(attr, oc, 1 << oc_dim, scales);
 * 
 *      dnnl_primitive_desc_t conv_pd;
 *      dnnl_primitive_desc_create(&conv_pd, &conv_d, attr, engine, NULL);
 *  }</pre>
 * 
 *  @param attr Primitive attributes.
 *  @param count Length of the array of scaling factors \p scales.
 *  @param mask Scaling factors correspondence mask that defines the
 *      correspondence between the output tensor dimensions and the \p scales
 *      array. The set i-th bit indicates that a dedicated output scaling
 *      factor is used for each index along that dimension. The mask value of
 *      0 implies a common output scaling factor for the whole output tensor.
 *  @param scales Array of output scaling factors. If the output scaling
 *      factors are known at the time of this call, this array must contain \p
 *      count values and the following equality must hold:
 *      <pre>{@code \[count = \prod\limits_{d \in mask} output.dims[d].\]}</pre>
 *      Violations can only be detected when the attributes are used to create
 *      a primitive descriptor.
 *      If the output scaling factors are not known at the time of the call,
 *      this array must contain a single #DNNL_RUNTIME_F32_VAL value and the
 *      output scaling factors must be passed at execution time as an argument
 *      with index #DNNL_ARG_ATTR_OUTPUT_SCALES.
 *  @return #dnnl_success on success and a status describing the error
 *      otherwise. */

///
///
///
///
public static native @Cast("dnnl_status_t") int dnnl_primitive_attr_set_output_scales(
        dnnl_primitive_attr attr, @Cast("dnnl_dim_t") long count, int mask,
        @Const FloatPointer scales);
public static native @Cast("dnnl_status_t") int dnnl_primitive_attr_set_output_scales(
        dnnl_primitive_attr attr, @Cast("dnnl_dim_t") long count, int mask,
        @Const FloatBuffer scales);
public static native @Cast("dnnl_status_t") int dnnl_primitive_attr_set_output_scales(
        dnnl_primitive_attr attr, @Cast("dnnl_dim_t") long count, int mask,
        @Const float[] scales);

/** Returns primitive attributes scaling factors correspondence mask and values
 *  for a given memory argument.
 * 
 *  \warning
 *      The output \p scales array is an internal part of the primitive
 *      attributes \p attr, so it is an error to modify or destroy the \p
 *      scales array.
 * 
 *  \warning
 *      The lifetime of the \p scales array is the same as that of the primitive
 *      attributes \p attr to which it belongs, so it is an error to use \p
 *      scales after \p attr is destroyed.
 * 
 * 
 *  @param attr Primitive attributes.
 *  @param arg Parameter argument index as passed to the
 *      dnnl_primitive_execute() call.
 *  @param count Output length of the array of scaling factors \p scales.
 *  @param mask Output scaling factors correspondence mask that defines the
 *      correspondence between the output tensor dimensions and the \p
 *      scales array. The set i-th bit indicates that a dedicated output scaling
 *      factor is used for each index along that dimension. The mask value of 0
 *      implies a common scaling factor for the whole output tensor.
 *  @param scales Output pointer to a constant array of float scaling factors.
 *  @return #dnnl_success on success and a status describing the error
 *      otherwise. */

///
///
///
public static native @Cast("dnnl_status_t") int dnnl_primitive_attr_get_scales(
        dnnl_primitive_attr attr, int arg, @Cast("dnnl_dim_t*") LongPointer count, IntPointer mask,
        @Cast("const float**") PointerPointer scales);
public static native @Cast("dnnl_status_t") int dnnl_primitive_attr_get_scales(
        dnnl_primitive_attr attr, int arg, @Cast("dnnl_dim_t*") LongPointer count, IntPointer mask,
        @Const @ByPtrPtr FloatPointer scales);
public static native @Cast("dnnl_status_t") int dnnl_primitive_attr_get_scales(
        dnnl_primitive_attr attr, int arg, @Cast("dnnl_dim_t*") LongBuffer count, IntBuffer mask,
        @Const @ByPtrPtr FloatBuffer scales);
public static native @Cast("dnnl_status_t") int dnnl_primitive_attr_get_scales(
        dnnl_primitive_attr attr, int arg, @Cast("dnnl_dim_t*") long[] count, int[] mask,
        @Const @ByPtrPtr float[] scales);

/** Sets primitive attributes scaling factors for primitive operations for a
 *  given memory argument.
 * 
 *  @see dnnl_primitive_attr_set_output_scales
 * 
 * 
 *  @param attr Primitive attributes.
 *  @param arg Parameter argument index as passed to the
 *      dnnl_primitive_execute() call.
 *  @param count Length of the array of scaling factors \p scales.
 *  @param mask Scaling factors correspondence mask that defines the
 *      correspondence between the tensor dimensions and the \p scales array.
 *      The set i-th bit indicates that a dedicated scaling factor is used for
 *      each index along that dimension. Set the mask to 0 to use a common
 *      scaling factor for the whole output tensor.
 *  @param scales Constant array of float scaling factors. This array must
 *      contain \p count scales and the following equality must hold:
 *      <pre>{@code \[count = \prod\limits_{d \in mask} output.dims[d].\]}</pre>
 *  @return #dnnl_success on success and a status describing the error
 *      otherwise. */

///
///
///
///
public static native @Cast("dnnl_status_t") int dnnl_primitive_attr_set_scales(
        dnnl_primitive_attr attr, int arg, @Cast("dnnl_dim_t") long count, int mask,
        @Const FloatPointer scales);
public static native @Cast("dnnl_status_t") int dnnl_primitive_attr_set_scales(
        dnnl_primitive_attr attr, int arg, @Cast("dnnl_dim_t") long count, int mask,
        @Const FloatBuffer scales);
public static native @Cast("dnnl_status_t") int dnnl_primitive_attr_set_scales(
        dnnl_primitive_attr attr, int arg, @Cast("dnnl_dim_t") long count, int mask,
        @Const float[] scales);

/** Returns \p count, correspondence zero point \p mask, and a pointer to a
 *  constant int32_t array of \p zero_points for given \p attr and memory
 *  argument (index), previously set by dnnl_primitive_attr_set_zero_points.
 * 
 *  \warning
 *      The output \p zero_points array is an internal part of the primitive
 *      attributes \p attr, so it is an error to modify or destroy the \p
 *      zero_points array.
 * 
 *  \warning
 *      The lifetime of \p zero_points array is the same as that of the
 *      primitive attributes \p attr to which it belongs, so it is an error
 *      to use \p zero_points after \p attr is destroyed.
 * 
 * 
 *  @param attr Primitive attributes.
 *  @param arg Parameter argument index as passed to the
 *      dnnl_primitive_execute() call.
 *  @param count Output length of the array of zero points \p zero_points.
 *  @param mask Output zero points correspondence mask that defines the
 *      correspondence between the output tensor dimensions and the \p
 *      zero_points array. The set i-th bit indicates that a dedicated output
 *      zero point is used for each index along that dimension. The mask
 *      value of 0 implies a common zero point for the whole output tensor.
 *  @param zero_points Output pointer to a constant array of int32_t zero
 *      points.
 *  @return #dnnl_success on success and a status describing the error
 *      otherwise. */

///
///
///
public static native @Cast("dnnl_status_t") int dnnl_primitive_attr_get_zero_points(
        @Const dnnl_primitive_attr attr, int arg, @Cast("dnnl_dim_t*") LongPointer count, IntPointer mask,
        @Cast("const int32_t**") PointerPointer zero_points);
public static native @Cast("dnnl_status_t") int dnnl_primitive_attr_get_zero_points(
        @Const dnnl_primitive_attr attr, int arg, @Cast("dnnl_dim_t*") LongPointer count, IntPointer mask,
        @Const @ByPtrPtr IntPointer zero_points);
public static native @Cast("dnnl_status_t") int dnnl_primitive_attr_get_zero_points(
        @Const dnnl_primitive_attr attr, int arg, @Cast("dnnl_dim_t*") LongBuffer count, IntBuffer mask,
        @Const @ByPtrPtr IntBuffer zero_points);
public static native @Cast("dnnl_status_t") int dnnl_primitive_attr_get_zero_points(
        @Const dnnl_primitive_attr attr, int arg, @Cast("dnnl_dim_t*") long[] count, int[] mask,
        @Const @ByPtrPtr int[] zero_points);

/** Sets primitive attributes zero points for primitive operations for a given
 *  memory argument.
 * 
 *  @see dnnl_primitive_attr_set_output_scales
 * 
 * 
 *  @param attr Primitive attributes.
 *  @param arg Parameter argument index as passed to the
 *      dnnl_primitive_execute() call.
 *  @param count Length of the array of zero points \p zero_points.
 *  @param mask Zero point correspondence mask that defines the
 *      correspondence between the tensor dimensions and the \p
 *      zero_points array. The set i-th bit indicates that a dedicated
 *      zero point is used for each index along that dimension. Set the
 *      mask to 0 to use a common zero point for the whole output tensor.
 *  @param zero_points Constant array of int32_t zero points. If the zero
 *      points are known at the time of this call, this array must contain \p
 *      count zero points and the following equality must hold:
 *      <pre>{@code \[count = \prod\limits_{d \in mask} output.dims[d].\]}</pre>
 *      If the zero points are not known at the time of the call, this array
 *      must contain a single #DNNL_RUNTIME_S32_VAL and the zero points must
 *      be passed at execution time as an argument with index
 *      #DNNL_ARG_ATTR_ZERO_POINTS.
 *  @return #dnnl_success on success and a status describing the error
 *      otherwise. */

///
///
public static native @Cast("dnnl_status_t") int dnnl_primitive_attr_set_zero_points(
        dnnl_primitive_attr attr, int arg, @Cast("dnnl_dim_t") long count, int mask,
        @Const IntPointer zero_points);
public static native @Cast("dnnl_status_t") int dnnl_primitive_attr_set_zero_points(
        dnnl_primitive_attr attr, int arg, @Cast("dnnl_dim_t") long count, int mask,
        @Const IntBuffer zero_points);
public static native @Cast("dnnl_status_t") int dnnl_primitive_attr_set_zero_points(
        dnnl_primitive_attr attr, int arg, @Cast("dnnl_dim_t") long count, int mask,
        @Const int[] zero_points);

/** Returns primitive attributes post-ops.
 * 
 *  \warning
 *      The output \p post_ops points to the internal \p attr field, so it is
 *      an error to modify or destroy them. The lifetime of \p post_ops is
 *      the same as that of the \p attr it belongs to, so it is an error to
 *      use \p post_ops after \p attr has been destroyed.
 * 
 *  @param attr Primitive attributes.
 *  @param post_ops Output post-ops.
 *  @return #dnnl_success on success and a status describing the error
 *      otherwise. */

///
///
public static native @Cast("dnnl_status_t") int dnnl_primitive_attr_get_post_ops(
        @Const dnnl_primitive_attr attr, @Const @ByPtrPtr dnnl_post_ops post_ops);
public static native @Cast("dnnl_status_t") int dnnl_primitive_attr_get_post_ops(
        @Const dnnl_primitive_attr attr, @Cast("const_dnnl_post_ops_t*") PointerPointer post_ops);

/** Sets primitive attributes post-ops.
 * 
 *  \note
 *      There is no way to check whether the post-ops would be supported by
 *      the target primitive. Any error will be reported by the
 *      dnnl_primitive_desc_create() function call.
 * 
 *  @param attr Primitive attributes.
 *  @param post_ops Post-ops to set.
 *  @return #dnnl_success on success and a status describing the error
 *      otherwise. */

///
public static native @Cast("dnnl_status_t") int dnnl_primitive_attr_set_post_ops(
        dnnl_primitive_attr attr, @Const dnnl_post_ops post_ops);

/** Creates empty post-ops sequence.
 * 
 *  @param post_ops Output post-ops.
 *  @return #dnnl_success on success and a status describing the error
 *      otherwise. */

///
public static native @Cast("dnnl_status_t") int dnnl_post_ops_create(@ByPtrPtr dnnl_post_ops post_ops);
public static native @Cast("dnnl_status_t") int dnnl_post_ops_create(@Cast("dnnl_post_ops_t*") PointerPointer post_ops);

/** Destroys post-ops.
 * 
 *  @param post_ops Post-ops to destroy.
 *  @return #dnnl_success on success and a status describing the error
 *      otherwise. */

///
public static native @Cast("dnnl_status_t") int dnnl_post_ops_destroy(dnnl_post_ops post_ops);

/** Returns the length of post-ops.
 * 
 *  @param post_ops Post-ops.
 *  @return The number of post-ops entries. */

///
public static native int dnnl_post_ops_len(@Const dnnl_post_ops post_ops);

/** Returns the kind of a post-op entry.
 * 
 *  @param post_ops Post-ops.
 *  @param index Post-op entry index.
 *  @return The kind of the post-op with the specified index.
 *  @return #dnnl_undefined_primitive if there is no post-op at the specified
 *      index. */

///
///
///
///
///
///
public static native @Cast("dnnl_primitive_kind_t") int dnnl_post_ops_get_kind(
        @Const dnnl_post_ops post_ops, int index);

/** Appends an accumulation (sum) to post-ops. Prior to accumulating the
 *  result, the previous value is multiplied by a scale.
 * 
 *  The kind of this post-op is #dnnl_sum.
 * 
 *  This feature may improve performance for cases like residual learning
 *  blocks, where the result of convolution is accumulated to the previously
 *  computed activations. The parameter \p scale may be used for the
 *  integer-based computations when the result and previous activations have
 *  different logical scaling factors.
 * 
 *  In the simplest case when the accumulation is the only post-op, the
 *  computations would be:
 * 
 *      dst[:] <- scale * dst[:] + op(...) // instead of dst[:] <- op(...)
 * 
 *  \note
 *      This post-op executes in-place and does not change the
 *      destination layout.
 * 
 *  @param post_ops Post-ops.
 *  @param scale Accumulation scaling factor.
 *  @return #dnnl_success on success and a status describing the error
 *      otherwise. */

///
///
///
///
///
///
///
public static native @Cast("dnnl_status_t") int dnnl_post_ops_append_sum(
        dnnl_post_ops post_ops, float scale);

/** Appends an accumulation v2 (sum) to post-ops. Prior to accumulating the
 *  result, the previous value is multiplied by a scale.
 * 
 *  The kind of this post-op is #dnnl_sum.
 * 
 *  This feature may improve performance for cases like residual learning
 *  blocks, where the result of convolution is accumulated to the previously
 *  computed activations. The parameter \p scale may be used for the
 *  integer-based computations when the result and previous activations have
 *  different logical scaling factors.
 * 
 *  In the simplest case when the accumulation is the only post-op, the
 *  computations would be:
 * 
 *      dst[:] <- scale * dst[:] + op(...) // instead of dst[:] <- op(...)
 * 
 *  If \p data_type is specified, original dst tensor will be reinterpreted
 *  as a tensor with provided data type. Since it is reinterpretation,
 *  data_type and dst data type should have same size.
 *  As a result, computations would be:
 * 
 *      dst[:] <- scale * as_data_type(dst[:]) + op(...)
 *                                         // instead of dst[:] <- op(...)
 *  \note
 *      This post-op executes in-place and does not change the
 *      destination layout.
 * 
 *  @param post_ops Post-ops.
 *  @param scale Accumulation scaling factor.
 *  @param data_type Accumulation data_type.
 *  @return #dnnl_success on success and a status describing the error
 *      otherwise. */

///
public static native @Cast("dnnl_status_t") int dnnl_post_ops_append_sum_v2(
        dnnl_post_ops post_ops, float scale, @Cast("dnnl_data_type_t") int data_type);

/** Returns the parameters of an accumulation (sum) post-op.
 * 
 *  @param post_ops Post-ops.
 *  @param index Index of the sum post-op.
 *  @param scale Output accumulation scaling factor.
 *  @return #dnnl_success on success and a status describing the error
 *      otherwise.
 *  @return #dnnl_invalid_arguments if \p index does not refer to a sum
 *      post-op. */

///
public static native @Cast("dnnl_status_t") int dnnl_post_ops_get_params_sum(
        @Const dnnl_post_ops post_ops, int index, FloatPointer scale);
public static native @Cast("dnnl_status_t") int dnnl_post_ops_get_params_sum(
        @Const dnnl_post_ops post_ops, int index, FloatBuffer scale);
public static native @Cast("dnnl_status_t") int dnnl_post_ops_get_params_sum(
        @Const dnnl_post_ops post_ops, int index, float[] scale);

/** Returns the parameters of an accumulation (sum) post-op with
 *  a data type parameter.
 * 
 *  @param post_ops Post-ops.
 *  @param index Index of the sum post-op.
 *  @param scale Output accumulation scaling factor.
 *  @param data_type Data type for accumulation.
 *  @return #dnnl_success on success and a status describing the error
 *      otherwise. */

///
///
///
///
///
public static native @Cast("dnnl_status_t") int dnnl_post_ops_get_params_sum_v2(
        @Const dnnl_post_ops post_ops, int index, FloatPointer scale,
        @Cast("dnnl_data_type_t*") IntPointer data_type);
public static native @Cast("dnnl_status_t") int dnnl_post_ops_get_params_sum_v2(
        @Const dnnl_post_ops post_ops, int index, FloatBuffer scale,
        @Cast("dnnl_data_type_t*") IntBuffer data_type);
public static native @Cast("dnnl_status_t") int dnnl_post_ops_get_params_sum_v2(
        @Const dnnl_post_ops post_ops, int index, float[] scale,
        @Cast("dnnl_data_type_t*") int[] data_type);

/** Appends an elementwise post-op.
 * 
 *  The kind of this post operation is #dnnl_eltwise.
 * 
 *  In the simplest case when the elementwise is the only post operation, the
 *  computations would be:
 * 
 *      dst[:] <- scale * eltwise_op (op(...)) // instead of dst[:] <- op(...)
 * 
 *  where eltwise_op is configured with the given parameters.
 * 
 *  @param post_ops Post-ops.
 *  @param scale Scaling factor.
 *  @param alg_kind Elementwise algorithm for the post-op.
 *  @param alpha Alpha parameter for the elementwise algorithm.
 *  @param beta Beta parameter for the elementwise algorithm.
 *  @return #dnnl_success on success and a status describing the error
 *      otherwise. */

///
public static native @Cast("dnnl_status_t") int dnnl_post_ops_append_eltwise(dnnl_post_ops post_ops,
        float scale, @Cast("dnnl_alg_kind_t") int alg_kind, float alpha, float beta);

/** Returns the parameters of an elementwise post-op.
 * 
 *  @param post_ops Post-ops.
 *  @param index Index of the elementwise post-op.
 *  @param scale Output scaling factor.
 *  @param alg_kind Output elementwise algorithm kind.
 *  @param alpha Output alpha parameter for the elementwise algorithm.
 *  @param beta Output beta parameter for the elementwise algorithm.
 *  @return #dnnl_success on success and a status describing the error
 *      otherwise.
 *  @return #dnnl_invalid_arguments if \p index does not refer to an
 *      elementwise post-op. */

///
///
///
///
///
///
///
public static native @Cast("dnnl_status_t") int dnnl_post_ops_get_params_eltwise(
        @Const dnnl_post_ops post_ops, int index, FloatPointer scale,
        @Cast("dnnl_alg_kind_t*") IntPointer alg_kind, FloatPointer alpha, FloatPointer beta);
public static native @Cast("dnnl_status_t") int dnnl_post_ops_get_params_eltwise(
        @Const dnnl_post_ops post_ops, int index, FloatBuffer scale,
        @Cast("dnnl_alg_kind_t*") IntBuffer alg_kind, FloatBuffer alpha, FloatBuffer beta);
public static native @Cast("dnnl_status_t") int dnnl_post_ops_get_params_eltwise(
        @Const dnnl_post_ops post_ops, int index, float[] scale,
        @Cast("dnnl_alg_kind_t*") int[] alg_kind, float[] alpha, float[] beta);

/** Appends a depthwise post-op convolution with stride 1.
 * 
 *  This post-op can only be fused with a 2D 1x1 convolution (convolution with
 *  weights spatial dimension equal to 1 i.e., kh=kw=1).
 * 
 *  The kind of this post-op is #dnnl_convolution.
 * 
 *  The number of outputs for primitive remain same as before. The output size
 *  remain same as the original primitive due to stride=1.
 * 
 *  The Post-op can be defined as:
 * 
 *       dst[:] <- scales * (conv_dw(conv_1x1))
 * 
 *  See \ref dev_guide_attributes_post_ops_depthwise and
 *  \ref dev_guide_attributes_post_ops_depthwise_fusion for more info.
 * 
 *  @param post_ops Post-ops.
 *  @param weights_data_type Weights data type of depthwise post-op
 *  @param bias_data_type Bias data type of depthwise post-op
 *  @param dst_data_type Output data type of depthwise post-op
 *  @param count Output length of the array of scaling factors \p scales.
 *  @param mask Output scaling factors correspondence mask that defines the
 *      correspondence between the output tensor dimensions and the \p
 *      scales array. The set i-th bit indicates that a dedicated output scaling
 *      factor is used for each index along that dimension. The mask value of 0
 *      implies a common scaling factor for the whole output tensor.
 *  @param scales Output pointer to a constant array of float scaling factors.
 *  @return #dnnl_success on success and a status describing the error
 *      otherwise */

///
public static native @Cast("dnnl_status_t") int dnnl_post_ops_append_dw_k3s1p1(dnnl_post_ops post_ops,
        @Cast("dnnl_data_type_t") int weights_data_type, @Cast("dnnl_data_type_t") int bias_data_type,
        @Cast("dnnl_data_type_t") int dst_data_type, @Cast("dnnl_dim_t") long count, int mask,
        @Const FloatPointer scales);
public static native @Cast("dnnl_status_t") int dnnl_post_ops_append_dw_k3s1p1(dnnl_post_ops post_ops,
        @Cast("dnnl_data_type_t") int weights_data_type, @Cast("dnnl_data_type_t") int bias_data_type,
        @Cast("dnnl_data_type_t") int dst_data_type, @Cast("dnnl_dim_t") long count, int mask,
        @Const FloatBuffer scales);
public static native @Cast("dnnl_status_t") int dnnl_post_ops_append_dw_k3s1p1(dnnl_post_ops post_ops,
        @Cast("dnnl_data_type_t") int weights_data_type, @Cast("dnnl_data_type_t") int bias_data_type,
        @Cast("dnnl_data_type_t") int dst_data_type, @Cast("dnnl_dim_t") long count, int mask,
        @Const float[] scales);

/** Returns the parameters of an depthwise post-op with stride 1.
 * 
 *  @param post_ops Post-ops.
 *  @param index Index of the elementwise post-op.
 *  @param weights_data_type Weights data type of depthwise post-op
 *  @param bias_data_type Bias data type of depthwise post-op
 *  @param dst_data_type Output data type of depthwise post-op
 *  @param count Output length of the array of scaling factors \p scales.
 *  @param mask Output scaling factors correspondence mask that defines the
 *      correspondence between the output tensor dimensions and the \p
 *      scales array. The set i-th bit indicates that a dedicated output scaling
 *      factor is used for each index along that dimension. The mask value of 0
 *      implies a common scaling factor for the whole output tensor.
 *  @param scales Output pointer to a constant array of float scaling factors.
 *  @return #dnnl_success on success and a status describing the error
 *      otherwise */

///
///
///
///
///
///
///
///
public static native @Cast("dnnl_status_t") int dnnl_post_ops_get_params_dw_k3s1p1(
        @Const dnnl_post_ops post_ops, int index,
        @Cast("dnnl_data_type_t*") IntPointer weights_data_type, @Cast("dnnl_data_type_t*") IntPointer bias_data_type,
        @Cast("dnnl_data_type_t*") IntPointer dst_data_type, @Cast("dnnl_dim_t*") LongPointer count, IntPointer mask,
        @Cast("const float**") PointerPointer scales);
public static native @Cast("dnnl_status_t") int dnnl_post_ops_get_params_dw_k3s1p1(
        @Const dnnl_post_ops post_ops, int index,
        @Cast("dnnl_data_type_t*") IntPointer weights_data_type, @Cast("dnnl_data_type_t*") IntPointer bias_data_type,
        @Cast("dnnl_data_type_t*") IntPointer dst_data_type, @Cast("dnnl_dim_t*") LongPointer count, IntPointer mask,
        @Const @ByPtrPtr FloatPointer scales);
public static native @Cast("dnnl_status_t") int dnnl_post_ops_get_params_dw_k3s1p1(
        @Const dnnl_post_ops post_ops, int index,
        @Cast("dnnl_data_type_t*") IntBuffer weights_data_type, @Cast("dnnl_data_type_t*") IntBuffer bias_data_type,
        @Cast("dnnl_data_type_t*") IntBuffer dst_data_type, @Cast("dnnl_dim_t*") LongBuffer count, IntBuffer mask,
        @Const @ByPtrPtr FloatBuffer scales);
public static native @Cast("dnnl_status_t") int dnnl_post_ops_get_params_dw_k3s1p1(
        @Const dnnl_post_ops post_ops, int index,
        @Cast("dnnl_data_type_t*") int[] weights_data_type, @Cast("dnnl_data_type_t*") int[] bias_data_type,
        @Cast("dnnl_data_type_t*") int[] dst_data_type, @Cast("dnnl_dim_t*") long[] count, int[] mask,
        @Const @ByPtrPtr float[] scales);

/** Appends a depthwise post-op convolution with stride 2.
 * 
 *  This post-op can only be fused with a 2D 1x1 convolution (convolution with
 *  weights spatial dimension equal to 1 i.e., kh=kw=1).
 * 
 *  The kind of this post-op is #dnnl_convolution.
 * 
 *  The number of outputs for primitive remain same as before. The output
 *  spatial size can be derived as below:
 * 
 *  output_height = ceil(output_height_1x1_convolution, stride)
 *  output_width = ceil(output_width_1x1_convolution, stride)
 * 
 *  The Post-op can be defined as:
 * 
 *       dst[:] <- scales * (conv_dw(conv_1x1))
 * 
 *  See \ref dev_guide_attributes_post_ops_depthwise and
 *  \ref dev_guide_attributes_post_ops_depthwise_fusion for more info.
 * 
 *  @param post_ops Post-ops.
 *  @param weights_data_type Weights data type of depthwise post-op
 *  @param bias_data_type Bias data type of depthwise post-op
 *  @param dst_data_type Output data type of depthwise post-op
 *  @param count Output length of the array of scaling factors \p scales.
 *  @param mask Output scaling factors correspondence mask that defines the
 *      correspondence between the output tensor dimensions and the \p
 *      scales array. The set i-th bit indicates that a dedicated output scaling
 *      factor is used for each index along that dimension. The mask value of 0
 *      implies a common scaling factor for the whole output tensor.
 *  @param scales Output pointer to a constant array of float scaling factors.
 *  @return #dnnl_success on success and a status describing the error
 *      otherwise */

///
public static native @Cast("dnnl_status_t") int dnnl_post_ops_append_dw_k3s2p1(dnnl_post_ops post_ops,
        @Cast("dnnl_data_type_t") int weights_data_type, @Cast("dnnl_data_type_t") int bias_data_type,
        @Cast("dnnl_data_type_t") int dst_data_type, @Cast("dnnl_dim_t") long count, int mask,
        @Const FloatPointer scales);
public static native @Cast("dnnl_status_t") int dnnl_post_ops_append_dw_k3s2p1(dnnl_post_ops post_ops,
        @Cast("dnnl_data_type_t") int weights_data_type, @Cast("dnnl_data_type_t") int bias_data_type,
        @Cast("dnnl_data_type_t") int dst_data_type, @Cast("dnnl_dim_t") long count, int mask,
        @Const FloatBuffer scales);
public static native @Cast("dnnl_status_t") int dnnl_post_ops_append_dw_k3s2p1(dnnl_post_ops post_ops,
        @Cast("dnnl_data_type_t") int weights_data_type, @Cast("dnnl_data_type_t") int bias_data_type,
        @Cast("dnnl_data_type_t") int dst_data_type, @Cast("dnnl_dim_t") long count, int mask,
        @Const float[] scales);

/** Returns the parameters of an depthwise post-op with stride 2.
 * 
 *  @param post_ops Post-ops.
 *  @param index Index of the elementwise post-op.
 *  @param weights_data_type Weights data type of depthwise post-op
 *  @param bias_data_type Bias data type of depthwise post-op
 *  @param dst_data_type Output data type of depthwise post-op
 *  @param count Output length of the array of scaling factors \p scales.
 *  @param mask Output scaling factors correspondence mask that defines the
 *      correspondence between the output tensor dimensions and the \p
 *      scales array. The set i-th bit indicates that a dedicated output scaling
 *      factor is used for each index along that dimension. The mask value of 0
 *      implies a common scaling factor for the whole output tensor.
 *  @param scales Output pointer to a constant array of float scaling factors.
 *  @return #dnnl_success on success and a status describing the error
 *      otherwise */

///
///
///
///
///
public static native @Cast("dnnl_status_t") int dnnl_post_ops_get_params_dw_k3s2p1(
        @Const dnnl_post_ops post_ops, int index,
        @Cast("dnnl_data_type_t*") IntPointer weights_data_type, @Cast("dnnl_data_type_t*") IntPointer bias_data_type,
        @Cast("dnnl_data_type_t*") IntPointer dst_data_type, @Cast("dnnl_dim_t*") LongPointer count, IntPointer mask,
        @Cast("const float**") PointerPointer scales);
public static native @Cast("dnnl_status_t") int dnnl_post_ops_get_params_dw_k3s2p1(
        @Const dnnl_post_ops post_ops, int index,
        @Cast("dnnl_data_type_t*") IntPointer weights_data_type, @Cast("dnnl_data_type_t*") IntPointer bias_data_type,
        @Cast("dnnl_data_type_t*") IntPointer dst_data_type, @Cast("dnnl_dim_t*") LongPointer count, IntPointer mask,
        @Const @ByPtrPtr FloatPointer scales);
public static native @Cast("dnnl_status_t") int dnnl_post_ops_get_params_dw_k3s2p1(
        @Const dnnl_post_ops post_ops, int index,
        @Cast("dnnl_data_type_t*") IntBuffer weights_data_type, @Cast("dnnl_data_type_t*") IntBuffer bias_data_type,
        @Cast("dnnl_data_type_t*") IntBuffer dst_data_type, @Cast("dnnl_dim_t*") LongBuffer count, IntBuffer mask,
        @Const @ByPtrPtr FloatBuffer scales);
public static native @Cast("dnnl_status_t") int dnnl_post_ops_get_params_dw_k3s2p1(
        @Const dnnl_post_ops post_ops, int index,
        @Cast("dnnl_data_type_t*") int[] weights_data_type, @Cast("dnnl_data_type_t*") int[] bias_data_type,
        @Cast("dnnl_data_type_t*") int[] dst_data_type, @Cast("dnnl_dim_t*") long[] count, int[] mask,
        @Const @ByPtrPtr float[] scales);

/** Appends a binary post-op.
 * 
 *  The kind of this post operation is #dnnl_binary.
 * 
 *  In the simplest case when the binary is the only post operation, the
 *  computations would be:
 * 
 *      dst[:] <- binary_op (dst[:], another_input[:])
 * 
 *  where binary_op is configured with the given parameters. binary_op supports
 *  broadcast semantics for a second operand.
 * 
 *  @param post_ops Post-ops.
 *  @param alg_kind Binary algorithm for the post-op.
 *  @param src1_desc Memory descriptor of a second operand.
 *  @return #dnnl_success on success and a status describing the error
 *      otherwise. */

///
public static native @Cast("dnnl_status_t") int dnnl_post_ops_append_binary(dnnl_post_ops post_ops,
        @Cast("dnnl_alg_kind_t") int alg_kind, @Const dnnl_memory_desc_t src1_desc);

/** Returns the parameters of a binary post-op.
 * 
 *  @param post_ops Post-ops.
 *  @param index Index of the binary post-op.
 *  @param alg_kind Output binary algorithm kind.
 *  @param src1_desc Output memory descriptor of a second operand.
 *  @return #dnnl_success on success and a status describing the error
 *      otherwise.
 *  @return #dnnl_invalid_arguments if \p index does not refer to a binary
 *      post-op. */

///
///
public static native @Cast("dnnl_status_t") int dnnl_post_ops_get_params_binary(
        @Const dnnl_post_ops post_ops, int index, @Cast("dnnl_alg_kind_t*") IntPointer alg_kind,
        @Cast("const dnnl_memory_desc_t**") PointerPointer src1_desc);
public static native @Cast("dnnl_status_t") int dnnl_post_ops_get_params_binary(
        @Const dnnl_post_ops post_ops, int index, @Cast("dnnl_alg_kind_t*") IntPointer alg_kind,
        @Const @ByPtrPtr dnnl_memory_desc_t src1_desc);
public static native @Cast("dnnl_status_t") int dnnl_post_ops_get_params_binary(
        @Const dnnl_post_ops post_ops, int index, @Cast("dnnl_alg_kind_t*") IntBuffer alg_kind,
        @Const @ByPtrPtr dnnl_memory_desc_t src1_desc);
public static native @Cast("dnnl_status_t") int dnnl_post_ops_get_params_binary(
        @Const dnnl_post_ops post_ops, int index, @Cast("dnnl_alg_kind_t*") int[] alg_kind,
        @Const @ByPtrPtr dnnl_memory_desc_t src1_desc);

/** \} dnnl_api_attributes
 <p>
 *  \} dnnl_api_primitives
 <p>
 *  \addtogroup dnnl_api_memory
 *  \{
 <p>
 *  Initializes a memory descriptor using dimensions and strides.
 * 
 *  \note
 *      As always, the logical order of dimensions corresponds to the {@code abc...}
 *      format tag, and the physical meaning of the dimensions depends on both
 *      the primitive that consumes the memory and the context of that
 *      consumption.
 * 
 *  @param memory_desc Output memory descriptor.
 *  @param ndims Number of dimensions
 *  @param dims Array of dimensions.
 *  @param data_type Elements data type.
 *  @param strides Strides in each dimension.
 *  @return #dnnl_success on success and a status describing the error
 *      otherwise. */

///
///
public static native @Cast("dnnl_status_t") int dnnl_memory_desc_init_by_strides(
        dnnl_memory_desc_t memory_desc, int ndims, @Cast("const int64_t*") LongPointer dims,
        @Cast("dnnl_data_type_t") int data_type, @Cast("const int64_t*") LongPointer strides);
public static native @Cast("dnnl_status_t") int dnnl_memory_desc_init_by_strides(
        dnnl_memory_desc_t memory_desc, int ndims, @Cast("const int64_t*") LongBuffer dims,
        @Cast("dnnl_data_type_t") int data_type, @Cast("const int64_t*") LongBuffer strides);
public static native @Cast("dnnl_status_t") int dnnl_memory_desc_init_by_strides(
        dnnl_memory_desc_t memory_desc, int ndims, @Cast("const int64_t*") long[] dims,
        @Cast("dnnl_data_type_t") int data_type, @Cast("const int64_t*") long[] strides);

/** Initializes a memory descriptor using dimensions and memory format tag.
 * 
 *  \note
 *      As always, the logical order of dimensions corresponds to the {@code abc...}
 *      format tag, and the physical meaning of the dimensions depends on both
 *      the primitive that consumes the memory and the context of that
 *      consumption.
 * 
 *  @param memory_desc Output memory descriptor.
 *  @param ndims Number of dimensions
 *  @param dims Array of dimensions.
 *  @param data_type Elements data type.
 *  @param tag Memory format tag. Can be #dnnl_format_tag_any which would
 *      allow a primitive to chose the final memory format. In this case the
 *      format_kind field of the memory descriptor would be set to
 *      #dnnl_format_kind_any.
 *  @return #dnnl_success on success and a status describing the error
 *      otherwise. */

///
public static native @Cast("dnnl_status_t") int dnnl_memory_desc_init_by_tag(
        dnnl_memory_desc_t memory_desc, int ndims, @Cast("const int64_t*") LongPointer dims,
        @Cast("dnnl_data_type_t") int data_type, @Cast("dnnl_format_tag_t") int tag);
public static native @Cast("dnnl_status_t") int dnnl_memory_desc_init_by_tag(
        dnnl_memory_desc_t memory_desc, int ndims, @Cast("const int64_t*") LongBuffer dims,
        @Cast("dnnl_data_type_t") int data_type, @Cast("dnnl_format_tag_t") int tag);
public static native @Cast("dnnl_status_t") int dnnl_memory_desc_init_by_tag(
        dnnl_memory_desc_t memory_desc, int ndims, @Cast("const int64_t*") long[] dims,
        @Cast("dnnl_data_type_t") int data_type, @Cast("dnnl_format_tag_t") int tag);

/** Initializes a memory descriptor for a region inside an area
 *  described by an existing memory descriptor.
 * 
 *  \warning
 *      Some combinations of physical memory layout and/or offsets or dims may
 *      result in a failure to create a submemory. */
//
/** @param memory_desc Output memory descriptor.
/** @param parent_memory_desc An existing memory descriptor.
/** @param dims Sizes of the region.
/** @param offsets Offsets to the region from the encompassing
/**     memory object in each dimension
/** @return #dnnl_success on success and a status describing the error
/**     otherwise. */

///
///
///
///
public static native @Cast("dnnl_status_t") int dnnl_memory_desc_init_submemory(
        dnnl_memory_desc_t memory_desc,
        @Const dnnl_memory_desc_t parent_memory_desc, @Cast("const int64_t*") LongPointer dims,
        @Cast("const int64_t*") LongPointer offsets);
public static native @Cast("dnnl_status_t") int dnnl_memory_desc_init_submemory(
        dnnl_memory_desc_t memory_desc,
        @Const dnnl_memory_desc_t parent_memory_desc, @Cast("const int64_t*") LongBuffer dims,
        @Cast("const int64_t*") LongBuffer offsets);
public static native @Cast("dnnl_status_t") int dnnl_memory_desc_init_submemory(
        dnnl_memory_desc_t memory_desc,
        @Const dnnl_memory_desc_t parent_memory_desc, @Cast("const int64_t*") long[] dims,
        @Cast("const int64_t*") long[] offsets);

/** Initializes a memory descriptor by reshaping an existing one. The new
 *  memory descriptor inherits the data type. This operation is valid only for
 *  memory descriptors that have format_kind set to #dnnl_blocked or
 *  #dnnl_format_kind_any.
 * 
 *  The operation ensures the transformation of the physical memory format
 *  corresponds to the transformation of the logical dimensions. If such
 *  transformation is impossible, the function returns #dnnl_invalid_arguments.
 * 
 *  The reshape operation can be described as a combination of the following
 *  basic operations:
 *  1. Add a dimension of size {@code 1}. This is always possible.
 *  2. Remove a dimension of size {@code 1}. This is possible only if the dimension
 *     has no padding (i.e. {@code padded_dims[dim] == dims[dim] && dims[dim] == 1}).
 *  3. Split a dimension into multiple ones. This is possible only if the size
 *     of the dimension is exactly equal to the product of the split ones and
 *     the dimension does not have padding (i.e.
 *     {@code padded_dims[dim] = dims[dim]}).
 *  4. Joining multiple consecutive dimensions into a single one. As in the
 *     cases above, this requires that the dimensions do not have padding and
 *     that the memory format is such that in physical memory these dimensions
 *     are dense and have the same order as their logical counterparts. This
 *     also assumes that these dimensions are not blocked.
 *     - Here, dense means:
 *       {@code stride for dim[i] == (stride for dim[i + 1]) * dim[i + 1]};
 *     - And same order means:
 *       {@code i < j} if and only if {@code stride for dim[j] <= stride for dim[i]}.
 * 
 *  \warning
 *      Some combinations of physical memory layout and/or offsets or
 *      dimensions may result in a failure to make a reshape.
 * 
 *  @param out_memory_desc Output memory descriptor.
 *  @param in_memory_desc An existing memory descriptor. Must have format_kind
 *      set to #dnnl_blocked or #dnnl_format_kind_any.
 *  @param ndims Number of dimensions for the output memory descriptor.
 *  @param dims Dimensions for the output memory descriptor.
 *  @return #dnnl_success on success and a status describing the error
 *      otherwise. */

///
///
///
///
///
///
///
///
///
public static native @Cast("dnnl_status_t") int dnnl_memory_desc_reshape(
        dnnl_memory_desc_t out_memory_desc,
        @Const dnnl_memory_desc_t in_memory_desc, int ndims,
        @Cast("const int64_t*") LongPointer dims);
public static native @Cast("dnnl_status_t") int dnnl_memory_desc_reshape(
        dnnl_memory_desc_t out_memory_desc,
        @Const dnnl_memory_desc_t in_memory_desc, int ndims,
        @Cast("const int64_t*") LongBuffer dims);
public static native @Cast("dnnl_status_t") int dnnl_memory_desc_reshape(
        dnnl_memory_desc_t out_memory_desc,
        @Const dnnl_memory_desc_t in_memory_desc, int ndims,
        @Cast("const int64_t*") long[] dims);

/** Initializes a memory descriptor by permuting axes in an existing one.
 * 
 *  The physical memory layout representation is adjusted accordingly to
 *  maintain the consistency between the logical and physical parts of the
 *  memory descriptor.
 * 
 *  The new memory descriptor inherits the data type. This operation is valid
 *  only for memory descriptors that have format_kind set to #dnnl_blocked or
 *  #dnnl_format_kind_any.
 * 
 *  The logical axes will be permuted in the following manner:
 *  <pre>{@code
 *  for (i: 0 .. in_memory_desc->ndims)
 *      out_memory_desc->dims[permutation[i]] = in_memory_desc->dims[i];
 *  }</pre>
 * 
 *  Example:
 *  <pre>{@code
 *      dnnl_memory_desc_t in_md, out_md, expect_out_md;
 * 
 *      const int permutation[] = {1, 0}; // swap the first and the second axes
 * 
 *      dnnl_dims_t in_dims = {2, 3}, out_dims = {3, 2};
 *      dnnl_format_tag_t in_tag = dnnl_ab, out_tag = dnnl_ba;
 * 
 *      dnnl_memory_desc_init_by_tag(
 *              &in_md, 2, in_dims, data_type, in_tag);
 *      dnnl_memory_desc_init_by_tag(
 *              &expect_out_md, 2, out_dims, data_type, out_tag);
 * 
 *      dnnl_memory_desc_permute_axes(&out_md, in_md, permutation);
 *      assert(dnnl_memory_desc_equal(&out_md, &expect_out_md));
 *  }</pre>
 * 
 *  @param out_memory_desc Output memory descriptor.
 *  @param in_memory_desc An existing memory descriptor. Must have format_kind
 *      set to #dnnl_blocked or #dnnl_format_kind_any.
 *  @param permutation Axes permutation (of size {@code in_memory_desc->ndims}).
 *  @return #dnnl_success on success and a status describing the error
 *      otherwise. */

///
///
public static native @Cast("dnnl_status_t") int dnnl_memory_desc_permute_axes(
        dnnl_memory_desc_t out_memory_desc,
        @Const dnnl_memory_desc_t in_memory_desc, @Const IntPointer permutation);
public static native @Cast("dnnl_status_t") int dnnl_memory_desc_permute_axes(
        dnnl_memory_desc_t out_memory_desc,
        @Const dnnl_memory_desc_t in_memory_desc, @Const IntBuffer permutation);
public static native @Cast("dnnl_status_t") int dnnl_memory_desc_permute_axes(
        dnnl_memory_desc_t out_memory_desc,
        @Const dnnl_memory_desc_t in_memory_desc, @Const int[] permutation);

/** Compares two memory descriptors.
 * 
 *  Use this function to identify whether a reorder is required between the
 *  two memories
 * 
 *  @param lhs Left-hand side of the comparison.
 *  @param rhs Right-hand side of the comparison.
 *  @return 1 if the descriptors are the same.
 *  @return 0 if the descriptors are different. */

///
public static native int dnnl_memory_desc_equal(
        @Const dnnl_memory_desc_t lhs, @Const dnnl_memory_desc_t rhs);

/** Returns the size of a memory descriptor.
 * 
 *  @param memory_desc Memory descriptor.
 *  @return The number of bytes required for memory described by a memory
 *      descriptor. */

///
public static native @Cast("size_t") long dnnl_memory_desc_get_size(
        @Const dnnl_memory_desc_t memory_desc);

/** Returns the size of data type.
 * 
 *  @param data_type Data type.
 *  @return The number of bytes occupied by data type. */

///
///
///
public static native @Cast("size_t") long dnnl_data_type_size(@Cast("dnnl_data_type_t") int data_type);

/** Creates a memory object.
 * 
 *  Unless \p handle is equal to DNNL_MEMORY_NONE, the constructed memory
 *  object will have the underlying buffer set. In this case, the buffer will
 *  be initialized as if dnnl_memory_set_data_handle() had been called.
 * 
 *  @see dnnl_memory_set_data_handle()
 * 
 *  @param memory Output memory object.
 *  @param memory_desc Memory descriptor.
 *  @param engine Engine to use.
 *  @param handle Handle of the memory buffer to use as an underlying storage.
 *      - A pointer to the user-allocated buffer. In this case the library
 *        doesn't own the buffer.
 *      - The DNNL_MEMORY_ALLOCATE special value. Instructs the library to
 *        allocate the buffer for the memory object. In this case the library
 *        owns the buffer.
 *      - DNNL_MEMORY_NONE to create dnnl_memory without an underlying buffer.
 *  @return #dnnl_success on success and a status describing the error
 *      otherwise. */

///
public static native @Cast("dnnl_status_t") int dnnl_memory_create(@ByPtrPtr dnnl_memory memory,
        @Const dnnl_memory_desc_t memory_desc, dnnl_engine engine,
        Pointer handle);
public static native @Cast("dnnl_status_t") int dnnl_memory_create(@Cast("dnnl_memory_t*") PointerPointer memory,
        @Const dnnl_memory_desc_t memory_desc, dnnl_engine engine,
        Pointer handle);

/** Returns the memory descriptor for a memory object.
 * 
 *  @param memory Memory object.
 *  @param memory_desc Output memory descriptor (a copy).
 *  @return #dnnl_success on success and a status describing the error
 *      otherwise. */

///
public static native @Cast("dnnl_status_t") int dnnl_memory_get_memory_desc(
        @Const dnnl_memory memory, @Cast("const dnnl_memory_desc_t**") PointerPointer memory_desc);
public static native @Cast("dnnl_status_t") int dnnl_memory_get_memory_desc(
        @Const dnnl_memory memory, @Const @ByPtrPtr dnnl_memory_desc_t memory_desc);

/** Returns the engine of a memory object.
 * 
 *  @param memory Memory object.
 *  @param engine Output engine on which the memory is located.
 *  @return #dnnl_success on success and a status describing the error
 *      otherwise. */

///
///
///
///
///
public static native @Cast("dnnl_status_t") int dnnl_memory_get_engine(
        @Const dnnl_memory memory, @ByPtrPtr dnnl_engine engine);
public static native @Cast("dnnl_status_t") int dnnl_memory_get_engine(
        @Const dnnl_memory memory, @Cast("dnnl_engine_t*") PointerPointer engine);

/** Maps a memory object and returns a host-side pointer to a memory buffer
 *  with a copy of its contents.
 * 
 *  Mapping enables explicit direct access to memory contents for the engines
 *  that do not support it implicitly.
 * 
 *  Mapping is an exclusive operation - a memory object cannot be used in
 *  other operations until this memory object is unmapped.
 * 
 *  \note
 *      Any primitives working with \p memory should be completed before
 *      the memory is mapped. Use dnnl_stream_wait to synchronize the
 *      corresponding execution stream.
 * 
 *  \note
 *      The dnnl_memory_map_data() and dnnl_memory_unmap_data() functions are
 *      mainly provided for debug and testing purposes, and their performance
 *      may be suboptimal.
 * 
 *  @param memory Memory object.
 *  @param mapped_ptr Output pointer to the mapped buffer.
 *  @return #dnnl_success on success and a status describing the error
 *      otherwise. */

///
///
public static native @Cast("dnnl_status_t") int dnnl_memory_map_data(
        @Const dnnl_memory memory, @Cast("void**") PointerPointer mapped_ptr);
public static native @Cast("dnnl_status_t") int dnnl_memory_map_data(
        @Const dnnl_memory memory, @Cast("void**") @ByPtrPtr Pointer mapped_ptr);

/** Unmaps a memory object and writes back any changes made to the previously
 *  mapped memory buffer. The pointer to the mapped buffer must be obtained
 *  via the dnnl_memory_map_data() call.
 * 
 *  \note
 *      The dnnl_memory_map_data() and dnnl_memory_unmap_data() functions are
 *      mainly provided for debug and testing purposes, and their performance
 *      may be suboptimal.
 * 
 *  @param memory Memory object.
 *  @param mapped_ptr Pointer to the mapped buffer that must have been
 *      obtained using the dnnl_memory_map_data() function.
 *  @return #dnnl_success on success and a status describing the error
 *      otherwise. */

///
public static native @Cast("dnnl_status_t") int dnnl_memory_unmap_data(
        @Const dnnl_memory memory, Pointer mapped_ptr);

/** Returns memory object's data handle.
 * 
 *  @param memory Memory object.
 *  @param handle Output data handle. For the CPU engine, the data handle is a
 *      pointer to the actual data. For OpenCL it is a cl_mem.
 *  @return #dnnl_success on success and a status describing the error
 *      otherwise. */

///
///
public static native @Cast("dnnl_status_t") int dnnl_memory_get_data_handle(
        @Const dnnl_memory memory, @Cast("void**") PointerPointer handle);
public static native @Cast("dnnl_status_t") int dnnl_memory_get_data_handle(
        @Const dnnl_memory memory, @Cast("void**") @ByPtrPtr Pointer handle);

/** Sets the underlying memory buffer.
 * 
 *  See the description of dnnl_memory_set_data_handle_v2() for more details.
 * 
 *  @param memory Memory object.
 *  @param handle Data handle. For the CPU engine, the data handle is a
 *      pointer to the actual data. For OpenCL it is a {@code cl_mem}.
 *  @return #dnnl_success on success and a status describing the error
 *      otherwise. */

///
public static native @Cast("dnnl_status_t") int dnnl_memory_set_data_handle(
        dnnl_memory memory, Pointer handle);

/** Sets the underlying memory buffer.
 * 
 *  @param memory Memory object.
 *  @param handle Data handle. For the CPU engine, the data handle is a
 *      pointer to the actual data. For OpenCL it is a {@code cl_mem}.
 *  @param stream Stream to use to execute padding in.
 *  @return #dnnl_success on success and a status describing the error
 *      otherwise. */

///
public static native @Cast("dnnl_status_t") int dnnl_memory_set_data_handle_v2(
        dnnl_memory memory, Pointer handle, dnnl_stream stream);

/** Destroys a memory object.
 * 
 *  @param memory Memory object to destroy.
 *  @return #dnnl_success on success and a status describing the error
 *      otherwise. */

///
public static native @Cast("dnnl_status_t") int dnnl_memory_destroy(dnnl_memory memory);

/** \} dnnl_api_memory
 <p>
 *  \addtogroup dnnl_api_primitives
 *  \{
 <p>
 *  \addtogroup dnnl_api_reorder
 *  \{
 <p>
 *  Creates a primitive descriptor for a reorder primitive.
 * 
 *  @param reorder_primitive_desc Output primitive descriptor.
 *  @param src_desc Source memory descriptor.
 *  @param src_engine Engine on which the source memory object will be
 *      located.
 *  @param dst_desc Destination memory descriptor.
 *  @param dst_engine Engine on which the destination memory object
 *      will be located.
 *  @param attr Primitive attributes to use (can be NULL).
 *  @return #dnnl_success on success and a status describing the error
 *      otherwise. */

///
public static native @Cast("dnnl_status_t") int dnnl_reorder_primitive_desc_create(
        @ByPtrPtr dnnl_primitive_desc reorder_primitive_desc,
        @Const dnnl_memory_desc_t src_desc, dnnl_engine src_engine,
        @Const dnnl_memory_desc_t dst_desc, dnnl_engine dst_engine,
        @Const dnnl_primitive_attr attr);
public static native @Cast("dnnl_status_t") int dnnl_reorder_primitive_desc_create(
        @Cast("dnnl_primitive_desc_t*") PointerPointer reorder_primitive_desc,
        @Const dnnl_memory_desc_t src_desc, dnnl_engine src_engine,
        @Const dnnl_memory_desc_t dst_desc, dnnl_engine dst_engine,
        @Const dnnl_primitive_attr attr);

/** \} dnnl_api_reorder
 <p>
 *  \addtogroup dnnl_api_concat
 *  \{
 <p>
 *  Creates a primitive descriptor for an out-of-place concatenation
 *  primitive.
 * 
 *  @param concat_primitive_desc Output primitive descriptor.
 *  @param dst_desc Destination memory descriptor.
 *  @param n Number of source parameters.
 *  @param concat_dimension Source tensors will be concatenated over
 *      dimension with this index. Note that order of dimensions does
 *      not depend on memory format.
 *  @param src_descs Array of source memory descriptors with \p n elements.
 *  @param attr Primitive attributes to use (can be NULL).
 *  @param engine Engine to use.
 *  @return #dnnl_success on success and a status describing the error
 *      otherwise. */

///
public static native @Cast("dnnl_status_t") int dnnl_concat_primitive_desc_create(
        @ByPtrPtr dnnl_primitive_desc concat_primitive_desc,
        @Const dnnl_memory_desc_t dst_desc, int n, int concat_dimension,
        @Const dnnl_memory_desc_t src_descs, @Const dnnl_primitive_attr attr,
        dnnl_engine engine);
public static native @Cast("dnnl_status_t") int dnnl_concat_primitive_desc_create(
        @Cast("dnnl_primitive_desc_t*") PointerPointer concat_primitive_desc,
        @Const dnnl_memory_desc_t dst_desc, int n, int concat_dimension,
        @Const dnnl_memory_desc_t src_descs, @Const dnnl_primitive_attr attr,
        dnnl_engine engine);

/** \} dnnl_api_concat
 <p>
 *  \addtogroup dnnl_api_sum
 *  \{
 <p>
 *  Creates a primitive descriptor for an (out-of-place) sum primitive.
 * 
 *  @param sum_primitive_desc Output primitive descriptor.
 *  @param dst_desc Destination memory descriptor.
 *  @param n Number of source parameters.
 *  @param scales Vector of scales to multiply data in each source
 *      memory by.
 *  @param src_descs Array of source memory descriptors having \p n elements.
 *  @param attr Primitive attributes to use (can be NULL).
 *  @param engine Engine to use.
 *  @return #dnnl_success on success and a status describing the error
 *      otherwise. */

///
///
///
public static native @Cast("dnnl_status_t") int dnnl_sum_primitive_desc_create(
        @ByPtrPtr dnnl_primitive_desc sum_primitive_desc,
        @Const dnnl_memory_desc_t dst_desc, int n, @Const FloatPointer scales,
        @Const dnnl_memory_desc_t src_descs, @Const dnnl_primitive_attr attr,
        dnnl_engine engine);
public static native @Cast("dnnl_status_t") int dnnl_sum_primitive_desc_create(
        @Cast("dnnl_primitive_desc_t*") PointerPointer sum_primitive_desc,
        @Const dnnl_memory_desc_t dst_desc, int n, @Const FloatBuffer scales,
        @Const dnnl_memory_desc_t src_descs, @Const dnnl_primitive_attr attr,
        dnnl_engine engine);
public static native @Cast("dnnl_status_t") int dnnl_sum_primitive_desc_create(
        @ByPtrPtr dnnl_primitive_desc sum_primitive_desc,
        @Const dnnl_memory_desc_t dst_desc, int n, @Const float[] scales,
        @Const dnnl_memory_desc_t src_descs, @Const dnnl_primitive_attr attr,
        dnnl_engine engine);
public static native @Cast("dnnl_status_t") int dnnl_sum_primitive_desc_create(
        @Cast("dnnl_primitive_desc_t*") PointerPointer sum_primitive_desc,
        @Const dnnl_memory_desc_t dst_desc, int n, @Const FloatPointer scales,
        @Const dnnl_memory_desc_t src_descs, @Const dnnl_primitive_attr attr,
        dnnl_engine engine);
public static native @Cast("dnnl_status_t") int dnnl_sum_primitive_desc_create(
        @ByPtrPtr dnnl_primitive_desc sum_primitive_desc,
        @Const dnnl_memory_desc_t dst_desc, int n, @Const FloatBuffer scales,
        @Const dnnl_memory_desc_t src_descs, @Const dnnl_primitive_attr attr,
        dnnl_engine engine);
public static native @Cast("dnnl_status_t") int dnnl_sum_primitive_desc_create(
        @Cast("dnnl_primitive_desc_t*") PointerPointer sum_primitive_desc,
        @Const dnnl_memory_desc_t dst_desc, int n, @Const float[] scales,
        @Const dnnl_memory_desc_t src_descs, @Const dnnl_primitive_attr attr,
        dnnl_engine engine);

/** \} dnnl_api_sum
 <p>
 *  \addtogroup dnnl_api_binary
 *  \{
 <p>
 *  Initializes a descriptor for a binary primitive.
 * 
 *  \note
 *      Memory descriptor \p dst_desc is allowed to be initialized with
 *      #dnnl_format_tag_any or with format_kind set to #dnnl_format_kind_any.
 * 
 *  \note
 *      Both memory descriptors must have the same number of dimensions.
 *      Element broadcasting is supported for memory descriptor \p src1_desc
 *      and are applied to \ src1_desc dimensions that have size equal to 1.
 * 
 *  @param binary_desc Output descriptor for a binary primitive.
 *  @param alg_kind Algorithm kind. Valid values are #dnnl_binary_add,
 *      #dnnl_binary_mul, #dnnl_binary_max, #dnnl_binary_min, #dnnl_binary_div,
 *      #dnnl_binary_sub, #dnnl_binary_ge, #dnnl_binary_gt, #dnnl_binary_le,
 *      #dnnl_binary_lt, #dnnl_binary_eq and #dnnl_binary_ne.
 *  @param src0_desc Source 0 memory descriptor.
 *  @param src1_desc Source 1 memory descriptor.
 *  @param dst_desc Destination memory descriptor.
 *  @return #dnnl_success on success and a status describing the error
 *      otherwise. */

///
///
///
public static native @Cast("dnnl_status_t") int dnnl_binary_desc_init(dnnl_binary_desc_t binary_desc,
        @Cast("dnnl_alg_kind_t") int alg_kind, @Const dnnl_memory_desc_t src0_desc,
        @Const dnnl_memory_desc_t src1_desc,
        @Const dnnl_memory_desc_t dst_desc);

/** \} dnnl_api_binary
 <p>
 *  \addtogroup dnnl_api_convolution
 *  \{
 <p>
 *  Initializes a descriptor for a convolution forward propagation primitive.
 * 
 *  \note
 *      Memory descriptors can be initialized with
 *      #dnnl_format_tag_any or with format_kind set to #dnnl_format_kind_any.
 * 
 *  Arrays \p strides, \p padding_l, and \p padding_r contain values for
 *  spatial dimensions only and hence must have the same number of elements as
 *  there are spatial dimensions. The order of values is the same as in the
 *  tensor: depth (for 3D tensors), height (for 3D and 2D tensors), and width.
 * 
 *  @param conv_desc Output descriptor for a convolution primitive.
 *  @param prop_kind Propagation kind. Possible values are
 *      #dnnl_forward_training and #dnnl_forward_inference.
 *  @param alg_kind Convolution algorithm. Possible values are
 *      #dnnl_convolution_direct, #dnnl_convolution_winograd,
 *      #dnnl_convolution_auto.
 *  @param src_desc Source memory descriptor.
 *  @param weights_desc Weights memory descriptor.
 *  @param bias_desc Bias memory descriptor. Passing NULL, a zero memory
 *      descriptor, or a memory descriptor with format_kind set to
 *      #dnnl_format_kind_undef disables the bias term.
 *  @param dst_desc Destination memory descriptor.
 *  @param strides Array of strides for spatial dimension.
 *  @param padding_l Array of padding values for low indices for each spatial
 *      dimension {@code ([[front,] top,] left)}.
 *  @param padding_r Array of padding values for high indices for each spatial
 *      dimension {@code ([[back,] bottom,] right)}. Can be NULL in which case
 *      padding is assumed to be symmetrical.
 *  @return #dnnl_success on success and a status describing the error
 *      otherwise. */

///
///
///
public static native @Cast("dnnl_status_t") int dnnl_convolution_forward_desc_init(
        dnnl_convolution_desc_t conv_desc, @Cast("dnnl_prop_kind_t") int prop_kind,
        @Cast("dnnl_alg_kind_t") int alg_kind, @Const dnnl_memory_desc_t src_desc,
        @Const dnnl_memory_desc_t weights_desc,
        @Const dnnl_memory_desc_t bias_desc, @Const dnnl_memory_desc_t dst_desc,
        @Cast("const int64_t*") LongPointer strides, @Cast("const int64_t*") LongPointer padding_l,
        @Cast("const int64_t*") LongPointer padding_r);
public static native @Cast("dnnl_status_t") int dnnl_convolution_forward_desc_init(
        dnnl_convolution_desc_t conv_desc, @Cast("dnnl_prop_kind_t") int prop_kind,
        @Cast("dnnl_alg_kind_t") int alg_kind, @Const dnnl_memory_desc_t src_desc,
        @Const dnnl_memory_desc_t weights_desc,
        @Const dnnl_memory_desc_t bias_desc, @Const dnnl_memory_desc_t dst_desc,
        @Cast("const int64_t*") LongBuffer strides, @Cast("const int64_t*") LongBuffer padding_l,
        @Cast("const int64_t*") LongBuffer padding_r);
public static native @Cast("dnnl_status_t") int dnnl_convolution_forward_desc_init(
        dnnl_convolution_desc_t conv_desc, @Cast("dnnl_prop_kind_t") int prop_kind,
        @Cast("dnnl_alg_kind_t") int alg_kind, @Const dnnl_memory_desc_t src_desc,
        @Const dnnl_memory_desc_t weights_desc,
        @Const dnnl_memory_desc_t bias_desc, @Const dnnl_memory_desc_t dst_desc,
        @Cast("const int64_t*") long[] strides, @Cast("const int64_t*") long[] padding_l,
        @Cast("const int64_t*") long[] padding_r);

/** Initializes a descriptor for a dilated convolution forward propagation
 *  primitive.
 * 
 *  \note
 *      Memory descriptors can be initialized with
 *      #dnnl_format_tag_any or with format_kind set to #dnnl_format_kind_any.
 * 
 *  Arrays \p strides, \p dilates, \p padding_l, and \p padding_r contain
 *  values for spatial dimensions only and hence must have the same number of
 *  elements as there are spatial dimensions. The order of values is the same
 *  as in the tensor: depth (for 3D tensors), height (for 3D and 2D tensors),
 *  and width.
 * 
 *  @param conv_desc Output descriptor for a convolution primitive.
 *  @param prop_kind Propagation kind. Possible values are
 *      #dnnl_forward_training and #dnnl_forward_inference.
 *  @param alg_kind Convolution algorithm. Possible values are
 *      #dnnl_convolution_direct, #dnnl_convolution_winograd,
 *      #dnnl_convolution_auto.
 *  @param src_desc Source memory descriptor.
 *  @param weights_desc Weights memory descriptor.
 *  @param bias_desc Bias memory descriptor. Passing NULL, a zero memory
 *      descriptor, or a memory descriptor with format_kind set to
 *      #dnnl_format_kind_undef disables the bias term.
 *  @param dst_desc Destination memory descriptor.
 *  @param strides Array of strides for spatial dimension.
 *  @param dilates Array of dilations for spatial dimension. A zero value
 *      means no dilation in the corresponding dimension.
 *  @param padding_l Array of padding values for low indices for each spatial
 *      dimension {@code ([[front,] top,] left)}.
 *  @param padding_r Array of padding values for high indices for each spatial
 *      dimension {@code ([[back,] bottom,] right)}. Can be NULL in which case
 *      padding is considered to be symmetrical.
 *  @return #dnnl_success on success and a status describing the error
 *      otherwise. */

///
///
///
public static native @Cast("dnnl_status_t") int dnnl_dilated_convolution_forward_desc_init(
        dnnl_convolution_desc_t conv_desc, @Cast("dnnl_prop_kind_t") int prop_kind,
        @Cast("dnnl_alg_kind_t") int alg_kind, @Const dnnl_memory_desc_t src_desc,
        @Const dnnl_memory_desc_t weights_desc,
        @Const dnnl_memory_desc_t bias_desc, @Const dnnl_memory_desc_t dst_desc,
        @Cast("const int64_t*") LongPointer strides, @Cast("const int64_t*") LongPointer dilates,
        @Cast("const int64_t*") LongPointer padding_l, @Cast("const int64_t*") LongPointer padding_r);
public static native @Cast("dnnl_status_t") int dnnl_dilated_convolution_forward_desc_init(
        dnnl_convolution_desc_t conv_desc, @Cast("dnnl_prop_kind_t") int prop_kind,
        @Cast("dnnl_alg_kind_t") int alg_kind, @Const dnnl_memory_desc_t src_desc,
        @Const dnnl_memory_desc_t weights_desc,
        @Const dnnl_memory_desc_t bias_desc, @Const dnnl_memory_desc_t dst_desc,
        @Cast("const int64_t*") LongBuffer strides, @Cast("const int64_t*") LongBuffer dilates,
        @Cast("const int64_t*") LongBuffer padding_l, @Cast("const int64_t*") LongBuffer padding_r);
public static native @Cast("dnnl_status_t") int dnnl_dilated_convolution_forward_desc_init(
        dnnl_convolution_desc_t conv_desc, @Cast("dnnl_prop_kind_t") int prop_kind,
        @Cast("dnnl_alg_kind_t") int alg_kind, @Const dnnl_memory_desc_t src_desc,
        @Const dnnl_memory_desc_t weights_desc,
        @Const dnnl_memory_desc_t bias_desc, @Const dnnl_memory_desc_t dst_desc,
        @Cast("const int64_t*") long[] strides, @Cast("const int64_t*") long[] dilates,
        @Cast("const int64_t*") long[] padding_l, @Cast("const int64_t*") long[] padding_r);

/** Initializes a descriptor for a convolution backward propagation primitive.
 * 
 *  \note
 *      Memory descriptors can be initialized with
 *      #dnnl_format_tag_any or with format_kind set to #dnnl_format_kind_any.
 * 
 *  Arrays \p strides, \p padding_l, and \p padding_r contain values for
 *  spatial dimensions only and hence must have the same number of elements as
 *  there are spatial dimensions. The order of values is the same as in the
 *  tensor: depth (for 3D tensors), height (for 3D and 2D tensors), and width.
 * 
 *  @param conv_desc Output descriptor for a convolution primitive.
 *  @param alg_kind Convolution algorithm. Possible values are
 *      #dnnl_convolution_direct, #dnnl_convolution_winograd,
 *      #dnnl_convolution_auto.
 *  @param diff_src_desc Diff source memory descriptor.
 *  @param weights_desc Weights memory descriptor.
 *  @param diff_dst_desc Diff destination memory descriptor.
 *  @param strides Array of strides for spatial dimension.
 *  @param padding_l Array of padding values for low indices for each spatial
 *      dimension {@code ([[front,] top,] left)}.
 *  @param padding_r Array of padding values for high indices for each spatial
 *      dimension {@code ([[back,] bottom,] right)}. Can be NULL in which case
 *      padding is assumed to be symmetrical.
 *  @return #dnnl_success on success and a status describing the error
 *      otherwise. */

///
///
///
public static native @Cast("dnnl_status_t") int dnnl_convolution_backward_data_desc_init(
        dnnl_convolution_desc_t conv_desc, @Cast("dnnl_alg_kind_t") int alg_kind,
        @Const dnnl_memory_desc_t diff_src_desc,
        @Const dnnl_memory_desc_t weights_desc,
        @Const dnnl_memory_desc_t diff_dst_desc, @Cast("const int64_t*") LongPointer strides,
        @Cast("const int64_t*") LongPointer padding_l, @Cast("const int64_t*") LongPointer padding_r);
public static native @Cast("dnnl_status_t") int dnnl_convolution_backward_data_desc_init(
        dnnl_convolution_desc_t conv_desc, @Cast("dnnl_alg_kind_t") int alg_kind,
        @Const dnnl_memory_desc_t diff_src_desc,
        @Const dnnl_memory_desc_t weights_desc,
        @Const dnnl_memory_desc_t diff_dst_desc, @Cast("const int64_t*") LongBuffer strides,
        @Cast("const int64_t*") LongBuffer padding_l, @Cast("const int64_t*") LongBuffer padding_r);
public static native @Cast("dnnl_status_t") int dnnl_convolution_backward_data_desc_init(
        dnnl_convolution_desc_t conv_desc, @Cast("dnnl_alg_kind_t") int alg_kind,
        @Const dnnl_memory_desc_t diff_src_desc,
        @Const dnnl_memory_desc_t weights_desc,
        @Const dnnl_memory_desc_t diff_dst_desc, @Cast("const int64_t*") long[] strides,
        @Cast("const int64_t*") long[] padding_l, @Cast("const int64_t*") long[] padding_r);

/** Initializes a descriptor for a dilated convolution backward propagation
 *  primitive.
 * 
 *  \note
 *      Memory descriptors can be initialized with
 *      #dnnl_format_tag_any or with format_kind set to #dnnl_format_kind_any.
 * 
 *  Arrays \p strides, \p dilates, \p padding_l, and \p padding_r contain
 *  values for spatial dimensions only and hence must have the same number of
 *  elements as there are spatial dimensions. The order of values is the same
 *  as in the tensor: depth (for 3D tensors), height (for 3D and 2D tensors),
 *  and width.
 * 
 *  @param conv_desc Output descriptor for a convolution primitive.
 *  @param alg_kind Convolution algorithm. Possible values are
 *      #dnnl_convolution_direct, #dnnl_convolution_winograd,
 *      #dnnl_convolution_auto.
 *  @param diff_src_desc Diff source memory descriptor.
 *  @param weights_desc Weights memory descriptor.
 *  @param diff_dst_desc Diff destination memory descriptor.
 *  @param strides Array of strides for spatial dimension.
 *  @param dilates Array of dilations for spatial dimension. A zero value
 *      means no dilation in the corresponding dimension.
 *  @param padding_l Array of padding values for low indices for each spatial
 *      dimension {@code ([[front,] top,] left)}.
 *  @param padding_r Array of padding values for high indices for each spatial
 *      dimension {@code ([[back,] bottom,] right)}. Can be NULL in which case
 *      padding is considered to be symmetrical.
 *  @return #dnnl_success on success and a status describing the error
 *      otherwise. */

///
///
///
public static native @Cast("dnnl_status_t") int dnnl_dilated_convolution_backward_data_desc_init(
        dnnl_convolution_desc_t conv_desc, @Cast("dnnl_alg_kind_t") int alg_kind,
        @Const dnnl_memory_desc_t diff_src_desc,
        @Const dnnl_memory_desc_t weights_desc,
        @Const dnnl_memory_desc_t diff_dst_desc, @Cast("const int64_t*") LongPointer strides,
        @Cast("const int64_t*") LongPointer dilates, @Cast("const int64_t*") LongPointer padding_l,
        @Cast("const int64_t*") LongPointer padding_r);
public static native @Cast("dnnl_status_t") int dnnl_dilated_convolution_backward_data_desc_init(
        dnnl_convolution_desc_t conv_desc, @Cast("dnnl_alg_kind_t") int alg_kind,
        @Const dnnl_memory_desc_t diff_src_desc,
        @Const dnnl_memory_desc_t weights_desc,
        @Const dnnl_memory_desc_t diff_dst_desc, @Cast("const int64_t*") LongBuffer strides,
        @Cast("const int64_t*") LongBuffer dilates, @Cast("const int64_t*") LongBuffer padding_l,
        @Cast("const int64_t*") LongBuffer padding_r);
public static native @Cast("dnnl_status_t") int dnnl_dilated_convolution_backward_data_desc_init(
        dnnl_convolution_desc_t conv_desc, @Cast("dnnl_alg_kind_t") int alg_kind,
        @Const dnnl_memory_desc_t diff_src_desc,
        @Const dnnl_memory_desc_t weights_desc,
        @Const dnnl_memory_desc_t diff_dst_desc, @Cast("const int64_t*") long[] strides,
        @Cast("const int64_t*") long[] dilates, @Cast("const int64_t*") long[] padding_l,
        @Cast("const int64_t*") long[] padding_r);

/** Initializes a descriptor for a convolution weights gradient primitive.
 * 
 *  \note
 *      Memory descriptors can be initialized with
 *      #dnnl_format_tag_any or with format_kind set to #dnnl_format_kind_any.
 * 
 *  Arrays \p strides, \p padding_l, and \p padding_r contain values for
 *  spatial dimensions only and hence must have the same number of elements as
 *  there are spatial dimensions. The order of values is the same as in the
 *  tensor: depth (for 3D tensors), height (for 3D and 2D tensors), and width.
 * 
 *  @param conv_desc Output descriptor for a convolution primitive.
 *  @param alg_kind Convolution algorithm. Possible values are
 *      #dnnl_convolution_direct, #dnnl_convolution_winograd,
 *      #dnnl_convolution_auto.
 *  @param src_desc Source memory descriptor.
 *  @param diff_weights_desc Diff weights memory descriptor.
 *  @param diff_bias_desc Diff bias memory descriptor. Passing NULL, a zero
 *      memory descriptor, or a memory descriptor with format_kind set to
 *      #dnnl_format_kind_undef disables the bias term.
 *  @param diff_dst_desc Diff destination memory descriptor.
 *  @param strides Array of strides for spatial dimension.
 *  @param padding_l Array of padding values for low indices for each spatial
 *      dimension {@code ([[front,] top,] left)}.
 *  @param padding_r Array of padding values for high indices for each spatial
 *      dimension {@code ([[back,] bottom,] right)}. Can be NULL in which case
 *      padding is considered to be symmetrical.
 *  @return #dnnl_success on success and a status describing the error
 *      otherwise. */

///
///
///
public static native @Cast("dnnl_status_t") int dnnl_convolution_backward_weights_desc_init(
        dnnl_convolution_desc_t conv_desc, @Cast("dnnl_alg_kind_t") int alg_kind,
        @Const dnnl_memory_desc_t src_desc,
        @Const dnnl_memory_desc_t diff_weights_desc,
        @Const dnnl_memory_desc_t diff_bias_desc,
        @Const dnnl_memory_desc_t diff_dst_desc, @Cast("const int64_t*") LongPointer strides,
        @Cast("const int64_t*") LongPointer padding_l, @Cast("const int64_t*") LongPointer padding_r);
public static native @Cast("dnnl_status_t") int dnnl_convolution_backward_weights_desc_init(
        dnnl_convolution_desc_t conv_desc, @Cast("dnnl_alg_kind_t") int alg_kind,
        @Const dnnl_memory_desc_t src_desc,
        @Const dnnl_memory_desc_t diff_weights_desc,
        @Const dnnl_memory_desc_t diff_bias_desc,
        @Const dnnl_memory_desc_t diff_dst_desc, @Cast("const int64_t*") LongBuffer strides,
        @Cast("const int64_t*") LongBuffer padding_l, @Cast("const int64_t*") LongBuffer padding_r);
public static native @Cast("dnnl_status_t") int dnnl_convolution_backward_weights_desc_init(
        dnnl_convolution_desc_t conv_desc, @Cast("dnnl_alg_kind_t") int alg_kind,
        @Const dnnl_memory_desc_t src_desc,
        @Const dnnl_memory_desc_t diff_weights_desc,
        @Const dnnl_memory_desc_t diff_bias_desc,
        @Const dnnl_memory_desc_t diff_dst_desc, @Cast("const int64_t*") long[] strides,
        @Cast("const int64_t*") long[] padding_l, @Cast("const int64_t*") long[] padding_r);

/** Initializes a descriptor for a dilated convolution weights gradient
 *  primitive.
 * 
 *  \note
 *      Memory descriptors can be initialized with
 *      #dnnl_format_tag_any or with format_kind set to #dnnl_format_kind_any.
 * 
 *  Arrays \p strides, \p dilates, \p padding_l, and \p padding_r contain
 *  values for spatial dimensions only and hence must have the same number of
 *  elements as there are spatial dimensions. The order of values is the same
 *  as in the tensor: depth (for 3D tensors), height (for 3D and 2D tensors),
 *  and width.
 * 
 *  @param conv_desc Output descriptor for a convolution primitive.
 *  @param alg_kind Convolution algorithm. Possible values are
 *      #dnnl_convolution_direct, #dnnl_convolution_winograd,
 *      #dnnl_convolution_auto.
 *  @param src_desc Source memory descriptor.
 *  @param diff_weights_desc Diff weights memory descriptor.
 *  @param diff_bias_desc Diff bias memory descriptor. Passing NULL, a zero
 *      memory descriptor, or a memory descriptor with format_kind set to
 *      #dnnl_format_kind_undef disables the bias term.
 *  @param diff_dst_desc Diff destination memory descriptor.
 *  @param strides Array of strides for spatial dimension.
 *  @param dilates Array of dilations for spatial dimension. A zero value
 *      means no dilation in the corresponding dimension.
 *  @param padding_l Array of padding values for low indices for each spatial
 *      dimension {@code ([[front,] top,] left)}.
 *  @param padding_r Array of padding values for high indices for each spatial
 *      dimension {@code ([[back,] bottom,] right)}. Can be NULL in which case
 *      padding is considered to be symmetrical.
 *  @return #dnnl_success on success and a status describing the error
 *      otherwise. */

///
///
///
public static native @Cast("dnnl_status_t") int dnnl_dilated_convolution_backward_weights_desc_init(
        dnnl_convolution_desc_t conv_desc, @Cast("dnnl_alg_kind_t") int alg_kind,
        @Const dnnl_memory_desc_t src_desc,
        @Const dnnl_memory_desc_t diff_weights_desc,
        @Const dnnl_memory_desc_t diff_bias_desc,
        @Const dnnl_memory_desc_t diff_dst_desc, @Cast("const int64_t*") LongPointer strides,
        @Cast("const int64_t*") LongPointer dilates, @Cast("const int64_t*") LongPointer padding_l,
        @Cast("const int64_t*") LongPointer padding_r);
public static native @Cast("dnnl_status_t") int dnnl_dilated_convolution_backward_weights_desc_init(
        dnnl_convolution_desc_t conv_desc, @Cast("dnnl_alg_kind_t") int alg_kind,
        @Const dnnl_memory_desc_t src_desc,
        @Const dnnl_memory_desc_t diff_weights_desc,
        @Const dnnl_memory_desc_t diff_bias_desc,
        @Const dnnl_memory_desc_t diff_dst_desc, @Cast("const int64_t*") LongBuffer strides,
        @Cast("const int64_t*") LongBuffer dilates, @Cast("const int64_t*") LongBuffer padding_l,
        @Cast("const int64_t*") LongBuffer padding_r);
public static native @Cast("dnnl_status_t") int dnnl_dilated_convolution_backward_weights_desc_init(
        dnnl_convolution_desc_t conv_desc, @Cast("dnnl_alg_kind_t") int alg_kind,
        @Const dnnl_memory_desc_t src_desc,
        @Const dnnl_memory_desc_t diff_weights_desc,
        @Const dnnl_memory_desc_t diff_bias_desc,
        @Const dnnl_memory_desc_t diff_dst_desc, @Cast("const int64_t*") long[] strides,
        @Cast("const int64_t*") long[] dilates, @Cast("const int64_t*") long[] padding_l,
        @Cast("const int64_t*") long[] padding_r);

/** \} dnnl_api_convolution
 <p>
 *  \addtogroup dnnl_api_deconvolution
 *  \{
 <p>
 *  Initializes a descriptor for a deconvolution forward propagation primitive.
 * 
 *  \note
 *      Memory descriptors can be initialized with
 *      #dnnl_format_tag_any or with format_kind set to #dnnl_format_kind_any.
 * 
 *  Arrays \p strides, \p padding_l, and \p padding_r contain values for
 *  spatial dimensions only and hence must have the same number of elements as
 *  there are spatial dimensions. The order of values is the same as in the
 *  tensor: depth (for 3D tensors), height (for 3D and 2D tensors), and width.
 * 
 *  @param deconv_desc Output descriptor for a deconvolution primitive.
 *  @param prop_kind Propagation kind. Possible values are
 *      #dnnl_forward_training and #dnnl_forward_inference.
 *  @param alg_kind Deconvolution algorithm. Possible values are
 *      #dnnl_deconvolution_direct, #dnnl_deconvolution_winograd.
 *  @param src_desc Source memory descriptor.
 *  @param weights_desc Weights memory descriptor.
 *  @param bias_desc Bias memory descriptor. Passing NULL, a zero memory
 *      descriptor, or a memory descriptor with format_kind set to
 *      #dnnl_format_kind_undef disables the bias term.
 *  @param dst_desc Destination memory descriptor.
 *  @param strides Array of strides for spatial dimension.
 *  @param padding_l Array of padding values for low indices for each spatial
 *      dimension {@code ([[front,] top,] left)}.
 *  @param padding_r Array of padding values for high indices for each spatial
 *      dimension {@code ([[back,] bottom,] right)}. Can be NULL in which case
 *      padding is considered to be symmetrical.
 *  @return #dnnl_success on success and a status describing the error
 *      otherwise. */

///
///
///
public static native @Cast("dnnl_status_t") int dnnl_deconvolution_forward_desc_init(
        @Cast("dnnl_deconvolution_desc_t*") dnnl_convolution_desc_t deconv_desc, @Cast("dnnl_prop_kind_t") int prop_kind,
        @Cast("dnnl_alg_kind_t") int alg_kind, @Const dnnl_memory_desc_t src_desc,
        @Const dnnl_memory_desc_t weights_desc,
        @Const dnnl_memory_desc_t bias_desc, @Const dnnl_memory_desc_t dst_desc,
        @Cast("const int64_t*") LongPointer strides, @Cast("const int64_t*") LongPointer padding_l,
        @Cast("const int64_t*") LongPointer padding_r);
public static native @Cast("dnnl_status_t") int dnnl_deconvolution_forward_desc_init(
        @Cast("dnnl_deconvolution_desc_t*") dnnl_convolution_desc_t deconv_desc, @Cast("dnnl_prop_kind_t") int prop_kind,
        @Cast("dnnl_alg_kind_t") int alg_kind, @Const dnnl_memory_desc_t src_desc,
        @Const dnnl_memory_desc_t weights_desc,
        @Const dnnl_memory_desc_t bias_desc, @Const dnnl_memory_desc_t dst_desc,
        @Cast("const int64_t*") LongBuffer strides, @Cast("const int64_t*") LongBuffer padding_l,
        @Cast("const int64_t*") LongBuffer padding_r);
public static native @Cast("dnnl_status_t") int dnnl_deconvolution_forward_desc_init(
        @Cast("dnnl_deconvolution_desc_t*") dnnl_convolution_desc_t deconv_desc, @Cast("dnnl_prop_kind_t") int prop_kind,
        @Cast("dnnl_alg_kind_t") int alg_kind, @Const dnnl_memory_desc_t src_desc,
        @Const dnnl_memory_desc_t weights_desc,
        @Const dnnl_memory_desc_t bias_desc, @Const dnnl_memory_desc_t dst_desc,
        @Cast("const int64_t*") long[] strides, @Cast("const int64_t*") long[] padding_l,
        @Cast("const int64_t*") long[] padding_r);

/** Initializes a descriptor for a dilated deconvolution forward propagation
 *  primitive.
 * 
 *  \note
 *      Memory descriptors can be initialized with
 *      #dnnl_format_tag_any or with format_kind set to #dnnl_format_kind_any.
 * 
 *  Arrays \p strides, \p dilates, \p padding_l, and \p padding_r contain
 *  values for spatial dimensions only and hence must have the same number of
 *  elements as there are spatial dimensions. The order of values is the same
 *  as in the tensor: depth (for 3D tensors), height (for 3D and 2D tensors),
 *  and width.
 * 
 *  @param deconv_desc Output descriptor for a deconvolution primitive.
 *  @param prop_kind Propagation kind. Possible values are
 *      #dnnl_forward_training and #dnnl_forward_inference.
 *  @param alg_kind Deconvolution algorithm. Possible values are
 *      #dnnl_deconvolution_direct, #dnnl_deconvolution_winograd.
 *  @param src_desc Source memory descriptor.
 *  @param weights_desc Weights memory descriptor.
 *  @param bias_desc Bias memory descriptor. Passing NULL, a zero memory
 *      descriptor, or a memory descriptor with format_kind set to
 *      #dnnl_format_kind_undef disables the bias term.
 *  @param dst_desc Destination memory descriptor.
 *  @param strides Array of strides for spatial dimension.
 *  @param dilates Array of dilations for spatial dimension. A zero value
 *      means no dilation in the corresponding dimension.
 *  @param padding_l Array of padding values for low indices for each spatial
 *      dimension {@code ([[front,] top,] left)}.
 *  @param padding_r Array of padding values for high indices for each spatial
 *      dimension {@code ([[back,] bottom,] right)}. Can be NULL in which case
 *      padding is considered to be symmetrical.
 *  @return #dnnl_success on success and a status describing the error
 *      otherwise. */

///
///
///
public static native @Cast("dnnl_status_t") int dnnl_dilated_deconvolution_forward_desc_init(
        @Cast("dnnl_deconvolution_desc_t*") dnnl_convolution_desc_t deconv_desc, @Cast("dnnl_prop_kind_t") int prop_kind,
        @Cast("dnnl_alg_kind_t") int alg_kind, @Const dnnl_memory_desc_t src_desc,
        @Const dnnl_memory_desc_t weights_desc,
        @Const dnnl_memory_desc_t bias_desc, @Const dnnl_memory_desc_t dst_desc,
        @Cast("const int64_t*") LongPointer strides, @Cast("const int64_t*") LongPointer dilates,
        @Cast("const int64_t*") LongPointer padding_l, @Cast("const int64_t*") LongPointer padding_r);
public static native @Cast("dnnl_status_t") int dnnl_dilated_deconvolution_forward_desc_init(
        @Cast("dnnl_deconvolution_desc_t*") dnnl_convolution_desc_t deconv_desc, @Cast("dnnl_prop_kind_t") int prop_kind,
        @Cast("dnnl_alg_kind_t") int alg_kind, @Const dnnl_memory_desc_t src_desc,
        @Const dnnl_memory_desc_t weights_desc,
        @Const dnnl_memory_desc_t bias_desc, @Const dnnl_memory_desc_t dst_desc,
        @Cast("const int64_t*") LongBuffer strides, @Cast("const int64_t*") LongBuffer dilates,
        @Cast("const int64_t*") LongBuffer padding_l, @Cast("const int64_t*") LongBuffer padding_r);
public static native @Cast("dnnl_status_t") int dnnl_dilated_deconvolution_forward_desc_init(
        @Cast("dnnl_deconvolution_desc_t*") dnnl_convolution_desc_t deconv_desc, @Cast("dnnl_prop_kind_t") int prop_kind,
        @Cast("dnnl_alg_kind_t") int alg_kind, @Const dnnl_memory_desc_t src_desc,
        @Const dnnl_memory_desc_t weights_desc,
        @Const dnnl_memory_desc_t bias_desc, @Const dnnl_memory_desc_t dst_desc,
        @Cast("const int64_t*") long[] strides, @Cast("const int64_t*") long[] dilates,
        @Cast("const int64_t*") long[] padding_l, @Cast("const int64_t*") long[] padding_r);

/** Initializes a descriptor for a deconvolution backward propagation primitive.
 * 
 *  \note
 *      Memory descriptors can be initialized with
 *      #dnnl_format_tag_any or with format_kind set to #dnnl_format_kind_any.
 * 
 *  Arrays \p strides, \p padding_l, and \p padding_r contain values for
 *  spatial dimensions only and hence must have the same number of elements as
 *  there are spatial dimensions. The order of values is the same as in the
 *  tensor: depth (for 3D tensors), height (for 3D and 2D tensors), and width.
 * 
 *  @param deconv_desc Output descriptor for a deconvolution primitive.
 *  @param alg_kind Deconvolution algorithm. Possible values are
 *      #dnnl_deconvolution_direct, #dnnl_deconvolution_winograd.
 *  @param diff_src_desc Diff source memory descriptor.
 *  @param weights_desc Weights memory descriptor.
 *  @param diff_dst_desc Diff destination memory descriptor.
 *  @param strides Array of strides for spatial dimension.
 *  @param padding_l Array of padding values for low indices for each spatial
 *      dimension {@code ([[front,] top,] left)}.
 *  @param padding_r Array of padding values for high indices for each spatial
 *      dimension {@code ([[back,] bottom,] right)}. Can be NULL in which case
 *      padding is considered to be symmetrical.
 *  @return #dnnl_success on success and a status describing the error
 *      otherwise. */

///
///
///
public static native @Cast("dnnl_status_t") int dnnl_deconvolution_backward_data_desc_init(
        @Cast("dnnl_deconvolution_desc_t*") dnnl_convolution_desc_t deconv_desc, @Cast("dnnl_alg_kind_t") int alg_kind,
        @Const dnnl_memory_desc_t diff_src_desc,
        @Const dnnl_memory_desc_t weights_desc,
        @Const dnnl_memory_desc_t diff_dst_desc, @Cast("const int64_t*") LongPointer strides,
        @Cast("const int64_t*") LongPointer padding_l, @Cast("const int64_t*") LongPointer padding_r);
public static native @Cast("dnnl_status_t") int dnnl_deconvolution_backward_data_desc_init(
        @Cast("dnnl_deconvolution_desc_t*") dnnl_convolution_desc_t deconv_desc, @Cast("dnnl_alg_kind_t") int alg_kind,
        @Const dnnl_memory_desc_t diff_src_desc,
        @Const dnnl_memory_desc_t weights_desc,
        @Const dnnl_memory_desc_t diff_dst_desc, @Cast("const int64_t*") LongBuffer strides,
        @Cast("const int64_t*") LongBuffer padding_l, @Cast("const int64_t*") LongBuffer padding_r);
public static native @Cast("dnnl_status_t") int dnnl_deconvolution_backward_data_desc_init(
        @Cast("dnnl_deconvolution_desc_t*") dnnl_convolution_desc_t deconv_desc, @Cast("dnnl_alg_kind_t") int alg_kind,
        @Const dnnl_memory_desc_t diff_src_desc,
        @Const dnnl_memory_desc_t weights_desc,
        @Const dnnl_memory_desc_t diff_dst_desc, @Cast("const int64_t*") long[] strides,
        @Cast("const int64_t*") long[] padding_l, @Cast("const int64_t*") long[] padding_r);

/** Initializes a descriptor for a dilated deconvolution backward propagation
 *  primitive.
 * 
 *  \note
 *      Memory descriptors can be initialized with
 *      #dnnl_format_tag_any or with format_kind set to #dnnl_format_kind_any.
 * 
 *  Arrays \p strides, \p dilates, \p padding_l, and \p padding_r contain
 *  values for spatial dimensions only and hence must have the same number of
 *  elements as there are spatial dimensions. The order of values is the same
 *  as in the tensor: depth (for 3D tensors), height (for 3D and 2D tensors),
 *  and width.
 * 
 *  @param deconv_desc Output descriptor for a deconvolution primitive.
 *  @param alg_kind Deconvolution algorithm. Possible values are
 *      #dnnl_deconvolution_direct, #dnnl_deconvolution_winograd.
 *  @param diff_src_desc Diff source memory descriptor.
 *  @param weights_desc Weights memory descriptor.
 *  @param diff_dst_desc Diff destination memory descriptor.
 *  @param strides Array of strides for spatial dimension.
 *  @param dilates Array of dilations for spatial dimension. A zero value
 *      means no dilation in the corresponding dimension.
 *  @param padding_l Array of padding values for low indices for each spatial
 *      dimension {@code ([[front,] top,] left)}.
 *  @param padding_r Array of padding values for high indices for each spatial
 *      dimension {@code ([[back,] bottom,] right)}. Can be NULL in which case
 *      padding is considered to be symmetrical.
 *  @return #dnnl_success on success and a status describing the error
 *      otherwise. */

///
///
///
public static native @Cast("dnnl_status_t") int dnnl_dilated_deconvolution_backward_data_desc_init(
        @Cast("dnnl_deconvolution_desc_t*") dnnl_convolution_desc_t deconv_desc, @Cast("dnnl_alg_kind_t") int alg_kind,
        @Const dnnl_memory_desc_t diff_src_desc,
        @Const dnnl_memory_desc_t weights_desc,
        @Const dnnl_memory_desc_t diff_dst_desc, @Cast("const int64_t*") LongPointer strides,
        @Cast("const int64_t*") LongPointer dilates, @Cast("const int64_t*") LongPointer padding_l,
        @Cast("const int64_t*") LongPointer padding_r);
public static native @Cast("dnnl_status_t") int dnnl_dilated_deconvolution_backward_data_desc_init(
        @Cast("dnnl_deconvolution_desc_t*") dnnl_convolution_desc_t deconv_desc, @Cast("dnnl_alg_kind_t") int alg_kind,
        @Const dnnl_memory_desc_t diff_src_desc,
        @Const dnnl_memory_desc_t weights_desc,
        @Const dnnl_memory_desc_t diff_dst_desc, @Cast("const int64_t*") LongBuffer strides,
        @Cast("const int64_t*") LongBuffer dilates, @Cast("const int64_t*") LongBuffer padding_l,
        @Cast("const int64_t*") LongBuffer padding_r);
public static native @Cast("dnnl_status_t") int dnnl_dilated_deconvolution_backward_data_desc_init(
        @Cast("dnnl_deconvolution_desc_t*") dnnl_convolution_desc_t deconv_desc, @Cast("dnnl_alg_kind_t") int alg_kind,
        @Const dnnl_memory_desc_t diff_src_desc,
        @Const dnnl_memory_desc_t weights_desc,
        @Const dnnl_memory_desc_t diff_dst_desc, @Cast("const int64_t*") long[] strides,
        @Cast("const int64_t*") long[] dilates, @Cast("const int64_t*") long[] padding_l,
        @Cast("const int64_t*") long[] padding_r);

/** Initializes a descriptor for a deconvolution weights gradient primitive.
 * 
 *  \note
 *      Memory descriptors can be initialized with
 *      #dnnl_format_tag_any or with format_kind set to #dnnl_format_kind_any.
 * 
 *  Arrays \p strides, \p padding_l, and \p padding_r contain values for
 *  spatial dimensions only and hence must have the same number of elements as
 *  there are spatial dimensions. The order of values is the same as in the
 *  tensor: depth (for 3D tensors), height (for 3D and 2D tensors), and width.
 * 
 *  @param deconv_desc Output descriptor for a deconvolution primitive.
 *  @param alg_kind Deconvolution algorithm. Possible values are
 *      #dnnl_deconvolution_direct, #dnnl_deconvolution_winograd.
 *  @param src_desc Source memory descriptor.
 *  @param diff_weights_desc Diff weights memory descriptor.
 *  @param diff_bias_desc Diff bias memory descriptor. Passing NULL, a zero
 *      memory descriptor, or a memory descriptor with format_kind set to
 *      #dnnl_format_kind_undef disables the bias term.
 *  @param diff_dst_desc Diff destination memory descriptor.
 *  @param strides Array of strides for spatial dimension.
 *  @param padding_l Array of padding values for low indices for each spatial
 *      dimension {@code ([[front,] top,] left)}.
 *  @param padding_r Array of padding values for high indices for each spatial
 *      dimension {@code ([[back,] bottom,] right)}. Can be NULL in which case
 *      padding is considered to be symmetrical.
 *  @return #dnnl_success on success and a status describing the error
 *      otherwise. */

///
///
///
public static native @Cast("dnnl_status_t") int dnnl_deconvolution_backward_weights_desc_init(
        @Cast("dnnl_deconvolution_desc_t*") dnnl_convolution_desc_t deconv_desc, @Cast("dnnl_alg_kind_t") int alg_kind,
        @Const dnnl_memory_desc_t src_desc,
        @Const dnnl_memory_desc_t diff_weights_desc,
        @Const dnnl_memory_desc_t diff_bias_desc,
        @Const dnnl_memory_desc_t diff_dst_desc, @Cast("const int64_t*") LongPointer strides,
        @Cast("const int64_t*") LongPointer padding_l, @Cast("const int64_t*") LongPointer padding_r);
public static native @Cast("dnnl_status_t") int dnnl_deconvolution_backward_weights_desc_init(
        @Cast("dnnl_deconvolution_desc_t*") dnnl_convolution_desc_t deconv_desc, @Cast("dnnl_alg_kind_t") int alg_kind,
        @Const dnnl_memory_desc_t src_desc,
        @Const dnnl_memory_desc_t diff_weights_desc,
        @Const dnnl_memory_desc_t diff_bias_desc,
        @Const dnnl_memory_desc_t diff_dst_desc, @Cast("const int64_t*") LongBuffer strides,
        @Cast("const int64_t*") LongBuffer padding_l, @Cast("const int64_t*") LongBuffer padding_r);
public static native @Cast("dnnl_status_t") int dnnl_deconvolution_backward_weights_desc_init(
        @Cast("dnnl_deconvolution_desc_t*") dnnl_convolution_desc_t deconv_desc, @Cast("dnnl_alg_kind_t") int alg_kind,
        @Const dnnl_memory_desc_t src_desc,
        @Const dnnl_memory_desc_t diff_weights_desc,
        @Const dnnl_memory_desc_t diff_bias_desc,
        @Const dnnl_memory_desc_t diff_dst_desc, @Cast("const int64_t*") long[] strides,
        @Cast("const int64_t*") long[] padding_l, @Cast("const int64_t*") long[] padding_r);

/** Initializes a descriptor for a dilated deconvolution weights gradient
 *  primitive.
 * 
 *  \note
 *      Memory descriptors can be initialized with
 *      #dnnl_format_tag_any or with format_kind set to #dnnl_format_kind_any.
 * 
 *  Arrays \p strides, \p dilates, \p padding_l, and \p padding_r contain
 *  values for spatial dimensions only and hence must have the same number of
 *  elements as there are spatial dimensions. The order of values is the same
 *  as in the tensor: depth (for 3D tensors), height (for 3D and 2D tensors),
 *  and width.
 * 
 *  @param deconv_desc Output descriptor for a deconvolution primitive.
 *  @param alg_kind Deconvolution algorithm. Possible values are
 *      #dnnl_deconvolution_direct, #dnnl_deconvolution_winograd.
 *  @param src_desc Source memory descriptor.
 *  @param diff_weights_desc Diff weights memory descriptor.
 *  @param diff_bias_desc Diff bias memory descriptor. Passing NULL, a zero
 *      memory descriptor, or a memory descriptor with format_kind set to
 *      #dnnl_format_kind_undef disables the bias term.
 *  @param diff_dst_desc Diff destination memory descriptor.
 *  @param strides Array of strides for spatial dimension.
 *  @param dilates Array of dilations for spatial dimension. A zero value
 *      means no dilation in the corresponding dimension.
 *  @param padding_l Array of padding values for low indices for each spatial
 *      dimension {@code ([[front,] top,] left)}.
 *  @param padding_r Array of padding values for high indices for each spatial
 *      dimension {@code ([[back,] bottom,] right)}. Can be NULL in which case
 *      padding is considered to be symmetrical.
 *  @return #dnnl_success on success and a status describing the error
 *      otherwise. */

///
public static native @Cast("dnnl_status_t") int dnnl_dilated_deconvolution_backward_weights_desc_init(
        @Cast("dnnl_deconvolution_desc_t*") dnnl_convolution_desc_t deconv_desc, @Cast("dnnl_alg_kind_t") int alg_kind,
        @Const dnnl_memory_desc_t src_desc,
        @Const dnnl_memory_desc_t diff_weights_desc,
        @Const dnnl_memory_desc_t diff_bias_desc,
        @Const dnnl_memory_desc_t diff_dst_desc, @Cast("const int64_t*") LongPointer strides,
        @Cast("const int64_t*") LongPointer dilates, @Cast("const int64_t*") LongPointer padding_l,
        @Cast("const int64_t*") LongPointer padding_r);
public static native @Cast("dnnl_status_t") int dnnl_dilated_deconvolution_backward_weights_desc_init(
        @Cast("dnnl_deconvolution_desc_t*") dnnl_convolution_desc_t deconv_desc, @Cast("dnnl_alg_kind_t") int alg_kind,
        @Const dnnl_memory_desc_t src_desc,
        @Const dnnl_memory_desc_t diff_weights_desc,
        @Const dnnl_memory_desc_t diff_bias_desc,
        @Const dnnl_memory_desc_t diff_dst_desc, @Cast("const int64_t*") LongBuffer strides,
        @Cast("const int64_t*") LongBuffer dilates, @Cast("const int64_t*") LongBuffer padding_l,
        @Cast("const int64_t*") LongBuffer padding_r);
public static native @Cast("dnnl_status_t") int dnnl_dilated_deconvolution_backward_weights_desc_init(
        @Cast("dnnl_deconvolution_desc_t*") dnnl_convolution_desc_t deconv_desc, @Cast("dnnl_alg_kind_t") int alg_kind,
        @Const dnnl_memory_desc_t src_desc,
        @Const dnnl_memory_desc_t diff_weights_desc,
        @Const dnnl_memory_desc_t diff_bias_desc,
        @Const dnnl_memory_desc_t diff_dst_desc, @Cast("const int64_t*") long[] strides,
        @Cast("const int64_t*") long[] dilates, @Cast("const int64_t*") long[] padding_l,
        @Cast("const int64_t*") long[] padding_r);

/** \} dnnl_api_deconvolution
 <p>
 *  \addtogroup dnnl_api_shuffle
 *  \{
 <p>
 *  Initializes a descriptor for shuffle forward propagation primitive.
 * 
 *  @param shuffle_desc Output descriptor for a shuffle primitive.
 *  @param prop_kind Propagation kind. Possible values are
 *      #dnnl_forward_training and #dnnl_forward_inference.
 *  @param data_desc Source and destination memory descriptor.
 *  @param axis The axis along which the data is shuffled.
 *  @param group_size Shuffle group size.
 *  @return #dnnl_success on success and a status describing the error
 *      otherwise. */

///
public static native @Cast("dnnl_status_t") int dnnl_shuffle_forward_desc_init(
        dnnl_shuffle_desc_t shuffle_desc, @Cast("dnnl_prop_kind_t") int prop_kind,
        @Const dnnl_memory_desc_t data_desc, int axis, @Cast("dnnl_dim_t") long group_size);

/** Initializes a descriptor for shuffle backward propagation primitive.
 * 
 *  @param shuffle_desc Output descriptor for a shuffle primitive.
 *  @param diff_data_desc Diff source and diff destination memory descriptor.
 *  @param axis The axis along which the data is shuffled.
 *  @param group_size Shuffle group size.
 *  @return #dnnl_success on success and a status describing the error
 *      otherwise. */

///
public static native @Cast("dnnl_status_t") int dnnl_shuffle_backward_desc_init(
        dnnl_shuffle_desc_t shuffle_desc,
        @Const dnnl_memory_desc_t diff_data_desc, int axis,
        @Cast("dnnl_dim_t") long group_size);

/** \} dnnl_api_shuffle
 <p>
 *  \addtogroup dnnl_api_eltwise
 *  \{
 <p>
 *  Initializes a descriptor for eltwise forward propagation primitive.
 * 
 *  @param eltwise_desc Output descriptor for an eltwise primitive.
 *  @param prop_kind Propagation kind. Possible values are
 *      #dnnl_forward_training and #dnnl_forward_inference.
 *  @param alg_kind Elementwise algorithm kind.
 *  @param data_desc Source and destination memory descriptor.
 *  @param alpha The alpha parameter for the elementwise operation. Specific
 *      meaning depends on the algorithm.
 *  @param beta The beta parameter for the elementwise operation. Specific
 *      meaning depends on the algorithm.
 *  @return #dnnl_success on success and a status describing the error
 *      otherwise. */

///
public static native @Cast("dnnl_status_t") int dnnl_eltwise_forward_desc_init(
        dnnl_eltwise_desc_t eltwise_desc, @Cast("dnnl_prop_kind_t") int prop_kind,
        @Cast("dnnl_alg_kind_t") int alg_kind, @Const dnnl_memory_desc_t data_desc,
        float alpha, float beta);

/** Initializes a descriptor for eltwise backward propagation primitive.
 * 
 *  @param eltwise_desc Output descriptor for an eltwise primitive.
 *  @param alg_kind Elementwise algorithm kind.
 *  @param diff_data_desc Diff source and diff destination memory descriptors.
 *  @param data_desc Source and destination memory descriptor.
 *  @param alpha The alpha parameter for the elementwise operation. Specific
 *      meaning depends on the algorithm.
 *  @param beta The beta parameter for the elementwise operation. Specific
 *      meaning depends on the algorithm.
 *  @return #dnnl_success on success and a status describing the error
 *      otherwise. */

///
public static native @Cast("dnnl_status_t") int dnnl_eltwise_backward_desc_init(
        dnnl_eltwise_desc_t eltwise_desc, @Cast("dnnl_alg_kind_t") int alg_kind,
        @Const dnnl_memory_desc_t diff_data_desc,
        @Const dnnl_memory_desc_t data_desc, float alpha, float beta);

/** \} dnnl_api_eltwise
 <p>
 *  \addtogroup dnnl_api_softmax
 *  \{
 <p>
 *  Initializes a descriptor for softmax forward propagation primitive.
 * 
 *  @param softmax_desc Output descriptor for a softmax primitive.
 *  @param prop_kind Propagation kind. Possible values are
 *      #dnnl_forward_training and #dnnl_forward_inference.
 *  @param data_desc Source and destination memory descriptor.
 *  @param softmax_axis Axis over which softmax is computed.
 *  @return #dnnl_success on success and a status describing the error
 *      otherwise. */

///
public static native @Cast("dnnl_status_t") int dnnl_softmax_forward_desc_init(
        dnnl_softmax_desc_t softmax_desc, @Cast("dnnl_prop_kind_t") int prop_kind,
        @Const dnnl_memory_desc_t data_desc, int softmax_axis);

/** Initializes a descriptor for softmax backward propagation primitive.
 * 
 *  @param softmax_desc Output descriptor for a softmax primitive.
 *  @param diff_data_desc Diff source and diff destination memory descriptors.
 *  @param data_desc Destination memory descriptor.
 *  @param softmax_axis Axis over which softmax is computed.
 *  @return #dnnl_success on success and a status describing the error
 *      otherwise. */

///
public static native @Cast("dnnl_status_t") int dnnl_softmax_backward_desc_init(
        dnnl_softmax_desc_t softmax_desc,
        @Const dnnl_memory_desc_t diff_data_desc,
        @Const dnnl_memory_desc_t data_desc, int softmax_axis);

/** \} dnnl_api_softmax
 <p>
 *  \addtogroup dnnl_api_logsoftmax
 *  \{
 <p>
 *  Initializes a descriptor for logsoftmax forward propagation primitive.
 * 
 *  @param logsoftmax_desc Output descriptor for a logsoftmax primitive.
 *  @param prop_kind Propagation kind. Possible values are
 *      #dnnl_forward_training and #dnnl_forward_inference.
 *  @param data_desc Source and destination memory descriptor.
 *  @param logsoftmax_axis Axis over which logsoftmax is computed.
 *  @return #dnnl_success on success and a status describing the error
 *      otherwise. */

///
public static native @Cast("dnnl_status_t") int dnnl_logsoftmax_forward_desc_init(
        @Cast("dnnl_logsoftmax_desc_t*") dnnl_softmax_desc_t logsoftmax_desc, @Cast("dnnl_prop_kind_t") int prop_kind,
        @Const dnnl_memory_desc_t data_desc, int logsoftmax_axis);

/** Initializes a descriptor for logsoftmax backward propagation primitive.
 * 
 *  @param logsoftmax_desc Output descriptor for a logsoftmax primitive.
 *  @param diff_data_desc Diff source and diff destination memory descriptors.
 *  @param data_desc Destination memory descriptor.
 *  @param logsoftmax_axis Axis over which softmax is computed.
 *  @return #dnnl_success on success and a status describing the error
 *      otherwise. */

///
///
public static native @Cast("dnnl_status_t") int dnnl_logsoftmax_backward_desc_init(
        @Cast("dnnl_logsoftmax_desc_t*") dnnl_softmax_desc_t logsoftmax_desc,
        @Const dnnl_memory_desc_t diff_data_desc,
        @Const dnnl_memory_desc_t data_desc, int logsoftmax_axis);

/** \} dnnl_api_logsoftmax
 <p>
 *  \addtogroup dnnl_api_pooling
 *  \{
 <p>
 *  Initializes a descriptor for pooling forward propagation primitive.
 * 
 *  Arrays \p strides, \p kernel, \p padding_l, and \p padding_r contain values
 *  for spatial dimensions only and hence must have the same number of elements
 *  as there are spatial dimensions. The order of values is the same as in the
 *  tensor: depth (for 3D tensors), height (for 3D and 2D tensors), and width.
 * 
 *  @param pool_desc Output descriptor for a pooling primitive.
 *  @param prop_kind Propagation kind. Possible values are
 *      #dnnl_forward_training and #dnnl_forward_inference.
 *  @param alg_kind Pooling algorithm kind: either #dnnl_pooling_max,
 *      #dnnl_pooling_avg_include_padding, or #dnnl_pooling_avg (same as
 *      #dnnl_pooling_avg_exclude_padding).
 *  @param src_desc Source memory descriptor.
 *  @param dst_desc Destination memory descriptor.
 *  @param strides Array of strides for spatial dimension.
 *  @param kernel Array of kernel spatial dimensions.
 *  @param padding_l Array of padding values for low indices for each spatial
 *      dimension {@code ([[front,] top,] left)}.
 *  @param padding_r Array of padding values for high indices for each spatial
 *      dimension {@code ([[back,] bottom,] right)}. Can be NULL in which case
 *      padding is considered to be symmetrical.
 *  @return #dnnl_success on success and a status describing the error
 *      otherwise. */

///
///
public static native @Cast("dnnl_status_t") int dnnl_pooling_forward_desc_init(
        dnnl_pooling_desc_t pool_desc, @Cast("dnnl_prop_kind_t") int prop_kind,
        @Cast("dnnl_alg_kind_t") int alg_kind, @Const dnnl_memory_desc_t src_desc,
        @Const dnnl_memory_desc_t dst_desc, @Cast("const int64_t*") LongPointer strides,
        @Cast("const int64_t*") LongPointer kernel, @Cast("const int64_t*") LongPointer padding_l,
        @Cast("const int64_t*") LongPointer padding_r);
public static native @Cast("dnnl_status_t") int dnnl_pooling_forward_desc_init(
        dnnl_pooling_desc_t pool_desc, @Cast("dnnl_prop_kind_t") int prop_kind,
        @Cast("dnnl_alg_kind_t") int alg_kind, @Const dnnl_memory_desc_t src_desc,
        @Const dnnl_memory_desc_t dst_desc, @Cast("const int64_t*") LongBuffer strides,
        @Cast("const int64_t*") LongBuffer kernel, @Cast("const int64_t*") LongBuffer padding_l,
        @Cast("const int64_t*") LongBuffer padding_r);
public static native @Cast("dnnl_status_t") int dnnl_pooling_forward_desc_init(
        dnnl_pooling_desc_t pool_desc, @Cast("dnnl_prop_kind_t") int prop_kind,
        @Cast("dnnl_alg_kind_t") int alg_kind, @Const dnnl_memory_desc_t src_desc,
        @Const dnnl_memory_desc_t dst_desc, @Cast("const int64_t*") long[] strides,
        @Cast("const int64_t*") long[] kernel, @Cast("const int64_t*") long[] padding_l,
        @Cast("const int64_t*") long[] padding_r);

/** Initializes a descriptor for pooling backward propagation primitive.
 * 
 *  Arrays \p strides, \p kernel, \p padding_l, and \p padding_r contain values
 *  for spatial dimensions only and hence must have the same number of elements
 *  as there are spatial dimensions. The order of values is the same as in the
 *  tensor: depth (for 3D tensors), height (for 3D and 2D tensors), and width.
 * 
 *  @param pool_desc Output descriptor for a pooling primitive.
 *  @param alg_kind Pooling algorithm kind: either #dnnl_pooling_max,
 *      #dnnl_pooling_avg_include_padding, or #dnnl_pooling_avg (same as
 *      #dnnl_pooling_avg_exclude_padding).
 *  @param diff_src_desc Diff source memory descriptor.
 *  @param diff_dst_desc Diff destination memory descriptor.
 *  @param strides Array of strides for spatial dimension.
 *  @param kernel Array of kernel spatial dimensions.
 *  @param padding_l Array of padding values for low indices for each spatial
 *      dimension {@code ([[front,] top,] left)}.
 *  @param padding_r Array of padding values for high indices for each spatial
 *      dimension {@code ([[back,] bottom,] right)}. Can be NULL in which case
 *      padding is considered to be symmetrical.
 *  @return #dnnl_success on success and a status describing the error
 *      otherwise. */

///
///
public static native @Cast("dnnl_status_t") int dnnl_pooling_backward_desc_init(
        dnnl_pooling_desc_t pool_desc, @Cast("dnnl_alg_kind_t") int alg_kind,
        @Const dnnl_memory_desc_t diff_src_desc,
        @Const dnnl_memory_desc_t diff_dst_desc, @Cast("const int64_t*") LongPointer strides,
        @Cast("const int64_t*") LongPointer kernel, @Cast("const int64_t*") LongPointer padding_l,
        @Cast("const int64_t*") LongPointer padding_r);
public static native @Cast("dnnl_status_t") int dnnl_pooling_backward_desc_init(
        dnnl_pooling_desc_t pool_desc, @Cast("dnnl_alg_kind_t") int alg_kind,
        @Const dnnl_memory_desc_t diff_src_desc,
        @Const dnnl_memory_desc_t diff_dst_desc, @Cast("const int64_t*") LongBuffer strides,
        @Cast("const int64_t*") LongBuffer kernel, @Cast("const int64_t*") LongBuffer padding_l,
        @Cast("const int64_t*") LongBuffer padding_r);
public static native @Cast("dnnl_status_t") int dnnl_pooling_backward_desc_init(
        dnnl_pooling_desc_t pool_desc, @Cast("dnnl_alg_kind_t") int alg_kind,
        @Const dnnl_memory_desc_t diff_src_desc,
        @Const dnnl_memory_desc_t diff_dst_desc, @Cast("const int64_t*") long[] strides,
        @Cast("const int64_t*") long[] kernel, @Cast("const int64_t*") long[] padding_l,
        @Cast("const int64_t*") long[] padding_r);

/** \} dnnl_api_pooling
 <p>
 *  \addtogroup dnnl_api_pooling_v2
 *  \{
 <p>
 *  Initializes a descriptor for pooling v2 (pooling with dilation support)
 *  forward propagation primitive.
 * 
 *  Arrays \p strides, \p kernel, \p dilation, \p padding_l and \p padding_r
 *  contain values for spatial dimensions only and hence must have the same
 *  number of elements as there are spatial dimensions. The order of values
 *  is the same as in the tensor: depth (for 3D tensors),
 *  height (for 3D and 2D tensors), and width.
 * 
 *  @param pool_desc Output descriptor for a pooling primitive.
 *  @param prop_kind Propagation kind. Possible values are
 *      #dnnl_forward_training and #dnnl_forward_inference.
 *  @param alg_kind Pooling algorithm kind: either #dnnl_pooling_max,
 *      #dnnl_pooling_avg_include_padding, or #dnnl_pooling_avg (same as
 *      #dnnl_pooling_avg_exclude_padding).
 *  @param src_desc Source memory descriptor.
 *  @param dst_desc Destination memory descriptor.
 *  @param strides Array of strides for spatial dimension.
 *  @param kernel Array of kernel spatial dimensions.
 *  @param dilation Array of dilations for spatial dimension.
 *  @param padding_l Array of padding values for low indices for each spatial
 *      dimension {@code ([[front,] top,] left)}.
 *  @param padding_r Array of padding values for high indices for each spatial
 *      dimension {@code ([[back,] bottom,] right)}. Can be NULL in which case
 *      padding is considered to be symmetrical.
 *  @return #dnnl_success on success and a status describing the error
 *      otherwise. */

///
///
public static native @Cast("dnnl_status_t") int dnnl_pooling_v2_forward_desc_init(
        dnnl_pooling_v2_desc_t pool_desc, @Cast("dnnl_prop_kind_t") int prop_kind,
        @Cast("dnnl_alg_kind_t") int alg_kind, @Const dnnl_memory_desc_t src_desc,
        @Const dnnl_memory_desc_t dst_desc, @Cast("const int64_t*") LongPointer strides,
        @Cast("const int64_t*") LongPointer kernel, @Cast("const int64_t*") LongPointer dilation,
        @Cast("const int64_t*") LongPointer padding_l, @Cast("const int64_t*") LongPointer padding_r);
public static native @Cast("dnnl_status_t") int dnnl_pooling_v2_forward_desc_init(
        dnnl_pooling_v2_desc_t pool_desc, @Cast("dnnl_prop_kind_t") int prop_kind,
        @Cast("dnnl_alg_kind_t") int alg_kind, @Const dnnl_memory_desc_t src_desc,
        @Const dnnl_memory_desc_t dst_desc, @Cast("const int64_t*") LongBuffer strides,
        @Cast("const int64_t*") LongBuffer kernel, @Cast("const int64_t*") LongBuffer dilation,
        @Cast("const int64_t*") LongBuffer padding_l, @Cast("const int64_t*") LongBuffer padding_r);
public static native @Cast("dnnl_status_t") int dnnl_pooling_v2_forward_desc_init(
        dnnl_pooling_v2_desc_t pool_desc, @Cast("dnnl_prop_kind_t") int prop_kind,
        @Cast("dnnl_alg_kind_t") int alg_kind, @Const dnnl_memory_desc_t src_desc,
        @Const dnnl_memory_desc_t dst_desc, @Cast("const int64_t*") long[] strides,
        @Cast("const int64_t*") long[] kernel, @Cast("const int64_t*") long[] dilation,
        @Cast("const int64_t*") long[] padding_l, @Cast("const int64_t*") long[] padding_r);

/** Initializes a descriptor for pooling v2 (pooling with dilation support)
 *  backward propagation primitive.
 * 
 *  Arrays \p strides, \p kernel, \p dilation, \p padding_l and \p padding_r
 *  contain values for spatial dimensions only and hence must have the same
 *  number of elements as there are spatial dimensions. The order of values
 *  is the same as in the tensor: depth (for 3D tensors),
 *  height (for 3D and 2D tensors), and width.
 * 
 *  @param pool_desc Output descriptor for a pooling primitive.
 *  @param alg_kind Pooling algorithm kind: either #dnnl_pooling_max,
 *      #dnnl_pooling_avg_include_padding, or #dnnl_pooling_avg (same as
 *      #dnnl_pooling_avg_exclude_padding).
 *  @param diff_src_desc Diff source memory descriptor.
 *  @param diff_dst_desc Diff destination memory descriptor.
 *  @param strides Array of strides for spatial dimension.
 *  @param kernel Array of kernel spatial dimensions.
 *  @param dilation Array of dilations for spatial dimension.
 *  @param padding_l Array of padding values for low indices for each spatial
 *      dimension {@code ([[front,] top,] left)}.
 *  @param padding_r Array of padding values for high indices for each spatial
 *      dimension {@code ([[back,] bottom,] right)}. Can be NULL in which case
 *      padding is considered to be symmetrical.
 *  @return #dnnl_success on success and a status describing the error
 *      otherwise. */

///
///
public static native @Cast("dnnl_status_t") int dnnl_pooling_v2_backward_desc_init(
        dnnl_pooling_v2_desc_t pool_desc, @Cast("dnnl_alg_kind_t") int alg_kind,
        @Const dnnl_memory_desc_t diff_src_desc,
        @Const dnnl_memory_desc_t diff_dst_desc, @Cast("const int64_t*") LongPointer strides,
        @Cast("const int64_t*") LongPointer kernel, @Cast("const int64_t*") LongPointer dilation,
        @Cast("const int64_t*") LongPointer padding_l, @Cast("const int64_t*") LongPointer padding_r);
public static native @Cast("dnnl_status_t") int dnnl_pooling_v2_backward_desc_init(
        dnnl_pooling_v2_desc_t pool_desc, @Cast("dnnl_alg_kind_t") int alg_kind,
        @Const dnnl_memory_desc_t diff_src_desc,
        @Const dnnl_memory_desc_t diff_dst_desc, @Cast("const int64_t*") LongBuffer strides,
        @Cast("const int64_t*") LongBuffer kernel, @Cast("const int64_t*") LongBuffer dilation,
        @Cast("const int64_t*") LongBuffer padding_l, @Cast("const int64_t*") LongBuffer padding_r);
public static native @Cast("dnnl_status_t") int dnnl_pooling_v2_backward_desc_init(
        dnnl_pooling_v2_desc_t pool_desc, @Cast("dnnl_alg_kind_t") int alg_kind,
        @Const dnnl_memory_desc_t diff_src_desc,
        @Const dnnl_memory_desc_t diff_dst_desc, @Cast("const int64_t*") long[] strides,
        @Cast("const int64_t*") long[] kernel, @Cast("const int64_t*") long[] dilation,
        @Cast("const int64_t*") long[] padding_l, @Cast("const int64_t*") long[] padding_r);

/** \} dnnl_api_pooling_v2
 <p>
 *  \addtogroup dnnl_api_prelu
 *  \{
 <p>
 *  Initializes a descriptor for PReLU
 *  (leaky ReLU with trainable alpha parameter)
 *  forward propagation primitive.
 * 
 *  \note
 *      weights descriptor is allowed to be initialized with
 *      #dnnl_format_tag_any or with format_kind set to #dnnl_format_kind_any.
 * 
 *  @param prelu_desc Output descriptor for a prelu primitive.
 *  @param prop_kind Propagation kind. Possible values are
 *      #dnnl_forward_training and #dnnl_forward_inference.
 *  @param data_desc Source and destination memory descriptor.
 *  @param weights_desc Alpha parameters memory descriptor.
 *  @return #dnnl_success on success and a status describing the error
 *      otherwise. */

///
///
public static native @Cast("dnnl_status_t") int dnnl_prelu_forward_desc_init(
        dnnl_prelu_desc_t prelu_desc, @Cast("dnnl_prop_kind_t") int prop_kind,
        @Const dnnl_memory_desc_t data_desc,
        @Const dnnl_memory_desc_t weights_desc);

/** Initializes a descriptor for PReLU
 *  (leaky ReLU with trainable alpha parameter)
 *  backward propagation primitive.
 * 
 *  \note
 *      weights descriptor and diff_weights descriptor are allowed
 *      to be initialized with #dnnl_format_tag_any or with format_kind
 *      set to #dnnl_format_kind_any.
 * 
 *  @param prelu_desc Output descriptor for a prelu primitive.
 *  @param data_desc Source and destination memory descriptor.
 *  @param weights_desc Alpha parameters memory descriptor.
 *  @param diff_data_desc Diff source and destination memory descriptor.
 *  @param diff_weights_desc Diff alpha parameters memory descriptor.
 *  @return #dnnl_success on success and a status describing the error
 *      otherwise. */

///
public static native @Cast("dnnl_status_t") int dnnl_prelu_backward_desc_init(
        dnnl_prelu_desc_t prelu_desc, @Const dnnl_memory_desc_t data_desc,
        @Const dnnl_memory_desc_t weights_desc,
        @Const dnnl_memory_desc_t diff_data_desc,
        @Const dnnl_memory_desc_t diff_weights_desc);

/** \} dnnl_api_prelu
 <p>
 *  \addtogroup dnnl_api_lrn
 *  \{
 <p>
 *  Initializes a descriptor for LRN forward propagation primitive.
 * 
 *  @param lrn_desc Output descriptor for a LRN primitive.
 *  @param prop_kind Propagation kind. Possible values are
 *      #dnnl_forward_training and #dnnl_forward_inference.
 *  @param alg_kind LRN algorithm kind: either #dnnl_lrn_across_channels or
 *      #dnnl_lrn_within_channel.
 *  @param data_desc Source and destination memory descriptor.
 *  @param local_size Regularization local size.
 *  @param alpha The alpha regularization parameter.
 *  @param beta The beta regularization parameter.
 *  @param k The k regularization parameter.
 *  @return #dnnl_success on success and a status describing the error
 *      otherwise. */

///
public static native @Cast("dnnl_status_t") int dnnl_lrn_forward_desc_init(dnnl_lrn_desc_t lrn_desc,
        @Cast("dnnl_prop_kind_t") int prop_kind, @Cast("dnnl_alg_kind_t") int alg_kind,
        @Const dnnl_memory_desc_t data_desc, @Cast("dnnl_dim_t") long local_size, float alpha,
        float beta, float k);

/** Initializes a descriptor for LRN backward propagation primitive.
 * 
 *  @param lrn_desc Output descriptor for a LRN primitive.
 *  @param alg_kind LRN algorithm kind: either #dnnl_lrn_across_channels or
 *      #dnnl_lrn_within_channel.
 *  @param diff_data_desc Diff source and diff destination memory descriptor.
 *  @param data_desc Source memory descriptor.
 *  @param local_size Regularization local size.
 *  @param alpha The alpha regularization parameter.
 *  @param beta The beta regularization parameter.
 *  @param k The k regularization parameter.
 *  @return #dnnl_success on success and a status describing the error
 *      otherwise. */

///
///
public static native @Cast("dnnl_status_t") int dnnl_lrn_backward_desc_init(dnnl_lrn_desc_t lrn_desc,
        @Cast("dnnl_alg_kind_t") int alg_kind, @Const dnnl_memory_desc_t diff_data_desc,
        @Const dnnl_memory_desc_t data_desc, @Cast("dnnl_dim_t") long local_size, float alpha,
        float beta, float k);

/** \} dnnl_api_lrn
 <p>
 *  \addtogroup dnnl_api_batch_normalization
 *  \{
 <p>
 *  Initializes a descriptor for a batch normalization forward propagation
 *  primitive.
 * 
 *  \note
 *      In-place operation is supported: the dst can refer to the same memory
 *      as the src.
 * 
 *  @param bnrm_desc Output descriptor for batch normalization primitive.
 *  @param prop_kind Propagation kind. Possible values are
 *      #dnnl_forward_training and #dnnl_forward_inference.
 *  @param data_desc Source and destination memory descriptor.
 *  @param epsilon Batch normalization epsilon parameter.
 *  @param flags Batch normalization flags (\ref dnnl_normalization_flags_t).
 *  @return #dnnl_success on success and a status describing the error
 *      otherwise. */

///
///
public static native @Cast("dnnl_status_t") int dnnl_batch_normalization_forward_desc_init(
        dnnl_batch_normalization_desc_t bnrm_desc, @Cast("dnnl_prop_kind_t") int prop_kind,
        @Const dnnl_memory_desc_t data_desc, float epsilon, @Cast("unsigned") int flags);

/** Initializes a descriptor for a batch normalization backward propagation
 *  primitive.
 * 
 *  \note
 *      In-place operation is supported: the diff_dst can refer to the same
 *      memory as the diff_src.
 * 
 *  @param bnrm_desc Output descriptor for batch normalization primitive.
 *  @param prop_kind Propagation kind. Possible values are
 *      #dnnl_backward_data and #dnnl_backward (diffs for all parameters are
 *      computed in this case).
 *  @param diff_data_desc Diff source and diff destination memory descriptor.
 *  @param data_desc Source memory descriptor.
 *  @param epsilon Batch normalization epsilon parameter.
 *  @param flags Batch normalization flags (\ref dnnl_normalization_flags_t).
 *  @return #dnnl_success on success and a status describing the error
 *      otherwise. */

///
///
public static native @Cast("dnnl_status_t") int dnnl_batch_normalization_backward_desc_init(
        dnnl_batch_normalization_desc_t bnrm_desc, @Cast("dnnl_prop_kind_t") int prop_kind,
        @Const dnnl_memory_desc_t diff_data_desc,
        @Const dnnl_memory_desc_t data_desc, float epsilon, @Cast("unsigned") int flags);

/** \} dnnl_api_batch_normalization
 <p>
 *  \addtogroup dnnl_api_layer_normalization
 *  \{
 <p>
 *  Initializes a descriptor for layer normalization forward propagation
 *  primitive.
 * 
 *  \note
 *      In-place operation is supported: the dst can refer to the same memory
 *      as the src.
 * 
 *  @param lnrm_desc Output descriptor for layer normalization primitive.
 *  @param prop_kind Propagation kind. Possible values are
 *      #dnnl_forward_training and #dnnl_forward_inference.
 *  @param data_desc Source and destination memory descriptor.
 *  @param stat_desc Memory descriptor for mean and variance. If this
 *      parameter is NULL, a zero memory descriptor, or a memory descriptor
 *      with format_kind set to #dnnl_format_kind_undef, then the memory
 *      descriptor for stats is derived from \p data_desc by removing the last
 *      dimension.
 *  @param epsilon Layer normalization epsilon parameter.
 *  @param flags Layer normalization flags (\ref dnnl_normalization_flags_t).
 *  @return #dnnl_success on success and a status describing the error
 *      otherwise. */

///
///
public static native @Cast("dnnl_status_t") int dnnl_layer_normalization_forward_desc_init(
        dnnl_layer_normalization_desc_t lnrm_desc, @Cast("dnnl_prop_kind_t") int prop_kind,
        @Const dnnl_memory_desc_t data_desc,
        @Const dnnl_memory_desc_t stat_desc, float epsilon, @Cast("unsigned") int flags);

/** Initializes a descriptor for a layer normalization backward propagation
 *  primitive.
 * 
 *  \note
 *      In-place operation is supported: the diff_dst can refer to the same
 *      memory as the diff_src.
 * 
 *  @param lnrm_desc Output descriptor for layer normalization primitive.
 *  @param prop_kind Propagation kind. Possible values are
 *      #dnnl_backward_data and #dnnl_backward (diffs for all parameters are
 *      computed in this case).
 *  @param diff_data_desc Diff source and diff destination memory descriptor.
 *  @param data_desc Source memory descriptor.
 *  @param stat_desc Memory descriptor for mean and variance. If this
 *      parameter is NULL, a zero memory descriptor, or a memory descriptor
 *      with format_kind set to #dnnl_format_kind_undef, then the memory
 *      descriptor for stats is derived from \p data_desc by removing the last
 *      dimension.
 *  @param epsilon Layer normalization epsilon parameter.
 *  @param flags Layer normalization flags (\ref dnnl_normalization_flags_t).
 *  @return #dnnl_success on success and a status describing the error
 *      otherwise. */

///
///
public static native @Cast("dnnl_status_t") int dnnl_layer_normalization_backward_desc_init(
        dnnl_layer_normalization_desc_t lnrm_desc, @Cast("dnnl_prop_kind_t") int prop_kind,
        @Const dnnl_memory_desc_t diff_data_desc,
        @Const dnnl_memory_desc_t data_desc,
        @Const dnnl_memory_desc_t stat_desc, float epsilon, @Cast("unsigned") int flags);

/** \} dnnl_api_layer_normalization
 <p>
 *  \addtogroup dnnl_api_inner_product
 *  \{
 <p>
 *  Initializes descriptor for inner product forward propagation.
 * 
 *  \note
 *      Memory descriptors can be initialized with
 *      #dnnl_format_tag_any or with format_kind set to #dnnl_format_kind_any.
 * 
 *  @param ip_desc Output descriptor for inner product primitive.
 *  @param prop_kind Propagation kind. Possible values are
 *      #dnnl_forward_training and #dnnl_forward_inference.
 *  @param src_desc Source memory descriptor.
 *  @param weights_desc Weights memory descriptor.
 *  @param bias_desc Bias memory descriptor. Passing NULL, a zero memory
 *      descriptor, or a memory descriptor with format_kind set to
 *      #dnnl_format_kind_undef disables the bias term.
 *  @param dst_desc Destination memory descriptor.
 *  @return #dnnl_success on success and a status describing the error
 *      otherwise. */

///
///
public static native @Cast("dnnl_status_t") int dnnl_inner_product_forward_desc_init(
        dnnl_inner_product_desc_t ip_desc, @Cast("dnnl_prop_kind_t") int prop_kind,
        @Const dnnl_memory_desc_t src_desc,
        @Const dnnl_memory_desc_t weights_desc,
        @Const dnnl_memory_desc_t bias_desc,
        @Const dnnl_memory_desc_t dst_desc);

/** Initializes descriptor for inner product backward propagation.
 * 
 *  \note
 *      Memory descriptors can be initialized with
 *      #dnnl_format_tag_any or with format_kind set to #dnnl_format_kind_any.
 * 
 *  @param ip_desc Output descriptor for inner product primitive.
 *  @param diff_src_desc Diff source memory descriptor.
 *  @param weights_desc Weights memory descriptor.
 *  @param diff_dst_desc Diff destination memory descriptor.
 *  @return #dnnl_success on success and a status describing the error
 *      otherwise. */

///
///
public static native @Cast("dnnl_status_t") int dnnl_inner_product_backward_data_desc_init(
        dnnl_inner_product_desc_t ip_desc,
        @Const dnnl_memory_desc_t diff_src_desc,
        @Const dnnl_memory_desc_t weights_desc,
        @Const dnnl_memory_desc_t diff_dst_desc);

/** Initializes descriptor for inner product weights gradient primitive.
 * 
 *  \note
 *      Memory descriptors can be initialized with
 *      #dnnl_format_tag_any or with format_kind set to #dnnl_format_kind_any.
 * 
 *  @param ip_desc Output descriptor for inner product primitive.
 *  @param src_desc Source memory descriptor.
 *  @param diff_weights_desc Diff weights memory descriptor.
 *  @param diff_bias_desc Diff bias memory descriptor. Passing NULL, a zero
 *      memory descriptor, or a memory descriptor with format_kind set to
 *      #dnnl_format_kind_undef disables the bias term.
 *  @param diff_dst_desc Diff destination memory descriptor.
 *  @return #dnnl_success on success and a status describing the error
 *      otherwise. */

///
///
///
///
///
///
///
///
public static native @Cast("dnnl_status_t") int dnnl_inner_product_backward_weights_desc_init(
        dnnl_inner_product_desc_t ip_desc, @Const dnnl_memory_desc_t src_desc,
        @Const dnnl_memory_desc_t diff_weights_desc,
        @Const dnnl_memory_desc_t diff_bias_desc,
        @Const dnnl_memory_desc_t diff_dst_desc);

/** \} dnnl_api_inner_product
 <p>
 *  \addtogroup dnnl_api_attributes
 *  \{
 <p>
 *  Set quantization scale and shift parameters for RNN data tensors.
 * 
 *  For performance reasons, the low-precision configuration of the RNN
 *  primitives expects input activations to have the unsigned 8-bit integer
 *  data type. The scale and shift parameters are used to quantize
 *  floating-point data to unsigned integer and must be passed to the RNN
 *  primitive using attributes.
 * 
 *  The quantization formula is {@code scale * data + shift}.
 * 
 *  \note
 *      Quantization scale and shift are common for src_layer, src_iter,
 *      dst_iter, and dst_layer.
 * 
 *  Example usage:
 *  <pre>{@code
 *      // RNN parameters
 *      int l = 2, t = 2, mb = 32, sic = 32, slc = 32, dic = 32, dlc = 32;
 *      // Activations quantization parameters
 *      float scale = 63.f, shift = 64.f;
 * 
 *      dnnl_primitive_attr_t rnn_attr;
 *      // Create default attributes
 *      dnnl_primitive_attr_create(&rnn_attr);
 * 
 *      // Set scale and shift for int8 quantization of activation
 *      dnnl_primitive_attr_set_rnn_data_qparams(rnn_attr, scale, shift);
 * 
 *      // Create and configure rnn op_desc
 *      dnnl_rnn_desc_t rnn_d;
 *      dnnl_primitive_desc_t rnn_pd;
 *      dnnl_primitive_desc_create(&rnn_pd, &rnn_d, attr, engine, NULL);
 *  }</pre>
 * 
 *  @param attr Primitive attributes.
 *  @param scale The value to scale the data by.
 *  @param shift The value to shift the data by.
 *  @return #dnnl_success on success and a status describing the error
 *      otherwise. */

///
///
public static native @Cast("dnnl_status_t") int dnnl_primitive_attr_set_rnn_data_qparams(
        dnnl_primitive_attr attr, float scale, float shift);

/** Returns the quantization scale and shift parameters for RNN data tensors.
 * 
 *  \note
 *      Quantization scale and shift are common for src_layer, src_iter,
 *      dst_iter, and dst_layer.
 * 
 *  @param attr Primitive attributes.
 *  @param scale The value to scale the data by.
 *  @param shift The value to shift the data by.
 *  @return #dnnl_success on success and a status describing the error
 *      otherwise. */

///
///
///
public static native @Cast("dnnl_status_t") int dnnl_primitive_attr_get_rnn_data_qparams(
        @Const dnnl_primitive_attr attr, FloatPointer scale, FloatPointer shift);
public static native @Cast("dnnl_status_t") int dnnl_primitive_attr_get_rnn_data_qparams(
        @Const dnnl_primitive_attr attr, FloatBuffer scale, FloatBuffer shift);
public static native @Cast("dnnl_status_t") int dnnl_primitive_attr_get_rnn_data_qparams(
        @Const dnnl_primitive_attr attr, float[] scale, float[] shift);

/** Sets quantization scaling factors for RNN weights tensors. The
 *  low-precision configuration of the RNN primitives expects input weights to
 *  use the signed 8-bit integer data type. The scaling factors are used to
 *  quantize floating-point data to signed integer and must be passed to RNN
 *  primitives using attributes.
 * 
 *  \note
 *      The dimension order is always native and does not depend on the actual
 *      layout used. For example, five-dimensional weights always have (l, d,
 *      i, g, o) logical dimension ordering.
 * 
 *  \note
 *      Quantization scales are common for weights_layer and weights_iteration
 * 
 *  @param attr Primitive attributes.
 *  @param count Number of elements in the \p scales array.
 *  @param mask Scaling factors correspondence mask that defines the
 *      correspondence between the output tensor dimensions and the \p
 *      scales vector. The set i-th bit indicates that a dedicated scaling
 *      factor should be used for each index along that dimension. Set the
 *      mask to 0 to use a common scaling factor for the whole output
 *      tensor.
 *  @param scales Array of output scaling factors that must contain \p count
 *      values and the following equality must hold:
 *      <pre>{@code \[count = \prod\limits_{d \in mask} weights.dims[d].\]}</pre>
 *      Violations can only be detected when the attributes are used to create
 *      a primitive descriptor.
 *  @return #dnnl_success on success and a status describing the error
 *      otherwise. */

///
public static native @Cast("dnnl_status_t") int dnnl_primitive_attr_set_rnn_weights_qparams(
        dnnl_primitive_attr attr, @Cast("dnnl_dim_t") long count, int mask,
        @Const FloatPointer scales);
public static native @Cast("dnnl_status_t") int dnnl_primitive_attr_set_rnn_weights_qparams(
        dnnl_primitive_attr attr, @Cast("dnnl_dim_t") long count, int mask,
        @Const FloatBuffer scales);
public static native @Cast("dnnl_status_t") int dnnl_primitive_attr_set_rnn_weights_qparams(
        dnnl_primitive_attr attr, @Cast("dnnl_dim_t") long count, int mask,
        @Const float[] scales);

/** Returns the quantization scaling factors for RNN weights tensors.
 * 
 *  @param attr Primitive attributes.
 *  @param count Number of elements in the \p scales array.
 *  @param mask Scaling factors correspondence mask that defines the
 *      correspondence between the output tensor dimensions and the \p
 *      scales vector. The set i-th bit indicates that a dedicated scaling
 *      factor should be used for each index along that dimension. Set the
 *      mask to 0 to use a common scaling factor for the whole output
 *      tensor.
 *  @param scales Array of output scaling factors that contain \p count
 *      values and the following equality must hold:
 *      <pre>{@code \[count = \prod\limits_{d \in mask} weights.dims[d].\]}</pre>
 *  @return #dnnl_success on success and a status describing the error
 *      otherwise. */

///
///
public static native @Cast("dnnl_status_t") int dnnl_primitive_attr_get_rnn_weights_qparams(
        @Const dnnl_primitive_attr attr, @Cast("dnnl_dim_t*") LongPointer count, IntPointer mask,
        @Cast("const float**") PointerPointer scales);
public static native @Cast("dnnl_status_t") int dnnl_primitive_attr_get_rnn_weights_qparams(
        @Const dnnl_primitive_attr attr, @Cast("dnnl_dim_t*") LongPointer count, IntPointer mask,
        @Const @ByPtrPtr FloatPointer scales);
public static native @Cast("dnnl_status_t") int dnnl_primitive_attr_get_rnn_weights_qparams(
        @Const dnnl_primitive_attr attr, @Cast("dnnl_dim_t*") LongBuffer count, IntBuffer mask,
        @Const @ByPtrPtr FloatBuffer scales);
public static native @Cast("dnnl_status_t") int dnnl_primitive_attr_get_rnn_weights_qparams(
        @Const dnnl_primitive_attr attr, @Cast("dnnl_dim_t*") long[] count, int[] mask,
        @Const @ByPtrPtr float[] scales);

/** Sets quantization scaling factors for RNN projection weights tensors. The
 *  low-precision configuration of the RNN primitives expects input weights to
 *  use the signed 8-bit integer data type. The scaling factors are used to
 *  quantize floating-point data to signed integer and must be passed to RNN
 *  primitives using attributes.
 * 
 *  \note
 *      The dimension order is always native and does not depend on the actual
 *      layout used. For example, five-dimensional weights always have (l, d,
 *      i, g, o) logical dimension ordering.
 * 
 *  @param attr Primitive attributes.
 *  @param count Number of elements in the \p scales array.
 *  @param mask Scaling factors correspondence mask that defines the
 *      correspondence between the output tensor dimensions and the \p
 *      scales vector. The set i-th bit indicates that a dedicated scaling
 *      factor should be used for each index along that dimension. Set the
 *      mask to 0 to use a common scaling factor for the whole output
 *      tensor.
 *  @param scales Array of output scaling factors that must contain \p count
 *      values and the following equality must hold:
 *      <pre>{@code \[count = \prod\limits_{d \in mask} weights.dims[d].\]}</pre>
 *      Violations can only be detected when the attributes are used to create
 *      a primitive descriptor.
 *  @return #dnnl_success on success and a status describing the error
 *      otherwise. */

///
public static native @Cast("dnnl_status_t") int dnnl_primitive_attr_set_rnn_weights_projection_qparams(
        dnnl_primitive_attr attr, @Cast("dnnl_dim_t") long count, int mask,
        @Const FloatPointer scales);
public static native @Cast("dnnl_status_t") int dnnl_primitive_attr_set_rnn_weights_projection_qparams(
        dnnl_primitive_attr attr, @Cast("dnnl_dim_t") long count, int mask,
        @Const FloatBuffer scales);
public static native @Cast("dnnl_status_t") int dnnl_primitive_attr_set_rnn_weights_projection_qparams(
        dnnl_primitive_attr attr, @Cast("dnnl_dim_t") long count, int mask,
        @Const float[] scales);

/** Returns the quantization scaling factors for RNN projection weights tensors.
 * 
 *  @param attr Primitive attributes.
 *  @param count Number of elements in the \p scales array.
 *  @param mask Scaling factors correspondence mask that defines the
 *      correspondence between the output tensor dimensions and the \p
 *      scales vector. The set i-th bit indicates that a dedicated scaling
 *      factor should be used for each index along that dimension. Set the
 *      mask to 0 to use a common scaling factor for the whole output
 *      tensor.
 *  @param scales Array of output scaling factors that contain \p count
 *      values and the following equality must hold:
 *      <pre>{@code \[count = \prod\limits_{d \in mask} weights.dims[d].\]}</pre>
 *  @return #dnnl_success on success and a status describing the error
 *      otherwise. */

///
///
///
///
public static native @Cast("dnnl_status_t") int dnnl_primitive_attr_get_rnn_weights_projection_qparams(
        @Const dnnl_primitive_attr attr, @Cast("dnnl_dim_t*") LongPointer count, IntPointer mask,
        @Cast("const float**") PointerPointer scales);
public static native @Cast("dnnl_status_t") int dnnl_primitive_attr_get_rnn_weights_projection_qparams(
        @Const dnnl_primitive_attr attr, @Cast("dnnl_dim_t*") LongPointer count, IntPointer mask,
        @Const @ByPtrPtr FloatPointer scales);
public static native @Cast("dnnl_status_t") int dnnl_primitive_attr_get_rnn_weights_projection_qparams(
        @Const dnnl_primitive_attr attr, @Cast("dnnl_dim_t*") LongBuffer count, IntBuffer mask,
        @Const @ByPtrPtr FloatBuffer scales);
public static native @Cast("dnnl_status_t") int dnnl_primitive_attr_get_rnn_weights_projection_qparams(
        @Const dnnl_primitive_attr attr, @Cast("dnnl_dim_t*") long[] count, int[] mask,
        @Const @ByPtrPtr float[] scales);

/** \} dnnl_api_attributes
 <p>
 *  \addtogroup dnnl_api_rnn
 *  \{
 <p>
 *  Initializes a descriptor for vanilla RNN forward propagation primitive.
 * 
 *  The following arguments may either be \c NULL or point to a zero memory
 *  descriptor:
 *  - \p src_iter_desc,
 *  - \p bias_desc,
 *  - \p dst_iter_desc.
 * 
 *  This would then indicate that the RNN forward propagation primitive should
 *  not use them and should default to zero values instead.
 * 
 *  \note
 *      All memory descriptors can be initialized with
 *      #dnnl_format_tag_any or with format_kind set to #dnnl_format_kind_any.
 * 
 *  @param rnn_desc Output descriptor for vanilla RNN primitive.
 *  @param prop_kind Propagation kind. Possible values are
 *      #dnnl_forward_training and #dnnl_forward_inference.
 *  @param activation Activation kind. Possible values are #dnnl_eltwise_relu,
 *      #dnnl_eltwise_tanh or #dnnl_eltwise_logistic.
 *  @param direction RNN direction. See \ref dnnl_rnn_direction_t for more
 *      info.
 *  @param src_layer_desc Memory descriptor for the input vector.
 *  @param src_iter_desc Memory descriptor for the input recurrent hidden
 *      state vector.
 *  @param weights_layer_desc Memory descriptor for the weights applied to the
 *      layer input.
 *  @param weights_iter_desc Memory descriptor for the weights applied to the
 *      recurrent input.
 *  @param bias_desc Bias memory descriptor.
 *  @param dst_layer_desc Memory descriptor for the output vector.
 *  @param dst_iter_desc Memory descriptor for the output recurrent hidden
 *      state vector.
 *  @param flags Unused.
 *  @param alpha Negative slope if activation is #dnnl_eltwise_relu.
 *  @param beta Unused.
 *  @return #dnnl_success on success and a status describing the error
 *      otherwise. */

///
///
///
///
public static native @Cast("dnnl_status_t") int dnnl_vanilla_rnn_forward_desc_init(
        dnnl_rnn_desc_t rnn_desc, @Cast("dnnl_prop_kind_t") int prop_kind,
        @Cast("const dnnl_alg_kind_t") int activation, @Cast("const dnnl_rnn_direction_t") int direction,
        @Const dnnl_memory_desc_t src_layer_desc,
        @Const dnnl_memory_desc_t src_iter_desc,
        @Const dnnl_memory_desc_t weights_layer_desc,
        @Const dnnl_memory_desc_t weights_iter_desc,
        @Const dnnl_memory_desc_t bias_desc,
        @Const dnnl_memory_desc_t dst_layer_desc,
        @Const dnnl_memory_desc_t dst_iter_desc, @Cast("unsigned") int flags, float alpha,
        float beta);

/** Initializes a descriptor for vanilla RNN backward propagation primitive.
 * 
 *  The following arguments may either be \c NULL or point to a zero memory
 *  descriptor:
 *  - \p src_iter_desc together with \p diff_src_iter_desc,
 *  - \p bias_desc together with \p diff_bias_desc,
 *  - \p dst_iter_desc together with \p diff_dst_iter_desc.
 * 
 *  This would then indicate that the RNN backward propagation primitive should
 *  not use the respective data and should use zero values instead.
 * 
 *  \note
 *      All memory descriptors can be initialized with
 *      #dnnl_format_tag_any or with format_kind set to #dnnl_format_kind_any.
 * 
 *  @param rnn_desc Output descriptor for vanilla RNN primitive.
 *  @param prop_kind Propagation kind. Must be #dnnl_backward.
 *  @param activation Activation kind. Possible values are #dnnl_eltwise_relu,
 *      #dnnl_eltwise_tanh or #dnnl_eltwise_logistic.
 *  @param direction RNN direction. See \ref dnnl_rnn_direction_t for more
 *      info.
 *  @param src_layer_desc Memory descriptor for the input vector.
 *  @param src_iter_desc Memory descriptor for the input recurrent hidden
 *      state vector.
 *  @param weights_layer_desc Memory descriptor for the weights applied to the
 *      layer input.
 *  @param weights_iter_desc Memory descriptor for the weights applied to the
 *      recurrent input.
 *  @param bias_desc Bias memory descriptor.
 *  @param dst_layer_desc Memory descriptor for the output vector.
 *  @param dst_iter_desc Memory descriptor for the output recurrent hidden
 *      state vector.
 *  @param diff_src_layer_desc Memory descriptor for the diff of input vector.
 *  @param diff_src_iter_desc Memory descriptor for the diff of input recurrent
 *      hidden state vector.
 *  @param diff_weights_layer_desc Memory descriptor for the diff of weights
 *      applied to the layer input.
 *  @param diff_weights_iter_desc Memory descriptor for the diff of weights
 *      applied to the recurrent input.
 *  @param diff_bias_desc Diff bias memory descriptor.
 *  @param diff_dst_layer_desc Memory descriptor for the diff of output
 *      vector.
 *  @param diff_dst_iter_desc Memory descriptor for the diff of output
 *      recurrent hidden state vector.
 *  @param flags Unused.
 *  @param alpha Negative slope if activation is #dnnl_eltwise_relu.
 *  @param beta Unused.
 *  @return #dnnl_success on success and a status describing the error
 *      otherwise. */

///
///
///
///
///
public static native @Cast("dnnl_status_t") int dnnl_vanilla_rnn_backward_desc_init(
        dnnl_rnn_desc_t rnn_desc, @Cast("dnnl_prop_kind_t") int prop_kind,
        @Cast("const dnnl_alg_kind_t") int activation, @Cast("const dnnl_rnn_direction_t") int direction,
        @Const dnnl_memory_desc_t src_layer_desc,
        @Const dnnl_memory_desc_t src_iter_desc,
        @Const dnnl_memory_desc_t weights_layer_desc,
        @Const dnnl_memory_desc_t weights_iter_desc,
        @Const dnnl_memory_desc_t bias_desc,
        @Const dnnl_memory_desc_t dst_layer_desc,
        @Const dnnl_memory_desc_t dst_iter_desc,
        @Const dnnl_memory_desc_t diff_src_layer_desc,
        @Const dnnl_memory_desc_t diff_src_iter_desc,
        @Const dnnl_memory_desc_t diff_weights_layer_desc,
        @Const dnnl_memory_desc_t diff_weights_iter_desc,
        @Const dnnl_memory_desc_t diff_bias_desc,
        @Const dnnl_memory_desc_t diff_dst_layer_desc,
        @Const dnnl_memory_desc_t diff_dst_iter_desc, @Cast("unsigned") int flags,
        float alpha, float beta);

/** Initializes a descriptor for LSTM forward propagation primitive.
 * 
 *  The following arguments may either be \c NULL or point to a zero memory
 *  descriptor:
 *  - \p src_iter_desc together with \p src_iter_c_desc,
 *  - \p bias_desc,
 *  - \p dst_iter_desc together with \p dst_iter_c_desc.
 * 
 *  This would then indicate that the LSTM forward propagation primitive should
 *  not use them and should default to zero values instead.
 * 
 *  \note
 *      All memory descriptors can be initialized with
 *      #dnnl_format_tag_any or with format_kind set to #dnnl_format_kind_any.
 * 
 *  @see dnnl_lstm_forward_desc_init_v2 to initialize forward LSTM with and
 *      without peephole
 *  @see dnnl_lstm_forward_desc_init_v3 to initialize forward LSTM with and
 *      without peephole / recurrent projection layer
 * 
 *  @param rnn_desc Output descriptor for LSTM primitive.
 *  @param prop_kind Propagation kind. Possible values are
 *      #dnnl_forward_training and #dnnl_forward_inference.
 *  @param direction RNN direction. See \ref dnnl_rnn_direction_t for more
 *      info.
 *  @param src_layer_desc Memory descriptor for the input vector.
 *  @param src_iter_desc Memory descriptor for the input recurrent hidden
 *      state vector.
 *  @param src_iter_c_desc Memory descriptor for the input recurrent cell
 *      state vector.
 *  @param weights_layer_desc Memory descriptor for the weights applied to the
 *      layer input.
 *  @param weights_iter_desc Memory descriptor for the weights applied to the
 *      recurrent input.
 *  @param bias_desc Bias memory descriptor.
 *  @param dst_layer_desc Memory descriptor for the output vector.
 *  @param dst_iter_desc Memory descriptor for the output recurrent hidden
 *      state vector.
 *  @param dst_iter_c_desc Memory descriptor for the output recurrent cell
 *      state vector.
 *  @param flags Unused.
 *  @return #dnnl_success on success and a status describing the error
 *      otherwise. */

///
///
///
///
///
public static native @Cast("dnnl_status_t") int dnnl_lstm_forward_desc_init(dnnl_rnn_desc_t rnn_desc,
        @Cast("dnnl_prop_kind_t") int prop_kind, @Cast("dnnl_rnn_direction_t") int direction,
        @Const dnnl_memory_desc_t src_layer_desc,
        @Const dnnl_memory_desc_t src_iter_desc,
        @Const dnnl_memory_desc_t src_iter_c_desc,
        @Const dnnl_memory_desc_t weights_layer_desc,
        @Const dnnl_memory_desc_t weights_iter_desc,
        @Const dnnl_memory_desc_t bias_desc,
        @Const dnnl_memory_desc_t dst_layer_desc,
        @Const dnnl_memory_desc_t dst_iter_desc,
        @Const dnnl_memory_desc_t dst_iter_c_desc, @Cast("unsigned") int flags);

/** Initializes a descriptor for an LSTM (with or without peephole) forward
 *  propagation primitive.
 * 
 *  The following arguments may either be \c NULL or point to a zero memory
 *  descriptor:
 *  - \p src_iter_desc together with \p src_iter_c_desc,
 *  - \p weights_peephole_desc,
 *  - \p bias_desc,
 *  - \p dst_iter_desc together with \p dst_iter_c_desc.
 * 
 *  This would then indicate that the LSTM forward propagation primitive should
 *  not use them and should default to zero values instead.
 * 
 *  \note
 *      All memory descriptors can be initialized with #dnnl_format_tag_any or
 *      with format_kind set to #dnnl_format_kind_any.
 * 
 *  @see dnnl_lstm_forward_desc_init_v3 to initialize forward LSTM with and
 *      without peephole / recurrent projection layer
 * 
 *  @param rnn_desc Output descriptor for LSTM primitive.
 *  @param prop_kind Propagation kind. Possible values are
 *      #dnnl_forward_training and #dnnl_forward_inference.
 *  @param direction RNN direction. See \ref dnnl_rnn_direction_t for more
 *      info.
 *  @param src_layer_desc Memory descriptor for the input vector.
 *  @param src_iter_desc Memory descriptor for the input recurrent hidden
 *      state vector.
 *  @param src_iter_c_desc Memory descriptor for the input recurrent cell
 *      state vector.
 *  @param weights_layer_desc Memory descriptor for the weights applied to the
 *      layer input.
 *  @param weights_iter_desc Memory descriptor for the weights applied to the
 *      recurrent input.
 *  @param weights_peephole_desc Memory descriptor for the weights applied to
 *      the cell states (according to the Peephole LSTM formula).
 *  @param bias_desc Bias memory descriptor.
 *  @param dst_layer_desc Memory descriptor for the output vector.
 *  @param dst_iter_desc Memory descriptor for the output recurrent hidden
 *      state vector.
 *  @param dst_iter_c_desc Memory descriptor for the output recurrent cell
 *      state vector.
 *  @param flags Unused.
 *  @return #dnnl_success on success and a status describing the error
 *      otherwise. */

///
///
///
///
///
public static native @Cast("dnnl_status_t") int dnnl_lstm_forward_desc_init_v2(dnnl_rnn_desc_t rnn_desc,
        @Cast("dnnl_prop_kind_t") int prop_kind, @Cast("dnnl_rnn_direction_t") int direction,
        @Const dnnl_memory_desc_t src_layer_desc,
        @Const dnnl_memory_desc_t src_iter_desc,
        @Const dnnl_memory_desc_t src_iter_c_desc,
        @Const dnnl_memory_desc_t weights_layer_desc,
        @Const dnnl_memory_desc_t weights_iter_desc,
        @Const dnnl_memory_desc_t weights_peephole_desc,
        @Const dnnl_memory_desc_t bias_desc,
        @Const dnnl_memory_desc_t dst_layer_desc,
        @Const dnnl_memory_desc_t dst_iter_desc,
        @Const dnnl_memory_desc_t dst_iter_c_desc, @Cast("unsigned") int flags);

/** Initializes a descriptor for an LSTM (with or without peephole and with
 *  or without recurrent projection layer) forward propagation primitive.
 * 
 *  The following arguments may either be \c NULL or point to a zero memory
 *  descriptor:
 *  - \p src_iter_desc together with \p src_iter_c_desc,
 *  - \p weights_peephole_desc,
 *  - \p bias_desc,
 *  - \p dst_iter_desc together with \p dst_iter_c_desc.
 * 
 *  This would then indicate that the LSTM forward propagation primitive should
 *  not use them and should default to zero values instead.
 * 
 *  The \p weights_projection_desc could either be \c NULL or point to a zero
 *  memory descriptor. This would then indicate that the LSTM doesn't have
 *  recurrent projection layer.
 * 
 *  \note
 *      All memory descriptors can be initialized with #dnnl_format_tag_any or
 *      with format_kind set to #dnnl_format_kind_any.
 * 
 *  @param rnn_desc Output descriptor for LSTM primitive.
 *  @param prop_kind Propagation kind. Possible values are
 *      #dnnl_forward_training and #dnnl_forward_inference.
 *  @param direction RNN direction. See \ref dnnl_rnn_direction_t for more
 *      info.
 *  @param src_layer_desc Memory descriptor for the input vector.
 *  @param src_iter_desc Memory descriptor for the input recurrent hidden
 *      state vector.
 *  @param src_iter_c_desc Memory descriptor for the input recurrent cell
 *      state vector.
 *  @param weights_layer_desc Memory descriptor for the weights applied to the
 *      layer input.
 *  @param weights_iter_desc Memory descriptor for the weights applied to the
 *      recurrent input.
 *  @param weights_peephole_desc Memory descriptor for the weights applied to
 *      the cell states (according to the Peephole LSTM formula).
 *  @param weights_projection_desc Memory descriptor for the weights applied to
 *      the hidden states to get the recurrent projection (according to the
 *      Projection LSTM formula).
 *  @param bias_desc Bias memory descriptor.
 *  @param dst_layer_desc Memory descriptor for the output vector.
 *  @param dst_iter_desc Memory descriptor for the output recurrent hidden
 *      state vector.
 *  @param dst_iter_c_desc Memory descriptor for the output recurrent cell
 *      state vector.
 *  @param flags Unused.
 *  @return #dnnl_success on success and a status describing the error
 *      otherwise. */

///
///
///
///
///
public static native @Cast("dnnl_status_t") int dnnl_lstm_forward_desc_init_v3(dnnl_rnn_desc_t rnn_desc,
        @Cast("dnnl_prop_kind_t") int prop_kind, @Cast("dnnl_rnn_direction_t") int direction,
        @Const dnnl_memory_desc_t src_layer_desc,
        @Const dnnl_memory_desc_t src_iter_desc,
        @Const dnnl_memory_desc_t src_iter_c_desc,
        @Const dnnl_memory_desc_t weights_layer_desc,
        @Const dnnl_memory_desc_t weights_iter_desc,
        @Const dnnl_memory_desc_t weights_peephole_desc,
        @Const dnnl_memory_desc_t weights_projection_desc,
        @Const dnnl_memory_desc_t bias_desc,
        @Const dnnl_memory_desc_t dst_layer_desc,
        @Const dnnl_memory_desc_t dst_iter_desc,
        @Const dnnl_memory_desc_t dst_iter_c_desc, @Cast("unsigned") int flags);

/** Initializes a descriptor for an LSTM backward propagation primitive.
 * 
 *  The following arguments may either be \c NULL or point to a zero memory
 *  descriptor:
 *  - \p src_iter_desc together with \p src_iter_c_desc, \p diff_src_iter_desc,
 *    and \p diff_src_iter_c_desc,
 *  - \p bias_desc together with \p diff_bias_desc,
 *  - \p dst_iter_desc together with \p dst_iter_c_desc, \p diff_dst_iter_desc,
 *    and \p diff_dst_iter_c_desc.
 * 
 *  This would then indicate that the LSTM backward propagation primitive
 *  should not use them and should default to zero values instead.
 * 
 *  \note
 *      All memory descriptors can be initialized with
 *      #dnnl_format_tag_any or with format_kind set to #dnnl_format_kind_any.
 * 
 *  @see dnnl_lstm_backward_desc_init_v2 to initialize backward LSTM with and
 *      without peephole
 *  @see dnnl_lstm_backward_desc_init_v3 to initialize backward LSTM with and
 *      without peephole / recurrent projection layer
 * 
 *  @param rnn_desc Output descriptor for LSTM primitive.
 *  @param prop_kind Propagation kind. Must be #dnnl_backward.
 *  @param direction RNN direction. See \ref dnnl_rnn_direction_t for more
 *      info.
 *  @param src_layer_desc Memory descriptor for the input vector.
 *  @param src_iter_desc Memory descriptor for the input recurrent hidden
 *      state vector.
 *  @param src_iter_c_desc Memory descriptor for the input recurrent cell
 *      state vector.
 *  @param weights_layer_desc Memory descriptor for the weights applied to the
 *      layer input.
 *  @param weights_iter_desc Memory descriptor for the weights applied to the
 *      recurrent input.
 *  @param bias_desc Bias memory descriptor.
 *  @param dst_layer_desc Memory descriptor for the output vector.
 *  @param dst_iter_desc Memory descriptor for the output recurrent hidden
 *      state vector.
 *  @param dst_iter_c_desc Memory descriptor for the output recurrent cell
 *      state vector.
 *  @param diff_src_layer_desc Memory descriptor for the diff of input vector.
 *  @param diff_src_iter_desc Memory descriptor for the diff of input recurrent
 *      hidden state vector.
 *  @param diff_src_iter_c_desc Memory descriptor for the diff of input
 *  recurrent cell state vector.
 *  @param diff_weights_layer_desc Memory descriptor for the diff of weights
 *      applied to the layer input.
 *  @param diff_weights_iter_desc Memory descriptor for the diff of weights
 *      applied to the recurrent input.
 *  @param diff_bias_desc Diff bias memory descriptor.
 *  @param diff_dst_layer_desc Memory descriptor for the diff of output
 *      vector.
 *  @param diff_dst_iter_desc Memory descriptor for the diff of output
 *      recurrent hidden state vector.
 *  @param diff_dst_iter_c_desc Memory descriptor for the diff of output
 *      recurrent cell state vector.
 *  @param flags Unused.
 *  @return #dnnl_success on success and a status describing the error
 *      otherwise. */

///
///
///
///
///
public static native @Cast("dnnl_status_t") int dnnl_lstm_backward_desc_init(dnnl_rnn_desc_t rnn_desc,
        @Cast("dnnl_prop_kind_t") int prop_kind, @Cast("dnnl_rnn_direction_t") int direction,
        @Const dnnl_memory_desc_t src_layer_desc,
        @Const dnnl_memory_desc_t src_iter_desc,
        @Const dnnl_memory_desc_t src_iter_c_desc,
        @Const dnnl_memory_desc_t weights_layer_desc,
        @Const dnnl_memory_desc_t weights_iter_desc,
        @Const dnnl_memory_desc_t bias_desc,
        @Const dnnl_memory_desc_t dst_layer_desc,
        @Const dnnl_memory_desc_t dst_iter_desc,
        @Const dnnl_memory_desc_t dst_iter_c_desc,
        @Const dnnl_memory_desc_t diff_src_layer_desc,
        @Const dnnl_memory_desc_t diff_src_iter_desc,
        @Const dnnl_memory_desc_t diff_src_iter_c_desc,
        @Const dnnl_memory_desc_t diff_weights_layer_desc,
        @Const dnnl_memory_desc_t diff_weights_iter_desc,
        @Const dnnl_memory_desc_t diff_bias_desc,
        @Const dnnl_memory_desc_t diff_dst_layer_desc,
        @Const dnnl_memory_desc_t diff_dst_iter_desc,
        @Const dnnl_memory_desc_t diff_dst_iter_c_desc, @Cast("unsigned") int flags);

/** Initializes a descriptor for an LSTM (with or without peephole) backward
 *  propagation primitive.
 * 
 *  The following arguments may either be \c NULL or point to a zero memory
 *  descriptor:
 *  - \p src_iter_desc together with \p src_iter_c_desc, \p diff_src_iter_desc,
 *    and \p diff_src_iter_c_desc,
 *  - \p weights_peephole_desc together with \p diff_weights_peephole_desc,
 *  - \p bias_desc together with \p diff_bias_desc,
 *  - \p dst_iter_desc together with \p dst_iter_c_desc, \p diff_dst_iter_desc,
 *    and \p diff_dst_iter_c_desc.
 * 
 *  This would then indicate that the LSTM backward propagation primitive
 *  should not use them and should default to zero values instead.
 * 
 *  \note
 *      All memory descriptors can be initialized with #dnnl_format_tag_any or
 *      with format_kind set to #dnnl_format_kind_any.
 * 
 *  @see dnnl_lstm_backward_desc_init_v3 to initialize backward LSTM with and
 *      without peephole / recurrent projection layer
 * 
 *  @param rnn_desc Output descriptor for LSTM primitive.
 *  @param prop_kind Propagation kind. Must be #dnnl_backward.
 *  @param direction RNN direction. See \ref dnnl_rnn_direction_t for more
 *      info.
 *  @param src_layer_desc Memory descriptor for the input vector.
 *  @param src_iter_desc Memory descriptor for the input recurrent hidden
 *      state vector.
 *  @param src_iter_c_desc Memory descriptor for the input recurrent cell
 *      state vector.
 *  @param weights_layer_desc Memory descriptor for the weights applied to the
 *      layer input.
 *  @param weights_iter_desc Memory descriptor for the weights applied to the
 *      recurrent input.
 *  @param weights_peephole_desc Memory descriptor for the weights applied to
 *      the cell states (according to the Peephole LSTM formula).
 *  @param bias_desc Bias memory descriptor.
 *  @param dst_layer_desc Memory descriptor for the output vector.
 *  @param dst_iter_desc Memory descriptor for the output recurrent hidden
 *      state vector.
 *  @param dst_iter_c_desc Memory descriptor for the output recurrent cell
 *      state vector.
 *  @param diff_src_layer_desc Memory descriptor for the diff of input vector.
 *  @param diff_src_iter_desc Memory descriptor for the diff of input recurrent
 *      hidden state vector.
 *  @param diff_src_iter_c_desc Memory descriptor for the diff of input
 *  recurrent cell state vector.
 *  @param diff_weights_layer_desc Memory descriptor for the diff of weights
 *      applied to the layer input.
 *  @param diff_weights_iter_desc Memory descriptor for the diff of weights
 *      applied to the recurrent input.
 *  @param diff_weights_peephole_desc Memory descriptor for the diff of weights
 *      applied to the cell states (according to the Peephole LSTM formula).
 *  @param diff_bias_desc Diff bias memory descriptor.
 *  @param diff_dst_layer_desc Memory descriptor for the diff of output
 *      vector.
 *  @param diff_dst_iter_desc Memory descriptor for the diff of output
 *      recurrent hidden state vector.
 *  @param diff_dst_iter_c_desc Memory descriptor for the diff of output
 *      recurrent cell state vector.
 *  @param flags Unused.
 *  @return #dnnl_success on success and a status describing the error
 *      otherwise. */

///
///
///
///
///
public static native @Cast("dnnl_status_t") int dnnl_lstm_backward_desc_init_v2(
        dnnl_rnn_desc_t rnn_desc, @Cast("dnnl_prop_kind_t") int prop_kind,
        @Cast("dnnl_rnn_direction_t") int direction,
        @Const dnnl_memory_desc_t src_layer_desc,
        @Const dnnl_memory_desc_t src_iter_desc,
        @Const dnnl_memory_desc_t src_iter_c_desc,
        @Const dnnl_memory_desc_t weights_layer_desc,
        @Const dnnl_memory_desc_t weights_iter_desc,
        @Const dnnl_memory_desc_t weights_peephole_desc,
        @Const dnnl_memory_desc_t bias_desc,
        @Const dnnl_memory_desc_t dst_layer_desc,
        @Const dnnl_memory_desc_t dst_iter_desc,
        @Const dnnl_memory_desc_t dst_iter_c_desc,
        @Const dnnl_memory_desc_t diff_src_layer_desc,
        @Const dnnl_memory_desc_t diff_src_iter_desc,
        @Const dnnl_memory_desc_t diff_src_iter_c_desc,
        @Const dnnl_memory_desc_t diff_weights_layer_desc,
        @Const dnnl_memory_desc_t diff_weights_iter_desc,
        @Const dnnl_memory_desc_t diff_weights_peephole_desc,
        @Const dnnl_memory_desc_t diff_bias_desc,
        @Const dnnl_memory_desc_t diff_dst_layer_desc,
        @Const dnnl_memory_desc_t diff_dst_iter_desc,
        @Const dnnl_memory_desc_t diff_dst_iter_c_desc, @Cast("unsigned") int flags);

/** Initializes a descriptor for an LSTM (with or without peephole and with or
 *  with out recurrent projection layer) backward propagation primitive.
 * 
 *  The following arguments may either be \c NULL or point to a zero memory
 *  descriptor:
 *  - \p src_iter_desc together with \p src_iter_c_desc, \p diff_src_iter_desc,
 *    and \p diff_src_iter_c_desc,
 *  - \p weights_peephole_desc together with \p diff_weights_peephole_desc,
 *  - \p bias_desc together with \p diff_bias_desc,
 *  - \p dst_iter_desc together with \p dst_iter_c_desc, \p diff_dst_iter_desc,
 *    and \p diff_dst_iter_c_desc.
 * 
 *  This would then indicate that the LSTM backward propagation primitive
 *  should not use them and should default to zero values instead.
 * 
 *  The \p weights_projection_desc together with \p
 *  diff_weights_projection_desc could either be \c NULL or point to a zero
 *  memory descriptor. This would then indicate that the LSTM doesn't have
 *  recurrent projection layer.
 * 
 *  \note
 *      All memory descriptors can be initialized with #dnnl_format_tag_any or
 *      with format_kind set to #dnnl_format_kind_any.
 * 
 *  @param rnn_desc Output descriptor for LSTM primitive.
 *  @param prop_kind Propagation kind. Must be #dnnl_backward.
 *  @param direction RNN direction. See \ref dnnl_rnn_direction_t for more
 *      info.
 *  @param src_layer_desc Memory descriptor for the input vector.
 *  @param src_iter_desc Memory descriptor for the input recurrent hidden
 *      state vector.
 *  @param src_iter_c_desc Memory descriptor for the input recurrent cell
 *      state vector.
 *  @param weights_layer_desc Memory descriptor for the weights applied to the
 *      layer input.
 *  @param weights_iter_desc Memory descriptor for the weights applied to the
 *      recurrent input.
 *  @param weights_peephole_desc Memory descriptor for the weights applied to
 *      the cell states (according to the Peephole LSTM formula).
 *  @param weights_projection_desc Memory descriptor for the weights applied to
 *      the hidden states to get the recurrent projection (according to the
 *      Projection LSTM formula).
 *  @param bias_desc Bias memory descriptor.
 *  @param dst_layer_desc Memory descriptor for the output vector.
 *  @param dst_iter_desc Memory descriptor for the output recurrent hidden
 *      state vector.
 *  @param dst_iter_c_desc Memory descriptor for the output recurrent cell
 *      state vector.
 *  @param diff_src_layer_desc Memory descriptor for the diff of input vector.
 *  @param diff_src_iter_desc Memory descriptor for the diff of input recurrent
 *      hidden state vector.
 *  @param diff_src_iter_c_desc Memory descriptor for the diff of input
 *  recurrent cell state vector.
 *  @param diff_weights_layer_desc Memory descriptor for the diff of weights
 *      applied to the layer input.
 *  @param diff_weights_iter_desc Memory descriptor for the diff of weights
 *      applied to the recurrent input.
 *  @param diff_weights_peephole_desc Memory descriptor for the diff of weights
 *      applied to the cell states (according to the Peephole LSTM formula).
 *  @param diff_weights_projection_desc Memory descriptor for the diff of
 *      weights applied to the hidden states to get the recurrent projection
 *      (according to the Projection LSTM formula).
 *  @param diff_bias_desc Diff bias memory descriptor.
 *  @param diff_dst_layer_desc Memory descriptor for the diff of output
 *      vector.
 *  @param diff_dst_iter_desc Memory descriptor for the diff of output
 *      recurrent hidden state vector.
 *  @param diff_dst_iter_c_desc Memory descriptor for the diff of output
 *      recurrent cell state vector.
 *  @param flags Unused.
 *  @return #dnnl_success on success and a status describing the error
 *      otherwise. */

///
///
///
///
public static native @Cast("dnnl_status_t") int dnnl_lstm_backward_desc_init_v3(
        dnnl_rnn_desc_t rnn_desc, @Cast("dnnl_prop_kind_t") int prop_kind,
        @Cast("dnnl_rnn_direction_t") int direction,
        @Const dnnl_memory_desc_t src_layer_desc,
        @Const dnnl_memory_desc_t src_iter_desc,
        @Const dnnl_memory_desc_t src_iter_c_desc,
        @Const dnnl_memory_desc_t weights_layer_desc,
        @Const dnnl_memory_desc_t weights_iter_desc,
        @Const dnnl_memory_desc_t weights_peephole_desc,
        @Const dnnl_memory_desc_t weights_projection_desc,
        @Const dnnl_memory_desc_t bias_desc,
        @Const dnnl_memory_desc_t dst_layer_desc,
        @Const dnnl_memory_desc_t dst_iter_desc,
        @Const dnnl_memory_desc_t dst_iter_c_desc,
        @Const dnnl_memory_desc_t diff_src_layer_desc,
        @Const dnnl_memory_desc_t diff_src_iter_desc,
        @Const dnnl_memory_desc_t diff_src_iter_c_desc,
        @Const dnnl_memory_desc_t diff_weights_layer_desc,
        @Const dnnl_memory_desc_t diff_weights_iter_desc,
        @Const dnnl_memory_desc_t diff_weights_peephole_desc,
        @Const dnnl_memory_desc_t diff_weights_projection_desc,
        @Const dnnl_memory_desc_t diff_bias_desc,
        @Const dnnl_memory_desc_t diff_dst_layer_desc,
        @Const dnnl_memory_desc_t diff_dst_iter_desc,
        @Const dnnl_memory_desc_t diff_dst_iter_c_desc, @Cast("unsigned") int flags);

/** Initializes a descriptor for GRU forward propagation primitive.
 * 
 *  The following arguments may either be \c NULL or point to a zero memory
 *  descriptor:
 *  - \p src_iter_desc,
 *  - \p bias_desc,
 *  - \p dst_iter_desc.
 * 
 *  This would then indicate that the GRU forward propagation primitive should
 *  not use them and should default to zero values instead.
 * 
 *  \note
 *      All memory descriptors can be initialized with
 *      #dnnl_format_tag_any or with format_kind set to #dnnl_format_kind_any.
 * 
 *  @param rnn_desc Output descriptor for GRU primitive.
 *  @param prop_kind Propagation kind. Possible values are
 *      #dnnl_forward_training and #dnnl_forward_inference.
 *  @param direction RNN direction. See \ref dnnl_rnn_direction_t for more
 *      info.
 *  @param src_layer_desc Memory descriptor for the input vector.
 *  @param src_iter_desc Memory descriptor for the input recurrent hidden
 *      state vector.
 *  @param weights_layer_desc Memory descriptor for the weights applied to the
 *      layer input.
 *  @param weights_iter_desc Memory descriptor for the weights applied to the
 *      recurrent input.
 *  @param bias_desc Bias memory descriptor.
 *  @param dst_layer_desc Memory descriptor for the output vector.
 *  @param dst_iter_desc Memory descriptor for the output recurrent hidden
 *      state vector.
 *  @param flags Unused.
 *  @return #dnnl_success on success and a status describing the error
 *      otherwise. */

///
///
///
///
public static native @Cast("dnnl_status_t") int dnnl_gru_forward_desc_init(dnnl_rnn_desc_t rnn_desc,
        @Cast("dnnl_prop_kind_t") int prop_kind, @Cast("dnnl_rnn_direction_t") int direction,
        @Const dnnl_memory_desc_t src_layer_desc,
        @Const dnnl_memory_desc_t src_iter_desc,
        @Const dnnl_memory_desc_t weights_layer_desc,
        @Const dnnl_memory_desc_t weights_iter_desc,
        @Const dnnl_memory_desc_t bias_desc,
        @Const dnnl_memory_desc_t dst_layer_desc,
        @Const dnnl_memory_desc_t dst_iter_desc, @Cast("unsigned") int flags);

/** Initializes a descriptor for GRU backward propagation primitive.
 * 
 *  The following arguments may either be \c NULL or point to a zero memory
 *  descriptor:
 *  - \p src_iter_desc together with \p diff_src_iter_desc,
 *  - \p bias_desc together with \p diff_bias_desc,
 *  - \p dst_iter_desc together with \p diff_dst_iter_desc.
 * 
 *  This would then indicate that the GRU backward propagation primitive
 *  should not use them and should default to zero values instead.
 * 
 *  \note
 *      All memory descriptors can be initialized with
 *      #dnnl_format_tag_any or with format_kind set to #dnnl_format_kind_any.
 * 
 *  @param rnn_desc Output descriptor for GRU primitive.
 *  @param prop_kind Propagation kind. Must be #dnnl_backward.
 *  @param direction RNN direction. See \ref dnnl_rnn_direction_t for more
 *      info.
 *  @param src_layer_desc Memory descriptor for the input vector.
 *  @param src_iter_desc Memory descriptor for the input recurrent hidden
 *      state vector.
 *  @param weights_layer_desc Memory descriptor for the weights applied to the
 *      layer input.
 *  @param weights_iter_desc Memory descriptor for the weights applied to the
 *      recurrent input.
 *  @param bias_desc Bias memory descriptor.
 *  @param dst_layer_desc Memory descriptor for the output vector.
 *  @param dst_iter_desc Memory descriptor for the output recurrent hidden
 *      state vector.
 *  @param diff_src_layer_desc Memory descriptor for the diff of input vector.
 *  @param diff_src_iter_desc Memory descriptor for the diff of input recurrent
 *      hidden state vector.
 *  @param diff_weights_layer_desc Memory descriptor for the diff of weights
 *      applied to the layer input.
 *  @param diff_weights_iter_desc Memory descriptor for the diff of weights
 *      applied to the recurrent input.
 *  @param diff_bias_desc Diff bias memory descriptor.
 *  @param diff_dst_layer_desc Memory descriptor for the diff of output
 *      vector.
 *  @param diff_dst_iter_desc Memory descriptor for the diff of output
 *      recurrent hidden state vector.
 *  @param flags Unused.
 *  @return #dnnl_success on success and a status describing the error
 *      otherwise. */

///
///
///
public static native @Cast("dnnl_status_t") int dnnl_gru_backward_desc_init(dnnl_rnn_desc_t rnn_desc,
        @Cast("dnnl_prop_kind_t") int prop_kind, @Cast("dnnl_rnn_direction_t") int direction,
        @Const dnnl_memory_desc_t src_layer_desc,
        @Const dnnl_memory_desc_t src_iter_desc,
        @Const dnnl_memory_desc_t weights_layer_desc,
        @Const dnnl_memory_desc_t weights_iter_desc,
        @Const dnnl_memory_desc_t bias_desc,
        @Const dnnl_memory_desc_t dst_layer_desc,
        @Const dnnl_memory_desc_t dst_iter_desc,
        @Const dnnl_memory_desc_t diff_src_layer_desc,
        @Const dnnl_memory_desc_t diff_src_iter_desc,
        @Const dnnl_memory_desc_t diff_weights_layer_desc,
        @Const dnnl_memory_desc_t diff_weights_iter_desc,
        @Const dnnl_memory_desc_t diff_bias_desc,
        @Const dnnl_memory_desc_t diff_dst_layer_desc,
        @Const dnnl_memory_desc_t diff_dst_iter_desc, @Cast("unsigned") int flags);

/** Initializes a descriptor for LBR GRU forward propagation primitive.
 * 
 *  The following arguments may either be \c NULL or point to a zero memory
 *  descriptor:
 *  - \p src_iter_desc,
 *  - \p bias_desc,
 *  - \p dst_iter_desc.
 * 
 *  This would then indicate that the LBR GRU forward propagation primitive
 *  should not use them and should default to zero values instead.
 * 
 *  @param rnn_desc Output descriptor for LBR GRU primitive.
 *  @param prop_kind Propagation kind. Possible values are
 *      #dnnl_forward_training and #dnnl_forward_inference.
 *  @param direction RNN direction. See \ref dnnl_rnn_direction_t for more
 *      info.
 *  @param src_layer_desc Memory descriptor for the input vector.
 *  @param src_iter_desc Memory descriptor for the input recurrent hidden
 *      state vector.
 *  @param weights_layer_desc Memory descriptor for the weights applied to the
 *      layer input.
 *  @param weights_iter_desc Memory descriptor for the weights applied to the
 *      recurrent input.
 *  @param bias_desc Bias memory descriptor.
 *  @param dst_layer_desc Memory descriptor for the output vector.
 *  @param dst_iter_desc Memory descriptor for the output recurrent hidden
 *      state vector.
 *  @param flags Unused.
 *  @return #dnnl_success on success and a status describing the error
 *      otherwise. */

///
///
///
///
public static native @Cast("dnnl_status_t") int dnnl_lbr_gru_forward_desc_init(dnnl_rnn_desc_t rnn_desc,
        @Cast("dnnl_prop_kind_t") int prop_kind, @Cast("dnnl_rnn_direction_t") int direction,
        @Const dnnl_memory_desc_t src_layer_desc,
        @Const dnnl_memory_desc_t src_iter_desc,
        @Const dnnl_memory_desc_t weights_layer_desc,
        @Const dnnl_memory_desc_t weights_iter_desc,
        @Const dnnl_memory_desc_t bias_desc,
        @Const dnnl_memory_desc_t dst_layer_desc,
        @Const dnnl_memory_desc_t dst_iter_desc, @Cast("unsigned") int flags);

/** Initializes a descriptor for LBR GRU backward propagation primitive.
 * 
 *  The following arguments may either be \c NULL or point to a zero memory
 *  descriptor:
 *  - \p src_iter_desc together with \p diff_src_iter_desc,
 *  - \p bias_desc together with \p diff_bias_desc,
 *  - \p dst_iter_desc together with \p diff_dst_iter_desc.
 * 
 *  This would then indicate that the LBR GRU backward propagation primitive
 *  should not use them and should default to zero values instead.
 * 
 *  \note
 *      All memory descriptors can be initialized with
 *      #dnnl_format_tag_any or with format_kind set to #dnnl_format_kind_any.
 * 
 *  @param rnn_desc Output descriptor for LBR GRU primitive.
 *  @param prop_kind Propagation kind. Must be #dnnl_backward.
 *  @param direction RNN direction. See \ref dnnl_rnn_direction_t for more
 *      info.
 *  @param src_layer_desc Memory descriptor for the input vector.
 *  @param src_iter_desc Memory descriptor for the input recurrent hidden
 *      state vector.
 *  @param weights_layer_desc Memory descriptor for the weights applied to the
 *      layer input.
 *  @param weights_iter_desc Memory descriptor for the weights applied to the
 *      recurrent input.
 *  @param bias_desc Bias memory descriptor.
 *  @param dst_layer_desc Memory descriptor for the output vector.
 *  @param dst_iter_desc Memory descriptor for the output recurrent hidden
 *      state vector.
 *  @param diff_src_layer_desc Memory descriptor for the diff of input vector.
 *  @param diff_src_iter_desc Memory descriptor for the diff of input recurrent
 *      hidden state vector.
 *  @param diff_weights_layer_desc Memory descriptor for the diff of weights
 *      applied to the layer input.
 *  @param diff_weights_iter_desc Memory descriptor for the diff of weights
 *      applied to the recurrent input.
 *  @param diff_bias_desc Diff bias memory descriptor.
 *  @param diff_dst_layer_desc Memory descriptor for the diff of output
 *      vector.
 *  @param diff_dst_iter_desc Memory descriptor for the diff of output
 *      recurrent hidden state vector.
 *  @param flags Unused.
 *  @return #dnnl_success on success and a status describing the error
 *      otherwise. */

///
public static native @Cast("dnnl_status_t") int dnnl_lbr_gru_backward_desc_init(
        dnnl_rnn_desc_t rnn_desc, @Cast("dnnl_prop_kind_t") int prop_kind,
        @Cast("dnnl_rnn_direction_t") int direction,
        @Const dnnl_memory_desc_t src_layer_desc,
        @Const dnnl_memory_desc_t src_iter_desc,
        @Const dnnl_memory_desc_t weights_layer_desc,
        @Const dnnl_memory_desc_t weights_iter_desc,
        @Const dnnl_memory_desc_t bias_desc,
        @Const dnnl_memory_desc_t dst_layer_desc,
        @Const dnnl_memory_desc_t dst_iter_desc,
        @Const dnnl_memory_desc_t diff_src_layer_desc,
        @Const dnnl_memory_desc_t diff_src_iter_desc,
        @Const dnnl_memory_desc_t diff_weights_layer_desc,
        @Const dnnl_memory_desc_t diff_weights_iter_desc,
        @Const dnnl_memory_desc_t diff_bias_desc,
        @Const dnnl_memory_desc_t diff_dst_layer_desc,
        @Const dnnl_memory_desc_t diff_dst_iter_desc, @Cast("unsigned") int flags);

/** \} dnnl_api_rnn
 <p>
 *  \addtogroup dnnl_api_matmul
 *  \{
 <p>
 *  Initializes a matrix multiplication descriptor.
 * 
 *  @param matmul_desc Output descriptor for matmul primitive.
 *  @param src_desc Source memory descriptor (matrix A)
 *  @param weights_desc Weights memory descriptor (matrix B)
 *  @param bias_desc Bias memory descriptor. Passing NULL, a zero memory
 *      descriptor, or a memory descriptor with format_kind set to
 *      #dnnl_format_kind_undef disables the bias term.
 *  @param dst_desc Destination memory descriptor (matrix C).
 *  @return #dnnl_success on success and a status describing the error
 *      otherwise. */

///
///
///
public static native @Cast("dnnl_status_t") int dnnl_matmul_desc_init(dnnl_matmul_desc_t matmul_desc,
        @Const dnnl_memory_desc_t src_desc,
        @Const dnnl_memory_desc_t weights_desc,
        @Const dnnl_memory_desc_t bias_desc,
        @Const dnnl_memory_desc_t dst_desc);

/** \} dnnl_api_matmul
 <p>
 *  \addtogroup dnnl_api_resampling Resampling
 *  \{
 <p>
 *  Initializes a descriptor for a resampling forward propagation primitive.
 * 
 *  \note
 *      Destination memory descriptor is allowed to be initialized with
 *      #dnnl_format_tag_any or with format_kind set to #dnnl_format_kind_any.
 * 
 * 
 *  @param resampling_desc Output descriptor for a resampling primitive.
 *  @param prop_kind Propagation kind. Possible values are
 *      #dnnl_forward_training and #dnnl_forward_inference.
 *  @param alg_kind resampling algorithm kind: either #dnnl_resampling_nearest,
 *      or #dnnl_resampling_linear.
 *  @param factors Array of scaling factors for spatial dimension.
 *  @param src_desc Source memory descriptor.
 *  @param dst_desc Destination memory descriptor.
 *  @return #dnnl_success on success and a status describing the error
 *      otherwise. */

///
///
public static native @Cast("dnnl_status_t") int dnnl_resampling_forward_desc_init(
        dnnl_resampling_desc_t resampling_desc, @Cast("dnnl_prop_kind_t") int prop_kind,
        @Cast("dnnl_alg_kind_t") int alg_kind, @Const FloatPointer factors,
        @Const dnnl_memory_desc_t src_desc, @Const dnnl_memory_desc_t dst_desc);
public static native @Cast("dnnl_status_t") int dnnl_resampling_forward_desc_init(
        dnnl_resampling_desc_t resampling_desc, @Cast("dnnl_prop_kind_t") int prop_kind,
        @Cast("dnnl_alg_kind_t") int alg_kind, @Const FloatBuffer factors,
        @Const dnnl_memory_desc_t src_desc, @Const dnnl_memory_desc_t dst_desc);
public static native @Cast("dnnl_status_t") int dnnl_resampling_forward_desc_init(
        dnnl_resampling_desc_t resampling_desc, @Cast("dnnl_prop_kind_t") int prop_kind,
        @Cast("dnnl_alg_kind_t") int alg_kind, @Const float[] factors,
        @Const dnnl_memory_desc_t src_desc, @Const dnnl_memory_desc_t dst_desc);

/** Initializes a descriptor for resampling backward propagation primitive.
 * 
 *  @param resampling_desc Output descriptor for a resampling primitive.
 *  @param alg_kind resamplinging algorithm kind: either
 *      #dnnl_resampling_nearest, or #dnnl_resampling_linear.
 *  @param diff_src_desc Diff source memory descriptor.
 *  @param diff_dst_desc Diff destination memory descriptor.
 *  @param factors Array of scaling factors for spatial dimension.
 *  @return #dnnl_success on success and a status describing the error
 *      otherwise.
 *  */

///
///
///
///
public static native @Cast("dnnl_status_t") int dnnl_resampling_backward_desc_init(
        dnnl_resampling_desc_t resampling_desc, @Cast("dnnl_alg_kind_t") int alg_kind,
        @Const FloatPointer factors, @Const dnnl_memory_desc_t diff_src_desc,
        @Const dnnl_memory_desc_t diff_dst_desc);
public static native @Cast("dnnl_status_t") int dnnl_resampling_backward_desc_init(
        dnnl_resampling_desc_t resampling_desc, @Cast("dnnl_alg_kind_t") int alg_kind,
        @Const FloatBuffer factors, @Const dnnl_memory_desc_t diff_src_desc,
        @Const dnnl_memory_desc_t diff_dst_desc);
public static native @Cast("dnnl_status_t") int dnnl_resampling_backward_desc_init(
        dnnl_resampling_desc_t resampling_desc, @Cast("dnnl_alg_kind_t") int alg_kind,
        @Const float[] factors, @Const dnnl_memory_desc_t diff_src_desc,
        @Const dnnl_memory_desc_t diff_dst_desc);

/** \} dnnl_api_resampling
 <p>
 *  \addtogroup dnnl_api_reduction Reduction
 *  \{
 <p>
 *  Initializes a descriptor for a reduction primitive.
 * 
 *  \note
 *      Destination memory descriptor is allowed to be initialized with
 *      #dnnl_format_tag_any or with format_kind set to #dnnl_format_kind_any.
 * 
 * 
 *  @param desc Output descriptor for a reduction primitive.
 *  @param alg_kind reduction algorithm kind. Possible values:
 *      #dnnl_reduction_max, #dnnl_reduction_min, #dnnl_reduction_sum,
 *      #dnnl_reduction_mul, #dnnl_reduction_mean, #dnnl_reduction_norm_lp_max,
 *      #dnnl_reduction_norm_lp_sum, #dnnl_reduction_norm_lp_power_p_max,
 *      #dnnl_reduction_norm_lp_power_p_sum.
 *  @param p Algorithm specific parameter.
 *  @param eps Algorithm specific parameter.
 *  @param src_desc Source memory descriptor.
 *  @param dst_desc Destination memory descriptor.
 *  @return #dnnl_success on success and a status describing the error
 *      otherwise.
 *  */

///
public static native @Cast("dnnl_status_t") int dnnl_reduction_desc_init(dnnl_reduction_desc_t desc,
        @Cast("dnnl_alg_kind_t") int alg_kind, @Const dnnl_memory_desc_t src_desc,
        @Const dnnl_memory_desc_t dst_desc, float p, float eps);

/** \} dnnl_api_reduction
 <p>
 *  \} dnnl_api_primitives
 <p>
 *  \addtogroup dnnl_api_engine
 *  \{
 <p>
 *  Returns the number of engines of a particular kind.
 * 
 *  @param kind Kind of engines to count.
 *  @return Count of the engines. */

///
public static native @Cast("size_t") long dnnl_engine_get_count(@Cast("dnnl_engine_kind_t") int kind);

/** Creates an engine.
 * 
 *  @param engine Output engine.
 *  @param kind Engine kind.
 *  @param index Engine index that should be between 0 and the count of
 *      engines of the requested kind.
 *  @return #dnnl_success on success and a status describing the error
 *      otherwise. */

///
public static native @Cast("dnnl_status_t") int dnnl_engine_create(
        @ByPtrPtr dnnl_engine engine, @Cast("dnnl_engine_kind_t") int kind, @Cast("size_t") long index);
public static native @Cast("dnnl_status_t") int dnnl_engine_create(
        @Cast("dnnl_engine_t*") PointerPointer engine, @Cast("dnnl_engine_kind_t") int kind, @Cast("size_t") long index);

/** Returns the kind of an engine.
 * 
 *  @param engine Engine to query.
 *  @param kind Output engine kind.
 *  @return #dnnl_success on success and a status describing the error
 *      otherwise. */

///
public static native @Cast("dnnl_status_t") int dnnl_engine_get_kind(
        dnnl_engine engine, @Cast("dnnl_engine_kind_t*") IntPointer kind);
public static native @Cast("dnnl_status_t") int dnnl_engine_get_kind(
        dnnl_engine engine, @Cast("dnnl_engine_kind_t*") IntBuffer kind);
public static native @Cast("dnnl_status_t") int dnnl_engine_get_kind(
        dnnl_engine engine, @Cast("dnnl_engine_kind_t*") int[] kind);

/** Destroys an engine.
 * 
 *  @param engine Engine to destroy.
 *  @return #dnnl_success on success and a status describing the error
 *      otherwise. */

///
public static native @Cast("dnnl_status_t") int dnnl_engine_destroy(dnnl_engine engine);

/** \} dnnl_api_engine
 <p>
 *  \addtogroup dnnl_api_stream
 *  \{
 <p>
 *  Creates an execution stream.
 * 
 *  @param stream Output execution stream.
 *  @param engine Engine to create the execution stream on.
 *  @param flags Stream behavior flags (@see dnnl_stream_flags_t).
 *  @return #dnnl_success on success and a status describing the error
 *      otherwise. */

///
public static native @Cast("dnnl_status_t") int dnnl_stream_create(
        @ByPtrPtr dnnl_stream stream, dnnl_engine engine, @Cast("unsigned") int flags);
public static native @Cast("dnnl_status_t") int dnnl_stream_create(
        @Cast("dnnl_stream_t*") PointerPointer stream, dnnl_engine engine, @Cast("unsigned") int flags);

/** Returns the engine of a stream object.
 * 
 *  @param stream Stream object.
 *  @param engine Output engine on which the stream is created.
 *  @return #dnnl_success on success and a status describing the error
 *      otherwise. */

///
public static native @Cast("dnnl_status_t") int dnnl_stream_get_engine(
        @Const dnnl_stream stream, @ByPtrPtr dnnl_engine engine);
public static native @Cast("dnnl_status_t") int dnnl_stream_get_engine(
        @Const dnnl_stream stream, @Cast("dnnl_engine_t*") PointerPointer engine);

/** Waits for all primitives in the execution stream to finish computations.
 * 
 *  @param stream Execution stream.
 *  @return #dnnl_success on success and a status describing the error
 *      otherwise. */

///
public static native @Cast("dnnl_status_t") int dnnl_stream_wait(dnnl_stream stream);

/** Destroys an execution stream.
 * 
 *  @param stream Execution stream to destroy.
 *  @return #dnnl_success on success and a status describing the error
 *      otherwise. */

///
public static native @Cast("dnnl_status_t") int dnnl_stream_destroy(dnnl_stream stream);

/** \} dnnl_api_stream
 <p>
 *  \addtogroup dnnl_api_primitive_cache
 *  \{
 <p>
 *  Returns the number of primitives that can be held in the primitive cache
 *  at the same time.
 * 
 *  @param capacity Primitive cache capacity to query. Concurrently
 *  accessing \p capacity is safe.
 *  @return #dnnl_invalid_arguments/#dnnl::status::invalid_arguments if the
 *      \p capacity value is invalid, and #dnnl_success/#dnnl::status::success on
 *      success. */

///
public static native @Cast("dnnl_status_t") int dnnl_get_primitive_cache_capacity(IntPointer _capacity);
public static native @Cast("dnnl_status_t") int dnnl_get_primitive_cache_capacity(IntBuffer _capacity);
public static native @Cast("dnnl_status_t") int dnnl_get_primitive_cache_capacity(int[] _capacity);

/** Sets a number of primitives that can be held in the primitive cache
 *  at a time.
 * 
 *  @param capacity Primitive cache capacity to set. If a new \p capacity is
 *  less than a number of primitives that the primitive cache already has
 *  then the excess entries will be evicted. Setting the \p capacity to 0
 *  clears the primitive cache and disables it. Concurrently modifying
 *  \p capacity is safe.
 *  @return #dnnl_invalid_arguments/#dnnl::status::invalid_arguments if the
 *      \p capacity value is invalid, and #dnnl_success/#dnnl::status::success on
 *      success. */

///
///
public static native @Cast("dnnl_status_t") int dnnl_set_primitive_cache_capacity(int _capacity);

/** \} dnnl_api_primitive_cache
 <p>
 *  \addtogroup dnnl_api_service
 *  \{
 <p>
 *  Configures verbose output to stdout.
 * 
 *  \note
 *      Enabling verbose output affects performance.
 *      This setting overrides the DNNL_VERBOSE environment variable.
 * 
 *  @param level Verbosity level:
 *   - 0: no verbose output (default),
 *   - 1: primitive information at execution,
 *   - 2: primitive information at creation and execution.
 *  @return #dnnl_invalid_arguments/#dnnl::status::invalid_arguments if the
 *      \p level value is invalid, and #dnnl_success/#dnnl::status::success on
 *      success. */

///
///
public static native @Cast("dnnl_status_t") int dnnl_set_verbose(int level);

/** Configures dumping of JIT-generated code.
 * 
 *  \note
 *      This setting overrides the DNNL_JIT_DUMP environment variable.
 * 
 *  @param enable Flag value. Set to 0 to disable and set to 1 to enable.
 *  @return #dnnl_invalid_arguments/#dnnl::status::invalid_arguments if the
 *      \p flag value is invalid, and #dnnl_success/#dnnl::status::success on
 *      success. */
public static native @Cast("dnnl_status_t") int dnnl_set_jit_dump(int enable);

/** Returns library version information.
 *  @return Pointer to a constant structure containing
 *   - major: major version number,
 *   - minor: minor version number,
 *   - patch: patch release number,
 *   - hash: git commit hash. */

///
///
///
///
///
public static native @Const dnnl_version_t dnnl_version();

/** Sets library profiling flags. The flags define which profilers are
 *  supported.
 * 
 *  \note
 *      This setting overrides DNNL_JIT_PROFILE environment variable.
 * 
 *  @see \ref dev_guide_profilers
 * 
 *  @param flags Profiling flags that can contain the following bits:
 *      - \ref DNNL_JIT_PROFILE_VTUNE -- integration with VTune Amplifier
 *          (on by default)
 *      - \ref DNNL_JIT_PROFILE_LINUX_JITDUMP -- produce Linux-specific
 *          jit-pid.dump output (off by default). The location of the output
 *          is controlled via JITDUMPDIR environment variable or via
 *          dnnl_set_jit_profiling_jitdumpdir() function.
 *      - \ref DNNL_JIT_PROFILE_LINUX_PERFMAP -- produce Linux-specific
 *          perf-pid.map output (off by default). The output is always placed
 *          into /tmp.
 * 
 *      Passing \ref DNNL_JIT_PROFILE_NONE disables profiling completely.
 * 
 *  @return #dnnl_invalid_arguments/#dnnl::status::invalid_arguments if the
 *      \p flags value is invalid, and #dnnl_success/#dnnl::status::success on
 *      success. */

///
///
///
///
///
public static native @Cast("dnnl_status_t") int dnnl_set_jit_profiling_flags(@Cast("unsigned") int flags);

/** Sets JIT dump output path. Only applicable to Linux and is only
 *  used when profiling flags have DNNL_JIT_PROFILE_LINUX_PERF bit set.
 * 
 *  After the first JIT kernel is generated, the jitdump output will be placed
 *  into temporary directory created using the mkdtemp template
 *  'dir/.debug/jit/dnnl.XXXXXX'.
 * 
 *  @see \ref dev_guide_profilers
 * 
 *  \note
 *      This setting overrides JITDUMPDIR environment variable.  If
 *      JITDUMPDIR is not set, and this function is never called, the path
 *      defaults to HOME. Passing NULL reverts the value to default.
 * 
 *  \note
 *      The directory is accessed only when the first JIT kernel is being
 *      created. JIT profiling will be disabled in case of any errors
 *      accessing or creating this directory.
 * 
 *  @param dir JIT dump output path.
 *  @return #dnnl_success/#dnnl::status::success if the
 *      output directory was set correctly and an error status otherwise.
 *  @return #dnnl_unimplemented/#dnnl::status::unimplemented on Windows. */

///
///
///
///
///
public static native @Cast("dnnl_status_t") int dnnl_set_jit_profiling_jitdumpdir(@Cast("const char*") BytePointer dir);
public static native @Cast("dnnl_status_t") int dnnl_set_jit_profiling_jitdumpdir(String dir);

/** Sets the maximal ISA the library can dispatch to on the CPU. See
 *  #dnnl_cpu_isa_t and #dnnl::cpu_isa for the list of the values accepted by
 *  the C and C++ API functions respectively.
 * 
 *  This function has effect only once, and returns an error on subsequent
 *  calls. It should also be invoked before any other oneDNN API call, otherwise
 *  it may return an error.
 * 
 *  This function overrides the DNNL_MAX_CPU_ISA environment variable. The
 *  environment variable can be set to the desired maximal ISA name in upper
 *  case and with dnnl_cpu_isa prefix removed. For example:
 *  {@code DNNL_MAX_CPU_ISA=AVX2}.
 * 
 *  \note
 *      The ISAs are only partially ordered:
 *          - SSE41 < AVX < AVX2,
 *          - AVX2 < AVX512_MIC < AVX512_MIC_4OPS,
 *          - AVX2 < AVX512_CORE < AVX512_CORE_VNNI < AVX512_CORE_BF16
 *            < AVX512_CORE_AMX,
 *          - AVX2 < AVX2_VNNI.
 * 
 *  @see \ref dev_guide_cpu_dispatcher_control for more details
 * 
 *  @param isa Maximal ISA the library should dispatch to. Pass
 *      #dnnl_cpu_isa_all/#dnnl::cpu_isa::all to remove ISA restrictions
 *      (except for ISAs with initial support in the library).
 *  @return #dnnl_success/#dnnl::status::success on success and a
 *      #dnnl_invalid_arguments/#dnnl::status::invalid_arguments if the \p isa
 *      parameter is invalid or the ISA cannot be changed at this time.
 *  @return #dnnl_unimplemented/#dnnl::status::unimplemented if the feature
 *      was disabled at build time (see \ref dev_guide_build_options for more
 *      details). */

///
///
public static native @Cast("dnnl_status_t") int dnnl_set_max_cpu_isa(@Cast("dnnl_cpu_isa_t") int isa);

/** Gets the maximal ISA the library can dispatch to on the CPU. See
 *  #dnnl_cpu_isa_t and #dnnl::cpu_isa for the list of the values returned by
 *  the C and C++ API functions respectively.
 * 
 *  @see \ref dev_guide_cpu_dispatcher_control for more details
 * 
 *  @return #dnnl_cpu_isa_t value reflecting the maximal ISA the library may
 *      dispatch to. */

///
///
///
public static native @Cast("dnnl_cpu_isa_t") int dnnl_get_effective_cpu_isa();

/** Sets the hints flag for the CPU ISA. See #dnnl_cpu_isa_hints_t and
 *  #dnnl::cpu_isa_hints for the list of the values accepted by the C and C++
 *  API functions respectively.
 * 
 *  This function has effect only once, and returns an error on subsequent
 *  calls. It should also be invoked before any other oneDNN API call, otherwise
 *  it may return an error.
 * 
 *  This function overrides the DNNL_CPU_ISA_HINTS environment variable.
 *  @see \ref dev_guide_cpu_isa_hints for more details
 * 
 *  @param isa_hints CPU ISA hints to be passed over to the implementation.
 *      Pass #dnnl_cpu_isa_no_hints/#dnnl::cpu_isa_hints::no_hints to use
 *      default features i.e. no hints.
 *  @return #dnnl_success/#dnnl::status::success on success and a
 *      #dnnl_runtime_error/#dnnl::status::runtime_error if the ISA hints cannot
 *      be specified at the current time.
 *  @return #dnnl_unimplemented/#dnnl::status::unimplemented if the feature
 *      was disabled at build time (see \ref dev_guide_build_options for more
 *      details). */

///
///
public static native @Cast("dnnl_status_t") int dnnl_set_cpu_isa_hints(@Cast("dnnl_cpu_isa_hints_t") int isa_hints);

/** Gets the ISA specific hints that library can follow. See
 *  #dnnl_cpu_isa_hints_t and #dnnl::cpu_isa_hints for the list of the values
 *   returned by the C and C++ API functions respectively.
 * 
 *  @see \ref dev_guide_cpu_isa_hints for more details
 * 
 *  @return #dnnl_cpu_isa_hints_t value reflecting the ISA specific hints the
 *  library can follow. */

///
///
///
///
///
///
public static native @Cast("dnnl_cpu_isa_hints_t") int dnnl_get_cpu_isa_hints();

/** \} dnnl_api_service
 <p>
 *  \addtogroup dnnl_api_blas
 *  \{
 <p>
 *  Performs single-precision matrix-matrix multiply.
 * 
 *  The operation is defined as:
 * 
 *  {@code C := alpha * op( A ) * op( B ) + beta * C}
 * 
 *  where
 *   - {@code op( X ) = X} or {@code op( X ) = X**T},
 *   - {@code alpha} and {@code beta} are scalars, and
 *   - {@code A}, {@code B}, and {@code C} are matrices:
 *      - {@code op( A )} is an {@code MxK} matrix,
 *      - {@code op( B )} is an {@code KxN} matrix,
 *      - {@code C} is an {@code MxN} matrix.
 * 
 *  The matrices are assumed to be stored in row-major order (the elements in
 *  each of the matrix rows are contiguous in memory).
 * 
 *  \note
 *      This API does not support XERBLA. Instead, unlike the standard BLAS
 *      functions, this one returns a dnnl_status_t value to allow error
 *      handling.
 * 
 *  @param transa Transposition flag for matrix A: 'N' or 'n' means A is not
 *      transposed, and 'T' or 't' means that A is transposed.
 *  @param transb Transposition flag for matrix B: 'N' or 'n' means B is not
 *      transposed, and 'T' or 't' means that B is transposed.
 *  @param M The M dimension.
 *  @param N The N dimension.
 *  @param K The K dimension.
 *  @param alpha The alpha parameter that is used to scale the product of
 *      matrices A and B.
 *  @param A A pointer to the A matrix data.
 *  @param lda The leading dimension for the matrix A.
 *  @param B A pointer to the B matrix data.
 *  @param ldb The leading dimension for the matrix B.
 *  @param beta The beta parameter that is used to scale the matrix C.
 *  @param C A pointer to the C matrix data.
 *  @param ldc The leading dimension for the matrix C.
 *  @return #dnnl_success/#dnnl::status::success on success and a status
 *      describing the error otherwise. */

///
///
///
///
///
///
///
public static native @Cast("dnnl_status_t") int dnnl_sgemm(@Cast("char") byte transa, @Cast("char") byte transb, @Cast("dnnl_dim_t") long M,
        @Cast("dnnl_dim_t") long N, @Cast("dnnl_dim_t") long K, float alpha, @Const FloatPointer A, @Cast("dnnl_dim_t") long lda,
        @Const FloatPointer B, @Cast("dnnl_dim_t") long ldb, float beta, FloatPointer C, @Cast("dnnl_dim_t") long ldc);
public static native @Cast("dnnl_status_t") int dnnl_sgemm(@Cast("char") byte transa, @Cast("char") byte transb, @Cast("dnnl_dim_t") long M,
        @Cast("dnnl_dim_t") long N, @Cast("dnnl_dim_t") long K, float alpha, @Const FloatBuffer A, @Cast("dnnl_dim_t") long lda,
        @Const FloatBuffer B, @Cast("dnnl_dim_t") long ldb, float beta, FloatBuffer C, @Cast("dnnl_dim_t") long ldc);
public static native @Cast("dnnl_status_t") int dnnl_sgemm(@Cast("char") byte transa, @Cast("char") byte transb, @Cast("dnnl_dim_t") long M,
        @Cast("dnnl_dim_t") long N, @Cast("dnnl_dim_t") long K, float alpha, @Const float[] A, @Cast("dnnl_dim_t") long lda,
        @Const float[] B, @Cast("dnnl_dim_t") long ldb, float beta, float[] C, @Cast("dnnl_dim_t") long ldc);

/** Performs integer matrix-matrix multiply on 8-bit unsigned matrix A, 8-bit
 *  signed matrix B, and 32-bit signed resulting matrix C.
 * 
 *  The operation is defined as:
 * 
 *  {@code C := alpha * (op(A) - A_offset) * (op(B) - B_offset) + beta * C + C_offset}
 * 
 *  where
 *   - {@code op( X ) = X} or {@code op( X ) = X**T},
 *   - {@code alpha} and {@code beta} are scalars, and
 *   - {@code A}, {@code B}, and {@code C} are matrices:
 *      - {@code op( A )} is an {@code MxK} matrix,
 *      - {@code op( B )} is an {@code KxN} matrix,
 *      - {@code C} is an {@code MxN} matrix.
 *   - {@code A_offset} is an {@code MxK} matrix with every element equal the {@code ao} value,
 *   - {@code B_offset} is an {@code KxN} matrix with every element equal the {@code bo} value,
 *   - {@code C_offset} is an {@code MxN} matrix which is defined by the {@code co} array of size {@code len}:
 *     - if {@code offsetc = F}: the {@code len} must be at least {@code 1},
 *     - if {@code offsetc = C}: the {@code len} must be at least {@code max(1, m)},
 *     - if {@code offsetc = R}: the {@code len} must be at least {@code max(1, n)},
 * 
 *  The matrices are assumed to be stored in row-major order (the elements in
 *  each of the matrix rows are contiguous in memory).
 * 
 *  \note
 *      This API does not support XERBLA. Instead, unlike the standard BLAS
 *      functions, this one returns a dnnl_status_t value to allow error
 *      handling.
 * 
 *  \warning
 *      On some architectures saturation may happen during intermediate
 *      computations, which would lead to unexpected results. For more
 *      details, refer to \ref dev_guide_int8_computations.
 * 
 *  @param transa Transposition flag for matrix A: 'N' or 'n' means A is not
 *      transposed, and 'T' or 't' means that A is transposed.
 *  @param transb Transposition flag for matrix B: 'N' or 'n' means B is not
 *      transposed, and 'T' or 't' means that B is transposed.
 *  @param offsetc Flag specifying how offsets should be applied to matrix C:
 *      - 'F' means that the same offset will be applied to each element of
 *          the matrix C,
 *      - 'C' means that individual offset will be applied to each element
 *          within each column,
 *      - 'R' means that individual offset will be applied to each element
 *          within each row.
 *  @param M The M dimension.
 *  @param N The N dimension.
 *  @param K The K dimension.
 *  @param alpha The alpha parameter that is used to scale the product of
 *      matrices A and B.
 *  @param A A pointer to the A matrix data.
 *  @param lda The leading dimension for the matrix A.
 *  @param ao The offset value for the matrix A.
 *  @param B A pointer to the B matrix data.
 *  @param ldb The leading dimension for the matrix B.
 *  @param bo The offset value for the matrix B.
 *  @param beta The beta parameter that is used to scale the matrix C.
 *  @param C A pointer to the C matrix data.
 *  @param ldc The leading dimension for the matrix C.
 *  @param co An array of offset values for the matrix C. The number of
 *      elements in the array depends on the value of \p offsetc.
 *  @return #dnnl_success/#dnnl::status::success on success and a status
 *      describing the error otherwise. */

///
///
///
///
///
///
///
public static native @Cast("dnnl_status_t") int dnnl_gemm_u8s8s32(@Cast("char") byte transa, @Cast("char") byte transb, @Cast("char") byte offsetc,
        @Cast("dnnl_dim_t") long M, @Cast("dnnl_dim_t") long N, @Cast("dnnl_dim_t") long K, float alpha, @Cast("const uint8_t*") BytePointer A,
        @Cast("dnnl_dim_t") long lda, @Cast("uint8_t") byte ao, @Const BytePointer B, @Cast("dnnl_dim_t") long ldb, byte bo,
        float beta, IntPointer C, @Cast("dnnl_dim_t") long ldc, @Const IntPointer co);
public static native @Cast("dnnl_status_t") int dnnl_gemm_u8s8s32(@Cast("char") byte transa, @Cast("char") byte transb, @Cast("char") byte offsetc,
        @Cast("dnnl_dim_t") long M, @Cast("dnnl_dim_t") long N, @Cast("dnnl_dim_t") long K, float alpha, @Cast("const uint8_t*") ByteBuffer A,
        @Cast("dnnl_dim_t") long lda, @Cast("uint8_t") byte ao, @Const ByteBuffer B, @Cast("dnnl_dim_t") long ldb, byte bo,
        float beta, IntBuffer C, @Cast("dnnl_dim_t") long ldc, @Const IntBuffer co);
public static native @Cast("dnnl_status_t") int dnnl_gemm_u8s8s32(@Cast("char") byte transa, @Cast("char") byte transb, @Cast("char") byte offsetc,
        @Cast("dnnl_dim_t") long M, @Cast("dnnl_dim_t") long N, @Cast("dnnl_dim_t") long K, float alpha, @Cast("const uint8_t*") byte[] A,
        @Cast("dnnl_dim_t") long lda, @Cast("uint8_t") byte ao, @Const byte[] B, @Cast("dnnl_dim_t") long ldb, byte bo,
        float beta, int[] C, @Cast("dnnl_dim_t") long ldc, @Const int[] co);

/** Performs integer matrix-matrix multiply on 8-bit signed matrix A, 8-bit
 *  signed matrix B, and 32-bit signed resulting matrix C.
 * 
 *  The operation is defined as:
 * 
 *  {@code C := alpha * (op(A) - A_offset) * (op(B) - B_offset) + beta * C + C_offset}
 * 
 *  where
 *   - {@code op( X ) = X} or {@code op( X ) = X**T},
 *   - {@code alpha} and {@code beta} are scalars, and
 *   - {@code A}, {@code B}, and {@code C} are matrices:
 *      - {@code op( A )} is an {@code MxK} matrix,
 *      - {@code op( B )} is an {@code KxN} matrix,
 *      - {@code C} is an {@code MxN} matrix.
 *   - {@code A_offset} is an {@code MxK} matrix with every element equal the {@code ao} value,
 *   - {@code B_offset} is an {@code KxN} matrix with every element equal the {@code bo} value,
 *   - {@code C_offset} is an {@code MxN} matrix which is defined by the {@code co} array of size {@code len}:
 *     - if {@code offsetc = F}: the {@code len} must be at least {@code 1},
 *     - if {@code offsetc = C}: the {@code len} must be at least {@code max(1, m)},
 *     - if {@code offsetc = R}: the {@code len} must be at least {@code max(1, n)},
 * 
 *  The matrices are assumed to be stored in row-major order (the elements in
 *  each of the matrix rows are contiguous in memory).
 * 
 *  \note
 *      This API does not support XERBLA. Instead, unlike the standard BLAS
 *      functions, this one returns a dnnl_status_t value to allow error
 *      handling.
 * 
 *  \warning
 *      On some architectures saturation may happen during intermediate
 *      computations, which would lead to unexpected results. For more
 *      details, refer to \ref dev_guide_int8_computations.
 * 
 *  @param transa Transposition flag for matrix A: 'N' or 'n' means A is not
 *      transposed, and 'T' or 't' means that A is transposed.
 *  @param transb Transposition flag for matrix B: 'N' or 'n' means B is not
 *      transposed, and 'T' or 't' means that B is transposed.
 *  @param offsetc Flag specifying how offsets should be applied to matrix C:
 *      - 'F' means that the same offset will be applied to each element of
 *          the matrix C,
 *      - 'C' means that individual offset will be applied to each element
 *          within each column,
 *      - 'R' means that individual offset will be applied to each element
 *          within each row.
 *  @param M The M dimension.
 *  @param N The N dimension.
 *  @param K The K dimension.
 *  @param alpha The alpha parameter that is used to scale the product of
 *      matrices A and B.
 *  @param A A pointer to the A matrix data.
 *  @param lda The leading dimension for the matrix A.
 *  @param ao The offset value for the matrix A.
 *  @param B A pointer to the B matrix data.
 *  @param ldb The leading dimension for the matrix B.
 *  @param bo The offset value for the matrix B.
 *  @param beta The beta parameter that is used to scale the matrix C.
 *  @param C A pointer to the C matrix data.
 *  @param ldc The leading dimension for the matrix C.
 *  @param co An array of offset values for the matrix C. The number of
 *      elements in the array depends on the value of \p offsetc.
 *  @return #dnnl_success/#dnnl::status::success on success and a status
 *      describing the error otherwise. */
public static native @Cast("dnnl_status_t") int dnnl_gemm_s8s8s32(@Cast("char") byte transa, @Cast("char") byte transb, @Cast("char") byte offsetc,
        @Cast("dnnl_dim_t") long M, @Cast("dnnl_dim_t") long N, @Cast("dnnl_dim_t") long K, float alpha, @Const BytePointer A,
        @Cast("dnnl_dim_t") long lda, byte ao, @Const BytePointer B, @Cast("dnnl_dim_t") long ldb, byte bo,
        float beta, IntPointer C, @Cast("dnnl_dim_t") long ldc, @Const IntPointer co);
public static native @Cast("dnnl_status_t") int dnnl_gemm_s8s8s32(@Cast("char") byte transa, @Cast("char") byte transb, @Cast("char") byte offsetc,
        @Cast("dnnl_dim_t") long M, @Cast("dnnl_dim_t") long N, @Cast("dnnl_dim_t") long K, float alpha, @Const ByteBuffer A,
        @Cast("dnnl_dim_t") long lda, byte ao, @Const ByteBuffer B, @Cast("dnnl_dim_t") long ldb, byte bo,
        float beta, IntBuffer C, @Cast("dnnl_dim_t") long ldc, @Const IntBuffer co);
public static native @Cast("dnnl_status_t") int dnnl_gemm_s8s8s32(@Cast("char") byte transa, @Cast("char") byte transb, @Cast("char") byte offsetc,
        @Cast("dnnl_dim_t") long M, @Cast("dnnl_dim_t") long N, @Cast("dnnl_dim_t") long K, float alpha, @Const byte[] A,
        @Cast("dnnl_dim_t") long lda, byte ao, @Const byte[] B, @Cast("dnnl_dim_t") long ldb, byte bo,
        float beta, int[] C, @Cast("dnnl_dim_t") long ldc, @Const int[] co);

/** \} dnnl_api_blas
 <p>
 *  \} dnnl_api */

// #ifdef __cplusplus
// #endif

// #endif /* ONEAPI_DNNL_DNNL_H */


// Parsed from oneapi/dnnl/dnnl.hpp

/*******************************************************************************
* Copyright 2016-2021 Intel Corporation
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*******************************************************************************/

/** \file
/** C++ API */

// #ifndef ONEAPI_DNNL_DNNL_HPP
// #define ONEAPI_DNNL_DNNL_HPP

// #include "oneapi/dnnl/dnnl_config.h"

/** \cond DO_NOT_DOCUMENT_THIS */
// #include <algorithm>
// #include <cstdlib>
// #include <iterator>
// #include <memory>
// #include <string>
// #include <vector>
// #include <unordered_map>

// #include "oneapi/dnnl/dnnl.h"

/** \endcond */

// __cpp_exceptions is referred from
// https://gcc.gnu.org/onlinedocs/libstdc++/manual/using_exceptions.html
// gcc < 5 does not define __cpp_exceptions but __EXCEPTIONS,
// Microsoft C++ Compiler does not provide an option to disable exceptions
// #ifndef DNNL_ENABLE_EXCEPTIONS
// #if __cpp_exceptions || __EXCEPTIONS
//         || (defined(_MSC_VER) && !defined(__clang__))
public static final int DNNL_ENABLE_EXCEPTIONS = 1;
// #else
// #endif
// #endif

// #if defined(__GNUC__) || defined(__clang__)
// #define DNNL_TRAP() __builtin_trap()
// #elif defined(__INTEL_COMPILER) || defined(_MSC_VER)
// #define DNNL_TRAP() __debugbreak()
// #else
// #error "unknown compiler"
// #endif

// #if DNNL_ENABLE_EXCEPTIONS
// #define DNNL_THROW_ERROR(status, msg) throw error(status, msg)
// #else
// #endif

/** \addtogroup dnnl_api oneDNN API
 *  \{
 <p>
 *  oneDNN namespace */
// Targeting ../error.java



/** \cond DO_NOT_DOCUMENT_THIS */
/** \endcond
 <p>
 *  A class that provides the destructor for a oneDNN C API handle. */
// Targeting ../dnnl_engine_handle.java


// Targeting ../dnnl_memory_handle.java


// Targeting ../dnnl_primitive_desc_handle.java


// Targeting ../dnnl_primitive_attr_handle.java


// Targeting ../dnnl_post_ops_handle.java


// Targeting ../dnnl_primitive_handle.java


// Targeting ../dnnl_stream_handle.java



/** \cond DO_NOT_DOCUMENT_THIS */
/** \endcond
 <p>
 *  \} dnnl_api_utils */
// Targeting ../primitive.java



/** Converts primitive kind enum value from C++ API to C API type.
 * 
 *  @param akind C++ API primitive kind enum value.
 *  @return Corresponding C API primitive kind enum value. */
@Namespace("dnnl") public static native @Cast("dnnl_primitive_kind_t") int convert_to_c(primitive.kind akind);





/** \} dnnl_api_primitives_common
 <p>
 *  \addtogroup dnnl_api_attributes
 * 
 *  A container for parameters that extend primitives behavior.
 * 
 *  Attributes can also contain Post-ops, which are computations executed
 *  after the primitive.
 * 
 *  @see \ref dev_guide_attributes
 *  @see \ref dev_guide_attributes_post_ops
 * 
 *  \{
 <p>
 *  Scratchpad mode */
@Namespace("dnnl") public enum scratchpad_mode {
    /** The library manages the scratchpad allocation according to the policy
     *  specified by the {@code DNNL_ENABLE_CONCURRENT_EXEC}
     *  [build option](\ref dev_guide_build_options) (default).
     * 
     *  When {@code DNNL_ENABLE_CONCURRENT_EXEC=OFF} (default), the library
     *  scratchpad is common to all primitives to reduce the memory footprint.
     *  This configuration comes with limited thread-safety properties, namely
     *  primitives can be created and executed in parallel but cannot migrate
     *  between threads (in other words, each primitive should be executed in
     *  the same thread it was created in).
     * 
     *  When {@code DNNL_ENABLE_CONCURRENT_EXEC=ON}, the library scratchpad is
     *  private to each primitive. The memory footprint is larger than when
     *  using {@code DNNL_ENABLE_CONCURRENT_EXEC=OFF} but different primitives can be
     *  created and run concurrently (the same primitive cannot be run
     *  concurrently from two different threads though). */
    library(dnnl_scratchpad_mode_library),
    /** The user manages the scratchpad allocation by querying and providing
     *  the scratchpad memory to primitives. This mode is thread-safe as long
     *  as the scratchpad buffers are not used concurrently by two primitive
     *  executions. */
    user(dnnl_scratchpad_mode_user);

    public final int value;
    private scratchpad_mode(int v) { this.value = v; }
    private scratchpad_mode(scratchpad_mode e) { this.value = e.value; }
    public scratchpad_mode intern() { for (scratchpad_mode e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

/** Converts a scratchpad mode enum value from C++ API to C API type.
 * 
 *  @param mode C++ API scratchpad mode enum value.
 *  @return Corresponding C API scratchpad mode enum value. */
@Namespace("dnnl") public static native @Cast("dnnl_scratchpad_mode_t") int convert_to_c(scratchpad_mode mode);
@Namespace("dnnl") public static native @Cast("dnnl_scratchpad_mode_t") int convert_to_c(@Cast("dnnl::scratchpad_mode") int mode);

/** Propagation kind. */
@Namespace("dnnl") public enum prop_kind {
    /** Undefined propagation kind. */
    undef(dnnl_prop_kind_undef),
    /** Forward data propagation (training mode). In this mode, primitives
     *  perform computations necessary for subsequent backward propagation. */
    forward_training(dnnl_forward_training),
    /** Forward data propagation (inference mode). In this mode, primitives
     *  perform only computations that are necessary for inference and omit
     *  computations that are necessary only for backward propagation. */
    forward_inference(dnnl_forward_inference),
    /** Forward data propagation,
     *  alias for #dnnl::prop_kind::forward_inference. */
    forward_scoring(dnnl_forward_scoring),
    /** Forward data propagation,
     *  alias for #dnnl::prop_kind::forward_training. */
    forward(dnnl_forward),
    /** Backward propagation (with respect to all parameters). */
    backward(dnnl_backward),
    /** Backward data propagation. */
    backward_data(dnnl_backward_data),
    /** Backward weights propagation. */
    backward_weights(dnnl_backward_weights),
    /** Backward bias propagation. */
    backward_bias(dnnl_backward_bias);

    public final int value;
    private prop_kind(int v) { this.value = v; }
    private prop_kind(prop_kind e) { this.value = e.value; }
    public prop_kind intern() { for (prop_kind e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

/** Converts propagation kind enum value from C++ API to C API type.
 * 
 *  @param akind C++ API propagation kind enum value.
 *  @return Corresponding C API propagation kind enum value. */
@Namespace("dnnl") public static native @Cast("dnnl_prop_kind_t") int convert_to_c(prop_kind akind);

/** Kinds of algorithms. */
@Namespace("dnnl") public enum algorithm {
    /** Undefined algorithm */
    undef(dnnl_alg_kind_undef),
    /** Convolution algorithm that is chosen to be either direct or Winograd
     *  automatically */
    convolution_auto(dnnl_convolution_auto),
    /** Direct convolution */
    convolution_direct(dnnl_convolution_direct),
    /** Winograd convolution */
    convolution_winograd(dnnl_convolution_winograd),
    /** Direct deconvolution */
    deconvolution_direct(dnnl_deconvolution_direct),
    /** Winograd deconvolution */
    deconvolution_winograd(dnnl_deconvolution_winograd),
    /** Elementwise: rectified linear unit (ReLU) */
    eltwise_relu(dnnl_eltwise_relu),
    /** Elementwise: hyperbolic tangent non-linearity (tanh) */
    eltwise_tanh(dnnl_eltwise_tanh),
    /** Elementwise: exponential linear unit (ELU) */
    eltwise_elu(dnnl_eltwise_elu),
    /** Elementwise: square */
    eltwise_square(dnnl_eltwise_square),
    /** Elementwise: abs */
    eltwise_abs(dnnl_eltwise_abs),
    /** Elementwise: square root */
    eltwise_sqrt(dnnl_eltwise_sqrt),
    /** Elementwise: swish ({@code x \cdot sigmoid(a \cdot x)}) */
    eltwise_swish(dnnl_eltwise_swish),
    /** Elementwise: linear */
    eltwise_linear(dnnl_eltwise_linear),
    /** Elementwise: bounded_relu */
    eltwise_bounded_relu(dnnl_eltwise_bounded_relu),
    /** Elementwise: soft_relu */
    eltwise_soft_relu(dnnl_eltwise_soft_relu),
    /** Elementwise: logsigmoid */
    eltwise_logsigmoid(dnnl_eltwise_logsigmoid),
    /** Elementwise: mish */
    eltwise_mish(dnnl_eltwise_mish),
    /** Elementwise: logistic */
    eltwise_logistic(dnnl_eltwise_logistic),
    /** Elementwise: exponent */
    eltwise_exp(dnnl_eltwise_exp),
    /** Elementwise: gelu
     *  alias for #dnnl::algorithm::eltwise_gelu_tanh */
    eltwise_gelu(dnnl_eltwise_gelu),
    /** Elementwise: tanh-based gelu */
    eltwise_gelu_tanh(dnnl_eltwise_gelu_tanh),
    /** Elementwise: erf-based gelu */
    eltwise_gelu_erf(dnnl_eltwise_gelu_erf),
    /** Elementwise: natural logarithm */
    eltwise_log(dnnl_eltwise_log),
    /** Elementwise: clip */
    eltwise_clip(dnnl_eltwise_clip),
    /** Eltwise: clip version 2 */
    eltwise_clip_v2(dnnl_eltwise_clip_v2),
    /** Elementwise: pow */
    eltwise_pow(dnnl_eltwise_pow),
    /** Elementwise: round */
    eltwise_round(dnnl_eltwise_round),
    /** Elementwise: hardswish */
    eltwise_hardswish(dnnl_eltwise_hardswish),
    /** Elementwise: rectified linar unit (ReLU) (dst for backward) */
    eltwise_relu_use_dst_for_bwd(dnnl_eltwise_relu_use_dst_for_bwd),
    /** Elementwise: hyperbolic tangent non-linearity (tanh) (dst for backward) */
    eltwise_tanh_use_dst_for_bwd(dnnl_eltwise_tanh_use_dst_for_bwd),
    /** Elementwise: exponential linear unit (ELU) (dst for backward) */
    eltwise_elu_use_dst_for_bwd(dnnl_eltwise_elu_use_dst_for_bwd),
    /** Elementwise: square root (dst for backward) */
    eltwise_sqrt_use_dst_for_bwd(dnnl_eltwise_sqrt_use_dst_for_bwd),
    /** Elementwise: logistic (dst for backward) */
    eltwise_logistic_use_dst_for_bwd(dnnl_eltwise_logistic_use_dst_for_bwd),
    /** Elementwise: exponent (dst for backward) */
    eltwise_exp_use_dst_for_bwd(dnnl_eltwise_exp_use_dst_for_bwd),
    /** Elementwise: clip version 2 (dst for backward) */
    eltwise_clip_v2_use_dst_for_bwd(dnnl_eltwise_clip_v2_use_dst_for_bwd),
    /** Local response normalization (LRN) across multiple channels */
    lrn_across_channels(dnnl_lrn_across_channels),
    /** LRN within a single channel */
    lrn_within_channel(dnnl_lrn_within_channel),
    /** Max pooling */
    pooling_max(dnnl_pooling_max),
    /** Average pooling exclude padding,
     *  alias for #dnnl::algorithm::pooling_avg_exclude_padding */
    pooling_avg(dnnl_pooling_avg),
    /** Average pooling include padding */
    pooling_avg_include_padding(dnnl_pooling_avg_include_padding),
    /** Average pooling exclude padding */
    pooling_avg_exclude_padding(dnnl_pooling_avg_exclude_padding),
    /** RNN cell */
    vanilla_rnn(dnnl_vanilla_rnn),
    /** LSTM cell */
    vanilla_lstm(dnnl_vanilla_lstm),
    /** GRU cell */
    vanilla_gru(dnnl_vanilla_gru),
    /** GRU cell with linear before reset. Differs from the vanilla GRU
     *  in how the new memory gate is calculated:
     *  {@code c_t = tanh(W_c*x_t + b_{c_x} + r_t*(U_c*h_{t-1}+b_{c_h})) }
     *  LRB GRU expects 4 bias tensors on input:
     *  {@code [b_{u}, b_{r}, b_{c_x}, b_{c_h}]} */
    lbr_gru(dnnl_lbr_gru),
    /** Binary add */
    binary_add(dnnl_binary_add),
    /** Binary mul */
    binary_mul(dnnl_binary_mul),
    /** Binary max */
    binary_max(dnnl_binary_max),
    /** Binary min */
    binary_min(dnnl_binary_min),
    /** Binary div */
    binary_div(dnnl_binary_div),
    /** Binary sub */
    binary_sub(dnnl_binary_sub),
    /** Binary greater than or equal */
    binary_ge(dnnl_binary_ge),
    /** Binary greater than */
    binary_gt(dnnl_binary_gt),
    /** Binary less than or equal */
    binary_le(dnnl_binary_le),
    /** Binary less than */
    binary_lt(dnnl_binary_lt),
    /** Binary equal */
    binary_eq(dnnl_binary_eq),
    /** Binary not equal */
    binary_ne(dnnl_binary_ne),
    /** Nearest Neighbor resampling method */
    resampling_nearest(dnnl_resampling_nearest),
    /** Linear (Bilinear, Trilinear) resampling method */
    resampling_linear(dnnl_resampling_linear),
    /** Reduction using max operation */
    reduction_max(dnnl_reduction_max),
    /** Reduction using min operation */
    reduction_min(dnnl_reduction_min),
    /** Reduction using sum operation */
    reduction_sum(dnnl_reduction_sum),
    /** Reduction using mul operation */
    reduction_mul(dnnl_reduction_mul),
    /** Reduction using mean operation */
    reduction_mean(dnnl_reduction_mean),
    /** Reduction using norm_lp_max operation */
    reduction_norm_lp_max(dnnl_reduction_norm_lp_max),
    /** Reduction using norm_lp_sum operation */
    reduction_norm_lp_sum(dnnl_reduction_norm_lp_sum),
    /** Reduction using norm_lp_power_p_max operation */
    reduction_norm_lp_power_p_max(dnnl_reduction_norm_lp_power_p_max),
    /** Reduction using norm_lp_power_p_sum operation */
    reduction_norm_lp_power_p_sum(dnnl_reduction_norm_lp_power_p_sum);

    public final int value;
    private algorithm(int v) { this.value = v; }
    private algorithm(algorithm e) { this.value = e.value; }
    public algorithm intern() { for (algorithm e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

/** Converts algorithm kind enum value from C++ API to C API type.
 *  @param aalgorithm C++ API algorithm kind enum value.
 *  @return Corresponding C API algorithm kind enum value. */
@Namespace("dnnl") public static native @Cast("dnnl_alg_kind_t") int convert_to_c(algorithm aalgorithm);

/** \} dnnl_api_attributes
 <p>
 *  \addtogroup dnnl_api_primitives_common
 *  \{
 <p>
 *  Flags for normalization primitives. */
@Namespace("dnnl") public enum normalization_flags {
    /** Use no normalization flags. If specified, the library computes mean and
     *  variance on forward propagation for training and inference, outputs them
     *  on forward propagation for training, and computes the respective
     *  derivatives on backward propagation. */
    none(dnnl_normalization_flags_none),

    /** Use global statistics. If specified, the library uses mean and
     *  variance provided by the user as an input on forward propagation and
     *  does not compute their derivatives on backward propagation. Otherwise,
     *  the library computes mean and variance on forward propagation for
     *  training and inference, outputs them on forward propagation for
     *  training, and computes the respective derivatives on backward
     *  propagation. */
    use_global_stats(dnnl_use_global_stats),

    /** Use scale and shift parameters. If specified, the user is expected to
     *  pass scale and shift as inputs on forward propagation. On backward
     *  propagation of type #dnnl::prop_kind::backward, the library computes
     *  their derivatives. If not specified, the scale and shift parameters
     *  are not used by the library in any way. */
    use_scale_shift(dnnl_use_scaleshift),

    /** Fuse normalization with ReLU. On training, normalization will require
     *  the workspace to implement backward propagation. On inference, the
     *  workspace is not required and behavior is the same as when normalization
     *  is fused with ReLU using the post-ops API. */
    fuse_norm_relu(dnnl_fuse_norm_relu),

    /** Use scale parameter. If specified, the user is expected to pass scale as
     *  input on forward propagation. On backward propagation of type
     *  #dnnl::prop_kind::backward, the library computes its derivative. */
    use_scale(dnnl_use_scale),

    /** Use shift parameter. If specified, the user is expected to pass shift as
     *  input on forward propagation. On backward propagation of type
     *  #dnnl::prop_kind::backward, the library computes its derivative. */
    use_shift(dnnl_use_shift);

    public final int value;
    private normalization_flags(int v) { this.value = v; }
    private normalization_flags(normalization_flags e) { this.value = e.value; }
    public normalization_flags intern() { for (normalization_flags e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

/** Converts normalization flags enum value from C++ API to C API type.
 *  @param flags C++ API normalization flags enum value.
 *  @return Corresponding C API normalization flags enum value. */
@Namespace("dnnl") public static native @Cast("dnnl_normalization_flags_t") int convert_to_c(normalization_flags flags);

/** \} dnnl_api_primitives_common
 <p>
 *  \addtogroup dnnl_api_rnn
 *  \{
 <p>
 *  RNN cell flags. */
@Namespace("dnnl") public enum rnn_flags {
    /** Undefined RNN flags */
    undef(dnnl_rnn_flags_undef);

    public final int value;
    private rnn_flags(int v) { this.value = v; }
    private rnn_flags(rnn_flags e) { this.value = e.value; }
    public rnn_flags intern() { for (rnn_flags e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

/** Converts RNN cell flags enum value from C++ API to C API type.
 *  @param flags C++ API RNN cell flags enum value.
 *  @return Corresponding C API RNN cell flags enum value. */
@Namespace("dnnl") public static native @Cast("dnnl_rnn_flags_t") int convert_to_c(rnn_flags flags);

// #define DNNL_DEFINE_BITMASK_OPS(enum_name)
//     inline enum_name operator|(enum_name lhs, enum_name rhs) {
//         return static_cast<enum_name>(
//                 static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs));
//     }
// 
//     inline enum_name operator&(enum_name lhs, enum_name rhs) {
//         return static_cast<enum_name>(
//                 static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs));
//     }
// 
//     inline enum_name operator^(enum_name lhs, enum_name rhs) {
//         return static_cast<enum_name>(
//                 static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs));
//     }
// 
//     inline enum_name &operator|=(enum_name &lhs, enum_name rhs) {
//         lhs = static_cast<enum_name>(
//                 static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs));
//         return lhs;
//     }
// 
//     inline enum_name &operator&=(enum_name &lhs, enum_name rhs) {
//         lhs = static_cast<enum_name>(
//                 static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs));
//         return lhs;
//     }
// 
//     inline enum_name &operator^=(enum_name &lhs, enum_name rhs) {
//         lhs = static_cast<enum_name>(
//                 static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs));
//         return lhs;
//     }
// 
//     inline enum_name operator~(enum_name rhs) {
//         return static_cast<enum_name>(~static_cast<unsigned>(rhs));
//     }

@Namespace("dnnl") public static native @Name("operator |") normalization_flags or(normalization_flags lhs, normalization_flags rhs);
@Namespace("dnnl") public static native @Name("operator |") @Cast("dnnl::normalization_flags") int or(@Cast("dnnl::normalization_flags") int lhs, @Cast("dnnl::normalization_flags") int rhs);

    @Namespace("dnnl") public static native @Name("operator &") normalization_flags and(normalization_flags lhs, normalization_flags rhs);
    @Namespace("dnnl") public static native @Name("operator &") @Cast("dnnl::normalization_flags") int and(@Cast("dnnl::normalization_flags") int lhs, @Cast("dnnl::normalization_flags") int rhs);

    @Namespace("dnnl") public static native @Name("operator ^") normalization_flags xor(normalization_flags lhs, normalization_flags rhs);
    @Namespace("dnnl") public static native @Name("operator ^") @Cast("dnnl::normalization_flags") int xor(@Cast("dnnl::normalization_flags") int lhs, @Cast("dnnl::normalization_flags") int rhs);

    @Namespace("dnnl") public static native @ByRef @Name("operator |=") @Cast("dnnl::normalization_flags*") IntPointer orPut(@ByRef @Cast("dnnl::normalization_flags*") IntPointer lhs, normalization_flags rhs);
    @Namespace("dnnl") public static native @ByRef @Name("operator |=") @Cast("dnnl::normalization_flags*") IntBuffer orPut(@ByRef @Cast("dnnl::normalization_flags*") IntBuffer lhs, @Cast("dnnl::normalization_flags") int rhs);
    @Namespace("dnnl") public static native @ByRef @Name("operator |=") @Cast("dnnl::normalization_flags*") int[] orPut(@ByRef @Cast("dnnl::normalization_flags*") int[] lhs, normalization_flags rhs);
    @Namespace("dnnl") public static native @ByRef @Name("operator |=") @Cast("dnnl::normalization_flags*") IntPointer orPut(@ByRef @Cast("dnnl::normalization_flags*") IntPointer lhs, @Cast("dnnl::normalization_flags") int rhs);
    @Namespace("dnnl") public static native @ByRef @Name("operator |=") @Cast("dnnl::normalization_flags*") IntBuffer orPut(@ByRef @Cast("dnnl::normalization_flags*") IntBuffer lhs, normalization_flags rhs);
    @Namespace("dnnl") public static native @ByRef @Name("operator |=") @Cast("dnnl::normalization_flags*") int[] orPut(@ByRef @Cast("dnnl::normalization_flags*") int[] lhs, @Cast("dnnl::normalization_flags") int rhs);

    @Namespace("dnnl") public static native @ByRef @Name("operator &=") @Cast("dnnl::normalization_flags*") IntPointer andPut(@ByRef @Cast("dnnl::normalization_flags*") IntPointer lhs, normalization_flags rhs);
    @Namespace("dnnl") public static native @ByRef @Name("operator &=") @Cast("dnnl::normalization_flags*") IntBuffer andPut(@ByRef @Cast("dnnl::normalization_flags*") IntBuffer lhs, @Cast("dnnl::normalization_flags") int rhs);
    @Namespace("dnnl") public static native @ByRef @Name("operator &=") @Cast("dnnl::normalization_flags*") int[] andPut(@ByRef @Cast("dnnl::normalization_flags*") int[] lhs, normalization_flags rhs);
    @Namespace("dnnl") public static native @ByRef @Name("operator &=") @Cast("dnnl::normalization_flags*") IntPointer andPut(@ByRef @Cast("dnnl::normalization_flags*") IntPointer lhs, @Cast("dnnl::normalization_flags") int rhs);
    @Namespace("dnnl") public static native @ByRef @Name("operator &=") @Cast("dnnl::normalization_flags*") IntBuffer andPut(@ByRef @Cast("dnnl::normalization_flags*") IntBuffer lhs, normalization_flags rhs);
    @Namespace("dnnl") public static native @ByRef @Name("operator &=") @Cast("dnnl::normalization_flags*") int[] andPut(@ByRef @Cast("dnnl::normalization_flags*") int[] lhs, @Cast("dnnl::normalization_flags") int rhs);

    @Namespace("dnnl") public static native @ByRef @Name("operator ^=") @Cast("dnnl::normalization_flags*") IntPointer xorPut(@ByRef @Cast("dnnl::normalization_flags*") IntPointer lhs, normalization_flags rhs);
    @Namespace("dnnl") public static native @ByRef @Name("operator ^=") @Cast("dnnl::normalization_flags*") IntBuffer xorPut(@ByRef @Cast("dnnl::normalization_flags*") IntBuffer lhs, @Cast("dnnl::normalization_flags") int rhs);
    @Namespace("dnnl") public static native @ByRef @Name("operator ^=") @Cast("dnnl::normalization_flags*") int[] xorPut(@ByRef @Cast("dnnl::normalization_flags*") int[] lhs, normalization_flags rhs);
    @Namespace("dnnl") public static native @ByRef @Name("operator ^=") @Cast("dnnl::normalization_flags*") IntPointer xorPut(@ByRef @Cast("dnnl::normalization_flags*") IntPointer lhs, @Cast("dnnl::normalization_flags") int rhs);
    @Namespace("dnnl") public static native @ByRef @Name("operator ^=") @Cast("dnnl::normalization_flags*") IntBuffer xorPut(@ByRef @Cast("dnnl::normalization_flags*") IntBuffer lhs, normalization_flags rhs);
    @Namespace("dnnl") public static native @ByRef @Name("operator ^=") @Cast("dnnl::normalization_flags*") int[] xorPut(@ByRef @Cast("dnnl::normalization_flags*") int[] lhs, @Cast("dnnl::normalization_flags") int rhs);

    @Namespace("dnnl") public static native @Name("operator ~") normalization_flags not(normalization_flags rhs);
    @Namespace("dnnl") public static native @Name("operator ~") @Cast("dnnl::normalization_flags") int not(@Cast("dnnl::normalization_flags") int rhs);
@Namespace("dnnl") public static native @Name("operator |") rnn_flags or(rnn_flags lhs, rnn_flags rhs);

    @Namespace("dnnl") public static native @Name("operator &") rnn_flags and(rnn_flags lhs, rnn_flags rhs);

    @Namespace("dnnl") public static native @Name("operator ^") rnn_flags xor(rnn_flags lhs, rnn_flags rhs);

    @Namespace("dnnl") public static native @ByRef @Name("operator |=") @Cast("dnnl::rnn_flags*") IntPointer orPut(@ByRef @Cast("dnnl::rnn_flags*") IntPointer lhs, rnn_flags rhs);
    @Namespace("dnnl") public static native @ByRef @Name("operator |=") @Cast("dnnl::rnn_flags*") int[] orPut(@ByRef @Cast("dnnl::rnn_flags*") int[] lhs, rnn_flags rhs);
    @Namespace("dnnl") public static native @ByRef @Name("operator |=") @Cast("dnnl::rnn_flags*") IntBuffer orPut(@ByRef @Cast("dnnl::rnn_flags*") IntBuffer lhs, rnn_flags rhs);

    @Namespace("dnnl") public static native @ByRef @Name("operator &=") @Cast("dnnl::rnn_flags*") IntPointer andPut(@ByRef @Cast("dnnl::rnn_flags*") IntPointer lhs, rnn_flags rhs);
    @Namespace("dnnl") public static native @ByRef @Name("operator &=") @Cast("dnnl::rnn_flags*") int[] andPut(@ByRef @Cast("dnnl::rnn_flags*") int[] lhs, rnn_flags rhs);
    @Namespace("dnnl") public static native @ByRef @Name("operator &=") @Cast("dnnl::rnn_flags*") IntBuffer andPut(@ByRef @Cast("dnnl::rnn_flags*") IntBuffer lhs, rnn_flags rhs);

    @Namespace("dnnl") public static native @ByRef @Name("operator ^=") @Cast("dnnl::rnn_flags*") IntPointer xorPut(@ByRef @Cast("dnnl::rnn_flags*") IntPointer lhs, rnn_flags rhs);
    @Namespace("dnnl") public static native @ByRef @Name("operator ^=") @Cast("dnnl::rnn_flags*") int[] xorPut(@ByRef @Cast("dnnl::rnn_flags*") int[] lhs, rnn_flags rhs);
    @Namespace("dnnl") public static native @ByRef @Name("operator ^=") @Cast("dnnl::rnn_flags*") IntBuffer xorPut(@ByRef @Cast("dnnl::rnn_flags*") IntBuffer lhs, rnn_flags rhs);

    @Namespace("dnnl") public static native @Name("operator ~") rnn_flags not(rnn_flags rhs);

/** A direction of RNN primitive execution */
@Namespace("dnnl") public enum rnn_direction {
    /** Unidirectional execution of RNN primitive from left to right. */
    unidirectional_left2right(dnnl_unidirectional_left2right),
    /** Unidirectional execution of RNN primitive from right to left. */
    unidirectional_right2left(dnnl_unidirectional_right2left),
    /** Bidirectional execution of RNN primitive with concatenation of the
     *  results. */
    bidirectional_concat(dnnl_bidirectional_concat),
    /** Bidirectional execution of RNN primitive with summation of the
     *  results. */
    bidirectional_sum(dnnl_bidirectional_sum),
    /** Alias for #dnnl::rnn_direction::unidirectional_left2right */
    unidirectional(dnnl_unidirectional);

    public final int value;
    private rnn_direction(int v) { this.value = v; }
    private rnn_direction(rnn_direction e) { this.value = e.value; }
    public rnn_direction intern() { for (rnn_direction e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

/** Converts RNN direction enum value from C++ API to C API type.
 *  @param dir C++ API RNN direction enum value.
 *  @return Corresponding C API RNN direction enum value. */

///
///
@Namespace("dnnl") public static native @Cast("dnnl_rnn_direction_t") int convert_to_c(rnn_direction dir);

/** \} dnnl_api_rnn
 <p>
 *  \addtogroup dnnl_api_primitives_common
 *  \{
 <p>
 *  Primitive descriptor query specification.
 * 
 *  In general, queries are not used with the C++ API because most queries are
 *  implemented as class members.
 * 
 *  See \ref dnnl_query_t for more information. */
@Namespace("dnnl") public enum query {
    /** no query */
    undef(dnnl_query_undef),

    /** execution engine */
    engine(dnnl_query_engine),
    /** primitive kind */
    primitive_kind(dnnl_query_primitive_kind),

    /** number of inputs expected */
    num_of_inputs_s32(dnnl_query_num_of_inputs_s32),
    /** number of outputs expected */
    num_of_outputs_s32(dnnl_query_num_of_outputs_s32),

    /** runtime estimation (seconds), unimplemented */
    
///
    time_estimate_f64(dnnl_query_time_estimate_f64),
    /** memory required for scratchpad (bytes)
     * 
     *  @see \ref dev_guide_attributes_scratchpad */
    
///
    memory_consumption_s64(dnnl_query_memory_consumption_s64),

    /** scratchpad engine
     * 
     *  engine to be used for creating scratchpad memory */
    scratchpad_engine(dnnl_query_scratchpad_engine),

    /** reorder source engine */
    reorder_src_engine(dnnl_query_reorder_src_engine),
    /** reorder destination engine */
    reorder_dst_engine(dnnl_query_reorder_dst_engine),

    /** implementation name */
    impl_info_str(dnnl_query_impl_info_str),

    /** propagation kind */
    prop_kind(dnnl_query_prop_kind),

    /** operation descriptor */
    op_d(dnnl_query_op_d),
    /** convolution descriptor */
    convolution_d(dnnl_query_convolution_d),
    /** deconvolution descriptor */
    deconvolution_d(dnnl_query_deconvolution_d),
    /** shuffle descriptor */
    shuffle_d(dnnl_query_shuffle_d),
    /** eltwise descriptor */
    eltwise_d(dnnl_query_eltwise_d),
    /** softmax descriptor */
    softmax_d(dnnl_query_softmax_d),
    /** pooling descriptor */
    pooling_d(dnnl_query_pooling_d),
    /** lrn descriptor */
    lrn_d(dnnl_query_lrn_d),
    /** batch normalization descriptor */
    batch_normalization_d(dnnl_query_batch_normalization_d),
    /** layer normalization descriptor */
    layer_normalization_d(dnnl_query_layer_normalization_d),
    /** inner product descriptor */
    inner_product_d(dnnl_query_inner_product_d),
    /** rnn descriptor */
    rnn_d(dnnl_query_rnn_d),
    /** binary descriptor */
    binary_d(dnnl_query_binary_d),
    /** logsoftmax descriptor */
    logsoftmax_d(dnnl_query_logsoftmax_d),
    /** matmul descriptor */
    matmul_d(dnnl_query_matmul_d),
    /** resampling descriptor */
    resampling_d(dnnl_query_resampling_d),
    /** reduction descriptor */
    reduction_d(dnnl_query_reduction_d),

    /** source memory desc */
    src_md(dnnl_query_src_md),
    /** source gradient (diff) memory desc */
    diff_src_md(dnnl_query_diff_src_md),
    /** weights memory descriptor desc */
    weights_md(dnnl_query_weights_md),
    /** weights gradient (diff) memory desc */
    diff_weights_md(dnnl_query_diff_weights_md),
    /** destination memory desc */
    dst_md(dnnl_query_dst_md),
    /** destination gradient (diff) memory desc */
    diff_dst_md(dnnl_query_diff_dst_md),
    /** workspace memory desc */
    workspace_md(dnnl_query_workspace_md),
    /** scratchpad memory desc */
    scratchpad_md(dnnl_query_scratchpad_md),
    /** memory desc of an execute argument */
    exec_arg_md(dnnl_query_exec_arg_md);

    public final int value;
    private query(int v) { this.value = v; }
    private query(query e) { this.value = e.value; }
    public query intern() { for (query e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

/** Converts query enum value from C++ API to C API type.
 *  @param aquery C++ API query enum value.
 *  @return Corresponding C API query enum value. */

///
///
///
@Namespace("dnnl") public static native @Cast("dnnl_query_t") int convert_to_c(query aquery);

/** \} dnnl_api_primitives_common
 <p>
 *  \} dnnl_api_primitives
 <p>
 *  \addtogroup dnnl_api_engine Engine
 * 
 *  An abstraction of a computational device: a CPU, a specific GPU
 *  card in the system, etc. Most primitives are created to execute
 *  computations on one specific engine. The only exceptions are reorder
 *  primitives that transfer data between two different engines.
 * 
 *  @see \ref dev_guide_basic_concepts
 * 
 *  \{
 <p>
 *  \cond DO_NOT_DOCUMENT_THIS */
// Targeting ../engine.java



/** Converts engine kind enum value from C++ API to C API type.
 * 
 *  @param akind C++ API engine kind enum value.
 *  @return Corresponding C API engine kind enum value. */

///
///
///
@Namespace("dnnl") public static native @Cast("dnnl_engine_kind_t") int convert_to_c(engine.kind akind);

/** \} dnnl_api_engine
 <p>
 *  \addtogroup dnnl_api_stream Stream
 * 
 *  An encapsulation of execution context tied to a particular engine.
 * 
 *  @see \ref dev_guide_basic_concepts
 * 
 *  \{
 <p>
 *  \cond DO_NOT_DOCUMENT_THIS */
// Targeting ../stream.java



@Namespace("dnnl") public static native @Name("operator |") stream.flags or(stream.flags lhs, stream.flags rhs);

    @Namespace("dnnl") public static native @Name("operator &") stream.flags and(stream.flags lhs, stream.flags rhs);

    @Namespace("dnnl") public static native @Name("operator ^") stream.flags xor(stream.flags lhs, stream.flags rhs);

    @Namespace("dnnl") public static native @Name("operator |=") stream.flags orPut(stream.flags lhs, stream.flags rhs);

    @Namespace("dnnl") public static native @Name("operator &=") stream.flags andPut(stream.flags lhs, stream.flags rhs);

    @Namespace("dnnl") public static native @Name("operator ^=") stream.flags xorPut(stream.flags lhs, stream.flags rhs);

    
    ///
    ///
    ///
    ///
    ///
    ///
    ///
    ///
    ///
    ///
    ///
    ///
    ///
    ///
    @Namespace("dnnl") public static native @Name("operator ~") stream.flags not(stream.flags rhs);
// Targeting ../memory.java



@Namespace("dnnl") public static native @Cast("bool") @Name("operator ==") boolean equals(@Cast("dnnl_data_type_t") int a, memory.data_type b);
@Namespace("dnnl") public static native @Cast("bool") @Name("operator !=") boolean notEquals(@Cast("dnnl_data_type_t") int a, memory.data_type b);
@Namespace("dnnl") public static native @Cast("bool") @Name("operator ==") boolean equals(memory.data_type a, @Cast("dnnl_data_type_t") int b);
@Namespace("dnnl") public static native @Cast("bool") @Name("operator !=") boolean notEquals(memory.data_type a, @Cast("dnnl_data_type_t") int b);

@Namespace("dnnl") public static native @Cast("bool") @Name("operator ==") boolean equals(@Cast("dnnl_format_tag_t") int a, memory.format_tag b);
@Namespace("dnnl") public static native @Cast("bool") @Name("operator !=") boolean notEquals(@Cast("dnnl_format_tag_t") int a, memory.format_tag b);
@Namespace("dnnl") public static native @Cast("bool") @Name("operator ==") boolean equals(memory.format_tag a, @Cast("dnnl_format_tag_t") int b);

///
///
@Namespace("dnnl") public static native @Cast("bool") @Name("operator !=") boolean notEquals(memory.format_tag a, @Cast("dnnl_format_tag_t") int b);

/** \} dnnl_api_memory
 <p>
 *  \addtogroup dnnl_api_primitives
 *  \{
 *  \addtogroup dnnl_api_attributes Attributes
 * 
 *  A container for parameters that extend primitives behavior.
 * 
 *  \{
 <p>
 *  \cond DO_NOT_DOCUMENT_THIS */
// Targeting ../post_ops.java



/** \cond DO_NOT_DOCUMENT_THIS */
// Targeting ../primitive_attr.java


// Targeting ../primitive_desc_base.java


// Targeting ../reorder.java



/** \} dnnl_api_reorder
 <p>
 *  \addtogroup dnnl_api_concat Concat
 * 
 *  A primitive to concatenate data by arbitrary dimension.
 * 
 *  @see \ref dev_guide_concat in developer guide
 * 
 *  \{
 <p>
 *  \cond DO_NOT_DOCUMENT_THIS */
@Namespace("dnnl") public static native @StdVector dnnl_memory_desc_t convert_to_c(
        @StdVector memory.desc mems);
// Targeting ../concat.java


// Targeting ../sum.java


// Targeting ../primitive_desc.java


// Targeting ../convolution_forward.java


// Targeting ../convolution_backward_data.java


// Targeting ../convolution_backward_weights.java


// Targeting ../deconvolution_forward.java


// Targeting ../deconvolution_backward_data.java


// Targeting ../deconvolution_backward_weights.java


// Targeting ../lrn_forward.java


// Targeting ../lrn_backward.java


// Targeting ../pooling_forward.java


// Targeting ../pooling_backward.java


// Targeting ../eltwise_forward.java


// Targeting ../eltwise_backward.java


// Targeting ../softmax_forward.java


// Targeting ../softmax_backward.java


// Targeting ../logsoftmax_forward.java


// Targeting ../logsoftmax_backward.java


// Targeting ../batch_normalization_forward.java


// Targeting ../batch_normalization_backward.java


// Targeting ../layer_normalization_forward.java


// Targeting ../layer_normalization_backward.java


// Targeting ../inner_product_forward.java


// Targeting ../inner_product_backward_data.java


// Targeting ../inner_product_backward_weights.java


// Targeting ../rnn_primitive_desc_base.java


// Targeting ../vanilla_rnn_forward.java


// Targeting ../vanilla_rnn_backward.java


// Targeting ../lstm_forward.java


// Targeting ../lstm_backward.java


// Targeting ../gru_forward.java


// Targeting ../gru_backward.java


// Targeting ../lbr_gru_forward.java


// Targeting ../lbr_gru_backward.java


// Targeting ../shuffle_forward.java


// Targeting ../shuffle_backward.java


// Targeting ../binary.java


// Targeting ../matmul.java


// Targeting ../resampling_forward.java


// Targeting ../resampling_backward.java


// Targeting ../pooling_v2_forward.java


// Targeting ../pooling_v2_backward.java


// Targeting ../prelu_forward.java


// Targeting ../prelu_backward.java


// Targeting ../reduction.java



/** \} dnnl_api_reduction
 <p>
 *  \} dnnl_api_primitives
 <p>
 *  \addtogroup dnnl_api_service Service
 * 
 *  A set of functions that aid in oneDNN debugging and profiling.
 * 
 *  \{
 <p>
 *  \copydoc dnnl_version_t */

/** Status values returned by the library functions. */
@Namespace("dnnl") public enum status {
    /** \copydoc dnnl_success */
    success(dnnl_success),
    /** \copydoc dnnl_out_of_memory */
    out_of_memory(dnnl_out_of_memory),
    /** \copydoc dnnl_invalid_arguments */
    invalid_arguments(dnnl_invalid_arguments),
    /** \copydoc dnnl_unimplemented */
    unimplemented(dnnl_unimplemented),
    /** \copydoc dnnl_iterator_ends */
    iterator_ends(dnnl_iterator_ends),
    /** \copydoc dnnl_runtime_error */
    runtime_error(dnnl_runtime_error),
    /** \copydoc dnnl_not_required */
    not_required(dnnl_not_required);

    public final int value;
    private status(int v) { this.value = v; }
    private status(status e) { this.value = e.value; }
    public status intern() { for (status e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

/** \copydoc dnnl_set_verbose() */
@Namespace("dnnl") public static native status set_verbose(int level);

/** \copydoc dnnl_version() */
@Namespace("dnnl") public static native @Cast("const dnnl::version_t*") dnnl_version_t version();

/** \copydoc dnnl_set_jit_dump() */
@Namespace("dnnl") public static native status set_jit_dump(int enable);

/** \copydoc dnnl_set_jit_profiling_flags() */
@Namespace("dnnl") public static native status set_jit_profiling_flags(@Cast("unsigned") int flags);

/** \copydoc dnnl_set_jit_profiling_jitdumpdir() */
@Namespace("dnnl") public static native status set_jit_profiling_jitdumpdir(@StdString BytePointer dir);
@Namespace("dnnl") public static native @Cast("dnnl::status") int set_jit_profiling_jitdumpdir(@StdString String dir);

/** \copydoc dnnl_cpu_isa_t */
@Namespace("dnnl") public enum cpu_isa {
    /** \copydoc dnnl_cpu_isa_all */
    all(dnnl_cpu_isa_all),
    /** \copydoc dnnl_cpu_isa_sse41 */
    sse41(dnnl_cpu_isa_sse41),
    /** \copydoc dnnl_cpu_isa_avx */
    avx(dnnl_cpu_isa_avx),
    /** \copydoc dnnl_cpu_isa_avx2 */
    avx2(dnnl_cpu_isa_avx2),
    /** \copydoc dnnl_cpu_isa_avx512_mic */
    avx512_mic(dnnl_cpu_isa_avx512_mic),
    /** \copydoc dnnl_cpu_isa_avx512_mic_4ops */
    avx512_mic_4ops(dnnl_cpu_isa_avx512_mic_4ops),
    /** \copydoc dnnl_cpu_isa_avx512_core */
    avx512_core(dnnl_cpu_isa_avx512_core),
    /** \copydoc dnnl_cpu_isa_avx512_core_vnni */
    avx512_core_vnni(dnnl_cpu_isa_avx512_core_vnni),
    /** \copydoc dnnl_cpu_isa_avx512_core_bf16 */
    avx512_core_bf16(dnnl_cpu_isa_avx512_core_bf16),
    /** \copydoc dnnl_cpu_isa_avx512_core_amx */
    avx512_core_amx(dnnl_cpu_isa_avx512_core_amx),
    /** \copydoc dnnl_cpu_isa_avx2_vnni */
    avx2_vnni(dnnl_cpu_isa_avx2_vnni);

    public final int value;
    private cpu_isa(int v) { this.value = v; }
    private cpu_isa(cpu_isa e) { this.value = e.value; }
    public cpu_isa intern() { for (cpu_isa e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

/** \copydoc dnnl_set_max_cpu_isa() */
@Namespace("dnnl") public static native status set_max_cpu_isa(cpu_isa isa);
@Namespace("dnnl") public static native @Cast("dnnl::status") int set_max_cpu_isa(@Cast("dnnl::cpu_isa") int isa);

/** \copydoc dnnl_get_effective_cpu_isa() */
@Namespace("dnnl") public static native cpu_isa get_effective_cpu_isa();

/** \copydoc dnnl_cpu_isa_hints_t */
@Namespace("dnnl") public enum cpu_isa_hints {
    /** \copydoc dnnl_cpu_isa_no_hints */
    no_hints(dnnl_cpu_isa_no_hints),
    /** \copydoc dnnl_cpu_isa_prefer_ymm */
    prefer_ymm(dnnl_cpu_isa_prefer_ymm);

    public final int value;
    private cpu_isa_hints(int v) { this.value = v; }
    private cpu_isa_hints(cpu_isa_hints e) { this.value = e.value; }
    public cpu_isa_hints intern() { for (cpu_isa_hints e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

/** \copydoc dnnl_set_cpu_isa_hints() */
@Namespace("dnnl") public static native status set_cpu_isa_hints(cpu_isa_hints isa_hints);
@Namespace("dnnl") public static native @Cast("dnnl::status") int set_cpu_isa_hints(@Cast("dnnl::cpu_isa_hints") int isa_hints);

/** \copydoc dnnl_get_cpu_isa_hints() */

///
///
@Namespace("dnnl") public static native cpu_isa_hints get_cpu_isa_hints();

/** \} dnnl_api_service
 <p>
 *  \addtogroup dnnl_api_primitive_cache Primitive Cache
 * 
 *  A set of functions that provide primitive cache control.
 * 
 *  \{
 <p>
 *  Returns the number of primitives that can be held in the primitive cache
 *  at the same time. */
@Namespace("dnnl") public static native int get_primitive_cache_capacity();

/** \copydoc dnnl_set_primitive_cache_capacity(int capacity) */

///
///
@Namespace("dnnl") public static native void set_primitive_cache_capacity(int _capacity);

/** \} dnnl_api_primitive_cache
 <p>
 *  \addtogroup dnnl_api_blas BLAS functions
 * 
 *  A subset of Basic Linear Algebra (BLAS) functions that perform
 *  matrix-matrix multiplication.
 * 
 *  \{
 <p>
 *  \copydoc dnnl_sgemm() */
@Namespace("dnnl") public static native status sgemm(@Cast("char") byte transa, @Cast("char") byte transb, @Cast("dnnl_dim_t") long M, @Cast("dnnl_dim_t") long N,
        @Cast("dnnl_dim_t") long K, float alpha, @Const FloatPointer A, @Cast("dnnl_dim_t") long lda,
        @Const FloatPointer B, @Cast("dnnl_dim_t") long ldb, float beta, FloatPointer C, @Cast("dnnl_dim_t") long ldc);
@Namespace("dnnl") public static native @Cast("dnnl::status") int sgemm(@Cast("char") byte transa, @Cast("char") byte transb, @Cast("dnnl_dim_t") long M, @Cast("dnnl_dim_t") long N,
        @Cast("dnnl_dim_t") long K, float alpha, @Const FloatBuffer A, @Cast("dnnl_dim_t") long lda,
        @Const FloatBuffer B, @Cast("dnnl_dim_t") long ldb, float beta, FloatBuffer C, @Cast("dnnl_dim_t") long ldc);
@Namespace("dnnl") public static native status sgemm(@Cast("char") byte transa, @Cast("char") byte transb, @Cast("dnnl_dim_t") long M, @Cast("dnnl_dim_t") long N,
        @Cast("dnnl_dim_t") long K, float alpha, @Const float[] A, @Cast("dnnl_dim_t") long lda,
        @Const float[] B, @Cast("dnnl_dim_t") long ldb, float beta, float[] C, @Cast("dnnl_dim_t") long ldc);

/** \copydoc dnnl_gemm_u8s8s32() */
@Namespace("dnnl") public static native status gemm_u8s8s32(@Cast("char") byte transa, @Cast("char") byte transb, @Cast("char") byte offsetc, @Cast("dnnl_dim_t") long M,
        @Cast("dnnl_dim_t") long N, @Cast("dnnl_dim_t") long K, float alpha, @Cast("const uint8_t*") BytePointer A,
        @Cast("dnnl_dim_t") long lda, @Cast("uint8_t") byte ao, @Const BytePointer B, @Cast("dnnl_dim_t") long ldb, byte bo,
        float beta, IntPointer C, @Cast("dnnl_dim_t") long ldc, @Const IntPointer co);
@Namespace("dnnl") public static native @Cast("dnnl::status") int gemm_u8s8s32(@Cast("char") byte transa, @Cast("char") byte transb, @Cast("char") byte offsetc, @Cast("dnnl_dim_t") long M,
        @Cast("dnnl_dim_t") long N, @Cast("dnnl_dim_t") long K, float alpha, @Cast("const uint8_t*") ByteBuffer A,
        @Cast("dnnl_dim_t") long lda, @Cast("uint8_t") byte ao, @Const ByteBuffer B, @Cast("dnnl_dim_t") long ldb, byte bo,
        float beta, IntBuffer C, @Cast("dnnl_dim_t") long ldc, @Const IntBuffer co);
@Namespace("dnnl") public static native status gemm_u8s8s32(@Cast("char") byte transa, @Cast("char") byte transb, @Cast("char") byte offsetc, @Cast("dnnl_dim_t") long M,
        @Cast("dnnl_dim_t") long N, @Cast("dnnl_dim_t") long K, float alpha, @Cast("const uint8_t*") byte[] A,
        @Cast("dnnl_dim_t") long lda, @Cast("uint8_t") byte ao, @Const byte[] B, @Cast("dnnl_dim_t") long ldb, byte bo,
        float beta, int[] C, @Cast("dnnl_dim_t") long ldc, @Const int[] co);

/** \copydoc dnnl_gemm_s8s8s32() */
@Namespace("dnnl") public static native status gemm_s8s8s32(@Cast("char") byte transa, @Cast("char") byte transb, @Cast("char") byte offsetc, @Cast("dnnl_dim_t") long M,
        @Cast("dnnl_dim_t") long N, @Cast("dnnl_dim_t") long K, float alpha, @Const BytePointer A,
        @Cast("dnnl_dim_t") long lda, byte ao, @Const BytePointer B, @Cast("dnnl_dim_t") long ldb, byte bo,
        float beta, IntPointer C, @Cast("dnnl_dim_t") long ldc, @Const IntPointer co);
@Namespace("dnnl") public static native @Cast("dnnl::status") int gemm_s8s8s32(@Cast("char") byte transa, @Cast("char") byte transb, @Cast("char") byte offsetc, @Cast("dnnl_dim_t") long M,
        @Cast("dnnl_dim_t") long N, @Cast("dnnl_dim_t") long K, float alpha, @Const ByteBuffer A,
        @Cast("dnnl_dim_t") long lda, byte ao, @Const ByteBuffer B, @Cast("dnnl_dim_t") long ldb, byte bo,
        float beta, IntBuffer C, @Cast("dnnl_dim_t") long ldc, @Const IntBuffer co);
@Namespace("dnnl") public static native status gemm_s8s8s32(@Cast("char") byte transa, @Cast("char") byte transb, @Cast("char") byte offsetc, @Cast("dnnl_dim_t") long M,
        @Cast("dnnl_dim_t") long N, @Cast("dnnl_dim_t") long K, float alpha, @Const byte[] A,
        @Cast("dnnl_dim_t") long lda, byte ao, @Const byte[] B, @Cast("dnnl_dim_t") long ldb, byte bo,
        float beta, int[] C, @Cast("dnnl_dim_t") long ldc, @Const int[] co);

/** \} dnnl_api_blas */

// implementation section

/** \cond DO_NOT_DOCUMENT_THIS */






/** \endcond */

// #undef DNNL_DEFINE_BITMASK_OPS

 // namespace dnnl

/** oneAPI namespace
 <p>
 *  The oneAPI namespace.
 *  Contains the oneapi::dnnl namespace as an alias to the ::dnnl namespace. */
// Note: without this guard, doxygen warns of potentially recursive namespace
// #ifndef DOXYGEN_SHOULD_SKIP_THIS
// #endif
 // namespace oneapi

/** \} dnnl_api */

// #endif /* ONEAPI_DNNL_DNNL_HPP */


}
