/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.arrow;

import java.util.Arrays;
import org.bytedeco.arrow.ArrayData;
import org.bytedeco.arrow.presets.arrow;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.annotation.ByRef;
import org.bytedeco.javacpp.annotation.ByVal;
import org.bytedeco.javacpp.annotation.Cast;
import org.bytedeco.javacpp.annotation.Index;
import org.bytedeco.javacpp.annotation.Name;
import org.bytedeco.javacpp.annotation.NoOffset;
import org.bytedeco.javacpp.annotation.Properties;
import org.bytedeco.javacpp.annotation.SharedPtr;

@Name(value={"std::vector<std::shared_ptr<arrow::ArrayData> >"})
@Properties(inherit={arrow.class})
public class ArrayDataVector
extends Pointer {
    public ArrayDataVector(Pointer p) {
        super(p);
    }

    public ArrayDataVector(@Cast(value={"", "std::shared_ptr<arrow::ArrayData>"}) ArrayData value) {
        this(1L);
        this.put(0L, value);
    }

    public ArrayDataVector(ArrayData ... array) {
        this(array.length);
        this.put(array);
    }

    public ArrayDataVector() {
        this.allocate();
    }

    public ArrayDataVector(long n) {
        this.allocate(n);
    }

    private native void allocate();

    private native void allocate(@Cast(value={"size_t"}) long var1);

    @Name(value={"operator ="})
    @ByRef
    public native ArrayDataVector put(@ByRef ArrayDataVector var1);

    public boolean empty() {
        return this.size() == 0L;
    }

    public native long size();

    public void clear() {
        this.resize(0L);
    }

    public native void resize(@Cast(value={"size_t"}) long var1);

    @Index(function="at")
    @SharedPtr
    @Cast(value={"", "std::shared_ptr<arrow::ArrayData>"})
    public native ArrayData get(@Cast(value={"size_t"}) long var1);

    public native ArrayDataVector put(@Cast(value={"size_t"}) long var1, ArrayData var3);

    @ByVal
    public native Iterator insert(@ByVal Iterator var1, @SharedPtr @Cast(value={"", "std::shared_ptr<arrow::ArrayData>"}) ArrayData var2);

    @ByVal
    public native Iterator erase(@ByVal Iterator var1);

    @ByVal
    public native Iterator begin();

    @ByVal
    public native Iterator end();

    public ArrayData[] get() {
        ArrayData[] array = new ArrayData[this.size() < Integer.MAX_VALUE ? (int)this.size() : Integer.MAX_VALUE];
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.get(i);
        }
        return array;
    }

    public String toString() {
        return Arrays.toString((Object[])this.get());
    }

    public ArrayData pop_back() {
        long size = this.size();
        ArrayData value = this.get(size - 1L);
        this.resize(size - 1L);
        return value;
    }

    public ArrayDataVector push_back(ArrayData value) {
        long size = this.size();
        this.resize(size + 1L);
        return this.put(size, value);
    }

    public ArrayDataVector put(ArrayData value) {
        if (this.size() != 1L) {
            this.resize(1L);
        }
        return this.put(0L, value);
    }

    public ArrayDataVector put(ArrayData ... array) {
        if (this.size() != (long)array.length) {
            this.resize(array.length);
        }
        for (int i = 0; i < array.length; ++i) {
            this.put(i, array[i]);
        }
        return this;
    }

    static {
        Loader.load();
    }

    @NoOffset
    @Name(value={"iterator"})
    public static class Iterator
    extends Pointer {
        public Iterator(Pointer p) {
            super(p);
        }

        public Iterator() {
        }

        @Name(value={"operator ++"})
        @ByRef
        public native Iterator increment();

        @Name(value={"operator =="})
        public native boolean equals(@ByRef Iterator var1);

        @Name(value={"operator *"})
        @SharedPtr
        @Cast(value={"", "std::shared_ptr<arrow::ArrayData>"})
        public native ArrayData get();
    }
}

