// Targeted by JavaCPP version 1.5.5: DO NOT EDIT THIS FILE

package org.bytedeco.ale;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.ale.global.ale.*;


/**
  This class provides an interface for accessing frontend specific settings.
  <p>
  @author  Stephen Anthony
  @version $Id: Settings.hxx,v 1.33 2007/07/27 13:49:16 stephena Exp $
*/
@NoOffset @Properties(inherit = org.bytedeco.ale.presets.ale.class)
public class Settings extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public Settings(Pointer p) { super(p); }

    /**
      Create a new settings abstract class
    */
    public Settings(OSystem osystem) { super((Pointer)null); allocate(osystem); }
    private native void allocate(OSystem osystem);

    /**
      Destructor
    */
    /**
      This method should be called to load the current settings from an rc file.
    */
    public native void loadConfig();
    
    /**
      This method loads the given 
    */
    public native void loadConfig(@Cast("const char*") BytePointer config_file);
    public native void loadConfig(String config_file);

    /**
      This method should be called to save the current settings to an rc file.
    */
    public native void saveConfig();

    /**
      This method should be called to load the arguments from the commandline.
      <p>
      @return Name of the ROM to load, otherwise empty string
    */
    public native @StdString BytePointer loadCommandLine(int argc, @Cast("char**") PointerPointer argv);
    public native @StdString BytePointer loadCommandLine(int argc, @Cast("char**") @ByPtrPtr BytePointer argv);
    public native @StdString String loadCommandLine(int argc, @Cast("char**") @ByPtrPtr ByteBuffer argv);
    public native @StdString BytePointer loadCommandLine(int argc, @Cast("char**") @ByPtrPtr byte[] argv);

    /**
      This method should be called *after* settings have been read,
      to validate (and change, if necessary) any improper settings.
    */
    public native void validate();

    /**
      This method should be called to display usage information.
    */
    public native void usage();

    /**
      Get the value assigned to the specified key.  If the key does
      not exist then -1 is returned.
      <p>
      @param key The key of the setting to lookup
      @return The integer value of the setting
    */
    public native int getInt(@StdString BytePointer key, @Cast("bool") boolean strict/*=false*/);
    public native int getInt(@StdString BytePointer key);
    public native int getInt(@StdString String key, @Cast("bool") boolean strict/*=false*/);
    public native int getInt(@StdString String key);

    /**
      Get the value assigned to the specified key.  If the key does
      not exist then -1.0 is returned.
      <p>
      @param key The key of the setting to lookup
      @return The floating point value of the setting
    */
    public native float getFloat(@StdString BytePointer key, @Cast("bool") boolean strict/*=false*/);
    public native float getFloat(@StdString BytePointer key);
    public native float getFloat(@StdString String key, @Cast("bool") boolean strict/*=false*/);
    public native float getFloat(@StdString String key);

    /**
      Get the value assigned to the specified key.  If the key does
      not exist then false is returned.
      <p>
      @param key The key of the setting to lookup
      @return The boolean value of the setting
    */
    public native @Cast("bool") boolean getBool(@StdString BytePointer key, @Cast("bool") boolean strict/*=false*/);
    public native @Cast("bool") boolean getBool(@StdString BytePointer key);
    public native @Cast("bool") boolean getBool(@StdString String key, @Cast("bool") boolean strict/*=false*/);
    public native @Cast("bool") boolean getBool(@StdString String key);

    /**
      Get the value assigned to the specified key.  If the key does
      not exist then the empty string is returned.
      <p>
      @param key The key of the setting to lookup
      @return The string value of the setting
    */
    public native @StdString BytePointer getString(@StdString BytePointer key, @Cast("bool") boolean strict/*=false*/);
    public native @StdString BytePointer getString(@StdString BytePointer key);
    public native @StdString String getString(@StdString String key, @Cast("bool") boolean strict/*=false*/);
    public native @StdString String getString(@StdString String key);

    /**
      Get the x*y size assigned to the specified key.  If the key does
      not exist (or is invalid) then results are -1 for each item.
      <p>
      @param key The key of the setting to lookup
      @return The x and y values encoded in the key
    */
    public native void getSize(@StdString BytePointer key, @ByRef IntPointer x, @ByRef IntPointer y);
    public native void getSize(@StdString String key, @ByRef IntBuffer x, @ByRef IntBuffer y);
    public native void getSize(@StdString BytePointer key, @ByRef int[] x, @ByRef int[] y);
    public native void getSize(@StdString String key, @ByRef IntPointer x, @ByRef IntPointer y);
    public native void getSize(@StdString BytePointer key, @ByRef IntBuffer x, @ByRef IntBuffer y);
    public native void getSize(@StdString String key, @ByRef int[] x, @ByRef int[] y);

    /**
      Set the value associated with key to the given value.
      <p>
      @param key   The key of the setting
      @param value The value to assign to the setting
    */
    public native void setInt(@StdString BytePointer key, int value);
    public native void setInt(@StdString String key, int value);

    /**
      Set the value associated with key to the given value.
      <p>
      @param key   The key of the setting
      @param value The value to assign to the setting
    */
    public native void setFloat(@StdString BytePointer key, float value);
    public native void setFloat(@StdString String key, float value);

    /**
      Set the value associated with key to the given value.
      <p>
      @param key   The key of the setting
      @param value The value to assign to the setting
    */
    public native void setBool(@StdString BytePointer key, @Cast("const bool") boolean value);
    public native void setBool(@StdString String key, @Cast("const bool") boolean value);

    /**
      Set the value associated with key to the given value.
      <p>
      @param key   The key of the setting
      @param value The value to assign to the setting
    */
    public native void setString(@StdString BytePointer key, @StdString BytePointer value);
    public native void setString(@StdString String key, @StdString String value);

    /**
      Set the value associated with key to the given value.
      <p>
      @param key   The key of the setting
      @param value The value to assign to the setting
    */
    public native void setSize(@StdString BytePointer key, int value1, int value2);
    public native void setSize(@StdString String key, int value1, int value2);
}
