/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.loader;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.openejb.loader.ClassPath;
import org.apache.openejb.loader.ClassPathFactory;
import org.apache.openejb.loader.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SystemInstance {
    private final long startTime = System.currentTimeMillis();
    private final Properties internalProperties = new Properties();
    private final Properties externalProperties = new Properties();
    private final FileUtils home;
    private final FileUtils base;
    private final ClassLoader classLoader;
    private final HashMap<Class, Object> components = new HashMap();
    private final ClassPath classPath;
    private static SystemInstance system;
    private static boolean initialized;

    private SystemInstance(Properties properties) throws Exception {
        this.internalProperties.putAll((Map<?, ?>)System.getProperties());
        this.internalProperties.putAll((Map<?, ?>)properties);
        this.home = new FileUtils("openejb.home", "user.dir", this.internalProperties);
        this.base = new FileUtils("openejb.base", "openejb.home", this.internalProperties);
        this.classPath = ClassPathFactory.createClassPath(this.internalProperties.getProperty("openejb.loader", "context"));
        this.classLoader = this.classPath.getClassLoader();
        this.internalProperties.setProperty("openejb.home", this.home.getDirectory().getCanonicalPath());
        this.internalProperties.setProperty("openejb.base", this.base.getDirectory().getCanonicalPath());
        System.setProperty("derby.system.home", this.base.getDirectory().getCanonicalPath());
        System.setProperty("derby.storage.fileSyncTransactionLog", "true");
    }

    public long getStartTime() {
        return this.startTime;
    }

    public Properties getProperties() {
        return this.internalProperties;
    }

    public String getProperty(String key) {
        return this.internalProperties.getProperty(key);
    }

    public String getProperty(String key, String defaultValue) {
        return this.internalProperties.getProperty(key, defaultValue);
    }

    public Object setProperty(String key, String value) {
        return this.setProperty(key, value, false);
    }

    public Object setProperty(String key, String value, boolean isExternalProperty) {
        if (isExternalProperty) {
            this.externalProperties.setProperty(key, value);
            System.setProperty(key, value);
        }
        return this.internalProperties.setProperty(key, value);
    }

    public FileUtils getHome() {
        return this.home;
    }

    public FileUtils getBase() {
        return this.base;
    }

    public ClassPath getClassPath() {
        return this.classPath;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public <T> T getComponent(Class<T> type) {
        return (T)this.components.get(type);
    }

    public <T> T removeComponent(Class<T> type) {
        return (T)this.components.remove(type);
    }

    public <T> T setComponent(Class<T> type, T value) {
        return (T)this.components.put(type, value);
    }

    public static boolean isInitialized() {
        return initialized;
    }

    public static void reset() {
        try {
            system = new SystemInstance(System.getProperties());
            initialized = false;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create default instance of SystemInstance", e);
        }
    }

    public static void init(Properties properties) throws Exception {
        if (initialized) {
            return;
        }
        system = new SystemInstance(properties);
        initialized = true;
    }

    public static SystemInstance get() {
        return system;
    }

    public boolean hasProperty(String propName) {
        return this.internalProperties.get(propName) != null;
    }

    static {
        SystemInstance.reset();
    }
}

