/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import kafka.api.TopicMetadata;
import kafka.client.ClientUtils$;
import kafka.cluster.Broker;
import kafka.tools.GetOffsetShell$;
import kafka.utils.CommandLineUtils$;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.ScalaObject;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassManifest;
import scala.reflect.Manifest$;
import scala.runtime.LongRef;

public final class GetOffsetShell$
implements ScalaObject {
    public static final GetOffsetShell$ MODULE$;

    static {
        new GetOffsetShell$();
    }

    public void main(String[] args) {
        OptionParser parser = new OptionParser();
        ArgumentAcceptingOptionSpec brokerListOpt = parser.accepts("broker-list", "REQUIRED: The list of hostname and port of the server to connect to.").withRequiredArg().describedAs("hostname:port,...,hostname:port").ofType(String.class);
        ArgumentAcceptingOptionSpec topicOpt = parser.accepts("topic", "REQUIRED: The topic to get offset from.").withRequiredArg().describedAs("topic").ofType(String.class);
        ArgumentAcceptingOptionSpec partitionOpt = parser.accepts("partitions", "comma separated list of partition ids. If not specified, it will find offsets for all partitions").withRequiredArg().describedAs("partition ids").ofType(String.class).defaultsTo((Object)"", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec timeOpt = parser.accepts("time", "timestamp of the offsets before that").withRequiredArg().describedAs("timestamp/-1(latest)/-2(earliest)").ofType(Long.class);
        ArgumentAcceptingOptionSpec nOffsetsOpt = parser.accepts("offsets", "number of offsets returned").withRequiredArg().describedAs("count").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(1), (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec maxWaitMsOpt = parser.accepts("max-wait-ms", "The max amount of time each fetch request waits.").withRequiredArg().describedAs("ms").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(1000), (Object[])new Integer[0]);
        OptionSet options = parser.parse(args);
        CommandLineUtils$.MODULE$.checkRequiredArgs(parser, options, (Seq<OptionSpec<?>>)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{brokerListOpt, topicOpt, timeOpt}));
        String clientId$1 = "GetOffsetShell";
        Seq<Broker> metadataTargetBrokers = ClientUtils$.MODULE$.parseBrokerList((String)options.valueOf((OptionSpec)brokerListOpt));
        String topic$1 = (String)options.valueOf((OptionSpec)topicOpt);
        String partitionList = (String)options.valueOf((OptionSpec)partitionOpt);
        LongRef time$1 = new LongRef(((Long)options.valueOf((OptionSpec)timeOpt)).longValue());
        int nOffsets$1 = (Integer)options.valueOf((OptionSpec)nOffsetsOpt);
        int maxWaitMs = (Integer)options.valueOf((OptionSpec)maxWaitMsOpt);
        Seq<TopicMetadata> topicsMetadata$1 = ClientUtils$.MODULE$.fetchTopicMetadata((Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic$1}))), metadataTargetBrokers, clientId$1, maxWaitMs, ClientUtils$.MODULE$.fetchTopicMetadata$default$5()).topicsMetadata();
        if (topicsMetadata$1.size() != 1 || !((TopicMetadata)topicsMetadata$1.apply(0)).topic().equals(topic$1)) {
            System.err.println(new StringBuilder().append((Object)Predef$.MODULE$.augmentString("Error: no valid topic metadata for topic: %s,  probably the topic does not exist, run ").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic$1}))).append((Object)"kafka-list-topic.sh to verify").toString());
            System.exit(1);
        }
        String string = partitionList;
        String string2 = "";
        Seq partitions = !(string != null ? !string.equals(string2) : string2 != null) ? (Seq)((TopicMetadata)topicsMetadata$1.head()).partitionsMetadata().map((Function1)new anonfun.1(), Seq$.MODULE$.canBuildFrom()) : Predef$.MODULE$.intArrayOps((int[])Predef$.MODULE$.refArrayOps((Object[])partitionList.split(",")).map((Function1)new anonfun.2(), Array$.MODULE$.canBuildFrom((ClassManifest)Manifest$.MODULE$.Int()))).toSeq();
        partitions.foreach((Function1)new anonfun.main.1(clientId$1, topic$1, time$1, nOffsets$1, topicsMetadata$1));
    }

    private GetOffsetShell$() {
        MODULE$ = this;
    }
}

