/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import kafka.api.FetchRequest;
import kafka.api.FetchRequestBuilder;
import kafka.api.FetchResponse;
import kafka.api.FetchResponsePartitionData;
import kafka.cluster.Broker;
import kafka.common.ClientIdAndBroker;
import kafka.common.TopicAndPartition;
import kafka.consumer.SimpleConsumer;
import kafka.server.AbstractFetcherThread$;
import kafka.server.FetcherLagStats;
import kafka.server.FetcherStats;
import kafka.utils.ShutdownableThread;
import kafka.utils.Utils$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.ScalaObject;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.generic.Growable;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashSet;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001\t-b\u0001C\u0001\u0003\t\u0003\u0005\u0019\u0011A\u0004\u0003+\u0005\u00137\u000f\u001e:bGR4U\r^2iKJ$\u0006N]3bI*\u00111\u0001B\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001aE\u0002\u0001\u00119\u0001\"!\u0003\u0007\u000e\u0003)Q!a\u0003\u0003\u0002\u000bU$\u0018\u000e\\:\n\u00055Q!AE*ikR$wn\u001e8bE2,G\u000b\u001b:fC\u0012\u0004\"a\u0004\n\u000e\u0003AQ\u0011!E\u0001\u0006g\u000e\fG.Y\u0005\u0003'A\u00111bU2bY\u0006|%M[3di\"IQ\u0003\u0001B\u0001B\u0003%a#H\u0001\u0005]\u0006lW\r\u0005\u0002\u001859\u0011q\u0002G\u0005\u00033A\ta\u0001\u0015:fI\u00164\u0017BA\u000e\u001d\u0005\u0019\u0019FO]5oO*\u0011\u0011\u0004E\u0005\u0003+1A\u0001b\b\u0001\u0003\u0002\u0003\u0006IAF\u0001\tG2LWM\u001c;JI\"A\u0011\u0005\u0001B\u0001B\u0003%!%\u0001\u0007t_V\u00148-\u001a\"s_.,'\u000f\u0005\u0002$M5\tAE\u0003\u0002&\t\u000591\r\\;ti\u0016\u0014\u0018BA\u0014%\u0005\u0019\u0011%o\\6fe\"A\u0011\u0006\u0001B\u0001B\u0003%!&A\u0007t_\u000e\\W\r\u001e+j[\u0016|W\u000f\u001e\t\u0003\u001f-J!\u0001\f\t\u0003\u0007%sG\u000f\u0003\u0005/\u0001\t\u0005\t\u0015!\u0003+\u0003A\u0019xnY6fi\n+hMZ3s'&TX\r\u0003\u00051\u0001\t\u0005\t\u0015!\u0003+\u0003%1W\r^2i'&TX\r\u0003\u00053\u0001\t\u0005\t\u0015!\u0003+\u0003=1W\r^2iKJ\u0014%o\\6fe&#\u0007\u0002\u0003\u001b\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0016\u0002\u000f5\f\u0007pV1ji\"Aa\u0007\u0001B\u0001B\u0003%!&\u0001\u0005nS:\u0014\u0015\u0010^3t\u0011%A\u0004A!A!\u0002\u0013ID(A\bjg&sG/\u001a:skB$\u0018N\u00197f!\ty!(\u0003\u0002<!\t9!i\\8mK\u0006t\u0017B\u0001\u001d\r\u0011\u0015q\u0004\u0001\"\u0001@\u0003\u0019a\u0014N\\5u}QY\u0001IQ\"E\u000b\u001a;\u0005*\u0013&L!\t\t\u0005!D\u0001\u0003\u0011\u0015)R\b1\u0001\u0017\u0011\u0015yR\b1\u0001\u0017\u0011\u0015\tS\b1\u0001#\u0011\u0015IS\b1\u0001+\u0011\u0015qS\b1\u0001+\u0011\u0015\u0001T\b1\u0001+\u0011\u001d\u0011T\b%AA\u0002)Bq\u0001N\u001f\u0011\u0002\u0003\u0007!\u0006C\u00047{A\u0005\t\u0019\u0001\u0016\t\u000faj\u0004\u0013!a\u0001s!9Q\n\u0001b\u0001\n\u0013q\u0015\u0001\u00049beRLG/[8o\u001b\u0006\u0004X#A(\u0011\tA+v+X\u0007\u0002#*\u0011!kU\u0001\b[V$\u0018M\u00197f\u0015\t!\u0006#\u0001\u0006d_2dWm\u0019;j_:L!AV)\u0003\u000f!\u000b7\u000f['baB\u0011\u0001lW\u0007\u00023*\u0011!\fB\u0001\u0007G>lWn\u001c8\n\u0005qK&!\u0005+pa&\u001c\u0017I\u001c3QCJ$\u0018\u000e^5p]B\u0011qBX\u0005\u0003?B\u0011A\u0001T8oO\"1\u0011\r\u0001Q\u0001\n=\u000bQ\u0002]1si&$\u0018n\u001c8NCB\u0004\u0003bB2\u0001\u0005\u0004%I\u0001Z\u0001\u0011a\u0006\u0014H/\u001b;j_:l\u0015\r\u001d'pG.,\u0012!\u001a\t\u0003M>l\u0011a\u001a\u0006\u0003Q&\fQ\u0001\\8dWNT!A[6\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002m[\u0006!Q\u000f^5m\u0015\u0005q\u0017\u0001\u00026bm\u0006L!\u0001]4\u0003\u001bI+WM\u001c;sC:$Hj\\2l\u0011\u0019\u0011\b\u0001)A\u0005K\u0006\t\u0002/\u0019:uSRLwN\\'ba2{7m\u001b\u0011\t\u000fQ\u0004!\u0019!C\u0005k\u0006\u0001\u0002/\u0019:uSRLwN\\'ba\u000e{g\u000eZ\u000b\u0002mB\u0011am^\u0005\u0003q\u001e\u0014\u0011bQ8oI&$\u0018n\u001c8\t\ri\u0004\u0001\u0015!\u0003w\u0003E\u0001\u0018M\u001d;ji&|g.T1q\u0007>tG\r\t\u0005\by\u0002\u0011\r\u0011\"\u0001~\u00039\u0019\u0018.\u001c9mK\u000e{gn];nKJ,\u0012A \t\u0004\u007f\u0006\u0015QBAA\u0001\u0015\r\t\u0019\u0001B\u0001\tG>t7/^7fe&!\u0011qAA\u0001\u00059\u0019\u0016.\u001c9mK\u000e{gn];nKJDq!a\u0003\u0001A\u0003%a0A\btS6\u0004H.Z\"p]N,X.\u001a:!\u0011%\ty\u0001\u0001b\u0001\n\u0013\t\t\"\u0001\u0006ce>\\WM]%oM>,\u0012A\u0006\u0005\b\u0003+\u0001\u0001\u0015!\u0003\u0017\u0003-\u0011'o\\6fe&sgm\u001c\u0011\t\u0013\u0005e\u0001A1A\u0005\n\u0005m\u0011\u0001C7fiJL7-\u00133\u0016\u0005\u0005u\u0001c\u0001-\u0002 %\u0019\u0011\u0011E-\u0003#\rc\u0017.\u001a8u\u0013\u0012\fe\u000e\u001a\"s_.,'\u000f\u0003\u0005\u0002&\u0001\u0001\u000b\u0011BA\u000f\u0003%iW\r\u001e:jG&#\u0007\u0005C\u0005\u0002*\u0001\u0011\r\u0011\"\u0001\u0002,\u0005aa-\u001a;dQ\u0016\u00148\u000b^1ugV\u0011\u0011Q\u0006\t\u0004\u0003\u0006=\u0012bAA\u0019\u0005\taa)\u001a;dQ\u0016\u00148\u000b^1ug\"A\u0011Q\u0007\u0001!\u0002\u0013\ti#A\u0007gKR\u001c\u0007.\u001a:Ti\u0006$8\u000f\t\u0005\n\u0003s\u0001!\u0019!C\u0001\u0003w\tqBZ3uG\",'\u000fT1h'R\fGo]\u000b\u0003\u0003{\u00012!QA \u0013\r\t\tE\u0001\u0002\u0010\r\u0016$8\r[3s\u0019\u0006<7\u000b^1ug\"A\u0011Q\t\u0001!\u0002\u0013\ti$\u0001\tgKR\u001c\u0007.\u001a:MC\u001e\u001cF/\u0019;tA!I\u0011\u0011\n\u0001C\u0002\u0013\u0005\u00111J\u0001\u0014M\u0016$8\r\u001b*fcV,7\u000f\u001e\"vS2$WM]\u000b\u0003\u0003\u001b\u0002B!a\u0014\u0002V5\u0011\u0011\u0011\u000b\u0006\u0004\u0003'\"\u0011aA1qS&!\u0011qKA)\u0005M1U\r^2i%\u0016\fX/Z:u\u0005VLG\u000eZ3s\u0011!\tY\u0006\u0001Q\u0001\n\u00055\u0013\u0001\u00064fi\u000eD'+Z9vKN$()^5mI\u0016\u0014\b\u0005C\u0004\u0002`\u00011\t!!\u0019\u0002)A\u0014xnY3tgB\u000b'\u000f^5uS>tG)\u0019;b)!\t\u0019'!\u001b\u0002n\u0005E\u0004cA\b\u0002f%\u0019\u0011q\r\t\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003W\ni\u00061\u0001X\u0003E!x\u000e]5d\u0003:$\u0007+\u0019:uSRLwN\u001c\u0005\b\u0003_\ni\u00061\u0001^\u0003-1W\r^2i\u001f\u001a47/\u001a;\t\u0011\u0005M\u0014Q\fa\u0001\u0003k\nQ\u0002]1si&$\u0018n\u001c8ECR\f\u0007\u0003BA(\u0003oJA!!\u001f\u0002R\tQb)\u001a;dQJ+7\u000f]8og\u0016\u0004\u0016M\u001d;ji&|g\u000eR1uC\"9\u0011Q\u0010\u0001\u0007\u0002\u0005}\u0014A\u00065b]\u0012dWm\u00144gg\u0016$x*\u001e;PMJ\u000bgnZ3\u0015\u0007u\u000b\t\tC\u0004\u0002l\u0005m\u0004\u0019A,\t\u000f\u0005\u0015\u0005A\"\u0001\u0002\b\u0006Q\u0002.\u00198eY\u0016\u0004\u0016M\u001d;ji&|gn],ji\",%O]8sgR!\u00111MAE\u0011!\tY)a!A\u0002\u00055\u0015A\u00039beRLG/[8ogB)\u0011qRAP/:!\u0011\u0011SAN\u001d\u0011\t\u0019*!'\u000e\u0005\u0005U%bAAL\r\u00051AH]8pizJ\u0011!E\u0005\u0004\u0003;\u0003\u0012a\u00029bG.\fw-Z\u0005\u0005\u0003C\u000b\u0019K\u0001\u0005Ji\u0016\u0014\u0018M\u00197f\u0015\r\ti\n\u0005\u0005\b\u0003O\u0003A\u0011IAU\u0003!\u0019\b.\u001e;e_^tGCAA2\u0011\u001d\ti\u000b\u0001C!\u0003S\u000ba\u0001Z8X_J\\\u0007bBAY\u0001\u0011%\u00111W\u0001\u0014aJ|7-Z:t\r\u0016$8\r\u001b*fcV,7\u000f\u001e\u000b\u0005\u0003G\n)\f\u0003\u0005\u00028\u0006=\u0006\u0019AA]\u000311W\r^2i%\u0016\fX/Z:u!\u0011\ty%a/\n\t\u0005u\u0016\u0011\u000b\u0002\r\r\u0016$8\r\u001b*fcV,7\u000f\u001e\u0005\b\u0003\u0003\u0004A\u0011AAb\u00035\tG\r\u001a)beRLG/[8ogR!\u00111MAc\u0011!\t9-a0A\u0002\u0005%\u0017a\u00059beRLG/[8o\u0003:$wJ\u001a4tKR\u001c\bCBAf\u0003\u001b<V,D\u0001T\u0013\r\tym\u0015\u0002\u0004\u001b\u0006\u0004\bbBAj\u0001\u0011\u0005\u0011Q[\u0001\u0011e\u0016lwN^3QCJ$\u0018\u000e^5p]N$B!a\u0019\u0002X\"A\u0011\u0011\\Ai\u0001\u0004\tY.\u0001\nu_BL7-\u00118e!\u0006\u0014H/\u001b;j_:\u001c\b#BAf\u0003;<\u0016bAAp'\n\u00191+\u001a;\t\u000f\u0005\r\b\u0001\"\u0001\u0002f\u0006q\u0001/\u0019:uSRLwN\\\"pk:$H#\u0001\u0016\b\u0013\u0005%(!!A\t\u0006\u0005-\u0018!F!cgR\u0014\u0018m\u0019;GKR\u001c\u0007.\u001a:UQJ,\u0017\r\u001a\t\u0004\u0003\u00065h!C\u0001\u0003\t\u0007\u0005\tRAAx'\u0015\ti/!=\u000f!\u0011\t\u00190!?\u000e\u0005\u0005U(bAA|[\u0006!A.\u00198h\u0013\u0011\tY0!>\u0003\r=\u0013'.Z2u\u0011\u001dq\u0014Q\u001eC\u0001\u0003\u007f$\"!a;\t\u0015\t\r\u0011Q^I\u0001\n\u0003\u0011)!\u0001\bj]&$H\u0005Z3gCVdG\u000fJ\u001c\u0016\u0005\t\u001d!f\u0001\u0016\u0003\n-\u0012!1\u0002\t\u0005\u0005\u001b\u00119\"\u0004\u0002\u0003\u0010)!!\u0011\u0003B\n\u0003%)hn\u00195fG.,GMC\u0002\u0003\u0016A\t!\"\u00198o_R\fG/[8o\u0013\u0011\u0011IBa\u0004\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r\u0003\u0006\u0003\u001e\u00055\u0018\u0013!C\u0001\u0005\u000b\ta\"\u001b8ji\u0012\"WMZ1vYR$\u0003\b\u0003\u0006\u0003\"\u00055\u0018\u0013!C\u0001\u0005\u000b\ta\"\u001b8ji\u0012\"WMZ1vYR$\u0013\b\u0003\u0006\u0003&\u00055\u0018\u0013!C\u0001\u0005O\tq\"\u001b8ji\u0012\"WMZ1vYR$\u0013\u0007M\u000b\u0003\u0005SQ3!\u000fB\u0005\u0001")
public abstract class AbstractFetcherThread
extends ShutdownableThread
implements ScalaObject {
    public final Broker kafka$server$AbstractFetcherThread$$sourceBroker;
    public final int kafka$server$AbstractFetcherThread$$fetchSize;
    private final HashMap kafka$server$AbstractFetcherThread$$partitionMap;
    private final ReentrantLock partitionMapLock;
    private final Condition kafka$server$AbstractFetcherThread$$partitionMapCond;
    private final SimpleConsumer simpleConsumer;
    private final String brokerInfo;
    private final ClientIdAndBroker metricId;
    private final FetcherStats fetcherStats;
    private final FetcherLagStats fetcherLagStats;
    private final FetchRequestBuilder fetchRequestBuilder;

    public static final boolean init$default$10() {
        return AbstractFetcherThread$.MODULE$.init$default$10();
    }

    public static final int init$default$9() {
        return AbstractFetcherThread$.MODULE$.init$default$9();
    }

    public static final int init$default$8() {
        return AbstractFetcherThread$.MODULE$.init$default$8();
    }

    public static final int init$default$7() {
        return AbstractFetcherThread$.MODULE$.init$default$7();
    }

    public final HashMap kafka$server$AbstractFetcherThread$$partitionMap() {
        return this.kafka$server$AbstractFetcherThread$$partitionMap;
    }

    private ReentrantLock partitionMapLock() {
        return this.partitionMapLock;
    }

    public final Condition kafka$server$AbstractFetcherThread$$partitionMapCond() {
        return this.kafka$server$AbstractFetcherThread$$partitionMapCond;
    }

    public SimpleConsumer simpleConsumer() {
        return this.simpleConsumer;
    }

    private String brokerInfo() {
        return this.brokerInfo;
    }

    private ClientIdAndBroker metricId() {
        return this.metricId;
    }

    public FetcherStats fetcherStats() {
        return this.fetcherStats;
    }

    public FetcherLagStats fetcherLagStats() {
        return this.fetcherLagStats;
    }

    public FetchRequestBuilder fetchRequestBuilder() {
        return this.fetchRequestBuilder;
    }

    public abstract void processPartitionData(TopicAndPartition var1, long var2, FetchResponsePartitionData var4);

    public abstract long handleOffsetOutOfRange(TopicAndPartition var1);

    public abstract void handlePartitionsWithErrors(Iterable<TopicAndPartition> var1);

    @Override
    public void shutdown() {
        super.shutdown();
        this.simpleConsumer().close();
    }

    @Override
    public void doWork() {
        Utils$.MODULE$.inLock(this.partitionMapLock(), new $anonfun$doWork$1(this));
        FetchRequest fetchRequest = this.fetchRequestBuilder().build();
        if (!fetchRequest.requestInfo().isEmpty()) {
            this.processFetchRequest(fetchRequest);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processFetchRequest(FetchRequest fetchRequest$1) {
        HashSet partitionsWithError$1 = new HashSet();
        ObjectRef response$1 = new ObjectRef(null);
        BoxedUnit exceptionResult1 = null;
        try {
            this.trace((Function0<String>)new $anonfun$processFetchRequest$2(this, fetchRequest$1));
            response$1.elem = this.simpleConsumer().fetch(fetchRequest$1);
            exceptionResult1 = BoxedUnit.UNIT;
        }
        catch (Throwable throwable) {
            BoxedUnit boxedUnit;
            if (this.isRunning().get()) {
                this.error((Function0<String>)new $anonfun$processFetchRequest$3(this, fetchRequest$1), (Function0<Throwable>)new $anonfun$processFetchRequest$4(this, throwable));
                ReentrantLock reentrantLock = this.partitionMapLock();
                synchronized (reentrantLock) {
                    Growable growable = partitionsWithError$1.$plus$plus$eq((TraversableOnce)this.kafka$server$AbstractFetcherThread$$partitionMap().keys());
                    // MONITOREXIT @DISABLED, blocks:[1, 2, 3, 7] lbl17 : MonitorExitStatement: MONITOREXIT : var6_6
                    boxedUnit = growable;
                }
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            exceptionResult1 = boxedUnit;
        }
        this.fetcherStats().requestRate().mark();
        Object object = (FetchResponse)response$1.elem == null ? BoxedUnit.UNIT : Utils$.MODULE$.inLock(this.partitionMapLock(), new $anonfun$processFetchRequest$1(this, fetchRequest$1, partitionsWithError$1, response$1));
        if (partitionsWithError$1.size() > 0) {
            this.debug((Function0<String>)new $anonfun$processFetchRequest$5(this, partitionsWithError$1));
            this.handlePartitionsWithErrors((Iterable<TopicAndPartition>)partitionsWithError$1);
        }
    }

    public void addPartitions(Map<TopicAndPartition, Long> partitionAndOffsets) {
        this.partitionMapLock().lockInterruptibly();
        try {
            partitionAndOffsets.foreach((Function1)new $anonfun$addPartitions$1(this));
            this.kafka$server$AbstractFetcherThread$$partitionMapCond().signalAll();
            return;
        }
        finally {
            this.partitionMapLock().unlock();
        }
    }

    public void removePartitions(Set<TopicAndPartition> topicAndPartitions) {
        this.partitionMapLock().lockInterruptibly();
        try {
            topicAndPartitions.foreach((Function1)new $anonfun$removePartitions$1(this));
            return;
        }
        finally {
            this.partitionMapLock().unlock();
        }
    }

    public int partitionCount() {
        this.partitionMapLock().lockInterruptibly();
        int exceptionResult2 = 0;
        try {
            exceptionResult2 = this.kafka$server$AbstractFetcherThread$$partitionMap().size();
            return exceptionResult2;
        }
        finally {
            this.partitionMapLock().unlock();
        }
    }

    public AbstractFetcherThread(String name, String clientId, Broker sourceBroker, int socketTimeout, int socketBufferSize, int fetchSize, int fetcherBrokerId, int maxWait, int minBytes, boolean isInterruptible) {
        this.kafka$server$AbstractFetcherThread$$sourceBroker = sourceBroker;
        this.kafka$server$AbstractFetcherThread$$fetchSize = fetchSize;
        super(name, isInterruptible);
        this.kafka$server$AbstractFetcherThread$$partitionMap = new HashMap();
        this.partitionMapLock = new ReentrantLock();
        this.kafka$server$AbstractFetcherThread$$partitionMapCond = this.partitionMapLock().newCondition();
        this.simpleConsumer = new SimpleConsumer(sourceBroker.host(), sourceBroker.port(), socketTimeout, socketBufferSize, clientId);
        this.brokerInfo = Predef$.MODULE$.augmentString("host_%s-port_%s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sourceBroker.host(), BoxesRunTime.boxToInteger((int)sourceBroker.port())}));
        this.metricId = new ClientIdAndBroker(clientId, this.brokerInfo());
        this.fetcherStats = new FetcherStats(this.metricId());
        this.fetcherLagStats = new FetcherLagStats(this.metricId());
        this.fetchRequestBuilder = new FetchRequestBuilder().clientId(clientId).replicaId(fetcherBrokerId).maxWait(maxWait).minBytes(minBytes);
    }
}

