/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.util.Arrays;
import kafka.log.OffsetMap;
import kafka.log.OffsetMap$class;
import kafka.log.SkimpyOffsetMap$;
import kafka.utils.Utils$;
import scala.Function0;
import scala.Predef$;
import scala.ScalaObject;
import scala.math.package$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005]e\u0001C\u0001\u0003\t\u0003\u0005\t\u0011A\u0004\u0003\u001fM[\u0017.\u001c9z\u001f\u001a47/\u001a;NCBT!a\u0001\u0003\u0002\u00071|wMC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019B\u0001\u0001\u0005\u0011)A\u0011\u0011BD\u0007\u0002\u0015)\u00111\u0002D\u0001\u0005Y\u0006twMC\u0001\u000e\u0003\u0011Q\u0017M^1\n\u0005=Q!AB(cU\u0016\u001cG\u000f\u0005\u0002\u0012%5\t!!\u0003\u0002\u0014\u0005\tIqJ\u001a4tKRl\u0015\r\u001d\t\u0003+ai\u0011A\u0006\u0006\u0002/\u0005)1oY1mC&\u0011\u0011D\u0006\u0002\f'\u000e\fG.Y(cU\u0016\u001cG\u000f\u0003\u0005\u001c\u0001\t\u0015\r\u0011\"\u0001\u001d\u0003\u0019iW-\\8ssV\tQ\u0004\u0005\u0002\u0016=%\u0011qD\u0006\u0002\u0004\u0013:$\b\u0002C\u0011\u0001\u0005\u0003\u0005\u000b\u0011B\u000f\u0002\u000f5,Wn\u001c:zA!A1\u0005\u0001BC\u0002\u0013\u0005A%A\u0007iCND\u0017\t\\4pe&$\b.\\\u000b\u0002KA\u0011a%\u000b\b\u0003+\u001dJ!\u0001\u000b\f\u0002\rA\u0013X\rZ3g\u0013\tQ3F\u0001\u0004TiJLgn\u001a\u0006\u0003QYA\u0001\"\f\u0001\u0003\u0002\u0003\u0006I!J\u0001\u000fQ\u0006\u001c\b.\u00117h_JLG\u000f[7!\u0011\u0015y\u0003\u0001\"\u00011\u0003\u0019a\u0014N\\5u}Q\u0019\u0011GM\u001a\u0011\u0005E\u0001\u0001\"B\u000e/\u0001\u0004i\u0002bB\u0012/!\u0003\u0005\r!\n\u0005\bk\u0001\u0011\r\u0011\"\u00037\u0003\u0015\u0011\u0017\u0010^3t+\u00059\u0004C\u0001\u001d<\u001b\u0005I$B\u0001\u001e\r\u0003\rq\u0017n\\\u0005\u0003ye\u0012!BQ=uK\n+hMZ3s\u0011\u0019q\u0004\u0001)A\u0005o\u00051!-\u001f;fg\u0002Bq\u0001\u0011\u0001C\u0002\u0013%\u0011)\u0001\u0004eS\u001e,7\u000f^\u000b\u0002\u0005B\u00111IR\u0007\u0002\t*\u0011Q\tD\u0001\tg\u0016\u001cWO]5us&\u0011q\t\u0012\u0002\u000e\u001b\u0016\u001c8/Y4f\t&<Wm\u001d;\t\r%\u0003\u0001\u0015!\u0003C\u0003\u001d!\u0017nZ3ti\u0002Bqa\u0013\u0001C\u0002\u0013%A$\u0001\u0005iCND7+\u001b>f\u0011\u0019i\u0005\u0001)A\u0005;\u0005I\u0001.Y:i'&TX\r\t\u0005\b\u001f\u0002\u0011\r\u0011\"\u0003Q\u0003\u0015A\u0017m\u001d52+\u0005\t\u0006cA\u000bS)&\u00111K\u0006\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003+UK!A\u0016\f\u0003\t\tKH/\u001a\u0005\u00071\u0002\u0001\u000b\u0011B)\u0002\r!\f7\u000f[\u0019!\u0011\u001dQ\u0006A1A\u0005\nA\u000bQ\u0001[1tQJBa\u0001\u0018\u0001!\u0002\u0013\t\u0016A\u00025bg\"\u0014\u0004\u0005C\u0004_\u0001\u0001\u0007I\u0011\u0002\u000f\u0002\u000f\u0015tGO]5fg\"9\u0001\r\u0001a\u0001\n\u0013\t\u0017aC3oiJLWm]0%KF$\"AY3\u0011\u0005U\u0019\u0017B\u00013\u0017\u0005\u0011)f.\u001b;\t\u000f\u0019|\u0016\u0011!a\u0001;\u0005\u0019\u0001\u0010J\u0019\t\r!\u0004\u0001\u0015)\u0003\u001e\u0003!)g\u000e\u001e:jKN\u0004\u0003b\u00026\u0001\u0001\u0004%Ia[\u0001\bY>|7.\u001e9t+\u0005a\u0007CA\u000bn\u0013\tqgC\u0001\u0003M_:<\u0007b\u00029\u0001\u0001\u0004%I!]\u0001\fY>|7.\u001e9t?\u0012*\u0017\u000f\u0006\u0002ce\"9am\\A\u0001\u0002\u0004a\u0007B\u0002;\u0001A\u0003&A.\u0001\u0005m_>\\W\u000f]:!\u0011\u001d1\b\u00011A\u0005\n-\fa\u0001\u001d:pE\u0016\u001c\bb\u0002=\u0001\u0001\u0004%I!_\u0001\u000baJ|'-Z:`I\u0015\fHC\u00012{\u0011\u001d1w/!AA\u00021Da\u0001 \u0001!B\u0013a\u0017a\u00029s_\n,7\u000f\t\u0005\b}\u0002\u0011\r\u0011\"\u0001\u001d\u00035\u0011\u0017\u0010^3t!\u0016\u0014XI\u001c;ss\"9\u0011\u0011\u0001\u0001!\u0002\u0013i\u0012A\u00042zi\u0016\u001c\b+\u001a:F]R\u0014\u0018\u0010\t\u0005\t\u0003\u000b\u0001!\u0019!C\u00019\u0005)1\u000f\\8ug\"9\u0011\u0011\u0002\u0001!\u0002\u0013i\u0012AB:m_R\u001c\b\u0005C\u0004\u0002\u000e\u0001!\t%a\u0004\u0002\u0007A,H\u000fF\u0003c\u0003#\t)\u0002C\u0004\u0002\u0014\u0005-\u0001\u0019A\u001c\u0002\u0007-,\u0017\u0010C\u0004\u0002\u0018\u0005-\u0001\u0019\u00017\u0002\r=4gm]3u\u0011\u001d\tY\u0002\u0001C\u0005\u0003;\tq![:F[B$\u0018\u0010\u0006\u0003\u0002 \u0005\u0015\u0002cA\u000b\u0002\"%\u0019\u00111\u0005\f\u0003\u000f\t{w\u000e\\3b]\"9\u0011qEA\r\u0001\u0004i\u0012\u0001\u00039pg&$\u0018n\u001c8\t\u000f\u0005-\u0002\u0001\"\u0011\u0002.\u0005\u0019q-\u001a;\u0015\u00071\fy\u0003C\u0004\u0002\u0014\u0005%\u0002\u0019A\u001c\t\u000f\u0005M\u0002\u0001\"\u0011\u00026\u0005)1\r\\3beR\t!\r\u0003\u0004\u0002:\u0001!\t\u0005H\u0001\u0005g&TX\rC\u0004\u0002>\u0001!\t!a\u0010\u0002\u001b\r|G\u000e\\5tS>t'+\u0019;f+\t\t\t\u0005E\u0002\u0016\u0003\u0007J1!!\u0012\u0017\u0005\u0019!u.\u001e2mK\"9\u0011\u0011\n\u0001\u0005\n\u0005-\u0013A\u00039pg&$\u0018n\u001c8PMR)Q$!\u0014\u0002R!9\u0011qJA$\u0001\u0004\t\u0016\u0001\u00025bg\"Dq!a\u0015\u0002H\u0001\u0007Q$A\u0004biR,W\u000e\u001d;\t\u000f\u0005]\u0003\u0001\"\u0003\u0002Z\u0005A\u0001.Y:i\u0013:$x\u000eF\u0003c\u00037\ni\u0006C\u0004\u0002\u0014\u0005U\u0003\u0019A\u001c\t\u000f\u0005}\u0013Q\u000ba\u0001#\u00061!-\u001e4gKJD3\u0001AA2!\u0011\t)'a\u001b\u000e\u0005\u0005\u001d$bAA5\t\u0005)Q\u000f^5mg&!\u0011QNA4\u00055qwN\u001c;ie\u0016\fGm]1gK\u001eI\u0011\u0011\u000f\u0002\u0002\u0002#\u0015\u00111O\u0001\u0010'.LW\u000e]=PM\u001a\u001cX\r^'baB\u0019\u0011#!\u001e\u0007\u0013\u0005\u0011A1!A\t\u0006\u0005]4\u0003BA;\u0011QAqaLA;\t\u0003\tY\b\u0006\u0002\u0002t!Q\u0011qPA;#\u0003%\t!!!\u0002\u001d%t\u0017\u000e\u001e\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u00111\u0011\u0016\u0004K\u0005\u00155FAAD!\u0011\tI)a%\u000e\u0005\u0005-%\u0002BAG\u0003\u001f\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005Ee#\u0001\u0006b]:|G/\u0019;j_:LA!!&\u0002\f\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3")
public class SkimpyOffsetMap
implements OffsetMap,
ScalaObject {
    private final int memory;
    private final String hashAlgorithm;
    private final ByteBuffer bytes;
    private final MessageDigest digest;
    private final int hashSize;
    private final byte[] hash1;
    private final byte[] hash2;
    private int entries;
    private long lookups;
    private long probes;
    private final int bytesPerEntry;
    private final int slots;

    public static final String init$default$2() {
        return SkimpyOffsetMap$.MODULE$.init$default$2();
    }

    public double utilization() {
        return OffsetMap$class.utilization(this);
    }

    public int memory() {
        return this.memory;
    }

    public String hashAlgorithm() {
        return this.hashAlgorithm;
    }

    private ByteBuffer bytes() {
        return this.bytes;
    }

    private MessageDigest digest() {
        return this.digest;
    }

    private int hashSize() {
        return this.hashSize;
    }

    private byte[] hash1() {
        return this.hash1;
    }

    private byte[] hash2() {
        return this.hash2;
    }

    private int entries() {
        return this.entries;
    }

    private void entries_$eq(int n) {
        this.entries = n;
    }

    private long lookups() {
        return this.lookups;
    }

    private void lookups_$eq(long l) {
        this.lookups = l;
    }

    private long probes() {
        return this.probes;
    }

    private void probes_$eq(long l) {
        this.probes = l;
    }

    public int bytesPerEntry() {
        return this.bytesPerEntry;
    }

    public int slots() {
        return this.slots;
    }

    public void put(ByteBuffer key, long offset) {
        Predef$.MODULE$.require(this.entries() < this.slots(), (Function0)new $anonfun$put$1(this));
        this.lookups_$eq(this.lookups() + 1L);
        this.hashInto(key, this.hash1());
        int attempt = 0;
        int pos = this.positionOf(this.hash1(), attempt);
        while (true) {
            if (this.isEmpty(pos)) {
                this.bytes().position(pos);
                this.bytes().put(this.hash1());
                this.bytes().putLong(offset);
                this.entries_$eq(this.entries() + 1);
                return;
            }
            this.bytes().position(pos);
            this.bytes().get(this.hash2());
            if (Arrays.equals(this.hash1(), this.hash2())) {
                this.bytes().putLong(offset);
                return;
            }
            pos = this.positionOf(this.hash1(), ++attempt);
        }
    }

    private boolean isEmpty(int position) {
        return this.bytes().getLong(position) == 0L && this.bytes().getLong(position + 8) == 0L && this.bytes().getLong(position + 16) == 0L;
    }

    public long get(ByteBuffer key) {
        this.lookups_$eq(this.lookups() + 1L);
        this.hashInto(key, this.hash1());
        int attempt = 0;
        int pos = 0;
        do {
            pos = this.positionOf(this.hash1(), attempt);
            this.bytes().position(pos);
            if (this.isEmpty(pos)) {
                return -1L;
            }
            this.bytes().get(this.hash2());
            ++attempt;
        } while (!Arrays.equals(this.hash1(), this.hash2()));
        return this.bytes().getLong();
    }

    public void clear() {
        this.entries_$eq(0);
        this.lookups_$eq(0L);
        this.probes_$eq(0L);
        Arrays.fill(this.bytes().array(), this.bytes().arrayOffset(), this.bytes().arrayOffset() + this.bytes().limit(), (byte)0);
    }

    public int size() {
        return this.entries();
    }

    public double collisionRate() {
        return (double)(this.probes() - this.lookups()) / (double)this.lookups();
    }

    private int positionOf(byte[] hash, int attempt) {
        int probe = Utils$.MODULE$.readInt(hash, package$.MODULE$.min(attempt, this.hashSize() - 4)) + package$.MODULE$.max(0, attempt - this.hashSize() + 4);
        int slot = Utils$.MODULE$.abs(probe) % this.slots();
        this.probes_$eq(this.probes() + 1L);
        return slot * this.bytesPerEntry();
    }

    private void hashInto(ByteBuffer key, byte[] buffer) {
        key.mark();
        this.digest().update(key);
        key.reset();
        this.digest().digest(buffer, 0, this.hashSize());
    }

    public SkimpyOffsetMap(int memory, String hashAlgorithm) {
        this.memory = memory;
        this.hashAlgorithm = hashAlgorithm;
        OffsetMap$class.$init$(this);
        this.bytes = ByteBuffer.allocate(memory);
        this.digest = MessageDigest.getInstance(hashAlgorithm);
        this.hashSize = this.digest().getDigestLength();
        this.hash1 = new byte[this.hashSize()];
        this.hash2 = new byte[this.hashSize()];
        this.entries = 0;
        this.lookups = 0L;
        this.probes = 0L;
        this.bytesPerEntry = this.hashSize() + 8;
        this.slots = memory / this.bytesPerEntry();
    }
}

