/*
 * Decompiled with CFR 0.152.
 */
package kafka.consumer;

import java.io.OutputStream;
import java.util.Properties;
import java.util.Random;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import kafka.consumer.Blacklist;
import kafka.consumer.ConsoleConsumer$;
import kafka.consumer.Consumer$;
import kafka.consumer.ConsumerConfig;
import kafka.consumer.ConsumerConfig$;
import kafka.consumer.ConsumerConnector;
import kafka.consumer.DefaultMessageFormatter;
import kafka.consumer.KafkaStream;
import kafka.consumer.MessageFormatter;
import kafka.consumer.MessageFormatter$;
import kafka.consumer.TopicFilter;
import kafka.consumer.Whitelist;
import kafka.metrics.KafkaMetricsReporter$;
import kafka.serializer.DefaultDecoder;
import kafka.serializer.DefaultDecoder$;
import kafka.utils.CommandLineUtils$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.Utils$;
import kafka.utils.VerifiableProperties;
import kafka.utils.ZKStringSerializer$;
import kafka.utils.ZkUtils$;
import org.I0Itec.zkclient.ZkClient;
import org.I0Itec.zkclient.serialize.ZkSerializer;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.ScalaObject;
import scala.collection.Iterable;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class ConsoleConsumer$
implements Logging,
ScalaObject {
    public static final ConsoleConsumer$ MODULE$;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    static {
        new ConsoleConsumer$();
    }

    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        ConsoleConsumer$ consoleConsumer$ = this;
        synchronized (consoleConsumer$) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String string) {
        this.logIdent = string;
    }

    public final Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string) {
        this.loggerName = string;
    }

    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    public void trace(Function0 msg) {
        Logging$class.trace(this, msg);
    }

    public Object trace(Function0 e) {
        return Logging$class.trace(this, e);
    }

    public void trace(Function0 msg, Function0 e) {
        Logging$class.trace(this, msg, e);
    }

    public void swallowTrace(Function0 action) {
        Logging$class.swallowTrace(this, action);
    }

    public void debug(Function0 msg) {
        Logging$class.debug(this, msg);
    }

    public Object debug(Function0 e) {
        return Logging$class.debug(this, e);
    }

    public void debug(Function0 msg, Function0 e) {
        Logging$class.debug(this, msg, e);
    }

    public void swallowDebug(Function0 action) {
        Logging$class.swallowDebug(this, action);
    }

    public void info(Function0 msg) {
        Logging$class.info(this, msg);
    }

    public Object info(Function0 e) {
        return Logging$class.info(this, e);
    }

    public void info(Function0 msg, Function0 e) {
        Logging$class.info(this, msg, e);
    }

    public void swallowInfo(Function0 action) {
        Logging$class.swallowInfo(this, action);
    }

    public void warn(Function0 msg) {
        Logging$class.warn(this, msg);
    }

    public Object warn(Function0 e) {
        return Logging$class.warn(this, e);
    }

    public void warn(Function0 msg, Function0 e) {
        Logging$class.warn(this, msg, e);
    }

    public void swallowWarn(Function0 action) {
        Logging$class.swallowWarn(this, action);
    }

    public void swallow(Function0 action) {
        Logging$class.swallow(this, action);
    }

    public void error(Function0 msg) {
        Logging$class.error(this, msg);
    }

    public Object error(Function0 e) {
        return Logging$class.error(this, e);
    }

    public void error(Function0 msg, Function0 e) {
        Logging$class.error(this, msg, e);
    }

    public void swallowError(Function0 action) {
        Logging$class.swallowError(this, action);
    }

    public void fatal(Function0 msg) {
        Logging$class.fatal(this, msg);
    }

    public Object fatal(Function0 e) {
        return Logging$class.fatal(this, e);
    }

    public void fatal(Function0 msg, Function0 e) {
        Logging$class.fatal(this, msg, e);
    }

    public void main(String[] args) {
        OptionParser parser = new OptionParser();
        ArgumentAcceptingOptionSpec topicIdOpt = parser.accepts("topic", "The topic id to consume on.").withRequiredArg().describedAs("topic").ofType(String.class);
        ArgumentAcceptingOptionSpec whitelistOpt = parser.accepts("whitelist", "Whitelist of topics to include for consumption.").withRequiredArg().describedAs("whitelist").ofType(String.class);
        ArgumentAcceptingOptionSpec blacklistOpt = parser.accepts("blacklist", "Blacklist of topics to exclude from consumption.").withRequiredArg().describedAs("blacklist").ofType(String.class);
        ArgumentAcceptingOptionSpec zkConnectOpt$1 = parser.accepts("zookeeper", "REQUIRED: The connection string for the zookeeper connection in the form host:port. Multiple URLS can be given to allow fail-over.").withRequiredArg().describedAs("urls").ofType(String.class);
        ArgumentAcceptingOptionSpec groupIdOpt$1 = parser.accepts("group", "The group id to consume on.").withRequiredArg().describedAs("gid").defaultsTo((Object)new StringBuilder().append((Object)"console-consumer-").append((Object)BoxesRunTime.boxToInteger((int)new Random().nextInt(100000))).toString(), (Object[])new String[0]).ofType(String.class);
        ArgumentAcceptingOptionSpec fetchSizeOpt = parser.accepts("fetch-size", "The amount of data to fetch in a single request.").withRequiredArg().describedAs("size").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(0x100000), (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec minFetchBytesOpt = parser.accepts("min-fetch-bytes", "The min number of bytes each fetch request waits for.").withRequiredArg().describedAs("bytes").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(1), (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec maxWaitMsOpt = parser.accepts("max-wait-ms", "The max amount of time each fetch request waits.").withRequiredArg().describedAs("ms").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(100), (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec socketBufferSizeOpt = parser.accepts("socket-buffer-size", "The size of the tcp RECV size.").withRequiredArg().describedAs("size").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(0x200000), (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec socketTimeoutMsOpt = parser.accepts("socket-timeout-ms", "The socket timeout used for the connection to the broker").withRequiredArg().describedAs("ms").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(ConsumerConfig$.MODULE$.SocketTimeout()), (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec refreshMetadataBackoffMsOpt = parser.accepts("refresh-leader-backoff-ms", "Backoff time before refreshing metadata").withRequiredArg().describedAs("ms").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(ConsumerConfig$.MODULE$.RefreshMetadataBackoffMs()), (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec consumerTimeoutMsOpt = parser.accepts("consumer-timeout-ms", "consumer throws timeout exception after waiting this much of time without incoming messages").withRequiredArg().describedAs("prop").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(-1), (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec messageFormatterOpt = parser.accepts("formatter", "The name of a class to use for formatting kafka messages for display.").withRequiredArg().describedAs("class").ofType(String.class).defaultsTo((Object)DefaultMessageFormatter.class.getName(), (Object[])new String[0]);
        ArgumentAcceptingOptionSpec messageFormatterArgOpt = parser.accepts("property").withRequiredArg().describedAs("prop").ofType(String.class);
        OptionSpecBuilder resetBeginningOpt = parser.accepts("from-beginning", "If the consumer does not already have an established offset to consume from, start with the earliest message present in the log rather than the latest message.");
        ArgumentAcceptingOptionSpec autoCommitIntervalOpt = parser.accepts("autocommit.interval.ms", "The time interval at which to save the current offset in ms").withRequiredArg().describedAs("ms").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(ConsumerConfig$.MODULE$.AutoCommitInterval()), (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec maxMessagesOpt = parser.accepts("max-messages", "The maximum number of messages to consume before exiting. If not set, consumption is continual.").withRequiredArg().describedAs("num_messages").ofType(Integer.class);
        OptionSpecBuilder skipMessageOnErrorOpt = parser.accepts("skip-message-on-error", "If there is an error when processing a message, skip it instead of halt.");
        OptionSpecBuilder csvMetricsReporterEnabledOpt = parser.accepts("csv-reporter-enabled", "If set, the CSV metrics reporter will be enabled");
        ArgumentAcceptingOptionSpec metricsDirectoryOpt = parser.accepts("metrics-dir", "If csv-reporter-enable is set, and this parameter isset, the csv metrics will be outputed here").withRequiredArg().describedAs("metrics dictory").ofType(String.class);
        OptionSet options$1 = this.tryParse(parser, args);
        CommandLineUtils$.MODULE$.checkRequiredArgs(parser, options$1, (Seq<OptionSpec<?>>)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{zkConnectOpt$1}));
        List topicOrFilterOpt = (List)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ArgumentAcceptingOptionSpec[]{topicIdOpt, whitelistOpt, blacklistOpt})).filter((Function1)new anonfun.1(options$1));
        if (topicOrFilterOpt.size() != 1) {
            this.error((Function0<String>)new anonfun.main.1());
            parser.printHelpOn((OutputStream)System.err);
            System.exit(1);
        }
        String topicArg = (String)options$1.valueOf((OptionSpec)topicOrFilterOpt.head());
        TopicFilter filterSpec = options$1.has((OptionSpec)blacklistOpt) ? new Blacklist(topicArg) : new Whitelist(topicArg);
        boolean csvMetricsReporterEnabled = options$1.has((OptionSpec)csvMetricsReporterEnabledOpt);
        if (csvMetricsReporterEnabled) {
            Properties csvReporterProps = new Properties();
            csvReporterProps.put("kafka.metrics.polling.interval.secs", "5");
            csvReporterProps.put("kafka.metrics.reporters", "kafka.metrics.KafkaCSVMetricsReporter");
            Object object = options$1.has((OptionSpec)metricsDirectoryOpt) ? csvReporterProps.put("kafka.csv.metrics.dir", options$1.valueOf((OptionSpec)metricsDirectoryOpt)) : csvReporterProps.put("kafka.csv.metrics.dir", "kafka_metrics");
            csvReporterProps.put("kafka.csv.metrics.reporter.enabled", "true");
            VerifiableProperties verifiableProps = new VerifiableProperties(csvReporterProps);
            KafkaMetricsReporter$.MODULE$.startReporters(verifiableProps);
        }
        Properties props = new Properties();
        props.put("group.id", options$1.valueOf((OptionSpec)groupIdOpt$1));
        props.put("socket.receive.buffer.bytes", ((Integer)options$1.valueOf((OptionSpec)socketBufferSizeOpt)).toString());
        props.put("socket.timeout.ms", ((Integer)options$1.valueOf((OptionSpec)socketTimeoutMsOpt)).toString());
        props.put("fetch.message.max.bytes", ((Integer)options$1.valueOf((OptionSpec)fetchSizeOpt)).toString());
        props.put("fetch.min.bytes", ((Integer)options$1.valueOf((OptionSpec)minFetchBytesOpt)).toString());
        props.put("fetch.wait.max.ms", ((Integer)options$1.valueOf((OptionSpec)maxWaitMsOpt)).toString());
        props.put("auto.commit.enable", "true");
        props.put("auto.commit.interval.ms", ((Integer)options$1.valueOf((OptionSpec)autoCommitIntervalOpt)).toString());
        props.put("auto.offset.reset", options$1.has((OptionSpec)resetBeginningOpt) ? "smallest" : "largest");
        props.put("zookeeper.connect", options$1.valueOf((OptionSpec)zkConnectOpt$1));
        props.put("consumer.timeout.ms", ((Integer)options$1.valueOf((OptionSpec)consumerTimeoutMsOpt)).toString());
        props.put("refresh.leader.backoff.ms", ((Integer)options$1.valueOf((OptionSpec)refreshMetadataBackoffMsOpt)).toString());
        ConsumerConfig config = new ConsumerConfig(props);
        boolean skipMessageOnError$1 = options$1.has((OptionSpec)skipMessageOnErrorOpt);
        Class<?> messageFormatterClass = Class.forName((String)options$1.valueOf((OptionSpec)messageFormatterOpt));
        Properties formatterArgs = MessageFormatter$.MODULE$.tryParseFormatterArgs((Iterable<String>)JavaConversions$.MODULE$.asBuffer(options$1.valuesOf((OptionSpec)messageFormatterArgOpt)));
        int maxMessages = options$1.has((OptionSpec)maxMessagesOpt) ? (Integer)options$1.valueOf((OptionSpec)maxMessagesOpt) : -1;
        ConsumerConnector connector$1 = Consumer$.MODULE$.create(config);
        if (options$1.has((OptionSpec)resetBeginningOpt)) {
            ZkUtils$.MODULE$.maybeDeletePath((String)options$1.valueOf((OptionSpec)zkConnectOpt$1), new StringBuilder().append((Object)"/consumers/").append(options$1.valueOf((OptionSpec)groupIdOpt$1)).toString());
        }
        Runtime.getRuntime().addShutdownHook(new anon.1(zkConnectOpt$1, groupIdOpt$1, options$1, connector$1));
        LongRef numMessages$1 = new LongRef(0L);
        MessageFormatter formatter$1 = (MessageFormatter)messageFormatterClass.newInstance();
        formatter$1.init(formatterArgs);
        try {
            KafkaStream stream = (KafkaStream)JavaConversions$.MODULE$.asList(connector$1.createMessageStreamsByFilter(filterSpec, 1, new DefaultDecoder(DefaultDecoder$.MODULE$.init$default$1()), new DefaultDecoder(DefaultDecoder$.MODULE$.init$default$1()))).get(0);
            KafkaStream iter = maxMessages >= 0 ? (Iterable)stream.slice(0, maxMessages) : stream;
            iter.foreach((Function1)new anonfun.main.2(skipMessageOnError$1, connector$1, numMessages$1, formatter$1));
        }
        catch (Throwable throwable) {
            this.error((Function0<String>)new anonfun.main.3(), (Function0<Throwable>)new anonfun.main.4(throwable));
        }
        System.err.println(Predef$.MODULE$.augmentString("Consumed %d messages").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)numMessages$1.elem)})));
        System.out.flush();
        formatter$1.close();
        connector$1.shutdown();
    }

    /*
     * WARNING - void declaration
     */
    public OptionSet tryParse(OptionParser parser, String[] args) {
        void var3_3;
        OptionSet exceptionResult1 = null;
        try {
            exceptionResult1 = parser.parse(args);
        }
        catch (OptionException optionException) {
            Utils$.MODULE$.croak(optionException.getMessage());
            exceptionResult1 = null;
        }
        return var3_3;
    }

    public void tryCleanupZookeeper(String zkUrl, String groupId) {
        try {
            String dir$1 = new StringBuilder().append((Object)"/consumers/").append((Object)groupId).toString();
            this.info((Function0<String>)new anonfun.tryCleanupZookeeper.1(dir$1));
            ZkClient zk = new ZkClient(zkUrl, 30000, 30000, (ZkSerializer)ZKStringSerializer$.MODULE$);
            zk.deleteRecursive(dir$1);
            zk.close();
        }
        catch (Throwable throwable) {}
    }

    private ConsoleConsumer$() {
        MODULE$ = this;
        Logging$class.$init$(this);
    }
}

