/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.repl.load.message;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.messaging.AlterPartitionMessage;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.repl.load.message.AbstractMessageHandler;
import org.apache.hadoop.hive.ql.parse.repl.load.message.MessageHandler;
import org.apache.hadoop.hive.ql.plan.DDLWork;
import org.apache.hadoop.hive.ql.plan.TruncateTableDesc;

public class TruncatePartitionHandler
extends AbstractMessageHandler {
    @Override
    public List<Task<? extends Serializable>> handle(MessageHandler.Context context) throws SemanticException {
        AlterPartitionMessage msg = this.deserializer.getAlterPartitionMessage(context.dmd.getPayload());
        String actualDbName = context.isDbNameEmpty() ? msg.getDB() : context.dbName;
        String actualTblName = context.isTableNameEmpty() ? msg.getTable() : context.tableName;
        LinkedHashMap<String, String> partSpec = new LinkedHashMap<String, String>();
        try {
            Table tblObj = msg.getTableObj();
            Iterator<String> afterIterator = msg.getPtnObjAfter().getValuesIterator();
            for (FieldSchema fs : tblObj.getPartitionKeys()) {
                partSpec.put(fs.getName(), afterIterator.next());
            }
        }
        catch (Exception e) {
            if (!(e instanceof SemanticException)) {
                throw new SemanticException("Error reading message members", e);
            }
            throw (SemanticException)e;
        }
        TruncateTableDesc truncateTableDesc = new TruncateTableDesc(actualDbName + "." + actualTblName, partSpec, context.eventOnlyReplicationSpec());
        Task<DDLWork> truncatePtnTask = TaskFactory.get(new DDLWork((HashSet<ReadEntity>)this.readEntitySet, (HashSet<WriteEntity>)this.writeEntitySet, truncateTableDesc), context.hiveConf);
        context.log.debug("Added truncate ptn task : {}:{}", (Object)truncatePtnTask.getId(), (Object)truncateTableDesc.getTableName());
        this.updatedMetadata.set(context.dmd.getEventTo().toString(), actualDbName, actualTblName, partSpec);
        return Collections.singletonList(truncatePtnTask);
    }
}

