/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.conf;

import java.net.InetSocketAddress;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.conf.HAUtil;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.webapp.util.WebAppUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestYarnConfiguration {
    @Test
    public void testDefaultRMWebUrl() throws Exception {
        YarnConfiguration conf = new YarnConfiguration();
        String rmWebUrl = WebAppUtils.getRMWebAppURLWithScheme((Configuration)conf);
        junit.framework.Assert.assertNotSame((String)"RM Web Url is not correct", (Object)"http://0.0.0.0:8088", (Object)rmWebUrl);
    }

    @Test
    public void testRMWebUrlSpecified() throws Exception {
        YarnConfiguration conf = new YarnConfiguration();
        conf.set("yarn.resourcemanager.webapp.address", "fortesting:24543");
        conf.set("yarn.resourcemanager.address", "rmtesting:9999");
        String rmWebUrl = WebAppUtils.getRMWebAppURLWithScheme((Configuration)conf);
        String[] parts = rmWebUrl.split(":");
        junit.framework.Assert.assertEquals((String)"RM Web URL Port is incrrect", (int)24543, (int)Integer.valueOf(parts[parts.length - 1]));
        junit.framework.Assert.assertNotSame((String)"RM Web Url not resolved correctly. Should not be rmtesting", (Object)"http://rmtesting:24543", (Object)rmWebUrl);
    }

    @Test
    public void testGetSocketAddressForNMWithHA() {
        YarnConfiguration conf = new YarnConfiguration();
        conf.set("yarn.nodemanager.address", "0.0.0.0:1234");
        conf.setBoolean("yarn.resourcemanager.ha.enabled", true);
        conf.set("yarn.resourcemanager.ha.id", "rm1");
        Assert.assertTrue((boolean)HAUtil.isHAEnabled((Configuration)conf));
        InetSocketAddress addr = conf.getSocketAddr("yarn.nodemanager.address", "0.0.0.0:0", 0);
        Assert.assertEquals((long)1234L, (long)addr.getPort());
    }
}

