/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.conf;

import java.util.Collection;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.conf.HAUtil;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestHAUtil {
    private Configuration conf;
    private static final String RM1_ADDRESS_UNTRIMMED = "  \t\t\n 1.2.3.4:8021  \n\t ";
    private static final String RM1_ADDRESS = "  \t\t\n 1.2.3.4:8021  \n\t ".trim();
    private static final String RM2_ADDRESS = "localhost:8022";
    private static final String RM3_ADDRESS = "localhost:8033";
    private static final String RM1_NODE_ID_UNTRIMMED = "rm1 ";
    private static final String RM1_NODE_ID = "rm1 ".trim();
    private static final String RM2_NODE_ID = "rm2";
    private static final String RM3_NODE_ID = "rm3";
    private static final String RM_INVALID_NODE_ID = ".rm";
    private static final String RM_NODE_IDS_UNTRIMMED = "rm1 ,rm2";
    private static final String RM_NODE_IDS = RM1_NODE_ID + "," + "rm2";

    @Before
    public void setUp() {
        this.conf = new Configuration();
        this.conf.set("yarn.resourcemanager.ha.rm-ids", RM_NODE_IDS_UNTRIMMED);
        this.conf.set("yarn.resourcemanager.ha.id", RM1_NODE_ID_UNTRIMMED);
        for (String confKey : YarnConfiguration.RM_SERVICES_ADDRESS_CONF_KEYS) {
            this.conf.set(HAUtil.addSuffix((String)confKey, (String)RM1_NODE_ID), RM1_ADDRESS_UNTRIMMED);
            this.conf.set(HAUtil.addSuffix((String)confKey, (String)RM2_NODE_ID), RM2_ADDRESS);
        }
    }

    @Test
    public void testGetRMServiceId() throws Exception {
        this.conf.set("yarn.resourcemanager.ha.rm-ids", RM1_NODE_ID + "," + RM2_NODE_ID);
        Collection rmhaIds = HAUtil.getRMHAIds((Configuration)this.conf);
        Assert.assertEquals((long)2L, (long)rmhaIds.size());
        String[] ids = rmhaIds.toArray(new String[0]);
        Assert.assertEquals((Object)RM1_NODE_ID, (Object)ids[0]);
        Assert.assertEquals((Object)RM2_NODE_ID, (Object)ids[1]);
    }

    @Test
    public void testGetRMId() throws Exception {
        this.conf.set("yarn.resourcemanager.ha.id", RM1_NODE_ID);
        Assert.assertEquals((String)"Does not honor yarn.resourcemanager.ha.id", (Object)RM1_NODE_ID, (Object)HAUtil.getRMHAId((Configuration)this.conf));
        this.conf.clear();
        Assert.assertNull((String)"Return null when yarn.resourcemanager.ha.id is not set", (Object)HAUtil.getRMHAId((Configuration)this.conf));
    }

    @Test
    public void testVerifyAndSetConfiguration() throws Exception {
        try {
            HAUtil.verifyAndSetConfiguration((Configuration)this.conf);
        }
        catch (YarnRuntimeException e) {
            Assert.fail((String)"Should not throw any exceptions.");
        }
        Assert.assertEquals((String)"Should be saved as Trimmed collection", (Object)StringUtils.getStringCollection((String)RM_NODE_IDS), (Object)HAUtil.getRMHAIds((Configuration)this.conf));
        Assert.assertEquals((String)"Should be saved as Trimmed string", (Object)RM1_NODE_ID, (Object)HAUtil.getRMHAId((Configuration)this.conf));
        for (String confKey : YarnConfiguration.RM_SERVICES_ADDRESS_CONF_KEYS) {
            Assert.assertEquals((String)("RPC address not set for " + confKey), (Object)RM1_ADDRESS, (Object)this.conf.get(confKey));
        }
        this.conf.clear();
        this.conf.set("yarn.resourcemanager.ha.rm-ids", RM1_NODE_ID);
        try {
            HAUtil.verifyAndSetConfiguration((Configuration)this.conf);
        }
        catch (YarnRuntimeException e) {
            Assert.assertEquals((String)"YarnRuntimeException by verifyAndSetRMHAIds()", (Object)("Invalid configuration! " + HAUtil.getInvalidValueMessage((String)"yarn.resourcemanager.ha.rm-ids", (String)(this.conf.get("yarn.resourcemanager.ha.rm-ids") + "\nHA mode requires atleast two RMs"))), (Object)e.getMessage());
        }
        this.conf.clear();
        this.conf.set("yarn.resourcemanager.ha.rm-ids", RM1_NODE_ID + "," + RM2_NODE_ID);
        for (String confKey : YarnConfiguration.RM_SERVICES_ADDRESS_CONF_KEYS) {
            this.conf.set(HAUtil.addSuffix((String)confKey, (String)RM1_NODE_ID), RM1_ADDRESS);
            this.conf.set(HAUtil.addSuffix((String)confKey, (String)RM2_NODE_ID), RM2_ADDRESS);
        }
        try {
            HAUtil.verifyAndSetConfiguration((Configuration)this.conf);
        }
        catch (YarnRuntimeException e) {
            Assert.assertEquals((String)"YarnRuntimeException by getRMId()", (Object)("Invalid configuration! " + HAUtil.getNeedToSetValueMessage((String)"yarn.resourcemanager.ha.id")), (Object)e.getMessage());
        }
        this.conf.clear();
        this.conf.set("yarn.resourcemanager.ha.id", RM_INVALID_NODE_ID);
        this.conf.set("yarn.resourcemanager.ha.rm-ids", ".rm," + RM1_NODE_ID);
        for (String confKey : YarnConfiguration.RM_SERVICES_ADDRESS_CONF_KEYS) {
            this.conf.set(confKey + RM_INVALID_NODE_ID, RM_INVALID_NODE_ID);
        }
        try {
            HAUtil.verifyAndSetConfiguration((Configuration)this.conf);
        }
        catch (YarnRuntimeException e) {
            Assert.assertEquals((String)"YarnRuntimeException by addSuffix()", (Object)("Invalid configuration! " + HAUtil.getInvalidValueMessage((String)"yarn.resourcemanager.ha.id", (String)RM_INVALID_NODE_ID)), (Object)e.getMessage());
        }
        this.conf.clear();
        this.conf.set("yarn.resourcemanager.ha.id", RM1_NODE_ID);
        this.conf.set("yarn.resourcemanager.ha.rm-ids", RM1_NODE_ID + "," + RM2_NODE_ID);
        try {
            HAUtil.verifyAndSetConfiguration((Configuration)this.conf);
            Assert.fail((String)"Should throw YarnRuntimeException. by Configuration#set()");
        }
        catch (YarnRuntimeException e) {
            String confKey;
            confKey = HAUtil.addSuffix((String)"yarn.resourcemanager.address", (String)RM1_NODE_ID);
            Assert.assertEquals((String)"YarnRuntimeException by Configuration#set()", (Object)("Invalid configuration! " + HAUtil.getNeedToSetValueMessage((String)confKey)), (Object)e.getMessage());
        }
        this.conf.clear();
        this.conf.set("yarn.resourcemanager.ha.rm-ids", "rm2,rm3");
        this.conf.set("yarn.resourcemanager.ha.id", RM1_NODE_ID_UNTRIMMED);
        for (String confKey : YarnConfiguration.RM_SERVICES_ADDRESS_CONF_KEYS) {
            this.conf.set(HAUtil.addSuffix((String)confKey, (String)RM1_NODE_ID), RM1_ADDRESS_UNTRIMMED);
            this.conf.set(HAUtil.addSuffix((String)confKey, (String)RM2_NODE_ID), RM2_ADDRESS);
            this.conf.set(HAUtil.addSuffix((String)confKey, (String)RM3_NODE_ID), RM3_ADDRESS);
        }
        try {
            HAUtil.verifyAndSetConfiguration((Configuration)this.conf);
        }
        catch (YarnRuntimeException e) {
            Assert.assertEquals((String)"YarnRuntimeException by getRMId()'s validation", (Object)("Invalid configuration! " + HAUtil.getRMHAIdNeedToBeIncludedMessage((String)"[rm2, rm3]", (String)RM1_NODE_ID)), (Object)e.getMessage());
        }
    }

    @Test
    public void testGetConfKeyForRMInstance() {
        Assert.assertTrue((String)"RM instance id is not suffixed", (boolean)HAUtil.getConfKeyForRMInstance((String)"yarn.resourcemanager.address", (Configuration)this.conf).contains(HAUtil.getRMHAId((Configuration)this.conf)));
        Assert.assertFalse((String)"RM instance id is suffixed", (boolean)HAUtil.getConfKeyForRMInstance((String)"yarn.nodemanager.address", (Configuration)this.conf).contains(HAUtil.getRMHAId((Configuration)this.conf)));
    }
}

