/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.plan.nodes.datastream;

import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptSchema;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.prepare.RelOptTableImpl;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexNode;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.expressions.Cast;
import org.apache.flink.table.expressions.StreamRecordTimestamp;
import org.apache.flink.table.plan.nodes.FlinkRelNode;
import org.apache.flink.table.plan.nodes.datastream.DataStreamRel;
import org.apache.flink.table.plan.nodes.datastream.StreamScan;
import org.apache.flink.table.plan.schema.RowSchema;
import org.apache.flink.table.planner.StreamPlanner;
import org.apache.flink.table.runtime.types.CRow;
import org.apache.flink.table.typeutils.TimeIndicatorTypeInfo;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005ub\u0001B\u0001\u0003\u0001E\u0011a\u0002R1uCN#(/Z1n'\u000e\fgN\u0003\u0002\u0004\t\u0005QA-\u0019;bgR\u0014X-Y7\u000b\u0005\u00151\u0011!\u00028pI\u0016\u001c(BA\u0004\t\u0003\u0011\u0001H.\u00198\u000b\u0005%Q\u0011!\u0002;bE2,'BA\u0006\r\u0003\u00151G.\u001b8l\u0015\tia\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001f\u0005\u0019qN]4\u0004\u0001M\u0019\u0001A\u0005\u000f\u0011\u0005MQR\"\u0001\u000b\u000b\u0005U1\u0012\u0001B2pe\u0016T!a\u0006\r\u0002\u0007I,GN\u0003\u0002\u001a\u0019\u000591-\u00197dSR,\u0017BA\u000e\u0015\u0005%!\u0016M\u00197f'\u000e\fg\u000e\u0005\u0002\u001e=5\t!!\u0003\u0002 \u0005\tQ1\u000b\u001e:fC6\u001c6-\u00198\t\u0011\u0005\u0002!\u0011!Q\u0001\n\t\nqa\u00197vgR,'\u000f\u0005\u0002$K5\tAE\u0003\u0002\b1%\u0011a\u0005\n\u0002\u000e%\u0016dw\n\u001d;DYV\u001cH/\u001a:\t\u0011!\u0002!\u0011!Q\u0001\n%\n\u0001\u0002\u001e:bSR\u001cV\r\u001e\t\u0003G)J!a\u000b\u0013\u0003\u0017I+G\u000e\u0016:bSR\u001cV\r\u001e\u0005\t[\u0001\u0011\t\u0011)A\u0005]\u000591-\u0019;bY><\u0007CA\u00120\u0013\t\u0001DE\u0001\u0007SK2|\u0005\u000f^*dQ\u0016l\u0017\r\u0003\u00053\u0001\t\u0005\t\u0015!\u00034\u0003)!\u0017\r^1TiJ,\u0017-\u001c\u0019\u0003i}\u00022!N\u001e>\u001b\u00051$BA\u00028\u0015\tA\u0014(A\u0002ba&T!A\u000f\u0006\u0002\u0013M$(/Z1nS:<\u0017B\u0001\u001f7\u0005)!\u0015\r^1TiJ,\u0017-\u001c\t\u0003}}b\u0001\u0001B\u0005Ac\u0005\u0005\t\u0011!B\u0001\u0003\n\u0019q\fJ\u0019\u0012\u0005\tC\u0005CA\"G\u001b\u0005!%\"A#\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u001d#%a\u0002(pi\"Lgn\u001a\t\u0003\u0007&K!A\u0013#\u0003\u0007\u0005s\u0017\u0010\u0003\u0005M\u0001\t\u0005\t\u0015!\u0003N\u0003%1\u0017.\u001a7e\u0013\u0012D8\u000fE\u0002D\u001dBK!a\u0014#\u0003\u000b\u0005\u0013(/Y=\u0011\u0005\r\u000b\u0016B\u0001*E\u0005\rIe\u000e\u001e\u0005\t)\u0002\u0011\t\u0011)A\u0005+\u000611o\u00195f[\u0006\u0004\"A\u0016-\u000e\u0003]S!\u0001\u0016\u0004\n\u0005e;&!\u0003*poN\u001b\u0007.Z7b\u0011\u0015Y\u0006\u0001\"\u0001]\u0003\u0019a\u0014N\\5u}Q9QLX0aC\u001a<\u0007CA\u000f\u0001\u0011\u0015\t#\f1\u0001#\u0011\u0015A#\f1\u0001*\u0011\u0015i#\f1\u0001/\u0011\u0015\u0011$\f1\u0001ca\t\u0019W\rE\u00026w\u0011\u0004\"AP3\u0005\u0013\u0001\u000b\u0017\u0011!A\u0001\u0006\u0003\t\u0005\"\u0002'[\u0001\u0004i\u0005\"\u0002+[\u0001\u0004)\u0006\"B5\u0001\t\u0003R\u0017!\u00043fe&4XMU8x)f\u0004X\rF\u0001l!\taw.D\u0001n\u0015\tqg#\u0001\u0003usB,\u0017B\u00019n\u0005-\u0011V\r\u001c#bi\u0006$\u0016\u0010]3\t\u000bI\u0004A\u0011I:\u0002\t\r|\u0007/\u001f\u000b\u0004ibL\bCA;w\u001b\u00051\u0012BA<\u0017\u0005\u001d\u0011V\r\u001c(pI\u0016DQ\u0001K9A\u0002%BQA_9A\u0002m\fa!\u001b8qkR\u001c\b\u0003\u0002?\u0002\u0004Ql\u0011! \u0006\u0003}~\fA!\u001e;jY*\u0011\u0011\u0011A\u0001\u0005U\u00064\u0018-C\u0002\u0002\u0006u\u0014A\u0001T5ti\"9\u0011\u0011\u0002\u0001\u0005B\u0005-\u0011a\u0004;sC:\u001cH.\u0019;f)>\u0004F.\u00198\u0015\t\u00055\u0011q\u0004\t\u0005km\ny\u0001\u0005\u0003\u0002\u0012\u0005mQBAA\n\u0015\u0011\t)\"a\u0006\u0002\u000bQL\b/Z:\u000b\u0007\u0005e\u0001\"A\u0004sk:$\u0018.\\3\n\t\u0005u\u00111\u0003\u0002\u0005\u0007J{w\u000f\u0003\u0005\u0002\"\u0005\u001d\u0001\u0019AA\u0012\u0003\u001d\u0001H.\u00198oKJ\u0004B!!\n\u0002*5\u0011\u0011q\u0005\u0006\u0004\u0003CA\u0011\u0002BA\u0016\u0003O\u0011Qb\u0015;sK\u0006l\u0007\u000b\\1o]\u0016\u0014\bbBA\u0018\u0001\u0011\u0005\u0013\u0011G\u0001\rKb\u0004H.Y5o)\u0016\u0014Xn\u001d\u000b\u0005\u0003g\tI\u0004E\u0002v\u0003kI1!a\u000e\u0017\u0005%\u0011V\r\\,sSR,'\u000f\u0003\u0005\u0002<\u00055\u0002\u0019AA\u001a\u0003\t\u0001x\u000f")
public class DataStreamScan
extends TableScan
implements StreamScan {
    private final RelOptCluster cluster;
    private final RelOptSchema catalog;
    private final DataStream<?> dataStream;
    private final int[] fieldIdxs;
    private final RowSchema schema;

    @Override
    public DataStream<CRow> convertToInternalRow(RowSchema schema, DataStream<Object> input, int[] fieldIdxs, TableConfig config, Option<RexNode> rowtimeExpression) {
        return StreamScan.convertToInternalRow$(this, schema, input, fieldIdxs, config, rowtimeExpression);
    }

    @Override
    public boolean needsUpdatesAsRetraction() {
        return DataStreamRel.needsUpdatesAsRetraction$(this);
    }

    @Override
    public boolean producesUpdates() {
        return DataStreamRel.producesUpdates$(this);
    }

    @Override
    public boolean consumesRetractions() {
        return DataStreamRel.consumesRetractions$(this);
    }

    @Override
    public boolean producesRetractions() {
        return DataStreamRel.producesRetractions$(this);
    }

    @Override
    public String getExpressionString(RexNode expr, Seq<String> inFields, Option<Seq<RexNode>> localExprsTable) {
        return FlinkRelNode.getExpressionString$(this, expr, inFields, localExprsTable);
    }

    @Override
    public double estimateRowSize(RelDataType rowType) {
        return FlinkRelNode.estimateRowSize$(this, rowType);
    }

    @Override
    public double estimateDataTypeSize(RelDataType t) {
        return FlinkRelNode.estimateDataTypeSize$(this, t);
    }

    @Override
    public RelDataType deriveRowType() {
        return this.schema.relDataType();
    }

    @Override
    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new DataStreamScan(this.cluster, traitSet, this.catalog, this.dataStream, this.fieldIdxs, this.schema);
    }

    @Override
    public DataStream<CRow> translateToPlan(StreamPlanner planner) {
        TableConfig config = planner.getConfig();
        None$ rowtimeExpr = new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(this.fieldIdxs)).contains((Object)BoxesRunTime.boxToInteger((int)-1)) ? new Some((Object)new Cast(new StreamRecordTimestamp(), (TypeInformation<?>)TimeIndicatorTypeInfo.ROWTIME_INDICATOR).toRexNode(planner.getRelBuilder())) : None$.MODULE$;
        return this.convertToInternalRow(this.schema, this.dataStream, this.fieldIdxs, config, (Option<RexNode>)rowtimeExpr);
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        return pw.item("id", String.valueOf(BoxesRunTime.boxToInteger((int)this.dataStream.getId()))).item("fields", String.valueOf(String.join((CharSequence)", ", this.schema.relDataType().getFieldNames())));
    }

    public DataStreamScan(RelOptCluster cluster, RelTraitSet traitSet, RelOptSchema catalog, DataStream<?> dataStream, int[] fieldIdxs, RowSchema schema) {
        this.cluster = cluster;
        this.catalog = catalog;
        this.dataStream = dataStream;
        this.fieldIdxs = fieldIdxs;
        this.schema = schema;
        super(cluster, traitSet, RelOptTableImpl.create(catalog, schema.relDataType(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Nil$.MODULE$).asJava(), null));
        FlinkRelNode.$init$(this);
        DataStreamRel.$init$(this);
        StreamScan.$init$(this);
    }
}

