/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.expressions;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.TimeZone;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.SqlTimeTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.table.expressions.Literal;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.runtime.BoxesRunTime;

public final class Literal$
implements Serializable {
    public static Literal$ MODULE$;
    private final TimeZone UTC;

    static {
        new Literal$();
    }

    public TimeZone UTC() {
        return this.UTC;
    }

    public Literal apply(Object l) {
        Literal literal;
        Object object = l;
        if (object instanceof Integer) {
            int n = BoxesRunTime.unboxToInt((Object)object);
            literal = new Literal(BoxesRunTime.boxToInteger((int)n), (TypeInformation<?>)BasicTypeInfo.INT_TYPE_INFO);
        } else if (object instanceof Short) {
            short s = BoxesRunTime.unboxToShort((Object)object);
            literal = new Literal(BoxesRunTime.boxToShort((short)s), (TypeInformation<?>)BasicTypeInfo.SHORT_TYPE_INFO);
        } else if (object instanceof Byte) {
            byte by = BoxesRunTime.unboxToByte((Object)object);
            literal = new Literal(BoxesRunTime.boxToByte((byte)by), (TypeInformation<?>)BasicTypeInfo.BYTE_TYPE_INFO);
        } else if (object instanceof Long) {
            long l2 = BoxesRunTime.unboxToLong((Object)object);
            literal = new Literal(BoxesRunTime.boxToLong((long)l2), (TypeInformation<?>)BasicTypeInfo.LONG_TYPE_INFO);
        } else if (object instanceof Double) {
            double d = BoxesRunTime.unboxToDouble((Object)object);
            literal = new Literal(BoxesRunTime.boxToDouble((double)d), (TypeInformation<?>)BasicTypeInfo.DOUBLE_TYPE_INFO);
        } else if (object instanceof Float) {
            float f = BoxesRunTime.unboxToFloat((Object)object);
            literal = new Literal(BoxesRunTime.boxToFloat((float)f), (TypeInformation<?>)BasicTypeInfo.FLOAT_TYPE_INFO);
        } else if (object instanceof String) {
            String string = (String)object;
            literal = new Literal(string, (TypeInformation<?>)BasicTypeInfo.STRING_TYPE_INFO);
        } else if (object instanceof Boolean) {
            boolean bl = BoxesRunTime.unboxToBoolean((Object)object);
            literal = new Literal(BoxesRunTime.boxToBoolean((boolean)bl), (TypeInformation<?>)BasicTypeInfo.BOOLEAN_TYPE_INFO);
        } else if (object instanceof BigDecimal) {
            BigDecimal bigDecimal = (BigDecimal)object;
            literal = new Literal(bigDecimal, (TypeInformation<?>)BasicTypeInfo.BIG_DEC_TYPE_INFO);
        } else if (object instanceof scala.math.BigDecimal) {
            scala.math.BigDecimal bigDecimal = (scala.math.BigDecimal)object;
            literal = new Literal(bigDecimal.bigDecimal(), (TypeInformation<?>)BasicTypeInfo.BIG_DEC_TYPE_INFO);
        } else if (object instanceof Date) {
            Date date = (Date)object;
            literal = new Literal(date, (TypeInformation<?>)SqlTimeTypeInfo.DATE);
        } else if (object instanceof Time) {
            Time time = (Time)object;
            literal = new Literal(time, (TypeInformation<?>)SqlTimeTypeInfo.TIME);
        } else if (object instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)object;
            literal = new Literal(timestamp, (TypeInformation<?>)SqlTimeTypeInfo.TIMESTAMP);
        } else {
            throw new MatchError(object);
        }
        return literal;
    }

    public Literal apply(Object value, TypeInformation<?> resultType) {
        return new Literal(value, resultType);
    }

    public Option<Tuple2<Object, TypeInformation<?>>> unapply(Literal x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple2(x$0.value(), x$0.resultType()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private Literal$() {
        MODULE$ = this;
        this.UTC = TimeZone.getTimeZone("UTC");
    }
}

