/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client.program;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Random;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.flink.api.common.Plan;
import org.apache.flink.api.common.Program;
import org.apache.flink.api.common.ProgramDescription;
import org.apache.flink.client.program.JobWithJars;
import org.apache.flink.client.program.PreviewPlanEnvironment;
import org.apache.flink.client.program.ProgramInvocationException;
import org.apache.flink.client.program.ProgramParametrizationException;
import org.apache.flink.optimizer.Optimizer;
import org.apache.flink.optimizer.dag.DataSinkNode;
import org.apache.flink.optimizer.plandump.PlanJSONDumpGenerator;
import org.apache.flink.runtime.jobgraph.SavepointRestoreSettings;
import org.apache.flink.util.InstantiationUtil;

public class PackagedProgram {
    public static final String MANIFEST_ATTRIBUTE_ASSEMBLER_CLASS = "program-class";
    public static final String MANIFEST_ATTRIBUTE_MAIN_CLASS = "Main-Class";
    private final URL jarFile;
    private final String[] args;
    private final Program program;
    private final Class<?> mainClass;
    private final List<File> extractedTempLibraries;
    private final List<URL> classpaths;
    private ClassLoader userCodeClassLoader;
    private Plan plan;
    private SavepointRestoreSettings savepointSettings = SavepointRestoreSettings.none();

    public PackagedProgram(File jarFile, String ... args) throws ProgramInvocationException {
        this(jarFile, Collections.emptyList(), (String)null, args);
    }

    public PackagedProgram(File jarFile, List<URL> classpaths, String ... args) throws ProgramInvocationException {
        this(jarFile, classpaths, (String)null, args);
    }

    public PackagedProgram(File jarFile, String entryPointClassName, String ... args) throws ProgramInvocationException {
        this(jarFile, Collections.emptyList(), entryPointClassName, args);
    }

    public PackagedProgram(File jarFile, List<URL> classpaths, String entryPointClassName, String ... args) throws ProgramInvocationException {
        URL jarFileUrl;
        if (jarFile == null) {
            throw new IllegalArgumentException("The jar file must not be null.");
        }
        try {
            jarFileUrl = jarFile.getAbsoluteFile().toURI().toURL();
        }
        catch (MalformedURLException e1) {
            throw new IllegalArgumentException("The jar file path is invalid.");
        }
        PackagedProgram.checkJarFile(jarFileUrl);
        this.jarFile = jarFileUrl;
        String[] stringArray = this.args = args == null ? new String[]{} : args;
        if (entryPointClassName == null) {
            entryPointClassName = PackagedProgram.getEntryPointClassNameFromJar(jarFileUrl);
        }
        this.extractedTempLibraries = PackagedProgram.extractContainedLibraries(jarFileUrl);
        this.classpaths = classpaths;
        this.userCodeClassLoader = JobWithJars.buildUserCodeClassLoader(this.getAllLibraries(), classpaths, this.getClass().getClassLoader());
        this.mainClass = PackagedProgram.loadMainClass(entryPointClassName, this.userCodeClassLoader);
        if (Program.class.isAssignableFrom(this.mainClass)) {
            Program prg = null;
            try {
                prg = (Program)InstantiationUtil.instantiate(this.mainClass.asSubclass(Program.class), Program.class);
            }
            catch (Exception e) {
                if (!PackagedProgram.hasMainMethod(this.mainClass)) {
                    throw new ProgramInvocationException("The given program class implements the " + Program.class.getName() + " interface, but cannot be instantiated. It also declares no main(String[]) method as alternative entry point", e);
                }
            }
            catch (Throwable t) {
                throw new ProgramInvocationException("Error while trying to instantiate program class.", t);
            }
            this.program = prg;
        } else if (PackagedProgram.hasMainMethod(this.mainClass)) {
            this.program = null;
        } else {
            throw new ProgramInvocationException("The given program class neither has a main(String[]) method, nor does it implement the " + Program.class.getName() + " interface.");
        }
    }

    PackagedProgram(Class<?> entryPointClass, String ... args) throws ProgramInvocationException {
        this.jarFile = null;
        this.args = args == null ? new String[]{} : args;
        this.extractedTempLibraries = Collections.emptyList();
        this.classpaths = Collections.emptyList();
        this.userCodeClassLoader = entryPointClass.getClassLoader();
        this.mainClass = entryPointClass;
        if (Program.class.isAssignableFrom(this.mainClass)) {
            Program prg = null;
            try {
                prg = (Program)InstantiationUtil.instantiate(this.mainClass.asSubclass(Program.class), Program.class);
            }
            catch (Exception e) {
                if (!PackagedProgram.hasMainMethod(this.mainClass)) {
                    throw new ProgramInvocationException("The given program class implements the " + Program.class.getName() + " interface, but cannot be instantiated. It also declares no main(String[]) method as alternative entry point", e);
                }
            }
            catch (Throwable t) {
                throw new ProgramInvocationException("Error while trying to instantiate program class.", t);
            }
            this.program = prg;
        } else if (PackagedProgram.hasMainMethod(this.mainClass)) {
            this.program = null;
        } else {
            throw new ProgramInvocationException("The given program class neither has a main(String[]) method, nor does it implement the " + Program.class.getName() + " interface.");
        }
    }

    public void setSavepointRestoreSettings(SavepointRestoreSettings savepointSettings) {
        this.savepointSettings = savepointSettings;
    }

    public SavepointRestoreSettings getSavepointSettings() {
        return this.savepointSettings;
    }

    public String[] getArguments() {
        return this.args;
    }

    public String getMainClassName() {
        return this.mainClass.getName();
    }

    public boolean isUsingInteractiveMode() {
        return this.program == null;
    }

    public boolean isUsingProgramEntryPoint() {
        return this.program != null;
    }

    public JobWithJars getPlanWithoutJars() throws ProgramInvocationException {
        if (this.isUsingProgramEntryPoint()) {
            return new JobWithJars(this.getPlan(), Collections.emptyList(), this.classpaths, this.userCodeClassLoader);
        }
        throw new ProgramInvocationException("Cannot create a " + JobWithJars.class.getSimpleName() + " for a program that is using the interactive mode.");
    }

    public JobWithJars getPlanWithJars() throws ProgramInvocationException {
        if (this.isUsingProgramEntryPoint()) {
            return new JobWithJars(this.getPlan(), this.getAllLibraries(), this.classpaths, this.userCodeClassLoader);
        }
        throw new ProgramInvocationException("Cannot create a " + JobWithJars.class.getSimpleName() + " for a program that is using the interactive mode.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getPreviewPlan() throws ProgramInvocationException {
        List<DataSinkNode> previewPlan;
        Thread.currentThread().setContextClassLoader(this.getUserCodeClassLoader());
        if (this.isUsingProgramEntryPoint()) {
            previewPlan = Optimizer.createPreOptimizedPlan((Plan)this.getPlan());
        } else {
            PreviewPlanEnvironment env;
            block22: {
                if (!this.isUsingInteractiveMode()) throw new RuntimeException();
                env = new PreviewPlanEnvironment();
                env.setAsContext();
                try {
                    this.invokeInteractiveModeForExecution();
                }
                catch (ProgramInvocationException e) {
                    throw e;
                }
                catch (Throwable t) {
                    if (env.previewPlan != null) {
                        previewPlan = env.previewPlan;
                        break block22;
                    }
                    if (env.preview == null) throw new ProgramInvocationException("The program caused an error: ", t);
                    String string = env.preview;
                    return string;
                }
                finally {
                    env.unsetAsContext();
                }
            }
            if (env.previewPlan == null) throw new ProgramInvocationException("The program plan could not be fetched. The program silently swallowed the control flow exceptions.");
            previewPlan = env.previewPlan;
        }
        PlanJSONDumpGenerator jsonGen = new PlanJSONDumpGenerator();
        StringWriter string = new StringWriter(1024);
        try (PrintWriter pw = new PrintWriter(string);){
            jsonGen.dumpPactPlanAsJSON(previewPlan, pw);
            return string.toString();
        }
    }

    public String getDescription() throws ProgramInvocationException {
        if (ProgramDescription.class.isAssignableFrom(this.mainClass)) {
            ProgramDescription descr;
            if (this.program != null) {
                descr = (ProgramDescription)this.program;
            } else {
                try {
                    descr = (ProgramDescription)InstantiationUtil.instantiate(this.mainClass.asSubclass(ProgramDescription.class), ProgramDescription.class);
                }
                catch (Throwable t) {
                    return null;
                }
            }
            try {
                return descr.getDescription();
            }
            catch (Throwable t) {
                throw new ProgramInvocationException("Error while getting the program description" + (t.getMessage() == null ? "." : ": " + t.getMessage()), t);
            }
        }
        return null;
    }

    public void invokeInteractiveModeForExecution() throws ProgramInvocationException {
        if (!this.isUsingInteractiveMode()) {
            throw new ProgramInvocationException("Cannot invoke a plan-based program directly.");
        }
        PackagedProgram.callMainMethod(this.mainClass, this.args);
    }

    public List<URL> getClasspaths() {
        return this.classpaths;
    }

    public ClassLoader getUserCodeClassLoader() {
        return this.userCodeClassLoader;
    }

    public List<URL> getAllLibraries() {
        ArrayList<URL> libs = new ArrayList<URL>(this.extractedTempLibraries.size() + 1);
        if (this.jarFile != null) {
            libs.add(this.jarFile);
        }
        for (File tmpLib : this.extractedTempLibraries) {
            try {
                libs.add(tmpLib.getAbsoluteFile().toURI().toURL());
            }
            catch (MalformedURLException e) {
                throw new RuntimeException("URL is invalid. This should not happen.", e);
            }
        }
        return libs;
    }

    public void deleteExtractedLibraries() {
        PackagedProgram.deleteExtractedLibraries(this.extractedTempLibraries);
        this.extractedTempLibraries.clear();
    }

    private Plan getPlan() throws ProgramInvocationException {
        if (this.plan == null) {
            Thread.currentThread().setContextClassLoader(this.userCodeClassLoader);
            this.plan = PackagedProgram.createPlanFromProgram(this.program, this.args);
        }
        return this.plan;
    }

    private static boolean hasMainMethod(Class<?> entryClass) {
        Method mainMethod;
        try {
            mainMethod = entryClass.getMethod("main", String[].class);
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        catch (Throwable t) {
            throw new RuntimeException("Could not look up the main(String[]) method from the class " + entryClass.getName() + ": " + t.getMessage(), t);
        }
        return Modifier.isStatic(mainMethod.getModifiers()) && Modifier.isPublic(mainMethod.getModifiers());
    }

    private static void callMainMethod(Class<?> entryClass, String[] args) throws ProgramInvocationException {
        Method mainMethod;
        if (!Modifier.isPublic(entryClass.getModifiers())) {
            throw new ProgramInvocationException("The class " + entryClass.getName() + " must be public.");
        }
        try {
            mainMethod = entryClass.getMethod("main", String[].class);
        }
        catch (NoSuchMethodException e) {
            throw new ProgramInvocationException("The class " + entryClass.getName() + " has no main(String[]) method.");
        }
        catch (Throwable t) {
            throw new ProgramInvocationException("Could not look up the main(String[]) method from the class " + entryClass.getName() + ": " + t.getMessage(), t);
        }
        if (!Modifier.isStatic(mainMethod.getModifiers())) {
            throw new ProgramInvocationException("The class " + entryClass.getName() + " declares a non-static main method.");
        }
        if (!Modifier.isPublic(mainMethod.getModifiers())) {
            throw new ProgramInvocationException("The class " + entryClass.getName() + " declares a non-public main method.");
        }
        try {
            mainMethod.invoke(null, new Object[]{args});
        }
        catch (IllegalArgumentException e) {
            throw new ProgramInvocationException("Could not invoke the main method, arguments are not matching.", e);
        }
        catch (IllegalAccessException e) {
            throw new ProgramInvocationException("Access to the main method was denied: " + e.getMessage(), e);
        }
        catch (InvocationTargetException e) {
            Throwable exceptionInMethod = e.getTargetException();
            if (exceptionInMethod instanceof Error) {
                throw (Error)exceptionInMethod;
            }
            if (exceptionInMethod instanceof ProgramParametrizationException) {
                throw (ProgramParametrizationException)exceptionInMethod;
            }
            if (exceptionInMethod instanceof ProgramInvocationException) {
                throw (ProgramInvocationException)exceptionInMethod;
            }
            throw new ProgramInvocationException("The main method caused an error.", exceptionInMethod);
        }
        catch (Throwable t) {
            throw new ProgramInvocationException("An error occurred while invoking the program's main method: " + t.getMessage(), t);
        }
    }

    private static String getEntryPointClassNameFromJar(URL jarFile) throws ProgramInvocationException {
        JarFile jar;
        try {
            jar = new JarFile(new File(jarFile.toURI()));
        }
        catch (URISyntaxException use) {
            throw new ProgramInvocationException("Invalid file path '" + jarFile.getPath() + "'", use);
        }
        catch (IOException ioex) {
            throw new ProgramInvocationException("Error while opening jar file '" + jarFile.getPath() + "'. " + ioex.getMessage(), ioex);
        }
        try {
            Manifest manifest;
            try {
                manifest = jar.getManifest();
            }
            catch (IOException ioex) {
                throw new ProgramInvocationException("The Manifest in the jar file could not be accessed '" + jarFile.getPath() + "'. " + ioex.getMessage(), ioex);
            }
            if (manifest == null) {
                throw new ProgramInvocationException("No manifest found in jar file '" + jarFile.getPath() + "'. The manifest is need to point to the program's main class.");
            }
            Attributes attributes = manifest.getMainAttributes();
            String className = attributes.getValue(MANIFEST_ATTRIBUTE_ASSEMBLER_CLASS);
            if (className != null) {
                String string = className;
                return string;
            }
            className = attributes.getValue(MANIFEST_ATTRIBUTE_MAIN_CLASS);
            if (className != null) {
                String string = className;
                return string;
            }
            throw new ProgramInvocationException("Neither a 'Main-Class', nor a 'program-class' entry was found in the jar file.");
        }
        finally {
            try {
                jar.close();
            }
            catch (Throwable t) {
                throw new ProgramInvocationException("Could not close the JAR file: " + t.getMessage(), t);
            }
        }
    }

    private static Class<?> loadMainClass(String className, ClassLoader cl) throws ProgramInvocationException {
        ClassLoader contextCl = null;
        try {
            contextCl = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(cl);
            Class<?> clazz = Class.forName(className, false, cl);
            return clazz;
        }
        catch (ClassNotFoundException e) {
            throw new ProgramInvocationException("The program's entry point class '" + className + "' was not found in the jar file.", e);
        }
        catch (ExceptionInInitializerError e) {
            throw new ProgramInvocationException("The program's entry point class '" + className + "' threw an error during initialization.", e);
        }
        catch (LinkageError e) {
            throw new ProgramInvocationException("The program's entry point class '" + className + "' could not be loaded due to a linkage failure.", e);
        }
        catch (Throwable t) {
            throw new ProgramInvocationException("The program's entry point class '" + className + "' caused an exception during initialization: " + t.getMessage(), t);
        }
        finally {
            if (contextCl != null) {
                Thread.currentThread().setContextClassLoader(contextCl);
            }
        }
    }

    private static Plan createPlanFromProgram(Program program, String[] options) throws ProgramInvocationException {
        try {
            return program.getPlan(options);
        }
        catch (Throwable t) {
            throw new ProgramInvocationException("Error while calling the program: " + t.getMessage(), t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<File> extractContainedLibraries(URL jarFile) throws ProgramInvocationException {
        ArrayList<File> arrayList;
        Random rnd = new Random();
        ZipFile jar = null;
        try {
            Object entry;
            jar = new JarFile(new File(jarFile.toURI()));
            ArrayList<Object> containedJarFileEntries = new ArrayList<Object>();
            Enumeration<JarEntry> entries = ((JarFile)jar).entries();
            while (entries.hasMoreElements()) {
                entry = entries.nextElement();
                String name = ((ZipEntry)entry).getName();
                if (name.length() <= 8 || !name.startsWith("lib/") || !name.endsWith(".jar")) continue;
                containedJarFileEntries.add(entry);
            }
            if (containedJarFileEntries.isEmpty()) {
                entry = Collections.emptyList();
                return entry;
            }
            ArrayList<File> extractedTempLibraries = new ArrayList<File>(containedJarFileEntries.size());
            byte[] buffer = new byte[4096];
            boolean incomplete = true;
            try {
                for (int i = 0; i < containedJarFileEntries.size(); ++i) {
                    File tempFile;
                    JarEntry entry2 = (JarEntry)containedJarFileEntries.get(i);
                    String name = entry2.getName();
                    name = name.replace(File.separatorChar, '_');
                    try {
                        tempFile = File.createTempFile(rnd.nextInt(Integer.MAX_VALUE) + "_", name);
                        tempFile.deleteOnExit();
                    }
                    catch (IOException e) {
                        throw new ProgramInvocationException("An I/O error occurred while creating temporary file to extract nested library '" + entry2.getName() + "'.", e);
                    }
                    extractedTempLibraries.add(tempFile);
                    FileOutputStream out = null;
                    InputStream in = null;
                    try {
                        out = new FileOutputStream(tempFile);
                        in = new BufferedInputStream(((JarFile)jar).getInputStream(entry2));
                        int numRead = 0;
                        while ((numRead = in.read(buffer)) != -1) {
                            ((OutputStream)out).write(buffer, 0, numRead);
                        }
                        continue;
                    }
                    catch (IOException e) {
                        throw new ProgramInvocationException("An I/O error occurred while extracting nested library '" + entry2.getName() + "' to temporary file '" + tempFile.getAbsolutePath() + "'.");
                    }
                    finally {
                        if (out != null) {
                            ((OutputStream)out).close();
                        }
                        if (in != null) {
                            in.close();
                        }
                    }
                }
                incomplete = false;
            }
            finally {
                if (incomplete) {
                    PackagedProgram.deleteExtractedLibraries(extractedTempLibraries);
                }
            }
            arrayList = extractedTempLibraries;
        }
        catch (Throwable t) {
            throw new ProgramInvocationException("Unknown I/O error while extracting contained jar files.", t);
        }
        finally {
            if (jar != null) {
                try {
                    jar.close();
                }
                catch (Throwable name) {}
            }
        }
        return arrayList;
    }

    public static void deleteExtractedLibraries(List<File> tempLibraries) {
        for (File f : tempLibraries) {
            f.delete();
        }
    }

    private static void checkJarFile(URL jarfile) throws ProgramInvocationException {
        try {
            JobWithJars.checkJarFile(jarfile);
        }
        catch (IOException e) {
            throw new ProgramInvocationException(e.getMessage());
        }
        catch (Throwable t) {
            throw new ProgramInvocationException("Cannot access jar file" + (t.getMessage() == null ? "." : ": " + t.getMessage()), t);
        }
    }
}

