/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.util;

import java.io.IOException;
import java.net.InetSocketAddress;

public class StringUtils {
    public static InetSocketAddress parseAddr(String s) throws IOException {
        int port;
        String[] parts = s.split(":");
        if (parts.length != 2) {
            throw new IOException(s + " does not have the form host:port");
        }
        try {
            port = Integer.parseInt(parts[1]);
        }
        catch (NumberFormatException e) {
            throw new IOException(s + " does not have the form host:port");
        }
        InetSocketAddress addr = new InetSocketAddress(parts[0], port);
        return addr;
    }

    public static StringBuilder addrToString(StringBuilder sb, InetSocketAddress addr) {
        return sb.append(addr.getAddress().getHostAddress()).append(":").append(addr.getPort());
    }

    public static String getZKStringId(long id) {
        return String.format("%010d", id);
    }
}

