/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.tools;

import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.BookKeeperAdmin;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BookKeeperTools {
    private static Logger LOG = LoggerFactory.getLogger(BookKeeperTools.class);

    public static void main(String[] args) throws InterruptedException, IOException, KeeperException, BKException {
        if (args.length < 2) {
            System.err.println("USAGE: BookKeeperTools zkServers bookieSrc [bookieDest]");
            return;
        }
        String zkServers = args[0];
        String[] bookieSrcString = args[1].split(":");
        if (bookieSrcString.length < 2) {
            System.err.println("BookieSrc inputted has invalid name format (host:port expected): " + bookieSrcString);
            return;
        }
        InetSocketAddress bookieSrc = new InetSocketAddress(bookieSrcString[0], Integer.parseInt(bookieSrcString[1]));
        InetSocketAddress bookieDest = null;
        if (args.length < 3) {
            String[] bookieDestString = args[2].split(":");
            if (bookieDestString.length < 2) {
                System.err.println("BookieDest inputted has invalid name format (host:port expected): " + bookieDestString);
                return;
            }
            bookieDest = new InetSocketAddress(bookieDestString[0], Integer.parseInt(bookieDestString[1]));
        }
        BookKeeperAdmin bkTools = new BookKeeperAdmin(zkServers);
        bkTools.recoverBookieData(bookieSrc, bookieDest);
        bkTools.close();
    }
}

