/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.conf;

import java.io.File;
import org.apache.bookkeeper.conf.AbstractConfiguration;
import org.apache.commons.lang.StringUtils;

public class ServerConfiguration
extends AbstractConfiguration {
    protected static final String ENTRY_LOG_SIZE_LIMIT = "logSizeLimit";
    protected static final String GC_WAIT_TIME = "gcWaitTime";
    protected static final String FLUSH_INTERVAL = "flushInterval";
    protected static final String DEATH_WATCH_INTERVAL = "bookieDeathWatchInterval";
    protected static final String OPEN_FILE_LIMIT = "openFileLimit";
    protected static final String PAGE_LIMIT = "pageLimit";
    protected static final String PAGE_SIZE = "pageSize";
    protected static final String MAX_JOURNAL_SIZE = "journalMaxSizeMB";
    protected static final String MAX_BACKUP_JOURNALS = "journalMaxBackups";
    protected static final String BOOKIE_PORT = "bookiePort";
    protected static final String JOURNAL_DIR = "journalDirectory";
    protected static final String LEDGER_DIRS = "ledgerDirectories";
    protected static final String SERVER_TCP_NODELAY = "serverTcpNoDelay";
    protected static final String ZK_TIMEOUT = "zkTimeout";
    protected static final String ZK_SERVERS = "zkServers";
    protected static final String SEP = ",";

    public ServerConfiguration() {
    }

    public ServerConfiguration(AbstractConfiguration conf) {
        this.loadConf(conf);
    }

    public long getEntryLogSizeLimit() {
        return this.getLong(ENTRY_LOG_SIZE_LIMIT, 0x80000000L);
    }

    public ServerConfiguration setEntryLogSizeLimit(long logSizeLimit) {
        this.setProperty(ENTRY_LOG_SIZE_LIMIT, Long.toString(logSizeLimit));
        return this;
    }

    public long getGcWaitTime() {
        return this.getLong(GC_WAIT_TIME, 1000L);
    }

    public ServerConfiguration setGcWaitTime(long gcWaitTime) {
        this.setProperty(GC_WAIT_TIME, Long.toString(gcWaitTime));
        return this;
    }

    public int getFlushInterval() {
        return this.getInt(FLUSH_INTERVAL, 100);
    }

    public ServerConfiguration setFlushInterval(int flushInterval) {
        this.setProperty(FLUSH_INTERVAL, Integer.toString(flushInterval));
        return this;
    }

    public int getDeathWatchInterval() {
        return this.getInt(DEATH_WATCH_INTERVAL, 1000);
    }

    public int getOpenFileLimit() {
        return this.getInt(OPEN_FILE_LIMIT, 900);
    }

    public int getPageLimit() {
        return this.getInt(PAGE_LIMIT, -1);
    }

    public int getPageSize() {
        return this.getInt(PAGE_SIZE, 8192);
    }

    public long getMaxJournalSize() {
        return this.getLong(MAX_JOURNAL_SIZE, 2048L);
    }

    public ServerConfiguration setMaxJournalSize(long maxJournalSize) {
        this.setProperty(MAX_JOURNAL_SIZE, Long.toString(maxJournalSize));
        return this;
    }

    public int getMaxBackupJournals() {
        return this.getInt(MAX_BACKUP_JOURNALS, 5);
    }

    public ServerConfiguration setMaxBackupJournals(int maxBackupJournals) {
        this.setProperty(MAX_BACKUP_JOURNALS, Integer.toString(maxBackupJournals));
        return this;
    }

    public int getBookiePort() {
        return this.getInt(BOOKIE_PORT, 3181);
    }

    public ServerConfiguration setBookiePort(int port) {
        this.setProperty(BOOKIE_PORT, Integer.toString(port));
        return this;
    }

    public String getJournalDirName() {
        return this.getString(JOURNAL_DIR, "/tmp/bk-txn");
    }

    public ServerConfiguration setJournalDirName(String journalDir) {
        this.setProperty(JOURNAL_DIR, journalDir);
        return this;
    }

    public File getJournalDir() {
        String journalDirName = this.getJournalDirName();
        if (null == journalDirName) {
            return null;
        }
        return new File(journalDirName);
    }

    public String[] getLedgerDirNames() {
        String ledgerDirs = this.getString(LEDGER_DIRS, "/tmp/bk-data");
        if (null == ledgerDirs) {
            return null;
        }
        return ledgerDirs.split(SEP);
    }

    public ServerConfiguration setLedgerDirNames(String[] ledgerDirs) {
        if (null == ledgerDirs) {
            return this;
        }
        this.setProperty(LEDGER_DIRS, StringUtils.join((Object[])ledgerDirs, (String)SEP));
        return this;
    }

    public File[] getLedgerDirs() {
        String[] ledgerDirNames = this.getLedgerDirNames();
        if (null == ledgerDirNames) {
            return null;
        }
        File[] ledgerDirs = new File[ledgerDirNames.length];
        for (int i = 0; i < ledgerDirNames.length; ++i) {
            ledgerDirs[i] = new File(ledgerDirNames[i]);
        }
        return ledgerDirs;
    }

    public boolean getServerTcpNoDelay() {
        return this.getBoolean(SERVER_TCP_NODELAY, true);
    }

    public ServerConfiguration setServerTcpNoDelay(boolean noDelay) {
        this.setProperty(SERVER_TCP_NODELAY, Boolean.toString(noDelay));
        return this;
    }

    public String getZkServers() {
        return this.getString(ZK_SERVERS, null);
    }

    public ServerConfiguration setZkServers(String zkServers) {
        this.setProperty(ZK_SERVERS, zkServers);
        return this;
    }

    public int getZkTimeout() {
        return this.getInt(ZK_TIMEOUT, 10000);
    }

    public ServerConfiguration setZkTimeout(int zkTimeout) {
        this.setProperty(ZK_TIMEOUT, Integer.toString(zkTimeout));
        return this;
    }
}

