/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.conf;

import java.net.URL;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.configuration.SystemConfiguration;

public abstract class AbstractConfiguration
extends CompositeConfiguration {
    protected static final String LEDGER_MANAGER_TYPE = "ledgerManagerType";
    protected static final String ZK_LEDGERS_ROOT_PATH = "zkLedgersRootPath";

    protected AbstractConfiguration() {
        this.addConfiguration((Configuration)new SystemConfiguration());
    }

    public void loadConf(URL confURL) throws ConfigurationException {
        PropertiesConfiguration loadedConf = new PropertiesConfiguration(confURL);
        this.addConfiguration((Configuration)loadedConf);
    }

    public void loadConf(AbstractConfiguration baseConf) {
        this.addConfiguration((Configuration)baseConf);
    }

    public void setLedgerManagerType(String lmType) {
        this.setProperty(LEDGER_MANAGER_TYPE, lmType);
    }

    public String getLedgerManagerType() {
        return this.getString(LEDGER_MANAGER_TYPE);
    }

    public void setZkLedgersRootPath(String zkLedgersPath) {
        this.setProperty(ZK_LEDGERS_ROOT_PATH, zkLedgersPath);
    }

    public String getZkLedgersRootPath() {
        return this.getString(ZK_LEDGERS_ROOT_PATH, "/ledgers");
    }
}

