/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import org.apache.bookkeeper.client.DistributionSchedule;
import org.apache.bookkeeper.util.MathUtils;

class RoundRobinDistributionSchedule
implements DistributionSchedule {
    int quorumSize;
    int ensembleSize;
    boolean[] covered = null;
    int numQuorumsUncovered;

    public RoundRobinDistributionSchedule(int quorumSize, int ensembleSize) {
        this.quorumSize = quorumSize;
        this.ensembleSize = ensembleSize;
    }

    @Override
    public int getBookieIndex(long entryId, int replicaIndex) {
        return (int)((entryId + (long)replicaIndex) % (long)this.ensembleSize);
    }

    @Override
    public int getReplicaIndex(long entryId, int bookieIndex) {
        int replicaIndex = MathUtils.signSafeMod((long)bookieIndex - entryId, this.ensembleSize);
        return replicaIndex < this.quorumSize ? replicaIndex : -1;
    }

    @Override
    public synchronized boolean canProceedWithRecovery(int bookieIndexHeardFrom) {
        if (this.covered == null) {
            this.covered = new boolean[this.ensembleSize];
            this.numQuorumsUncovered = this.ensembleSize;
        }
        if (this.numQuorumsUncovered == 0) {
            return true;
        }
        for (int i = 0; i < this.quorumSize; ++i) {
            int quorumStartIndex = MathUtils.signSafeMod(bookieIndexHeardFrom - i, this.ensembleSize);
            if (this.covered[quorumStartIndex]) continue;
            this.covered[quorumStartIndex] = true;
            --this.numQuorumsUncovered;
            if (this.numQuorumsUncovered != 0) continue;
            return true;
        }
        return false;
    }
}

