/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import java.net.InetSocketAddress;
import org.apache.bookkeeper.client.AsyncCallback;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.jboss.netty.buffer.ChannelBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PendingAddOp
implements BookkeeperInternalCallbacks.WriteCallback {
    static final Logger LOG = LoggerFactory.getLogger(PendingAddOp.class);
    ChannelBuffer toSend;
    AsyncCallback.AddCallback cb;
    Object ctx;
    long entryId;
    boolean[] successesSoFar;
    int numResponsesPending;
    LedgerHandle lh;
    boolean isRecoveryAdd = false;

    PendingAddOp(LedgerHandle lh, AsyncCallback.AddCallback cb, Object ctx) {
        this.lh = lh;
        this.cb = cb;
        this.ctx = ctx;
        this.entryId = -1L;
        this.successesSoFar = new boolean[lh.metadata.quorumSize];
        this.numResponsesPending = this.successesSoFar.length;
    }

    PendingAddOp enableRecoveryAdd() {
        this.isRecoveryAdd = true;
        return this;
    }

    void setEntryId(long entryId) {
        this.entryId = entryId;
    }

    void sendWriteRequest(int bookieIndex, int arrayIndex) {
        int flags = this.isRecoveryAdd ? 2 : 0;
        this.lh.bk.bookieClient.addEntry(this.lh.metadata.currentEnsemble.get(bookieIndex), this.lh.ledgerId, this.lh.ledgerKey, this.entryId, this.toSend, this, arrayIndex, flags);
    }

    void unsetSuccessAndSendWriteRequest(int bookieIndex) {
        if (this.toSend == null) {
            return;
        }
        int replicaIndex = this.lh.distributionSchedule.getReplicaIndex(this.entryId, bookieIndex);
        if (replicaIndex < 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Leaving unchanged, ledger: " + this.lh.ledgerId + " entry: " + this.entryId + " bookie index: " + bookieIndex);
            }
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Unsetting success for ledger: " + this.lh.ledgerId + " entry: " + this.entryId + " bookie index: " + bookieIndex);
        }
        if (this.successesSoFar[replicaIndex]) {
            this.successesSoFar[replicaIndex] = false;
            ++this.numResponsesPending;
        }
        this.sendWriteRequest(bookieIndex, replicaIndex);
    }

    void initiate(ChannelBuffer toSend) {
        this.toSend = toSend;
        for (int i = 0; i < this.successesSoFar.length; ++i) {
            int bookieIndex = this.lh.distributionSchedule.getBookieIndex(this.entryId, i);
            this.sendWriteRequest(bookieIndex, i);
        }
    }

    @Override
    public void writeComplete(int rc, long ledgerId, long entryId, InetSocketAddress addr, Object ctx) {
        Integer replicaIndex = (Integer)ctx;
        int bookieIndex = this.lh.distributionSchedule.getBookieIndex(entryId, replicaIndex);
        if (!this.lh.metadata.currentEnsemble.get(bookieIndex).equals(addr)) {
            LOG.warn("Write did not succeed: " + ledgerId + ", " + entryId + ". But we have already fixed it.");
            return;
        }
        switch (rc) {
            case 0: {
                break;
            }
            case -101: {
                LOG.warn("Fencing exception on write: " + ledgerId + ", " + entryId);
                this.lh.handleUnrecoverableErrorDuringAdd(rc);
                return;
            }
            default: {
                LOG.warn("Write did not succeed: " + ledgerId + ", " + entryId);
                this.lh.handleBookieFailure(addr, bookieIndex);
                return;
            }
        }
        if (!this.successesSoFar[replicaIndex]) {
            this.successesSoFar[replicaIndex.intValue()] = true;
            --this.numResponsesPending;
            if (this.numResponsesPending == 0 && this.lh.pendingAddOps.peek() == this) {
                this.lh.sendAddSuccessCallbacks();
            }
        }
    }

    void submitCallback(int rc) {
        this.cb.addComplete(rc, this.lh, this.entryId, this.ctx);
        this.lh.opCounterSem.release();
    }
}

