/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.bookkeeper.bookie.Bookie;
import org.apache.bookkeeper.bookie.FileInfo;
import org.apache.bookkeeper.bookie.LedgerDescriptor;
import org.apache.bookkeeper.bookie.LedgerEntryPage;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.meta.LedgerManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LedgerCache {
    private static final Logger LOG = LoggerFactory.getLogger(LedgerDescriptor.class);
    final File[] ledgerDirectories;
    LinkedList<Long> cleanLedgers = new LinkedList();
    LinkedList<Long> dirtyLedgers = new LinkedList();
    HashMap<Long, FileInfo> fileInfoCache = new HashMap();
    LinkedList<Long> openLedgers = new LinkedList();
    final LedgerManager activeLedgerManager;
    final int openFileLimit;
    final int pageSize;
    final int pageLimit;
    final int entriesPerPage;
    private int pageCount = 0;
    HashMap<Long, HashMap<Long, LedgerEntryPage>> pages = new HashMap();
    private static final Random rand = new Random();

    public LedgerCache(ServerConfiguration conf, LedgerManager alm) {
        this.ledgerDirectories = conf.getLedgerDirs();
        this.openFileLimit = conf.getOpenFileLimit();
        this.pageSize = conf.getPageSize();
        this.entriesPerPage = this.pageSize / 8;
        this.pageLimit = conf.getPageLimit() <= 0 ? (int)(Runtime.getRuntime().maxMemory() / 3L / (long)this.pageSize) : conf.getPageLimit();
        LOG.info("maxMemory = " + Runtime.getRuntime().maxMemory());
        LOG.info("openFileLimit is " + this.openFileLimit + ", pageSize is " + this.pageSize + ", pageLimit is " + this.pageLimit);
        this.activeLedgerManager = alm;
        this.getActiveLedgers();
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public int getEntriesPerPage() {
        return this.entriesPerPage;
    }

    private void putIntoTable(HashMap<Long, HashMap<Long, LedgerEntryPage>> table, LedgerEntryPage lep) {
        HashMap<Long, LedgerEntryPage> map = table.get(lep.getLedger());
        if (map == null) {
            map = new HashMap();
            table.put(lep.getLedger(), map);
        }
        map.put(lep.getFirstEntry(), lep);
    }

    private static LedgerEntryPage getFromTable(HashMap<Long, HashMap<Long, LedgerEntryPage>> table, Long ledger, Long firstEntry) {
        HashMap<Long, LedgerEntryPage> map = table.get(ledger);
        if (map != null) {
            return map.get(firstEntry);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized LedgerEntryPage getLedgerEntryPage(Long ledger, Long firstEntry, boolean onlyDirty) {
        LedgerEntryPage lep = LedgerCache.getFromTable(this.pages, ledger, firstEntry);
        try {
            if (onlyDirty && lep.isClean()) {
                LedgerEntryPage ledgerEntryPage = null;
                return ledgerEntryPage;
            }
            LedgerEntryPage ledgerEntryPage = lep;
            return ledgerEntryPage;
        }
        finally {
            if (lep != null) {
                lep.usePage();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putEntryOffset(long ledger, long entry, long offset) throws IOException {
        int offsetInPage = (int)(entry % (long)this.entriesPerPage);
        long pageEntry = entry - (long)offsetInPage;
        LedgerEntryPage lep = this.getLedgerEntryPage(ledger, pageEntry, false);
        if (lep == null) {
            lep = this.grabCleanPage(ledger, pageEntry);
            this.updatePage(lep);
            LedgerCache ledgerCache = this;
            synchronized (ledgerCache) {
                this.putIntoTable(this.pages, lep);
            }
        }
        if (lep != null) {
            lep.setOffset(offset, offsetInPage * 8);
            lep.releasePage();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getEntryOffset(long ledger, long entry) throws IOException {
        int offsetInPage = (int)(entry % (long)this.entriesPerPage);
        long pageEntry = entry - (long)offsetInPage;
        LedgerEntryPage lep = this.getLedgerEntryPage(ledger, pageEntry, false);
        try {
            if (lep == null) {
                lep = this.grabCleanPage(ledger, pageEntry);
                LedgerCache ledgerCache = this;
                synchronized (ledgerCache) {
                    this.putIntoTable(this.pages, lep);
                }
                this.updatePage(lep);
            }
            long l = lep.getOffset(offsetInPage * 8);
            return l;
        }
        finally {
            if (lep != null) {
                lep.releasePage();
            }
        }
    }

    private static final String getLedgerName(long ledgerId) {
        int parent = (int)(ledgerId & 0xFFL);
        int grandParent = (int)((ledgerId & 0xFF00L) >> 8);
        StringBuilder sb = new StringBuilder();
        sb.append(Integer.toHexString(grandParent));
        sb.append('/');
        sb.append(Integer.toHexString(parent));
        sb.append('/');
        sb.append(Long.toHexString(ledgerId));
        sb.append(".idx");
        return sb.toString();
    }

    private static final void checkParents(File f) throws IOException {
        File parent = f.getParentFile();
        if (parent.exists()) {
            return;
        }
        if (!parent.mkdirs()) {
            throw new IOException("Counldn't mkdirs for " + parent);
        }
    }

    private static final File pickDirs(File[] dirs) {
        return dirs[rand.nextInt(dirs.length)];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FileInfo getFileInfo(Long ledger, boolean create) throws IOException {
        HashMap<Long, FileInfo> hashMap = this.fileInfoCache;
        synchronized (hashMap) {
            FileInfo fi = this.fileInfoCache.get(ledger);
            if (fi == null) {
                File d;
                String ledgerName = LedgerCache.getLedgerName(ledger);
                File lf = null;
                File[] arr$ = this.ledgerDirectories;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$ && !(lf = new File(d = arr$[i$], ledgerName)).exists(); ++i$) {
                    lf = null;
                }
                if (lf == null) {
                    if (!create) {
                        throw new Bookie.NoLedgerException(ledger);
                    }
                    File dir = LedgerCache.pickDirs(this.ledgerDirectories);
                    lf = new File(dir, ledgerName);
                    LedgerCache.checkParents(lf);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("New ledger index file created for ledgerId: " + ledger);
                    }
                    this.activeLedgerManager.addActiveLedger(ledger, true);
                }
                if (this.openLedgers.size() > this.openFileLimit) {
                    this.fileInfoCache.remove(this.openLedgers.removeFirst()).close();
                }
                fi = new FileInfo(lf);
                this.fileInfoCache.put(ledger, fi);
                this.openLedgers.add(ledger);
            }
            if (fi != null) {
                fi.use();
            }
            return fi;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updatePage(LedgerEntryPage lep) throws IOException {
        if (!lep.isClean()) {
            throw new IOException("Trying to update a dirty page");
        }
        FileInfo fi = null;
        try {
            fi = this.getFileInfo(lep.getLedger(), true);
            long pos = lep.getFirstEntry() * 8L;
            if (pos >= fi.size()) {
                lep.zeroPage();
            } else {
                lep.readPage(fi);
            }
        }
        finally {
            if (fi != null) {
                fi.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void flushLedger(boolean doAll) throws IOException {
        LinkedList<Long> linkedList = this.dirtyLedgers;
        synchronized (linkedList) {
            if (this.dirtyLedgers.isEmpty()) {
                LedgerCache ledgerCache = this;
                synchronized (ledgerCache) {
                    for (Long l : this.pages.keySet()) {
                        if (LOG.isTraceEnabled()) {
                            LOG.trace("Adding " + Long.toHexString(l) + " to dirty pages");
                        }
                        this.dirtyLedgers.add(l);
                    }
                }
            }
            if (this.dirtyLedgers.isEmpty()) {
                return;
            }
            while (!this.dirtyLedgers.isEmpty()) {
                LedgerEntryPage lep;
                LinkedList<Long> firstEntryList;
                Long l2 = this.dirtyLedgers.removeFirst();
                LedgerCache ledgerCache = this;
                synchronized (ledgerCache) {
                    HashMap<Long, LedgerEntryPage> pageMap = this.pages.get(l2);
                    if (pageMap == null || pageMap.isEmpty()) {
                        continue;
                    }
                    firstEntryList = new LinkedList<Long>();
                    for (Map.Entry<Long, LedgerEntryPage> entry : pageMap.entrySet()) {
                        lep = entry.getValue();
                        if (lep.isClean()) {
                            if (!LOG.isTraceEnabled()) continue;
                            LOG.trace("Page is clean " + lep);
                            continue;
                        }
                        firstEntryList.add(lep.getFirstEntry());
                    }
                }
                ArrayList<LedgerEntryPage> arrayList = new ArrayList<LedgerEntryPage>(firstEntryList.size());
                FileInfo fi = null;
                try {
                    for (Long firstEntry : firstEntryList) {
                        lep = this.getLedgerEntryPage(l2, firstEntry, true);
                        if (lep == null) continue;
                        arrayList.add(lep);
                    }
                    Collections.sort(arrayList, new Comparator<LedgerEntryPage>(){

                        @Override
                        public int compare(LedgerEntryPage o1, LedgerEntryPage o2) {
                            return (int)(o1.getFirstEntry() - o2.getFirstEntry());
                        }
                    });
                    ArrayList<Integer> versions = new ArrayList<Integer>(arrayList.size());
                    fi = this.getFileInfo(l2, true);
                    int start = 0;
                    long lastOffset = -1L;
                    for (int i = 0; i < arrayList.size(); ++i) {
                        versions.add(i, ((LedgerEntryPage)arrayList.get(i)).getVersion());
                        if (lastOffset != -1L && ((LedgerEntryPage)arrayList.get(i)).getFirstEntry() - lastOffset != (long)this.entriesPerPage) {
                            int count = i - start;
                            if (count == 0) {
                                System.out.println("Count cannot possibly be zero!");
                            }
                            this.writeBuffers(l2, arrayList, fi, start, count);
                            start = i;
                        }
                        lastOffset = ((LedgerEntryPage)arrayList.get(i)).getFirstEntry();
                    }
                    if (arrayList.size() - start == 0 && arrayList.size() != 0) {
                        System.out.println("Nothing to write, but there were entries!");
                    }
                    this.writeBuffers(l2, arrayList, fi, start, arrayList.size() - start);
                    LedgerCache ledgerCache2 = this;
                    synchronized (ledgerCache2) {
                        for (int i = 0; i < arrayList.size(); ++i) {
                            LedgerEntryPage lep2 = (LedgerEntryPage)arrayList.get(i);
                            lep2.setClean((Integer)versions.get(i));
                        }
                    }
                }
                finally {
                    for (LedgerEntryPage lep3 : arrayList) {
                        lep3.releasePage();
                    }
                    if (fi != null) {
                        fi.release();
                    }
                }
                if (!doAll) break;
                try {
                    this.dirtyLedgers.wait(1L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    private void writeBuffers(Long ledger, List<LedgerEntryPage> entries, FileInfo fi, int start, int count) throws IOException {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Writing " + count + " buffers of " + Long.toHexString(ledger));
        }
        if (count == 0) {
            return;
        }
        ByteBuffer[] buffs = new ByteBuffer[count];
        for (int j = 0; j < count; ++j) {
            buffs[j] = entries.get(start + j).getPageToWrite();
            if (entries.get(start + j).getLedger() == ledger.longValue()) continue;
            throw new IOException("Writing to " + ledger + " but page belongs to " + entries.get(start + j).getLedger());
        }
        long totalWritten = 0L;
        while (buffs[buffs.length - 1].remaining() > 0) {
            long rc = fi.write(buffs, entries.get(start + 0).getFirstEntry() * 8L);
            if (rc <= 0L) {
                throw new IOException("Short write to ledger " + ledger + " rc = " + rc);
            }
            totalWritten += rc;
        }
        if (totalWritten != (long)(count * this.pageSize)) {
            throw new IOException("Short write to ledger " + ledger + " wrote " + totalWritten + " expected " + count * this.pageSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private LedgerEntryPage grabCleanPage(long ledger, long entry) throws IOException {
        LedgerEntryPage lep;
        Iterator it;
        Map map;
        if (entry % (long)this.entriesPerPage != 0L) {
            throw new IllegalArgumentException(entry + " is not a multiple of " + this.entriesPerPage);
        }
        Object object = this;
        // MONITORENTER : object
        if (this.pageCount < this.pageLimit) {
            LedgerEntryPage lep2 = new LedgerEntryPage(this.pageSize, this.entriesPerPage);
            lep2.setLedger(ledger);
            lep2.setFirstEntry(entry);
            lep2.usePage();
            ++this.pageCount;
            // MONITOREXIT : object
            return lep2;
        }
        // MONITOREXIT : object
        block9: while (true) {
            LedgerCache ledgerCache;
            object = this.cleanLedgers;
            // MONITORENTER : object
            if (this.cleanLedgers.isEmpty()) {
                this.flushLedger(false);
                ledgerCache = this;
                // MONITORENTER : ledgerCache
                for (Long l : this.pages.keySet()) {
                    this.cleanLedgers.add(l);
                }
                // MONITOREXIT : ledgerCache
            }
            ledgerCache = this;
            // MONITORENTER : ledgerCache
            Long cleanLedger = this.cleanLedgers.getFirst();
            map = this.pages.get(cleanLedger);
            if (map == null || map.isEmpty()) {
                this.cleanLedgers.removeFirst();
                // MONITOREXIT : ledgerCache
                // MONITOREXIT : object
                continue;
            }
            it = map.entrySet().iterator();
            lep = (LedgerEntryPage)it.next().getValue();
            while (lep.inUse() || !lep.isClean()) {
                if (!it.hasNext()) {
                    // MONITOREXIT : ledgerCache
                    // MONITOREXIT : object
                    continue block9;
                }
                lep = (LedgerEntryPage)it.next().getValue();
            }
            break;
        }
        it.remove();
        if (map.isEmpty()) {
            this.pages.remove(lep.getLedger());
        }
        lep.usePage();
        lep.zeroPage();
        lep.setLedger(ledger);
        lep.setFirstEntry(entry);
        // MONITOREXIT : ledgerCache
        // MONITOREXIT : object
        return lep;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLastEntry(long ledgerId) {
        long lastEntry = 0L;
        LedgerCache ledgerCache = this;
        synchronized (ledgerCache) {
            Map map = this.pages.get(ledgerId);
            if (map != null) {
                for (LedgerEntryPage lep : map.values()) {
                    if (lep.getFirstEntry() + (long)this.entriesPerPage < lastEntry) continue;
                    lep.usePage();
                    long highest = lep.getLastEntry();
                    if (highest > lastEntry) {
                        lastEntry = highest;
                    }
                    lep.releasePage();
                }
            }
        }
        return lastEntry;
    }

    private void getActiveLedgers() {
        for (File ledgerDirectory : this.ledgerDirectories) {
            for (File grandParent : ledgerDirectory.listFiles()) {
                if (!grandParent.isDirectory()) continue;
                for (File parent : grandParent.listFiles()) {
                    if (!parent.isDirectory()) continue;
                    for (File index : parent.listFiles()) {
                        if (!index.isFile() || !index.getName().endsWith(".idx")) continue;
                        String ledgerIdInHex = index.getName().substring(0, index.getName().length() - 4);
                        this.activeLedgerManager.addActiveLedger(Long.parseLong(ledgerIdInHex, 16), true);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deleteLedger(long ledgerId) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Deleting ledgerId: " + ledgerId);
        }
        FileInfo fi = this.getFileInfo(ledgerId, false);
        fi.getFile().delete();
        fi.close();
        this.activeLedgerManager.removeActiveLedger(ledgerId);
        LinkedList<Long> linkedList = this;
        synchronized (linkedList) {
            this.pages.remove(ledgerId);
        }
        linkedList = this.fileInfoCache;
        synchronized (linkedList) {
            this.fileInfoCache.remove(ledgerId);
        }
        linkedList = this.cleanLedgers;
        synchronized (linkedList) {
            this.cleanLedgers.remove(ledgerId);
        }
        linkedList = this.dirtyLedgers;
        synchronized (linkedList) {
            this.dirtyLedgers.remove(ledgerId);
        }
        linkedList = this.openLedgers;
        synchronized (linkedList) {
            this.openLedgers.remove(ledgerId);
        }
    }
}

