/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FileInfo {
    static Logger LOG = LoggerFactory.getLogger(FileInfo.class);
    static final int NO_MASTER_KEY = -1;
    private FileChannel fc;
    private final File lf;
    private byte[] header = "BKLE\u0000\u0000\u0000\u0000".getBytes();
    static final long START_OF_DATA = 1024L;
    private long size;
    private int useCount;
    private boolean isClosed;

    public FileInfo(File lf) throws IOException {
        this.lf = lf;
        this.fc = new RandomAccessFile(lf, "rws").getChannel();
        this.size = this.fc.size();
        if (this.size == 0L) {
            this.fc.write(ByteBuffer.wrap(this.header));
            ByteBuffer buf = ByteBuffer.allocate(4);
            buf.putInt(-1);
            buf.flip();
            this.fc.write(buf);
        }
    }

    public synchronized void writeMasterKey(byte[] masterKey) throws IOException {
        if (masterKey == null || (long)(masterKey.length + 4 + this.header.length) > 1024L) {
            throw new IOException("master key is more than " + (1020L - (long)this.header.length));
        }
        int len = masterKey.length;
        ByteBuffer lenBuf = ByteBuffer.allocate(4);
        lenBuf.putInt(len);
        lenBuf.flip();
        this.fc.position(this.header.length);
        this.fc.write(lenBuf);
        this.fc.write(ByteBuffer.wrap(masterKey));
    }

    public synchronized byte[] readMasterKey() throws IOException {
        ByteBuffer lenBuf = ByteBuffer.allocate(4);
        int total = this.readAbsolute(lenBuf, this.header.length);
        if (total != 4) {
            throw new IOException("Short read during reading master key length");
        }
        lenBuf.rewind();
        int len = lenBuf.getInt();
        if (len == -1) {
            return null;
        }
        byte[] masterKey = new byte[len];
        total = this.readAbsolute(ByteBuffer.wrap(masterKey), this.header.length + 4);
        if (total != len) {
            throw new IOException("Short read during reading master key");
        }
        return masterKey;
    }

    public synchronized long size() {
        long rc = this.size - 1024L;
        if (rc < 0L) {
            rc = 0L;
        }
        return rc;
    }

    public synchronized int read(ByteBuffer bb, long position) throws IOException {
        return this.readAbsolute(bb, position + 1024L);
    }

    private int readAbsolute(ByteBuffer bb, long start) throws IOException {
        int total = 0;
        while (bb.remaining() > 0) {
            int rc = this.fc.read(bb, start);
            if (rc <= 0) {
                throw new IOException("Short read");
            }
            total += rc;
            start += (long)rc;
        }
        return total;
    }

    public synchronized void close() throws IOException {
        this.isClosed = true;
        if (this.useCount == 0) {
            this.fc.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized long write(ByteBuffer[] buffs, long position) throws IOException {
        long total = 0L;
        try {
            this.fc.position(position + 1024L);
            while (buffs[buffs.length - 1].remaining() > 0) {
                long rc = this.fc.write(buffs);
                if (rc <= 0L) {
                    throw new IOException("Short write");
                }
                total += rc;
            }
        }
        finally {
            long newsize = position + 1024L + total;
            if (newsize > this.size) {
                this.size = newsize;
            }
        }
        return total;
    }

    public synchronized void use() {
        ++this.useCount;
    }

    public synchronized void release() {
        --this.useCount;
        if (this.isClosed && this.useCount == 0) {
            try {
                this.fc.close();
            }
            catch (IOException e) {
                LOG.error("Error closing file channel", (Throwable)e);
            }
        }
    }

    File getFile() {
        return this.lf;
    }
}

