/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.bookkeeper.bookie.BookieException;
import org.apache.bookkeeper.bookie.BufferedChannel;
import org.apache.bookkeeper.bookie.EntryLogger;
import org.apache.bookkeeper.bookie.FileInfo;
import org.apache.bookkeeper.bookie.LedgerCache;
import org.apache.bookkeeper.bookie.LedgerDescriptor;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.meta.LedgerManager;
import org.apache.bookkeeper.meta.LedgerManagerFactory;
import org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Bookie
extends Thread {
    HashMap<Long, LedgerDescriptor> ledgers = new HashMap<K, V>();
    static Logger LOG = LoggerFactory.getLogger(Bookie.class);
    static final long MB = 0x100000L;
    final long maxJournalSize;
    final int maxBackupJournals;
    final File journalDirectory;
    final File[] ledgerDirectories;
    final ServerConfiguration conf;
    final SyncThread syncThread;
    final LedgerManager ledgerManager;
    static final int CURRENT_DIRECTORY_LAYOUT_VERSION = 1;
    static final String VERSION_FILENAME = "VERSION";
    static final String BOOKIE_REGISTRATION_PATH = "/ledgers/available/";
    ZooKeeper zk;
    private volatile boolean isZkExpired = true;
    private volatile boolean running = false;
    EntryLogger entryLogger;
    LedgerCache ledgerCache;
    LinkedBlockingQueue<QueueEntry> queue = new LinkedBlockingQueue<E>();
    public static final long preAllocSize = 0x400000L;
    public static final ByteBuffer zeros = ByteBuffer.allocate(512);
    private LastLogMark lastLogMark = new LastLogMark(0L, 0L);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public Bookie(ServerConfiguration conf) throws IOException, KeeperException, InterruptedException {
        super();
        this.conf = conf;
        this.journalDirectory = conf.getJournalDir();
        this.ledgerDirectories = conf.getLedgerDirs();
        this.maxJournalSize = conf.getMaxJournalSize() * 0x100000L;
        this.maxBackupJournals = conf.getMaxBackupJournals();
        this.checkDirectoryLayoutVersion(this.journalDirectory);
        for (File dir : this.ledgerDirectories) {
            this.checkDirectoryLayoutVersion(dir);
        }
        newZk = this.instantiateZookeeperClient(conf.getZkServers());
        this.ledgerManager = LedgerManagerFactory.newLedgerManager(conf, newZk);
        this.syncThread = new SyncThread(conf);
        this.entryLogger = new EntryLogger(conf, this);
        this.ledgerCache = new LedgerCache(conf, this.ledgerManager);
        this.lastLogMark.readLog();
        if (Bookie.LOG.isDebugEnabled()) {
            Bookie.LOG.debug("Last Log Mark : " + this.lastLogMark);
        }
        markedLogId = this.lastLogMark.txnLogId;
        logs = Bookie.listJournalIds(this.journalDirectory, new JournalIdFilter(){

            @Override
            public boolean accept(long journalId) {
                return journalId >= markedLogId;
            }
        });
        if (markedLogId > 0L && (logs.size() == 0 || logs.get(0) != markedLogId)) {
            throw new IOException("Recovery log " + markedLogId + " is missing");
        }
        if (Bookie.LOG.isDebugEnabled()) {
            Bookie.LOG.debug("Try to relay journal logs : " + logs);
        }
        lenBuff = ByteBuffer.allocate(4);
        recBuff = ByteBuffer.allocate(65536);
        block4: for (Long id : logs) {
            if (id == markedLogId) {
                markedLogPosition = this.lastLogMark.txnLogPosition;
                recLog = this.openChannel(id, markedLogPosition);
            } else {
                recLog = this.openChannel(id);
            }
            while (true) lbl-1000:
            // 3 sources

            {
                lenBuff.clear();
                Bookie.fullRead(recLog, lenBuff);
                if (lenBuff.remaining() != 0) continue block4;
                lenBuff.flip();
                len = lenBuff.getInt();
                if (len == 0) continue block4;
                recBuff.clear();
                if (recBuff.remaining() < len) {
                    recBuff = ByteBuffer.allocate(len);
                }
                recBuff.limit(len);
                if (Bookie.fullRead(recLog, recBuff) != len) continue block4;
                recBuff.flip();
                ledgerId = recBuff.getLong();
                if (Bookie.LOG.isDebugEnabled()) {
                    Bookie.LOG.debug("Relay journal - ledger id : " + ledgerId);
                }
                handle = this.getHandle(ledgerId, false);
                try {
                    recBuff.rewind();
                    handle.addEntry(recBuff);
                }
                finally {
                    this.putHandle(handle);
                    continue;
                }
                break;
            }
        }
        ** GOTO lbl-1000
        this.zk = newZk;
        this.registerBookie(conf.getBookiePort());
        this.setDaemon(true);
        Bookie.LOG.debug("I'm starting a bookie with journal directory " + this.journalDirectory.getName());
        this.start();
        this.syncThread.start();
        this.running = true;
    }

    public static List<Long> listJournalIds(File journalDir, JournalIdFilter filter) {
        File[] logFiles = journalDir.listFiles();
        ArrayList<Long> logs = new ArrayList<Long>();
        for (File f : logFiles) {
            String name = f.getName();
            if (!name.endsWith(".txn")) continue;
            String idString = name.split("\\.")[0];
            long id = Long.parseLong(idString, 16);
            if (filter != null) {
                if (!filter.accept(id)) continue;
                logs.add(id);
                continue;
            }
            logs.add(id);
        }
        Collections.sort(logs);
        return logs;
    }

    private ZooKeeper instantiateZookeeperClient(String zkServers) throws IOException {
        if (zkServers == null) {
            LOG.warn("No ZK servers passed to Bookie constructor so BookKeeper clients won't know about this server!");
            this.isZkExpired = false;
            return null;
        }
        int zkTimeout = this.conf.getZkTimeout();
        return this.newZookeeper(zkServers, zkTimeout);
    }

    private void registerBookie(int port) throws IOException {
        if (null == this.zk) {
            return;
        }
        try {
            this.zk.create(BOOKIE_REGISTRATION_PATH + InetAddress.getLocalHost().getHostAddress() + ":" + port, new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
        }
        catch (Exception e) {
            LOG.error("ZK exception registering ephemeral Znode for Bookie!", (Throwable)e);
            throw new IOException(e);
        }
    }

    private ZooKeeper newZookeeper(String zkServers, int sessionTimeout) throws IOException {
        ZooKeeper newZk = new ZooKeeper(zkServers, sessionTimeout, new Watcher(){

            public void process(WatchedEvent event) {
                if (event.getType().equals((Object)Watcher.Event.EventType.None)) {
                    if (event.getState().equals((Object)Watcher.Event.KeeperState.Disconnected)) {
                        LOG.warn("ZK client has been disconnected to the ZK server!");
                    } else if (event.getState().equals((Object)Watcher.Event.KeeperState.SyncConnected)) {
                        LOG.info("ZK client has been reconnected to the ZK server!");
                    }
                }
                if (event.getState().equals((Object)Watcher.Event.KeeperState.Expired)) {
                    LOG.error("ZK client connection to the ZK server has expired!");
                    Bookie.this.isZkExpired = true;
                    try {
                        Bookie.this.shutdown();
                    }
                    catch (InterruptedException ie) {
                        System.exit(-1);
                    }
                }
            }
        });
        this.isZkExpired = false;
        return newZk;
    }

    private void checkDirectoryLayoutVersion(File dir) throws IOException {
        FileInputStream fis;
        if (!dir.isDirectory()) {
            throw new IOException("Directory(" + dir + ") isn't a directory");
        }
        File versionFile = new File(dir, VERSION_FILENAME);
        try {
            fis = new FileInputStream(versionFile);
        }
        catch (FileNotFoundException e) {
            LOG.info("No version file found, creating");
            this.createDirectoryLayoutVersionFile(dir);
            return;
        }
        BufferedReader br = new BufferedReader(new InputStreamReader(fis));
        try {
            String layoutVersionStr = br.readLine();
            int layoutVersion = Integer.parseInt(layoutVersionStr);
            if (layoutVersion != 1) {
                String errmsg = "Directory has an invalid version, expected 1, found " + layoutVersion;
                LOG.error(errmsg);
                throw new IOException(errmsg);
            }
        }
        catch (NumberFormatException e) {
            throw new IOException("Version file has invalid content", e);
        }
        finally {
            try {
                fis.close();
            }
            catch (IOException e) {
                LOG.warn("Error closing version file", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createDirectoryLayoutVersionFile(File dir) throws IOException {
        File versionFile = new File(dir, VERSION_FILENAME);
        FileOutputStream fos = new FileOutputStream(versionFile);
        BufferedWriter bw = null;
        try {
            bw = new BufferedWriter(new OutputStreamWriter(fos));
            bw.write(String.valueOf(1));
        }
        finally {
            if (bw != null) {
                bw.close();
            }
            fos.close();
        }
    }

    private static int fullRead(FileChannel fc, ByteBuffer bb) throws IOException {
        int total = 0;
        while (bb.remaining() > 0) {
            int rc = fc.read(bb);
            if (rc <= 0) {
                return total;
            }
            total += rc;
        }
        return total;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putHandle(LedgerDescriptor handle) {
        HashMap<Long, LedgerDescriptor> hashMap = this.ledgers;
        synchronized (hashMap) {
            handle.decRef();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LedgerDescriptor getHandle(long ledgerId, boolean readonly, byte[] masterKey) throws IOException {
        LedgerDescriptor handle = null;
        HashMap<Long, LedgerDescriptor> hashMap = this.ledgers;
        synchronized (hashMap) {
            handle = this.ledgers.get(ledgerId);
            if (handle == null) {
                FileInfo fi = null;
                try {
                    fi = this.ledgerCache.getFileInfo(ledgerId, !readonly);
                    byte[] existingMasterKey = fi.readMasterKey();
                    ByteBuffer masterKeyToSet = ByteBuffer.wrap(masterKey);
                    if (existingMasterKey == null) {
                        fi.writeMasterKey(masterKey);
                    } else if (!masterKeyToSet.equals(ByteBuffer.wrap(existingMasterKey))) {
                        throw new IOException("Wrong master key for ledger " + ledgerId);
                    }
                    handle = this.createHandle(ledgerId, readonly);
                    this.ledgers.put(ledgerId, handle);
                    handle.setMasterKey(masterKeyToSet);
                }
                finally {
                    if (fi != null) {
                        fi.release();
                    }
                }
            }
            handle.incRef();
        }
        return handle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LedgerDescriptor getHandle(long ledgerId, boolean readonly) throws IOException {
        LedgerDescriptor handle = null;
        HashMap<Long, LedgerDescriptor> hashMap = this.ledgers;
        synchronized (hashMap) {
            handle = this.ledgers.get(ledgerId);
            if (handle == null) {
                FileInfo fi = null;
                try {
                    fi = this.ledgerCache.getFileInfo(ledgerId, !readonly);
                    byte[] existingMasterKey = fi.readMasterKey();
                    if (existingMasterKey == null) {
                        throw new IOException("Weird! No master key found in ledger " + ledgerId);
                    }
                    handle = this.createHandle(ledgerId, readonly);
                    this.ledgers.put(ledgerId, handle);
                    handle.setMasterKey(ByteBuffer.wrap(existingMasterKey));
                }
                finally {
                    if (fi != null) {
                        fi.release();
                    }
                }
            }
            handle.incRef();
        }
        return handle;
    }

    private LedgerDescriptor createHandle(long ledgerId, boolean readOnly) throws IOException {
        return new LedgerDescriptor(ledgerId, this.entryLogger, this.ledgerCache);
    }

    LastLogMark getLastLogMark() {
        return this.lastLogMark;
    }

    public boolean isRunning() {
        return this.running;
    }

    @Override
    public void run() {
        LinkedList<QueueEntry> toFlush = new LinkedList<QueueEntry>();
        ByteBuffer lenBuff = ByteBuffer.allocate(4);
        try {
            long logId = 0L;
            FileChannel logFile = null;
            BufferedChannel bc = null;
            long nextPrealloc = 0L;
            long lastFlushPosition = 0L;
            QueueEntry qe = null;
            while (true) {
                if (null == logFile) {
                    logId = System.currentTimeMillis();
                    logFile = this.openChannel(logId);
                    bc = new BufferedChannel(logFile, 65536);
                    zeros.clear();
                    nextPrealloc = 0x400000L;
                    lastFlushPosition = 0L;
                    logFile.write(zeros, nextPrealloc);
                }
                if (qe == null) {
                    if (toFlush.isEmpty()) {
                        qe = this.queue.take();
                    } else {
                        qe = this.queue.poll();
                        if (qe == null || bc.position() > lastFlushPosition + 524288L) {
                            bc.flush(true);
                            lastFlushPosition = bc.position();
                            this.lastLogMark.setLastLogMark(logId, lastFlushPosition);
                            for (QueueEntry e : toFlush) {
                                e.cb.writeComplete(0, e.ledgerId, e.entryId, null, e.ctx);
                            }
                            toFlush.clear();
                            if (bc.position() > this.maxJournalSize) {
                                logFile.close();
                                logFile = null;
                                continue;
                            }
                        }
                    }
                }
                if (this.isZkExpired) {
                    LOG.warn("Exiting... zk client has expired.");
                    break;
                }
                if (qe == null) continue;
                lenBuff.clear();
                lenBuff.putInt(qe.entry.remaining());
                lenBuff.flip();
                bc.write(lenBuff);
                bc.write(qe.entry);
                if (bc.position() > nextPrealloc) {
                    nextPrealloc = (logFile.size() / 0x400000L + 1L) * 0x400000L;
                    zeros.clear();
                    logFile.write(zeros, nextPrealloc);
                }
                toFlush.add(qe);
                qe = null;
            }
        }
        catch (Exception e) {
            LOG.error("Bookie thread exiting", (Throwable)e);
        }
    }

    private FileChannel openChannel(long logId) throws FileNotFoundException {
        return this.openChannel(logId, 0L);
    }

    private FileChannel openChannel(long logId, long position) throws FileNotFoundException {
        FileChannel logFile = new RandomAccessFile(new File(this.journalDirectory, Long.toHexString(logId) + ".txn"), "rw").getChannel();
        try {
            logFile.position(position);
        }
        catch (IOException e) {
            LOG.error("Bookie journal file can seek to position :", (Throwable)e);
        }
        return logFile;
    }

    public synchronized void shutdown() throws InterruptedException {
        if (!this.running) {
            return;
        }
        if (this.zk != null) {
            this.zk.close();
        }
        this.interrupt();
        this.join();
        this.syncThread.shutdown();
        for (LedgerDescriptor d : this.ledgers.values()) {
            d.close();
        }
        this.entryLogger.shutdown();
        this.ledgerManager.close();
        this.running = false;
    }

    private LedgerDescriptor getLedgerForEntry(ByteBuffer entry, byte[] masterKey) throws IOException, BookieException {
        long ledgerId = entry.getLong();
        LedgerDescriptor handle = this.getHandle(ledgerId, false, masterKey);
        if (!handle.cmpMasterKey(ByteBuffer.wrap(masterKey))) {
            this.putHandle(handle);
            throw BookieException.create(-1);
        }
        return handle;
    }

    private void addEntryInternal(LedgerDescriptor handle, ByteBuffer entry, BookkeeperInternalCallbacks.WriteCallback cb, Object ctx) throws IOException, BookieException {
        long ledgerId = handle.getLedgerId();
        entry.rewind();
        long entryId = handle.addEntry(entry);
        entry.rewind();
        if (LOG.isTraceEnabled()) {
            LOG.trace("Adding " + entryId + "@" + ledgerId);
        }
        this.queue.add(new QueueEntry(entry, ledgerId, entryId, cb, ctx));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recoveryAddEntry(ByteBuffer entry, BookkeeperInternalCallbacks.WriteCallback cb, Object ctx, byte[] masterKey) throws IOException, BookieException {
        LedgerDescriptor handle;
        LedgerDescriptor ledgerDescriptor = handle = this.getLedgerForEntry(entry, masterKey);
        synchronized (ledgerDescriptor) {
            try {
                this.addEntryInternal(handle, entry, cb, ctx);
            }
            finally {
                this.putHandle(handle);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEntry(ByteBuffer entry, BookkeeperInternalCallbacks.WriteCallback cb, Object ctx, byte[] masterKey) throws IOException, BookieException {
        LedgerDescriptor handle;
        LedgerDescriptor ledgerDescriptor = handle = this.getLedgerForEntry(entry, masterKey);
        synchronized (ledgerDescriptor) {
            try {
                if (handle.isFenced()) {
                    throw BookieException.create(-101);
                }
                this.addEntryInternal(handle, entry, cb, ctx);
            }
            finally {
                this.putHandle(handle);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fenceLedger(long ledgerId) throws IOException {
        LedgerDescriptor handle;
        LedgerDescriptor ledgerDescriptor = handle = this.getHandle(ledgerId, true);
        synchronized (ledgerDescriptor) {
            handle.setFenced();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuffer readEntry(long ledgerId, long entryId) throws IOException {
        LedgerDescriptor handle = this.getHandle(ledgerId, true);
        try {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Reading " + entryId + "@" + ledgerId);
            }
            ByteBuffer byteBuffer = handle.readEntry(entryId);
            return byteBuffer;
        }
        finally {
            this.putHandle(handle);
        }
    }

    public static void main(String[] args) throws IOException, InterruptedException, BookieException, KeeperException {
        Bookie b = new Bookie(new ServerConfiguration());
        CounterCallback cb = new CounterCallback();
        long start = System.currentTimeMillis();
        for (int i = 0; i < 100000; ++i) {
            ByteBuffer buff = ByteBuffer.allocate(1024);
            buff.putLong(1L);
            buff.putLong(i);
            buff.limit(1024);
            buff.position(0);
            cb.incCount();
            b.addEntry(buff, cb, null, new byte[0]);
        }
        cb.waitZero();
        long end = System.currentTimeMillis();
        System.out.println("Took " + (end - start) + "ms");
    }

    static class CounterCallback
    implements BookkeeperInternalCallbacks.WriteCallback {
        int count;

        CounterCallback() {
        }

        @Override
        public synchronized void writeComplete(int rc, long l, long e, InetSocketAddress addr, Object ctx) {
            --this.count;
            if (this.count == 0) {
                this.notifyAll();
            }
        }

        public synchronized void incCount() {
            ++this.count;
        }

        public synchronized void waitZero() throws InterruptedException {
            while (this.count > 0) {
                this.wait();
            }
        }
    }

    class LastLogMark {
        long txnLogId;
        long txnLogPosition;
        LastLogMark lastMark;

        LastLogMark(long logId, long logPosition) {
            this.txnLogId = logId;
            this.txnLogPosition = logPosition;
        }

        synchronized void setLastLogMark(long logId, long logPosition) {
            this.txnLogId = logId;
            this.txnLogPosition = logPosition;
        }

        synchronized void markLog() {
            this.lastMark = new LastLogMark(this.txnLogId, this.txnLogPosition);
        }

        synchronized void rollLog() {
            byte[] buff = new byte[16];
            ByteBuffer bb = ByteBuffer.wrap(buff);
            bb.putLong(this.lastMark.txnLogId);
            bb.putLong(this.lastMark.txnLogPosition);
            if (LOG.isDebugEnabled()) {
                LOG.debug("RollLog to persist last marked log : " + this.lastMark);
            }
            for (File dir : Bookie.this.ledgerDirectories) {
                File file = new File(dir, "lastMark");
                try {
                    FileOutputStream fos = new FileOutputStream(file);
                    fos.write(buff);
                    fos.getChannel().force(true);
                    fos.close();
                }
                catch (IOException e) {
                    LOG.error("Problems writing to " + file, (Throwable)e);
                }
            }
        }

        synchronized void readLog() {
            byte[] buff = new byte[16];
            ByteBuffer bb = ByteBuffer.wrap(buff);
            for (File dir : Bookie.this.ledgerDirectories) {
                File file = new File(dir, "lastMark");
                try {
                    FileInputStream fis = new FileInputStream(file);
                    fis.read(buff);
                    fis.close();
                    bb.clear();
                    long i = bb.getLong();
                    long p = bb.getLong();
                    if (i <= this.txnLogId) continue;
                    this.txnLogId = i;
                    if (p <= this.txnLogPosition) continue;
                    this.txnLogPosition = p;
                }
                catch (IOException e) {
                    LOG.error("Problems reading from " + file + " (this is okay if it is the first time starting this bookie");
                }
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("LastMark: logId - ").append(this.txnLogId).append(" , position - ").append(this.txnLogPosition);
            return sb.toString();
        }
    }

    static class QueueEntry {
        ByteBuffer entry;
        long ledgerId;
        long entryId;
        BookkeeperInternalCallbacks.WriteCallback cb;
        Object ctx;

        QueueEntry(ByteBuffer entry, long ledgerId, long entryId, BookkeeperInternalCallbacks.WriteCallback cb, Object ctx) {
            this.entry = entry.duplicate();
            this.cb = cb;
            this.ctx = ctx;
            this.ledgerId = ledgerId;
            this.entryId = entryId;
        }
    }

    public static interface JournalIdFilter {
        public boolean accept(long var1);
    }

    class SyncThread
    extends Thread {
        volatile boolean running;
        final AtomicBoolean flushing;
        final int flushInterval;

        public SyncThread(ServerConfiguration conf) {
            super("SyncThread");
            this.running = true;
            this.flushing = new AtomicBoolean(false);
            this.flushInterval = conf.getFlushInterval();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Flush Interval : " + this.flushInterval);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (this.running) {
                SyncThread syncThread = this;
                synchronized (syncThread) {
                    block13: {
                        try {
                            this.wait(this.flushInterval);
                            if (!Bookie.this.entryLogger.testAndClearSomethingWritten()) {
                            }
                            break block13;
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                        }
                        continue;
                    }
                }
                if (!this.flushing.compareAndSet(false, true)) break;
                Bookie.this.lastLogMark.markLog();
                try {
                    Bookie.this.ledgerCache.flushLedger(true);
                }
                catch (IOException e) {
                    LOG.error("Exception flushing Ledger", (Throwable)e);
                }
                try {
                    Bookie.this.entryLogger.flush();
                }
                catch (IOException e) {
                    LOG.error("Exception flushing entry logger", (Throwable)e);
                }
                Bookie.this.lastLogMark.rollLog();
                List<Long> logs = Bookie.listJournalIds(Bookie.this.journalDirectory, new JournalIdFilter(){

                    @Override
                    public boolean accept(long journalId) {
                        return journalId < ((Bookie)Bookie.this).lastLogMark.lastMark.txnLogId;
                    }
                });
                if (logs.size() >= Bookie.this.maxBackupJournals) {
                    int maxIdx = logs.size() - Bookie.this.maxBackupJournals;
                    for (int i = 0; i < maxIdx; ++i) {
                        long id = logs.get(i);
                        if (id >= ((Bookie)Bookie.this).lastLogMark.lastMark.txnLogId) continue;
                        File journalFile = new File(Bookie.this.journalDirectory, Long.toHexString(id) + ".txn");
                        journalFile.delete();
                        LOG.info("garbage collected journal " + journalFile.getName());
                    }
                }
                this.flushing.set(false);
            }
        }

        void shutdown() throws InterruptedException {
            this.running = false;
            if (this.flushing.compareAndSet(false, true)) {
                this.interrupt();
            }
            this.join();
        }
    }

    public static class NoEntryException
    extends IOException {
        private static final long serialVersionUID = 1L;
        private long ledgerId;
        private long entryId;

        public NoEntryException(long ledgerId, long entryId) {
            super("Entry " + entryId + " not found in " + ledgerId);
            this.ledgerId = ledgerId;
            this.entryId = entryId;
        }

        public long getLedger() {
            return this.ledgerId;
        }

        public long getEntry() {
            return this.entryId;
        }
    }

    public static class NoLedgerException
    extends IOException {
        private static final long serialVersionUID = 1L;
        private long ledgerId;

        public NoLedgerException(long ledgerId) {
            this.ledgerId = ledgerId;
        }

        public long getLedgerId() {
            return this.ledgerId;
        }
    }
}

