/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.editor.language.json.converter;

import org.activiti.editor.constants.EditorJsonConstants;
import org.activiti.editor.constants.StencilConstants;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.ObjectNode;

public class BpmnJsonConverterUtil
implements EditorJsonConstants,
StencilConstants {
    private static ObjectMapper objectMapper = new ObjectMapper();

    public static ObjectNode createChildShape(String id, String type, double lowerRightX, double lowerRightY, double upperLeftX, double upperLeftY) {
        ObjectNode shapeNode = objectMapper.createObjectNode();
        shapeNode.put("bounds", (JsonNode)BpmnJsonConverterUtil.createBoundsNode(lowerRightX, lowerRightY, upperLeftX, upperLeftY));
        shapeNode.put("resourceId", id);
        ArrayNode shapesArrayNode = objectMapper.createArrayNode();
        shapeNode.put("childShapes", (JsonNode)shapesArrayNode);
        ObjectNode stencilNode = objectMapper.createObjectNode();
        stencilNode.put("id", type);
        shapeNode.put("stencil", (JsonNode)stencilNode);
        return shapeNode;
    }

    public static ObjectNode createBoundsNode(double lowerRightX, double lowerRightY, double upperLeftX, double upperLeftY) {
        ObjectNode boundsNode = objectMapper.createObjectNode();
        boundsNode.put("lowerRight", (JsonNode)BpmnJsonConverterUtil.createPositionNode(lowerRightX, lowerRightY));
        boundsNode.put("upperLeft", (JsonNode)BpmnJsonConverterUtil.createPositionNode(upperLeftX, upperLeftY));
        return boundsNode;
    }

    public static ObjectNode createPositionNode(double x, double y) {
        ObjectNode positionNode = objectMapper.createObjectNode();
        positionNode.put("x", x);
        positionNode.put("y", y);
        return positionNode;
    }

    public static ObjectNode createResourceNode(String id) {
        ObjectNode resourceNode = objectMapper.createObjectNode();
        resourceNode.put("resourceId", id);
        return resourceNode;
    }

    public static String getStencilId(JsonNode objectNode) {
        String stencilId = null;
        JsonNode stencilNode = objectNode.get("stencil");
        if (stencilNode != null && stencilNode.get("id") != null) {
            stencilId = stencilNode.get("id").asText();
        }
        return stencilId;
    }

    public static String getElementId(JsonNode objectNode) {
        String elementId = null;
        elementId = StringUtils.isNotEmpty((CharSequence)BpmnJsonConverterUtil.getPropertyValueAsString("overrideid", objectNode)) ? BpmnJsonConverterUtil.getPropertyValueAsString("overrideid", objectNode).trim() : objectNode.get("resourceId").asText();
        return elementId;
    }

    protected static String getPropertyValueAsString(String name, JsonNode objectNode) {
        String propertyValue = null;
        JsonNode propertyNode = BpmnJsonConverterUtil.getProperty(name, objectNode);
        if (propertyNode != null) {
            propertyValue = propertyNode.asText();
        }
        return propertyValue;
    }

    protected static JsonNode getProperty(String name, JsonNode objectNode) {
        JsonNode propertyNode = null;
        if (objectNode.get("properties") != null) {
            JsonNode propertiesNode = objectNode.get("properties");
            propertyNode = propertiesNode.get(name);
        }
        return propertyNode;
    }
}

