/*
 * Decompiled with CFR 0.152.
 */
package net.java.truecommons.jmx.qonm;

import java.util.Hashtable;
import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.concurrent.Immutable;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import net.java.truecommons.jmx.AbstractObjectNameModifier;

@Immutable
public class QualifierObjectNameModifier
extends AbstractObjectNameModifier {
    private final String key;
    private final String value;
    private final KeyPropertyListStrategy keyPropertyList;

    public QualifierObjectNameModifier(String key, String value) {
        this.key = Objects.requireNonNull(key);
        this.value = Objects.requireNonNull(value);
        KeyPropertyListStrategy s = KeyPropertyListStrategy.GET;
        try {
            Hashtable<String, String> t = s.apply(new ObjectName(":test=test"));
            try {
                t.remove("test");
            }
            catch (UnsupportedOperationException ex) {
                s = KeyPropertyListStrategy.COPY;
            }
        }
        catch (MalformedObjectNameException cannotHappen) {
            throw new AssertionError((Object)cannotHappen);
        }
        this.keyPropertyList = s;
    }

    @Override
    public ObjectName apply(@CheckForNull ObjectName name) {
        if (null == name) {
            return null;
        }
        String domain = name.getDomain();
        Hashtable<String, String> table = this.keyPropertyList.apply(name);
        try {
            return null != table.put(this.key, this.value) ? name : new ObjectName(domain, table);
        }
        catch (MalformedObjectNameException ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Override
    public ObjectName unapply(ObjectName name) {
        if (null == name) {
            return null;
        }
        String domain = name.getDomain();
        Hashtable<String, String> table = this.keyPropertyList.apply(name);
        try {
            return null == table.remove(this.key) ? name : new ObjectName(domain, table);
        }
        catch (MalformedObjectNameException ex) {
            throw new IllegalStateException(ex);
        }
    }

    private static enum KeyPropertyListStrategy {
        GET{

            @Override
            Hashtable<String, String> apply(ObjectName name) {
                return name.getKeyPropertyList();
            }
        }
        ,
        COPY{

            @Override
            Hashtable<String, String> apply(ObjectName name) {
                return new Hashtable<String, String>(name.getKeyPropertyList());
            }
        };


        abstract Hashtable<String, String> apply(ObjectName var1);
    }
}

