/*
 * Decompiled with CFR 0.152.
 */
package net.java.truecommons.jmx.mmbs;

import java.io.ObjectInputStream;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.concurrent.Immutable;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.OperationsException;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import net.java.truecommons.jmx.DelegatingMBeanServer;
import net.java.truecommons.jmx.ObjectNameModifier;
import net.java.truecommons.shed.HashMaps;

@Immutable
public final class MultiplexingMBeanServer
extends DelegatingMBeanServer {
    private final MBeanServer mbs;
    private final ObjectNameModifier modifier;

    public MultiplexingMBeanServer(MBeanServer mbs, ObjectNameModifier modifier) {
        this.mbs = Objects.requireNonNull(mbs);
        this.modifier = Objects.requireNonNull(modifier);
    }

    @Override
    protected MBeanServer mbs() {
        return this.mbs;
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName name) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        return this.modifier.unapply(this.mbs().createMBean(className, this.modifier.apply(name)));
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        return this.modifier.unapply(this.mbs().createMBean(className, this.modifier.apply(name), loaderName));
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName name, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        return this.modifier.unapply(this.mbs().createMBean(className, this.modifier.apply(name), params, signature));
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        return this.modifier.unapply(this.mbs().createMBean(className, this.modifier.apply(name), loaderName, params, signature));
    }

    @Override
    public ObjectInstance registerMBean(Object object, ObjectName name) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        return this.modifier.unapply(this.mbs().registerMBean(object, this.modifier.apply(name)));
    }

    @Override
    public void unregisterMBean(ObjectName name) throws MBeanRegistrationException, InstanceNotFoundException {
        this.mbs().unregisterMBean(this.modifier.apply(name));
    }

    @Override
    public ObjectInstance getObjectInstance(ObjectName name) throws InstanceNotFoundException {
        return this.modifier.unapply(this.mbs().getObjectInstance(this.modifier.apply(name)));
    }

    @Override
    public Set<ObjectInstance> queryMBeans(ObjectName name, QueryExp query) {
        Set<ObjectInstance> is = this.mbs().queryMBeans(this.modifier.apply(name), query);
        LinkedHashSet<ObjectInstance> os = new LinkedHashSet<ObjectInstance>(HashMaps.initialCapacity((int)is.size()));
        for (ObjectInstance i : is) {
            os.add(this.modifier.unapply(i));
        }
        return os;
    }

    @Override
    public Set<ObjectName> queryNames(ObjectName name, QueryExp query) {
        Set<ObjectName> is = this.mbs().queryNames(this.modifier.apply(name), query);
        LinkedHashSet<ObjectName> os = new LinkedHashSet<ObjectName>(HashMaps.initialCapacity((int)is.size()));
        for (ObjectName i : is) {
            os.add(this.modifier.unapply(i));
        }
        return os;
    }

    @Override
    public boolean isRegistered(ObjectName name) {
        return this.mbs().isRegistered(this.modifier.apply(name));
    }

    @Override
    public Integer getMBeanCount() {
        return this.mbs().getMBeanCount();
    }

    @Override
    public Object getAttribute(ObjectName name, String attribute) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException {
        return this.mbs().getAttribute(this.modifier.apply(name), attribute);
    }

    @Override
    public AttributeList getAttributes(ObjectName name, String[] attributes) throws InstanceNotFoundException, ReflectionException {
        return this.mbs().getAttributes(this.modifier.apply(name), attributes);
    }

    @Override
    public void setAttribute(ObjectName name, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        this.mbs().setAttribute(this.modifier.apply(name), attribute);
    }

    @Override
    public AttributeList setAttributes(ObjectName name, AttributeList attributes) throws InstanceNotFoundException, ReflectionException {
        return this.mbs().setAttributes(this.modifier.apply(name), attributes);
    }

    @Override
    public Object invoke(ObjectName name, String operationName, Object[] params, String[] signature) throws InstanceNotFoundException, MBeanException, ReflectionException {
        return this.mbs().invoke(this.modifier.apply(name), operationName, params, signature);
    }

    @Override
    public void addNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException {
        this.mbs().addNotificationListener(this.modifier.apply(name), listener, filter, handback);
    }

    @Override
    public void addNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException {
        this.mbs().addNotificationListener(this.modifier.apply(name), listener, filter, handback);
    }

    @Override
    public void removeNotificationListener(ObjectName name, ObjectName listener) throws InstanceNotFoundException, ListenerNotFoundException {
        this.mbs().removeNotificationListener(this.modifier.apply(name), listener);
    }

    @Override
    public void removeNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException {
        this.mbs().removeNotificationListener(this.modifier.apply(name), listener, filter, handback);
    }

    @Override
    public void removeNotificationListener(ObjectName name, NotificationListener listener) throws InstanceNotFoundException, ListenerNotFoundException {
        this.mbs().removeNotificationListener(this.modifier.apply(name), listener);
    }

    @Override
    public void removeNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException {
        this.mbs().removeNotificationListener(this.modifier.apply(name), listener, filter, handback);
    }

    @Override
    public MBeanInfo getMBeanInfo(ObjectName name) throws InstanceNotFoundException, IntrospectionException, ReflectionException {
        return this.mbs().getMBeanInfo(this.modifier.apply(name));
    }

    @Override
    public boolean isInstanceOf(ObjectName name, String className) throws InstanceNotFoundException {
        return this.mbs().isInstanceOf(this.modifier.apply(name), className);
    }

    @Override
    @Deprecated
    public ObjectInputStream deserialize(ObjectName name, byte[] data) throws InstanceNotFoundException, OperationsException {
        return this.mbs().deserialize(this.modifier.apply(name), data);
    }

    @Override
    public ClassLoader getClassLoaderFor(ObjectName mbeanName) throws InstanceNotFoundException {
        return this.mbs().getClassLoaderFor(this.modifier.apply(mbeanName));
    }
}

