/*
 * Decompiled with CFR 0.152.
 */
package net.dubboclub.netty4;

import com.alibaba.dubbo.common.Constants;
import com.alibaba.dubbo.common.URL;
import com.alibaba.dubbo.common.logger.Logger;
import com.alibaba.dubbo.common.logger.LoggerFactory;
import com.alibaba.dubbo.common.utils.ExecutorUtil;
import com.alibaba.dubbo.common.utils.NamedThreadFactory;
import com.alibaba.dubbo.common.utils.NetUtils;
import com.alibaba.dubbo.remoting.Channel;
import com.alibaba.dubbo.remoting.RemotingException;
import com.alibaba.dubbo.remoting.transport.AbstractServer;
import com.alibaba.dubbo.remoting.transport.dispatcher.ChannelHandlers;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ThreadFactory;
import net.dubboclub.netty4.Netty4CodecAdapter;
import net.dubboclub.netty4.Netty4Handler;

public class Netty4Server
extends AbstractServer {
    private static final Logger logger = LoggerFactory.getLogger(Netty4Server.class);
    private Map<String, Channel> channels;
    private ServerBootstrap bootstrap;
    private io.netty.channel.Channel channel;

    public Netty4Server(URL url, com.alibaba.dubbo.remoting.ChannelHandler handler) throws RemotingException {
        super(url, ChannelHandlers.wrap((com.alibaba.dubbo.remoting.ChannelHandler)handler, (URL)ExecutorUtil.setThreadName((URL)url, (String)"DubboServerHandler")));
    }

    protected void doOpen() throws Throwable {
        System.out.println("used netty4");
        this.bootstrap = new ServerBootstrap();
        NioEventLoopGroup bossGroup = new NioEventLoopGroup(1, (ThreadFactory)new NamedThreadFactory("NettyServerBoss", true));
        NioEventLoopGroup workerGroup = new NioEventLoopGroup(this.getUrl().getPositiveParameter("iothreads", Constants.DEFAULT_IO_THREADS), (ThreadFactory)new NamedThreadFactory("NettyServerWorker", true));
        final Netty4Handler nettyHandler = new Netty4Handler(this.getUrl(), (com.alibaba.dubbo.remoting.ChannelHandler)this);
        this.channels = nettyHandler.getChannels();
        ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)this.bootstrap.group((EventLoopGroup)bossGroup, (EventLoopGroup)workerGroup).channel(NioServerSocketChannel.class)).option(ChannelOption.SO_KEEPALIVE, (Object)true)).option(ChannelOption.TCP_NODELAY, (Object)true)).childHandler((ChannelHandler)new ChannelInitializer<NioSocketChannel>(){

            protected void initChannel(NioSocketChannel ch) throws Exception {
                Netty4CodecAdapter codecAdapter = new Netty4CodecAdapter(Netty4Server.this.getCodec(), Netty4Server.this.getUrl(), (com.alibaba.dubbo.remoting.ChannelHandler)Netty4Server.this);
                ch.pipeline().addLast("decoder", codecAdapter.getDecoder()).addLast("encoder", codecAdapter.getEncoder()).addLast("handler", (ChannelHandler)nettyHandler);
            }
        });
        ChannelFuture channelFuture = this.bootstrap.bind((SocketAddress)this.getBindAddress());
        this.channel = channelFuture.channel();
    }

    protected void doClose() throws Throwable {
        try {
            if (this.channel != null) {
                this.channel.close();
            }
        }
        catch (Throwable e) {
            logger.warn(e.getMessage(), e);
        }
        try {
            Collection<Channel> channels = this.getChannels();
            if (channels != null && channels.size() > 0) {
                for (Channel channel : channels) {
                    try {
                        channel.close();
                    }
                    catch (Throwable e) {
                        logger.warn(e.getMessage(), e);
                    }
                }
            }
        }
        catch (Throwable e) {
            logger.warn(e.getMessage(), e);
        }
        try {
            if (this.channels != null) {
                this.channels.clear();
            }
        }
        catch (Throwable e) {
            logger.warn(e.getMessage(), e);
        }
    }

    public boolean isBound() {
        return this.channel.isActive();
    }

    public Collection<Channel> getChannels() {
        HashSet<Channel> chs = new HashSet<Channel>();
        for (Channel channel : this.channels.values()) {
            if (channel.isConnected()) {
                chs.add(channel);
                continue;
            }
            this.channels.remove(NetUtils.toAddressString((InetSocketAddress)channel.getRemoteAddress()));
        }
        return chs;
    }

    public Channel getChannel(InetSocketAddress remoteAddress) {
        return this.channels.get(NetUtils.toAddressString((InetSocketAddress)remoteAddress));
    }
}

