/*
 * Decompiled with CFR 0.152.
 */
package net.dubboclub.netty4;

import com.alibaba.dubbo.common.URL;
import com.alibaba.dubbo.common.utils.NetUtils;
import com.alibaba.dubbo.remoting.Channel;
import com.alibaba.dubbo.remoting.ChannelHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.net.InetSocketAddress;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.dubboclub.netty4.Netty4Channel;

@ChannelHandler.Sharable
public class Netty4Handler
extends SimpleChannelInboundHandler {
    private final Map<String, Channel> channels = new ConcurrentHashMap<String, Channel>();
    private final URL url;
    private final ChannelHandler handler;

    public Netty4Handler(URL url, ChannelHandler handler) {
        if (url == null) {
            throw new IllegalArgumentException("url == null");
        }
        if (handler == null) {
            throw new IllegalArgumentException("handler == null");
        }
        this.url = url;
        this.handler = handler;
    }

    public Map<String, Channel> getChannels() {
        return this.channels;
    }

    public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
        Netty4Channel channel = Netty4Channel.getOrAddChannel(ctx.channel(), this.url, this.handler);
        try {
            if (channel != null) {
                this.channels.put(NetUtils.toAddressString((InetSocketAddress)((InetSocketAddress)ctx.channel().remoteAddress())), (Channel)channel);
            }
            this.handler.connected((Channel)channel);
        }
        finally {
            Netty4Channel.removeChannelIfDisconnected(ctx.channel());
        }
    }

    public void channelUnregistered(ChannelHandlerContext ctx) throws Exception {
        Netty4Channel channel = Netty4Channel.getOrAddChannel(ctx.channel(), this.url, this.handler);
        try {
            this.channels.remove(NetUtils.toAddressString((InetSocketAddress)((InetSocketAddress)ctx.channel().remoteAddress())));
            this.handler.disconnected((Channel)channel);
        }
        finally {
            Netty4Channel.removeChannelIfDisconnected(ctx.channel());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        Netty4Channel channel = Netty4Channel.getOrAddChannel(ctx.channel(), this.url, this.handler);
        try {
            this.handler.caught((Channel)channel, cause.getCause());
        }
        finally {
            Netty4Channel.removeChannelIfDisconnected(ctx.channel());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void channelRead0(ChannelHandlerContext channelHandlerContext, Object o) throws Exception {
        Netty4Channel channel = Netty4Channel.getOrAddChannel(channelHandlerContext.channel(), this.url, this.handler);
        try {
            this.handler.received((Channel)channel, o);
        }
        finally {
            Netty4Channel.removeChannelIfDisconnected(channelHandlerContext.channel());
        }
    }
}

