/*
 * Decompiled with CFR 0.152.
 */
package net.dubboclub.netty4;

import com.alibaba.dubbo.common.URL;
import com.alibaba.dubbo.remoting.Channel;
import com.alibaba.dubbo.remoting.Codec2;
import com.alibaba.dubbo.remoting.buffer.ChannelBuffer;
import com.alibaba.dubbo.remoting.buffer.ChannelBuffers;
import com.alibaba.dubbo.remoting.buffer.DynamicChannelBuffer;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandler;
import io.netty.channel.ChannelOutboundHandler;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.MessageToByteEncoder;
import java.io.IOException;
import net.dubboclub.netty4.Netty4Channel;

public class Netty4CodecAdapter {
    private final ChannelOutboundHandler encoder = new InternalEncoder();
    private final ChannelInboundHandler decoder = new InternalDecoder();
    private final Codec2 codec;
    private final URL url;
    private final int bufferSize;
    private final com.alibaba.dubbo.remoting.ChannelHandler handler;

    public Netty4CodecAdapter(Codec2 codec, URL url, com.alibaba.dubbo.remoting.ChannelHandler handler) {
        this.codec = codec;
        this.url = url;
        this.handler = handler;
        int b = url.getPositiveParameter("buffer", 8192);
        this.bufferSize = b >= 1024 && b <= 16384 ? b : 8192;
    }

    public ChannelHandler getEncoder() {
        return this.encoder;
    }

    public ChannelHandler getDecoder() {
        return this.decoder;
    }

    private class InternalDecoder
    extends SimpleChannelInboundHandler {
        private ChannelBuffer buffer = ChannelBuffers.EMPTY_BUFFER;

        private InternalDecoder() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void channelRead0(ChannelHandlerContext channelHandlerContext, Object o) throws Exception {
            ChannelBuffer message;
            if (!(o instanceof ByteBuf)) {
                channelHandlerContext.fireChannelRead(o);
                return;
            }
            ByteBuf input = (ByteBuf)o;
            int readable = input.readableBytes();
            if (readable <= 0) {
                return;
            }
            byte[] bytes = new byte[readable];
            input.readBytes(bytes);
            if (this.buffer.readable()) {
                if (this.buffer instanceof DynamicChannelBuffer) {
                    this.buffer.writeBytes(bytes);
                    message = this.buffer;
                } else {
                    int size = this.buffer.readableBytes() + input.readableBytes();
                    message = ChannelBuffers.dynamicBuffer((int)(size > Netty4CodecAdapter.this.bufferSize ? size : Netty4CodecAdapter.this.bufferSize));
                    message.writeBytes(this.buffer, this.buffer.readableBytes());
                    message.writeBytes(bytes);
                }
            } else {
                message = ChannelBuffers.wrappedBuffer((byte[])bytes);
            }
            Netty4Channel channel = Netty4Channel.getOrAddChannel(channelHandlerContext.channel(), Netty4CodecAdapter.this.url, Netty4CodecAdapter.this.handler);
            try {
                do {
                    Object msg;
                    int saveReaderIndex = message.readerIndex();
                    try {
                        msg = Netty4CodecAdapter.this.codec.decode((Channel)channel, message);
                    }
                    catch (IOException e) {
                        this.buffer = ChannelBuffers.EMPTY_BUFFER;
                        throw e;
                    }
                    if (msg == Codec2.DecodeResult.NEED_MORE_INPUT) {
                        message.readerIndex(saveReaderIndex);
                        break;
                    }
                    if (saveReaderIndex == message.readerIndex()) {
                        this.buffer = ChannelBuffers.EMPTY_BUFFER;
                        throw new IOException("Decode without read data.");
                    }
                    if (msg == null) continue;
                    channelHandlerContext.fireChannelRead(msg);
                } while (message.readable());
            }
            finally {
                if (message.readable()) {
                    message.discardReadBytes();
                    this.buffer = message;
                } else {
                    this.buffer = ChannelBuffers.EMPTY_BUFFER;
                }
                Netty4Channel.removeChannelIfDisconnected(channelHandlerContext.channel());
            }
        }
    }

    private class InternalEncoder
    extends MessageToByteEncoder<byte[]> {
        private InternalEncoder() {
        }

        protected void encode(ChannelHandlerContext channelHandlerContext, byte[] bytes, ByteBuf byteBuf) throws Exception {
            byteBuf.writeBytes(bytes);
        }
    }
}

