/*
 * Decompiled with CFR 0.152.
 */
package net.dubboclub.netty4;

import com.alibaba.dubbo.common.Constants;
import com.alibaba.dubbo.common.URL;
import com.alibaba.dubbo.common.Version;
import com.alibaba.dubbo.common.logger.Logger;
import com.alibaba.dubbo.common.logger.LoggerFactory;
import com.alibaba.dubbo.common.utils.NamedThreadFactory;
import com.alibaba.dubbo.common.utils.NetUtils;
import com.alibaba.dubbo.remoting.Channel;
import com.alibaba.dubbo.remoting.RemotingException;
import com.alibaba.dubbo.remoting.transport.AbstractClient;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import java.net.SocketAddress;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import net.dubboclub.netty4.Netty4Channel;
import net.dubboclub.netty4.Netty4CodecAdapter;
import net.dubboclub.netty4.Netty4Handler;

public class Netty4Client
extends AbstractClient {
    private static final Logger logger = LoggerFactory.getLogger(Netty4Client.class);
    private Bootstrap bootstrap;
    private io.netty.channel.Channel channel;

    public Netty4Client(URL url, com.alibaba.dubbo.remoting.ChannelHandler handler) throws RemotingException {
        super(url, Netty4Client.wrapChannelHandler((URL)url, (com.alibaba.dubbo.remoting.ChannelHandler)handler));
    }

    protected void doOpen() throws Throwable {
        NioEventLoopGroup bossGroup = new NioEventLoopGroup(Constants.DEFAULT_IO_THREADS, (ThreadFactory)new NamedThreadFactory("NettyClientBoss", true));
        final Netty4Handler nettyHandler = new Netty4Handler(this.getUrl(), (com.alibaba.dubbo.remoting.ChannelHandler)this);
        this.bootstrap = new Bootstrap();
        ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)this.bootstrap.group((EventLoopGroup)bossGroup)).channel(NioSocketChannel.class)).option(ChannelOption.SO_KEEPALIVE, (Object)true)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)this.getTimeout())).option(ChannelOption.TCP_NODELAY, (Object)true)).handler((ChannelHandler)new ChannelInitializer<NioSocketChannel>(){

            protected void initChannel(NioSocketChannel ch) throws Exception {
                Netty4CodecAdapter adapter = new Netty4CodecAdapter(Netty4Client.this.getCodec(), Netty4Client.this.getUrl(), (com.alibaba.dubbo.remoting.ChannelHandler)Netty4Client.this);
                ch.pipeline().addLast("decoder", adapter.getDecoder()).addLast("encoder", adapter.getEncoder()).addLast("handler", (ChannelHandler)nettyHandler);
            }
        });
    }

    protected void doClose() throws Throwable {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doConnect() throws Throwable {
        block21: {
            long start = System.currentTimeMillis();
            ChannelFuture future = this.bootstrap.connect((SocketAddress)this.getConnectAddress()).sync();
            try {
                boolean ret = future.awaitUninterruptibly((long)this.getConnectTimeout(), TimeUnit.MILLISECONDS);
                if (ret && future.isSuccess()) {
                    io.netty.channel.Channel newChannel = future.channel();
                    try {
                        io.netty.channel.Channel oldChannel = this.channel;
                        if (oldChannel == null) break block21;
                        try {
                            if (logger.isInfoEnabled()) {
                                logger.info("Close old netty channel " + oldChannel + " on create new netty channel " + newChannel);
                            }
                            oldChannel.close();
                            break block21;
                        }
                        finally {
                            Netty4Channel.removeChannelIfDisconnected(oldChannel);
                        }
                    }
                    finally {
                        if (this.isClosed()) {
                            try {
                                if (logger.isInfoEnabled()) {
                                    logger.info("Close new netty channel " + newChannel + ", because the client closed.");
                                }
                                newChannel.close();
                            }
                            finally {
                                this.channel = null;
                                Netty4Channel.removeChannelIfDisconnected(newChannel);
                            }
                        } else {
                            this.channel = newChannel;
                        }
                    }
                }
                if (future.cause() != null) {
                    throw new RemotingException((Channel)this, "client(url: " + this.getUrl() + ") failed to connect to server " + this.getRemoteAddress() + ", error message is:" + future.cause().getMessage(), future.cause());
                }
                throw new RemotingException((Channel)this, "client(url: " + this.getUrl() + ") failed to connect to server " + this.getRemoteAddress() + " client-side timeout " + this.getConnectTimeout() + "ms (elapsed: " + (System.currentTimeMillis() - start) + "ms) from netty client " + NetUtils.getLocalHost() + " using dubbo version " + Version.getVersion());
            }
            finally {
                if (!this.isConnected()) {
                    future.cancel(true);
                }
            }
        }
    }

    protected void doDisConnect() throws Throwable {
        try {
            Netty4Channel.removeChannelIfDisconnected(this.channel);
        }
        catch (Throwable t) {
            logger.warn(t.getMessage());
        }
    }

    protected Channel getChannel() {
        io.netty.channel.Channel c = this.channel;
        if (c == null || !c.isOpen()) {
            return null;
        }
        return Netty4Channel.getOrAddChannel(c, this.getUrl(), (com.alibaba.dubbo.remoting.ChannelHandler)this);
    }
}

