/*
 * Decompiled with CFR 0.152.
 */
package net.dubboclub.netty4;

import com.alibaba.dubbo.common.URL;
import com.alibaba.dubbo.common.extension.ExtensionLoader;
import com.alibaba.dubbo.common.logger.Logger;
import com.alibaba.dubbo.common.logger.LoggerFactory;
import com.alibaba.dubbo.remoting.Channel;
import com.alibaba.dubbo.remoting.ChannelHandler;
import com.alibaba.dubbo.remoting.Codec;
import com.alibaba.dubbo.remoting.Codec2;
import com.alibaba.dubbo.remoting.RemotingException;
import com.alibaba.dubbo.remoting.buffer.ChannelBuffer;
import com.alibaba.dubbo.remoting.buffer.ChannelBuffers;
import com.alibaba.dubbo.remoting.transport.AbstractChannel;
import com.alibaba.dubbo.remoting.transport.codec.CodecAdapter;
import io.netty.channel.ChannelFuture;
import java.net.InetSocketAddress;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class Netty4Channel
extends AbstractChannel {
    private static final Logger logger = LoggerFactory.getLogger(Netty4Channel.class);
    private static final ConcurrentMap<io.netty.channel.Channel, Netty4Channel> channelMap = new ConcurrentHashMap<io.netty.channel.Channel, Netty4Channel>();
    private final Codec2 codec;
    private io.netty.channel.Channel originChannel;
    private final Map<String, Object> attributes = new ConcurrentHashMap<String, Object>();

    public Netty4Channel(io.netty.channel.Channel channel, URL url, ChannelHandler handler) {
        super(url, handler);
        if (channel == null) {
            throw new IllegalArgumentException("netty channel == null;");
        }
        this.originChannel = channel;
        this.codec = this.getChannelCodec(url);
    }

    protected Codec2 getChannelCodec(URL url) {
        String codecName = url.getParameter("codec", "telnet");
        if (ExtensionLoader.getExtensionLoader(Codec2.class).hasExtension(codecName)) {
            return (Codec2)ExtensionLoader.getExtensionLoader(Codec2.class).getExtension(codecName);
        }
        return new CodecAdapter((Codec)ExtensionLoader.getExtensionLoader(Codec.class).getExtension(codecName));
    }

    static Netty4Channel getOrAddChannel(io.netty.channel.Channel ch, URL url, ChannelHandler handler) {
        if (ch == null) {
            return null;
        }
        Netty4Channel ret = (Netty4Channel)((Object)channelMap.get(ch));
        if (ret == null) {
            Netty4Channel nc = new Netty4Channel(ch, url, handler);
            if (ch.isOpen()) {
                ret = channelMap.putIfAbsent(ch, nc);
            }
            if (ret == null) {
                ret = nc;
            }
        }
        return ret;
    }

    static void removeChannelIfDisconnected(io.netty.channel.Channel ch) {
        if (ch != null && !ch.isOpen()) {
            channelMap.remove(ch);
        }
    }

    public void send(Object message, boolean sent) throws RemotingException {
        super.send(message, sent);
        boolean success = true;
        int timeout = 0;
        try {
            Throwable cause;
            ChannelBuffer buffer = ChannelBuffers.dynamicBuffer((int)1024);
            this.codec.encode((Channel)this, buffer, message);
            byte[] bytes = new byte[buffer.readableBytes()];
            buffer.readBytes(bytes);
            ChannelFuture future = this.originChannel.writeAndFlush((Object)bytes);
            if (sent) {
                timeout = this.getUrl().getPositiveParameter("timeout", 1000);
                success = future.await((long)timeout);
            }
            if ((cause = future.cause()) != null) {
                throw cause;
            }
        }
        catch (Throwable e) {
            throw new RemotingException((Channel)this, "Failed to send message " + message + " to " + this.getRemoteAddress() + ", cause: " + e.getMessage(), e);
        }
        if (!success) {
            throw new RemotingException((Channel)this, "Failed to send message " + message + " to " + this.getRemoteAddress() + "in timeout(" + timeout + "ms) limit");
        }
    }

    public InetSocketAddress getRemoteAddress() {
        return (InetSocketAddress)this.originChannel.remoteAddress();
    }

    public boolean isConnected() {
        return this.originChannel.isOpen();
    }

    public boolean hasAttribute(String key) {
        return this.attributes.containsKey(key);
    }

    public Object getAttribute(String key) {
        return this.attributes.get(key);
    }

    public void setAttribute(String key, Object value) {
        if (value == null) {
            this.attributes.remove(key);
            return;
        }
        this.attributes.put(key, value);
    }

    public void removeAttribute(String key) {
        this.attributes.remove(key);
    }

    public InetSocketAddress getLocalAddress() {
        return (InetSocketAddress)this.originChannel.localAddress();
    }

    public void close() {
        try {
            super.close();
        }
        catch (Exception e) {
            logger.warn(e.getMessage(), (Throwable)e);
        }
        try {
            Netty4Channel.removeChannelIfDisconnected(this.originChannel);
        }
        catch (Exception e) {
            logger.warn(e.getMessage(), (Throwable)e);
        }
        try {
            this.attributes.clear();
        }
        catch (Exception e) {
            logger.warn(e.getMessage(), (Throwable)e);
        }
        try {
            if (logger.isInfoEnabled()) {
                logger.info("Close netty channel " + this.originChannel);
            }
            this.originChannel.close();
        }
        catch (Exception e) {
            logger.warn(e.getMessage(), (Throwable)e);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.originChannel == null ? 0 : this.originChannel.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        Netty4Channel other = (Netty4Channel)((Object)obj);
        return !(this.originChannel == null ? other.originChannel != null : !this.originChannel.equals(other.originChannel));
    }

    public String toString() {
        return "NettyChannel [channel=" + this.originChannel + "]";
    }
}

