/*
 * Decompiled with CFR 0.152.
 */
package net.devh.boot.grpc.server.autoconfigure;

import java.util.List;
import net.devh.boot.grpc.server.autoconfigure.GrpcServerAutoConfiguration;
import net.devh.boot.grpc.server.condition.ConditionalOnInterprocessServer;
import net.devh.boot.grpc.server.config.GrpcServerProperties;
import net.devh.boot.grpc.server.serverfactory.GrpcServerConfigurer;
import net.devh.boot.grpc.server.serverfactory.GrpcServerFactory;
import net.devh.boot.grpc.server.serverfactory.GrpcServerLifecycle;
import net.devh.boot.grpc.server.serverfactory.InProcessGrpcServerFactory;
import net.devh.boot.grpc.server.serverfactory.NettyGrpcServerFactory;
import net.devh.boot.grpc.server.serverfactory.ShadedNettyGrpcServerFactory;
import net.devh.boot.grpc.server.service.GrpcServiceDefinition;
import net.devh.boot.grpc.server.service.GrpcServiceDiscoverer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnMissingBean(value={GrpcServerFactory.class, GrpcServerLifecycle.class})
@AutoConfigureAfter(value={GrpcServerAutoConfiguration.class})
public class GrpcServerFactoryAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(GrpcServerFactoryAutoConfiguration.class);

    @ConditionalOnClass(name={"io.grpc.netty.shaded.io.netty.channel.Channel", "io.grpc.netty.shaded.io.grpc.netty.NettyServerBuilder"})
    @Conditional(value={ConditionalOnInterprocessServer.class})
    @Bean
    public ShadedNettyGrpcServerFactory shadedNettyGrpcServerFactory(GrpcServerProperties properties, GrpcServiceDiscoverer serviceDiscoverer, List<GrpcServerConfigurer> serverConfigurers) {
        log.info("Detected grpc-netty-shaded: Creating ShadedNettyGrpcServerFactory");
        ShadedNettyGrpcServerFactory factory = new ShadedNettyGrpcServerFactory(properties, serverConfigurers);
        for (GrpcServiceDefinition service : serviceDiscoverer.findGrpcServices()) {
            factory.addService(service);
        }
        return factory;
    }

    @ConditionalOnBean(value={ShadedNettyGrpcServerFactory.class})
    @Bean
    public GrpcServerLifecycle shadedNettyGrpcServerLifecycle(ShadedNettyGrpcServerFactory factory) {
        return new GrpcServerLifecycle(factory);
    }

    @ConditionalOnMissingBean(value={ShadedNettyGrpcServerFactory.class})
    @Conditional(value={ConditionalOnInterprocessServer.class})
    @ConditionalOnClass(name={"io.netty.channel.Channel", "io.grpc.netty.NettyServerBuilder"})
    @Bean
    public NettyGrpcServerFactory nettyGrpcServerFactory(GrpcServerProperties properties, GrpcServiceDiscoverer serviceDiscoverer, List<GrpcServerConfigurer> serverConfigurers) {
        log.info("Detected grpc-netty: Creating NettyGrpcServerFactory");
        NettyGrpcServerFactory factory = new NettyGrpcServerFactory(properties, serverConfigurers);
        for (GrpcServiceDefinition service : serviceDiscoverer.findGrpcServices()) {
            factory.addService(service);
        }
        return factory;
    }

    @ConditionalOnBean(value={NettyGrpcServerFactory.class})
    @Bean
    public GrpcServerLifecycle nettyGrpcServerLifecycle(NettyGrpcServerFactory factory) {
        return new GrpcServerLifecycle(factory);
    }

    @ConditionalOnProperty(prefix="grpc.server", name={"in-process-name"})
    @Bean
    public InProcessGrpcServerFactory inProcessGrpcServerFactory(GrpcServerProperties properties, GrpcServiceDiscoverer serviceDiscoverer) {
        log.info("'grpc.server.in-process-name' is set: Creating InProcessGrpcServerFactory");
        InProcessGrpcServerFactory factory = new InProcessGrpcServerFactory(properties);
        for (GrpcServiceDefinition service : serviceDiscoverer.findGrpcServices()) {
            factory.addService(service);
        }
        return factory;
    }

    @ConditionalOnBean(value={InProcessGrpcServerFactory.class})
    @Bean
    public GrpcServerLifecycle inProcessGrpcServerLifecycle(InProcessGrpcServerFactory factory) {
        return new GrpcServerLifecycle(factory);
    }
}

