// Generated by delombok at Tue Mar 05 13:44:27 UTC 2024
package io.weaviate.client.v1.graphql.query.argument;

import io.weaviate.client.v1.graphql.query.util.Serializer;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Base64;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

class NearMediaArgumentHelper {
  private final String mediaName;
  private final String mediaField;
  private final String data;
  private final File dataFile;
  private final Float certainty;
  private final Float distance;
  private final String[] targetVectors;

  public String build() {
    Set<String> fields = new LinkedHashSet<>();
    String content = getContent();
    if (StringUtils.isNotBlank(content)) {
      fields.add(String.format("%s:%s", mediaField, Serializer.quote(content)));
    }
    if (certainty != null) {
      fields.add(String.format("certainty:%s", certainty));
    }
    if (distance != null) {
      fields.add(String.format("distance:%s", distance));
    }
    if (ArrayUtils.isNotEmpty(targetVectors)) {
      fields.add(String.format("targetVectors:%s", Serializer.arrayWithQuotes(targetVectors)));
    }
    return String.format("%s:{%s}", mediaName, String.join(" ", fields));
  }

  private String getContent() {
    if (StringUtils.isNotBlank(data)) {
      if (data.startsWith("data:")) {
        String base64 = ";base64,";
        return data.substring(data.indexOf(base64) + base64.length());
      }
      return data;
    }
    if (dataFile != null) {
      return readFile(dataFile);
    }
    return null;
  }

  private String readFile(File file) {
    try {
      byte[] content = Files.readAllBytes(Paths.get(file.toURI()));
      return Base64.getEncoder().encodeToString(content);
    } catch (Exception e) {
      return null;
    }
  }

  @java.lang.SuppressWarnings("all")
  NearMediaArgumentHelper(final String mediaName, final String mediaField, final String data, final File dataFile, final Float certainty, final Float distance, final String[] targetVectors) {
    this.mediaName = mediaName;
    this.mediaField = mediaField;
    this.data = data;
    this.dataFile = dataFile;
    this.certainty = certainty;
    this.distance = distance;
    this.targetVectors = targetVectors;
  }


  @java.lang.SuppressWarnings("all")
  public static class NearMediaArgumentHelperBuilder {
    @java.lang.SuppressWarnings("all")
    private String mediaName;
    @java.lang.SuppressWarnings("all")
    private String mediaField;
    @java.lang.SuppressWarnings("all")
    private String data;
    @java.lang.SuppressWarnings("all")
    private File dataFile;
    @java.lang.SuppressWarnings("all")
    private Float certainty;
    @java.lang.SuppressWarnings("all")
    private Float distance;
    @java.lang.SuppressWarnings("all")
    private String[] targetVectors;

    @java.lang.SuppressWarnings("all")
    NearMediaArgumentHelperBuilder() {
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public NearMediaArgumentHelper.NearMediaArgumentHelperBuilder mediaName(final String mediaName) {
      this.mediaName = mediaName;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public NearMediaArgumentHelper.NearMediaArgumentHelperBuilder mediaField(final String mediaField) {
      this.mediaField = mediaField;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public NearMediaArgumentHelper.NearMediaArgumentHelperBuilder data(final String data) {
      this.data = data;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public NearMediaArgumentHelper.NearMediaArgumentHelperBuilder dataFile(final File dataFile) {
      this.dataFile = dataFile;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public NearMediaArgumentHelper.NearMediaArgumentHelperBuilder certainty(final Float certainty) {
      this.certainty = certainty;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public NearMediaArgumentHelper.NearMediaArgumentHelperBuilder distance(final Float distance) {
      this.distance = distance;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public NearMediaArgumentHelper.NearMediaArgumentHelperBuilder targetVectors(final String[] targetVectors) {
      this.targetVectors = targetVectors;
      return this;
    }

    @java.lang.SuppressWarnings("all")
    public NearMediaArgumentHelper build() {
      return new NearMediaArgumentHelper(this.mediaName, this.mediaField, this.data, this.dataFile, this.certainty, this.distance, this.targetVectors);
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    public java.lang.String toString() {
      return "NearMediaArgumentHelper.NearMediaArgumentHelperBuilder(mediaName=" + this.mediaName + ", mediaField=" + this.mediaField + ", data=" + this.data + ", dataFile=" + this.dataFile + ", certainty=" + this.certainty + ", distance=" + this.distance + ", targetVectors=" + java.util.Arrays.deepToString(this.targetVectors) + ")";
    }
  }

  @java.lang.SuppressWarnings("all")
  public static NearMediaArgumentHelper.NearMediaArgumentHelperBuilder builder() {
    return new NearMediaArgumentHelper.NearMediaArgumentHelperBuilder();
  }
}
