// Generated by delombok at Tue Mar 05 13:44:27 UTC 2024
package io.weaviate.client.v1.auth.nimbus;

import io.weaviate.client.base.http.builder.HttpApacheClientBuilder;
import io.weaviate.client.base.http.impl.CommonsHttpClientImpl;
import io.weaviate.client.Config;
import io.weaviate.client.base.Serializer;
import io.weaviate.client.base.http.HttpClient;
import io.weaviate.client.base.http.HttpResponse;
import io.weaviate.client.v1.auth.exception.AuthException;

public class BaseAuth {
  public static final String OIDC_URL = "/.well-known/openid-configuration";
  private final Serializer serializer;

  BaseAuth() {
    this.serializer = new Serializer();
  }


  public class AuthResponse {
    String clientId;
    String[] scopes;
    String configuration;

    @java.lang.SuppressWarnings("all")
    public String getClientId() {
      return this.clientId;
    }

    @java.lang.SuppressWarnings("all")
    public String[] getScopes() {
      return this.scopes;
    }

    @java.lang.SuppressWarnings("all")
    public String getConfiguration() {
      return this.configuration;
    }

    @java.lang.SuppressWarnings("all")
    public AuthResponse(final String clientId, final String[] scopes, final String configuration) {
      this.clientId = clientId;
      this.scopes = scopes;
      this.configuration = configuration;
    }
  }


  private class OIDCConfig {
    String clientId;
    String href;
    String[] scopes;

    @java.lang.SuppressWarnings("all")
    public String getClientId() {
      return this.clientId;
    }

    @java.lang.SuppressWarnings("all")
    public String getHref() {
      return this.href;
    }

    @java.lang.SuppressWarnings("all")
    public String[] getScopes() {
      return this.scopes;
    }
  }

  public AuthResponse getIdAndTokenEndpoint(Config config) throws AuthException {
    HttpClient client = new CommonsHttpClientImpl(config.getHeaders(), HttpApacheClientBuilder.build(config));
    String url = config.getBaseURL() + OIDC_URL;
    HttpResponse response = sendGetRequest(client, url);
    switch (response.getStatusCode()) {
    case 404: 
      String msg = "Auth001: The client was configured to use authentication, but weaviate is configured without authentication. Are you sure this is " + "correct?";
      log(msg);
      throw new AuthException(msg);
    case 200: 
      OIDCConfig oidcConfig = serializer.toResponse(response.getBody(), OIDCConfig.class);
      HttpResponse resp = sendGetRequest(client, oidcConfig.getHref());
      if (resp.getStatusCode() != 200) {
        String errorMessage = String.format("OIDC configuration url %s returned status code %s", oidcConfig.getHref(), resp.getStatusCode());
        throw new AuthException(errorMessage);
      }
      return new AuthResponse(oidcConfig.getClientId(), oidcConfig.getScopes(), resp.getBody());
    default: 
      String errorMessage = String.format("OIDC configuration url %s returned status code %s", url, response.getStatusCode());
      throw new AuthException(errorMessage);
    }
  }

  private HttpResponse sendGetRequest(HttpClient client, String url) throws AuthException {
    try {
      return client.sendGetRequest(url);
    } catch (Exception e) {
      throw new AuthException(e);
    }
  }

  private void log(String msg) {
    System.out.println(msg);
  }
}
