/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.routing.type.hint;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import io.shardingsphere.api.algorithm.sharding.ShardingValue;
import io.shardingsphere.core.hint.HintManagerHolder;
import io.shardingsphere.core.routing.strategy.hint.HintShardingStrategy;
import io.shardingsphere.core.routing.type.RoutingEngine;
import io.shardingsphere.core.routing.type.RoutingResult;
import io.shardingsphere.core.routing.type.TableUnit;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Collections;

public final class DatabaseHintRoutingEngine
implements RoutingEngine {
    private final Collection<String> dataSourceNames;
    private final HintShardingStrategy databaseShardingStrategy;

    @Override
    public RoutingResult route() {
        Optional<ShardingValue> shardingValue = HintManagerHolder.getDatabaseShardingValue("DB_TABLE_NAME");
        Preconditions.checkState((boolean)shardingValue.isPresent());
        Collection<String> routingDataSources = this.databaseShardingStrategy.doSharding(this.dataSourceNames, Collections.singletonList(shardingValue.get()));
        Preconditions.checkState((!routingDataSources.isEmpty() ? 1 : 0) != 0, (Object)"no database route info");
        RoutingResult result = new RoutingResult();
        for (String each : routingDataSources) {
            result.getTableUnits().getTableUnits().add(new TableUnit(each));
        }
        return result;
    }

    @ConstructorProperties(value={"dataSourceNames", "databaseShardingStrategy"})
    public DatabaseHintRoutingEngine(Collection<String> dataSourceNames, HintShardingStrategy databaseShardingStrategy) {
        this.dataSourceNames = dataSourceNames;
        this.databaseShardingStrategy = databaseShardingStrategy;
    }
}

