/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.parsing.antlr.filler;

import com.google.common.base.Optional;
import io.shardingsphere.core.metadata.table.ShardingTableMetaData;
import io.shardingsphere.core.parsing.antlr.filler.SQLStatementFiller;
import io.shardingsphere.core.parsing.antlr.rule.registry.ParsingRuleRegistry;
import io.shardingsphere.core.parsing.antlr.rule.registry.statement.SQLStatementRule;
import io.shardingsphere.core.parsing.antlr.sql.segment.SQLSegment;
import io.shardingsphere.core.parsing.parser.sql.SQLStatement;
import io.shardingsphere.core.rule.ShardingRule;
import java.beans.ConstructorProperties;
import java.util.Collection;

public final class SQLStatementFillerEngine {
    private final ParsingRuleRegistry parsingRuleRegistry = ParsingRuleRegistry.getInstance();
    private final String sql;
    private final ShardingRule shardingRule;
    private final ShardingTableMetaData shardingTableMetaData;

    public SQLStatement fill(Collection<SQLSegment> sqlSegments, SQLStatementRule rule) {
        SQLStatement result = rule.getSqlStatementClass().newInstance();
        for (SQLSegment each : sqlSegments) {
            Optional<SQLStatementFiller> filler = this.parsingRuleRegistry.findSQLStatementFiller(each.getClass());
            if (!filler.isPresent()) continue;
            ((SQLStatementFiller)filler.get()).fill(each, result, this.sql, this.shardingRule, this.shardingTableMetaData);
        }
        return result;
    }

    @ConstructorProperties(value={"sql", "shardingRule", "shardingTableMetaData"})
    public SQLStatementFillerEngine(String sql, ShardingRule shardingRule, ShardingTableMetaData shardingTableMetaData) {
        this.sql = sql;
        this.shardingRule = shardingRule;
        this.shardingTableMetaData = shardingTableMetaData;
    }
}

