/*
 * Decompiled with CFR 0.152.
 */
package io.provis.model;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.provis.model.ArtifactSet;
import io.provis.model.FileSet;
import io.provis.model.ProvisioArtifact;
import io.provis.model.ProvisioningAction;
import io.provis.model.ResourceSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Runtime {
    private String id;
    private List<ProvisioningAction> actions = Lists.newArrayList();
    private List<ArtifactSet> artifactSets = Lists.newArrayList();
    private Map<String, ArtifactSet> artifactSetReferences = Maps.newHashMap();
    private Map<String, ProvisioArtifact> artifactReferences = Maps.newHashMap();
    private List<ResourceSet> resourceSets = Lists.newArrayList();
    Map<String, String> variables;
    private List<FileSet> fileSets = Lists.newArrayList();

    public String getId() {
        return this.id;
    }

    public List<ProvisioningAction> getActions() {
        return this.actions;
    }

    public void addAction(ProvisioningAction action) {
        this.actions.add(action);
    }

    public List<ArtifactSet> getArtifactSets() {
        return this.artifactSets;
    }

    public void addArtifactSet(ArtifactSet artifactSet) {
        this.artifactSets.add(artifactSet);
    }

    public Map<String, ArtifactSet> getArtifactSetReferences() {
        return this.artifactSetReferences;
    }

    public void addArtifactSetReference(String refId, ArtifactSet artifactSet) {
        this.artifactSetReferences.put(refId, artifactSet);
    }

    public Map<String, ProvisioArtifact> getArtifactReferences() {
        return this.artifactReferences;
    }

    public void addArtifactReference(String refId, ProvisioArtifact artifact) {
        this.artifactReferences.put(refId, artifact);
    }

    public List<ResourceSet> getResourceSets() {
        return this.resourceSets;
    }

    public void addResourceSet(ResourceSet resourceSet) {
        this.resourceSets.add(resourceSet);
    }

    public List<FileSet> getFileSets() {
        return this.fileSets;
    }

    public void addFileSet(FileSet fileSet) {
        this.fileSets.add(fileSet);
    }

    public Map<String, String> getVariables() {
        return this.variables;
    }

    public void setVariables(Map<String, String> variables) {
        this.variables = variables;
    }

    public Set<String> getGAsOfArtifacts() {
        HashSet<String> dependenciesInVersionlessForm = new HashSet<String>();
        for (ArtifactSet artifactSet : this.artifactSets) {
            if (artifactSet.getArtifacts() == null) continue;
            for (ProvisioArtifact artifact : artifactSet.getArtifacts()) {
                if (artifact.getReference() != null) continue;
                dependenciesInVersionlessForm.add(artifact.getGA());
            }
        }
        return dependenciesInVersionlessForm;
    }

    public Set<String> getVersionlessCoordinatesOfArtifacts() {
        HashSet<String> dependenciesInVersionlessForm = new HashSet<String>();
        for (ArtifactSet artifactSet : this.artifactSets) {
            if (artifactSet.getArtifacts() == null) continue;
            for (ProvisioArtifact artifact : artifactSet.getArtifacts()) {
                if (artifact.getReference() != null) continue;
                dependenciesInVersionlessForm.add(artifact.toVersionlessCoordinate());
            }
        }
        return dependenciesInVersionlessForm;
    }
}

