/*
 * Decompiled with CFR 0.152.
 */
package io.pinecone;

import io.grpc.Channel;
import io.grpc.ClientInterceptor;
import io.grpc.ManagedChannel;
import io.grpc.Metadata;
import io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.NegotiationType;
import io.grpc.netty.NettyChannelBuilder;
import io.grpc.stub.MetadataUtils;
import io.pinecone.PineconeClientConfig;
import io.pinecone.PineconeConnectionConfig;
import io.pinecone.exceptions.PineconeException;
import io.pinecone.exceptions.PineconeValidationException;
import io.pinecone.proto.VectorServiceGrpc;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PineconeConnection
implements AutoCloseable {
    private static final int DEFAULT_MAX_MESSAGE_SIZE = 64000000;
    private static final Logger logger = LoggerFactory.getLogger(PineconeConnection.class);
    private final PineconeConnectionConfig connectionConfig;
    private final PineconeClientConfig clientConfig;
    final ManagedChannel channel;
    private VectorServiceGrpc.VectorServiceBlockingStub blockingStub;
    private VectorServiceGrpc.VectorServiceFutureStub futureStub;

    public PineconeConnection(PineconeClientConfig clientConfig, PineconeConnectionConfig connectionConfig) {
        this.connectionConfig = connectionConfig;
        this.clientConfig = clientConfig;
        this.validateConfigs();
        this.channel = connectionConfig.getCustomChannelBuilder() != null ? connectionConfig.getCustomChannelBuilder().apply(clientConfig, connectionConfig) : PineconeConnection.buildChannel(clientConfig, connectionConfig);
        this.channel.notifyWhenStateChanged(this.channel.getState(false), this::onConnectivityStateChanged);
        Metadata metadata = PineconeConnection.assembleMetadata(clientConfig);
        this.blockingStub = (VectorServiceGrpc.VectorServiceBlockingStub)((VectorServiceGrpc.VectorServiceBlockingStub)((VectorServiceGrpc.VectorServiceBlockingStub)VectorServiceGrpc.newBlockingStub((Channel)this.channel).withInterceptors(new ClientInterceptor[]{MetadataUtils.newAttachHeadersInterceptor((Metadata)metadata)})).withMaxInboundMessageSize(64000000)).withMaxOutboundMessageSize(64000000);
        this.futureStub = (VectorServiceGrpc.VectorServiceFutureStub)((VectorServiceGrpc.VectorServiceFutureStub)((VectorServiceGrpc.VectorServiceFutureStub)VectorServiceGrpc.newFutureStub((Channel)this.channel).withInterceptors(new ClientInterceptor[]{MetadataUtils.newAttachHeadersInterceptor((Metadata)metadata)})).withMaxInboundMessageSize(64000000)).withMaxOutboundMessageSize(64000000);
        logger.debug("created new PineconeConnection for channel: {}", (Object)this.channel);
    }

    @Override
    public void close() {
        try {
            logger.debug("closing channel");
            this.channel.shutdownNow().awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            logger.warn("Channel shutdown interrupted before termination confirmed");
        }
    }

    public ManagedChannel getChannel() {
        return this.channel;
    }

    public VectorServiceGrpc.VectorServiceBlockingStub getBlockingStub() {
        return this.blockingStub;
    }

    public VectorServiceGrpc.VectorServiceFutureStub getFutureStub() {
        return this.futureStub;
    }

    private void onConnectivityStateChanged() {
        logger.debug("channel connectivity state changed to {} for {}", (Object)this.channel.getState(false), (Object)this.channel);
    }

    public static ManagedChannel buildChannel(PineconeClientConfig clientConfig, PineconeConnectionConfig config) {
        String endpoint = PineconeConnection.getEndpoint(clientConfig, config);
        NettyChannelBuilder builder = NettyChannelBuilder.forTarget((String)endpoint);
        try {
            builder = ((NettyChannelBuilder)builder.overrideAuthority(endpoint)).negotiationType(NegotiationType.TLS).sslContext(GrpcSslContexts.forClient().build());
        }
        catch (SSLException e) {
            throw new PineconeException("SSL error opening gRPC channel", e);
        }
        return builder.build();
    }

    private static Metadata assembleMetadata(PineconeClientConfig clientConfig) {
        Metadata metadata = new Metadata();
        metadata.put(Metadata.Key.of((String)"api-key", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER), (Object)clientConfig.getApiKey());
        return metadata;
    }

    static String getEndpoint(PineconeClientConfig clientConfig, PineconeConnectionConfig connectionConfig) {
        String endpoint = connectionConfig.getConnectionUrl() != null ? connectionConfig.getConnectionUrl().replaceFirst("https?://", "") : String.format("%s-%s.svc.%s.pinecone.io", connectionConfig.getIndexName(), clientConfig.getProjectName(), clientConfig.getEnvironment());
        logger.debug("Pinecone endpoint is: " + endpoint);
        return endpoint;
    }

    void validateConfigs() throws PineconeValidationException {
        if (this.clientConfig == null) {
            throw new PineconeValidationException("PineconeClientConfiguration may not be null");
        }
        if (this.connectionConfig == null) {
            throw new PineconeValidationException("PineconeConnectionConfig may not be null");
        }
        this.clientConfig.validate();
        this.connectionConfig.validate();
        if (this.connectionConfig.getIndexName() != null && (this.clientConfig.getEnvironment() == null || this.clientConfig.getProjectName() == null)) {
            throw new PineconeValidationException("Cannot connect with indexName " + this.connectionConfig.getIndexName() + " unless PineconeClientConfig contains projectName and environment");
        }
    }
}

