package org.apache.rocketmq.logging.ch.qos.logback.classic.spi;

import org.apache.rocketmq.logging.org.slf4j.ILoggerFactory;
import org.apache.rocketmq.logging.org.slf4j.IMarkerFactory;
import org.apache.rocketmq.logging.org.slf4j.helpers.BasicMarkerFactory;
import org.apache.rocketmq.logging.org.slf4j.helpers.Util;
import org.apache.rocketmq.logging.org.slf4j.spi.MDCAdapter;
import org.apache.rocketmq.logging.org.slf4j.spi.SLF4JServiceProvider;

import org.apache.rocketmq.logging.ch.qos.logback.classic.LoggerContext;
import org.apache.rocketmq.logging.ch.qos.logback.classic.util.ContextInitializer;
import org.apache.rocketmq.logging.ch.qos.logback.classic.util.LogbackMDCAdapter;
import org.apache.rocketmq.logging.ch.qos.logback.core.CoreConstants;
import org.apache.rocketmq.logging.ch.qos.logback.core.joran.spi.JoranException;
import org.apache.rocketmq.logging.ch.qos.logback.core.status.StatusUtil;
import org.apache.rocketmq.logging.ch.qos.logback.core.util.StatusPrinter;

public class LogbackServiceProvider implements SLF4JServiceProvider {

    final static String NULL_CS_URL = CoreConstants.CODES_URL + "#null_CS";

    /**
     * Declare the version of the SLF4J API this implementation is compiled against.
     * The value of this field is modified with each major release.
     */
    // to avoid constant folding by the compiler, this field must *not* be final
    public static String REQUESTED_API_VERSION = "2.0.99"; // !final

    private LoggerContext defaultLoggerContext;
    private IMarkerFactory markerFactory;
    private MDCAdapter mdcAdapter;
    // private final ContextSelectorStaticBinder contextSelectorBinder =
    // ContextSelectorStaticBinder.getSingleton();
//    private static Object KEY = new Object();
//    private volatile boolean initialized = false;

    @Override
    public void initialize() {
        defaultLoggerContext = new LoggerContext();
        defaultLoggerContext.setName(CoreConstants.DEFAULT_CONTEXT_NAME);
        initializeLoggerContext();
        defaultLoggerContext.start();
        markerFactory = new BasicMarkerFactory();
        mdcAdapter = new LogbackMDCAdapter();
    }

    private void initializeLoggerContext() {
        try {
            try {
                new ContextInitializer(defaultLoggerContext).autoConfig();
            } catch (JoranException je) {
                Util.report("Failed to auto configure default logger context", je);
            }
            // LOGBACK-292
            if (!StatusUtil.contextHasStatusListener(defaultLoggerContext)) {
                StatusPrinter.printInCaseOfErrorsOrWarnings(defaultLoggerContext);
            }
            // contextSelectorBinder.init(defaultLoggerContext, KEY);

        } catch (Exception t) { // see LOGBACK-1159
            Util.report("Failed to instantiate [" + LoggerContext.class.getName() + "]", t);
        }
    }

    @Override

    public ILoggerFactory getLoggerFactory() {
        return defaultLoggerContext;

//        if (!initialized) {
//            return defaultLoggerContext;
//        
//
//        if (contextSelectorBinder.getContextSelector() == null) {
//            throw new IllegalStateException("contextSelector cannot be null. See also " + NULL_CS_URL);
//        }
//        return contextSelectorBinder.getContextSelector().getLoggerContext();
    }

    @Override
    public IMarkerFactory getMarkerFactory() {
        return markerFactory;
    }

    @Override
    public MDCAdapter getMDCAdapter() {
        return mdcAdapter;
    }

    @Override
    public String getRequestedApiVersion() {
        return REQUESTED_API_VERSION;
    }

}
