/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.migration.ddl;

import io.ebean.migration.ddl.DdlRunnerException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;

public class DdlParser {
    public List<String> parse(StringReader reader) {
        try {
            String s;
            BufferedReader br = new BufferedReader(reader);
            StatementsSeparator statements = new StatementsSeparator();
            while ((s = br.readLine()) != null) {
                statements.nextLine(s);
            }
            statements.endOfContent();
            return statements.statements;
        }
        catch (IOException e) {
            throw new DdlRunnerException(e);
        }
    }

    static class StatementsSeparator {
        private static final String EOL = "\n";
        ArrayList<String> statements = new ArrayList();
        boolean trimDelimiter;
        boolean inDbProcedure;
        StringBuilder sb = new StringBuilder();
        int quoteCount;

        StatementsSeparator() {
        }

        void lineContainsDollars(String line) {
            if (this.inDbProcedure) {
                if (this.trimDelimiter) {
                    line = line.replace("$$", "");
                }
                this.endOfStatement(line);
            } else {
                this.trimDelimiter = line.equals("delimiter $$");
                if (!this.trimDelimiter) {
                    this.sb.append(line).append(EOL);
                }
            }
            this.inDbProcedure = !this.inDbProcedure;
        }

        void endOfStatement(String line) {
            this.sb.append(line);
            this.statements.add(this.sb.toString().trim());
            this.quoteCount = 0;
            this.sb = new StringBuilder();
        }

        void nextLine(String line) {
            if (line.contains("$$")) {
                this.lineContainsDollars(line);
                return;
            }
            if (this.inDbProcedure) {
                this.sb.append(line).append(EOL);
                return;
            }
            if (this.sb.length() == 0 && (line.isEmpty() || line.startsWith("--"))) {
                return;
            }
            this.quoteCount += this.countQuotes(line);
            if (this.hasOddQuotes()) {
                this.sb.append(line).append(EOL);
                return;
            }
            int semiPos = line.lastIndexOf(59);
            if (semiPos == -1) {
                this.sb.append(line).append(EOL);
            } else if (semiPos == line.length() - 1) {
                this.endOfStatement(line);
            } else {
                String remaining = line.substring(semiPos + 1).trim();
                if (!remaining.startsWith("--")) {
                    this.sb.append(line).append(EOL);
                    return;
                }
                String preSemi = line.substring(0, semiPos + 1);
                this.endOfStatement(preSemi);
            }
        }

        private boolean hasOddQuotes() {
            return this.quoteCount % 2 == 1;
        }

        private int countQuotes(String content) {
            int count = 0;
            for (int i = 0; i < content.length(); ++i) {
                if (content.charAt(i) != '\'') continue;
                ++count;
            }
            return count;
        }

        void endOfContent() {
            String remaining = this.sb.toString().trim();
            if (remaining.length() > 0) {
                this.statements.add(remaining);
                this.sb = new StringBuilder();
            }
        }
    }
}

