/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql.transforms;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.config.ConfigDef;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.connector.ConnectRecord;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.data.Struct;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.transforms.Transformation;
import io.debezium.config.Configuration;
import io.debezium.data.Envelope;
import io.debezium.transforms.SmtManager;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadToInsertEvent<R extends ConnectRecord<R>>
implements Transformation<R> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReadToInsertEvent.class);
    private SmtManager<R> smtManager;

    @Override
    public R apply(R record) {
        if (((ConnectRecord)record).value() == null || !this.smtManager.isValidEnvelope(record)) {
            return record;
        }
        Struct originalValueStruct = (Struct)((ConnectRecord)record).value();
        String operation = originalValueStruct.getString("op");
        if (!operation.equals(Envelope.Operation.READ.code())) {
            return record;
        }
        Struct updatedValueStruct = originalValueStruct.put("op", (Object)Envelope.Operation.CREATE.code());
        return ((ConnectRecord)record).newRecord(((ConnectRecord)record).topic(), ((ConnectRecord)record).kafkaPartition(), ((ConnectRecord)record).keySchema(), ((ConnectRecord)record).key(), ((ConnectRecord)record).valueSchema(), updatedValueStruct, ((ConnectRecord)record).timestamp());
    }

    @Override
    public ConfigDef config() {
        return new ConfigDef();
    }

    @Override
    public void close() {
    }

    @Override
    public void configure(Map<String, ?> props) {
        Configuration config = Configuration.from(props);
        this.smtManager = new SmtManager(config);
    }
}

