/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql.converters;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.data.SchemaBuilder;
import io.debezium.function.Predicates;
import io.debezium.spi.converter.CustomConverter;
import io.debezium.spi.converter.RelationalColumn;
import io.debezium.util.Strings;
import java.util.Properties;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TinyIntOneToBooleanConverter
implements CustomConverter<SchemaBuilder, RelationalColumn> {
    private static final Boolean FALLBACK = Boolean.FALSE;
    public static final String SELECTOR_PROPERTY = "selector";
    private static final Logger LOGGER = LoggerFactory.getLogger(TinyIntOneToBooleanConverter.class);
    private Predicate<RelationalColumn> selector = x -> true;

    @Override
    public void configure(Properties props) {
        String selectorConfig = props.getProperty(SELECTOR_PROPERTY);
        if (Strings.isNullOrEmpty(selectorConfig)) {
            return;
        }
        this.selector = Predicates.includes(selectorConfig.trim(), x -> x.dataCollection() + "." + x.name());
    }

    @Override
    public void converterFor(RelationalColumn field, CustomConverter.ConverterRegistration<SchemaBuilder> registration) {
        if (!"TINYINT".equalsIgnoreCase(field.typeName()) || field.length().orElse(-1) != 1 || !this.selector.test(field)) {
            return;
        }
        registration.register(SchemaBuilder.bool(), x -> {
            if (x == null) {
                if (field.isOptional()) {
                    return null;
                }
                if (field.hasDefaultValue()) {
                    return field.defaultValue();
                }
                return FALLBACK;
            }
            if (x instanceof Boolean) {
                return x;
            }
            if (x instanceof Number) {
                return ((Number)x).intValue() > 0;
            }
            if (x instanceof String) {
                try {
                    return Integer.parseInt((String)x);
                }
                catch (NumberFormatException e) {
                    return Boolean.parseBoolean((String)x);
                }
            }
            LOGGER.warn("Cannot convert '{}' to boolean", x.getClass());
            return FALLBACK;
        });
    }
}

