/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import com.github.shyiko.mysql.binlog.event.deserialization.json.JsonBinary;
import com.mysql.cj.CharsetMapping;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.data.Decimal;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.data.Field;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.data.SchemaBuilder;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.errors.ConnectException;
import io.debezium.DebeziumException;
import io.debezium.annotation.Immutable;
import io.debezium.config.CommonConnectorConfig;
import io.debezium.connector.mysql.MySqlGeometry;
import io.debezium.connector.mysql.MySqlUnsignedIntegerConverter;
import io.debezium.connector.mysql.antlr.MySqlAntlrDdlParser;
import io.debezium.data.Enum;
import io.debezium.data.EnumSet;
import io.debezium.data.Json;
import io.debezium.data.geometry.Geometry;
import io.debezium.data.geometry.Point;
import io.debezium.jdbc.JdbcValueConverters;
import io.debezium.jdbc.TemporalPrecisionMode;
import io.debezium.relational.Column;
import io.debezium.relational.Table;
import io.debezium.relational.ValueConverter;
import io.debezium.util.Strings;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.LocalDate;
import java.time.Year;
import java.time.ZoneOffset;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAdjuster;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public class MySqlValueConverters
extends JdbcValueConverters {
    private static final Logger LOGGER = LoggerFactory.getLogger(MySqlValueConverters.class);
    private static final Pattern TIME_FIELD_PATTERN = Pattern.compile("(\\-?[0-9]*):([0-9]*):([0-9]*)(\\.([0-9]*))?");
    private static final Pattern DATE_FIELD_PATTERN = Pattern.compile("([0-9]*)-([0-9]*)-([0-9]*)");
    private static final Pattern TIMESTAMP_FIELD_PATTERN = Pattern.compile("([0-9]*)-([0-9]*)-([0-9]*) .*");
    private final ParsingErrorHandler parsingErrorHandler;

    public static Temporal adjustTemporal(Temporal temporal) {
        if (temporal.isSupported(ChronoField.YEAR)) {
            int year = temporal.get(ChronoField.YEAR);
            if (0 <= year && year <= 69) {
                temporal = temporal.plus(2000L, ChronoUnit.YEARS);
            } else if (70 <= year && year <= 99) {
                temporal = temporal.plus(1900L, ChronoUnit.YEARS);
            }
        }
        return temporal;
    }

    public MySqlValueConverters(JdbcValueConverters.DecimalMode decimalMode, TemporalPrecisionMode temporalPrecisionMode, JdbcValueConverters.BigIntUnsignedMode bigIntUnsignedMode, CommonConnectorConfig.BinaryHandlingMode binaryMode) {
        this(decimalMode, temporalPrecisionMode, bigIntUnsignedMode, binaryMode, (Temporal x) -> x, MySqlValueConverters::defaultParsingErrorHandler);
    }

    public MySqlValueConverters(JdbcValueConverters.DecimalMode decimalMode, TemporalPrecisionMode temporalPrecisionMode, JdbcValueConverters.BigIntUnsignedMode bigIntUnsignedMode, CommonConnectorConfig.BinaryHandlingMode binaryMode, TemporalAdjuster adjuster, ParsingErrorHandler parsingErrorHandler) {
        super(decimalMode, temporalPrecisionMode, ZoneOffset.UTC, adjuster, bigIntUnsignedMode, binaryMode);
        this.parsingErrorHandler = parsingErrorHandler;
    }

    @Override
    protected ByteOrder byteOrderOfBitType() {
        return ByteOrder.BIG_ENDIAN;
    }

    @Override
    public SchemaBuilder schemaBuilder(Column column) {
        String typeName = column.typeName().toUpperCase();
        if (this.matches(typeName, "JSON")) {
            return Json.builder();
        }
        if (this.matches(typeName, "POINT")) {
            return Point.builder();
        }
        if (this.matches(typeName, "GEOMETRY") || this.matches(typeName, "LINESTRING") || this.matches(typeName, "POLYGON") || this.matches(typeName, "MULTIPOINT") || this.matches(typeName, "MULTILINESTRING") || this.matches(typeName, "MULTIPOLYGON") || this.isGeometryCollection(typeName)) {
            return Geometry.builder();
        }
        if (this.matches(typeName, "YEAR")) {
            return io.debezium.time.Year.builder();
        }
        if (this.matches(typeName, "ENUM")) {
            String commaSeperatedOptions = this.extractEnumAndSetOptionsAsString(column);
            return Enum.builder(commaSeperatedOptions);
        }
        if (this.matches(typeName, "SET")) {
            String commaSeperatedOptions = this.extractEnumAndSetOptionsAsString(column);
            return EnumSet.builder(commaSeperatedOptions);
        }
        if (this.matches(typeName, "SMALLINT UNSIGNED") || this.matches(typeName, "SMALLINT UNSIGNED ZEROFILL") || this.matches(typeName, "INT2 UNSIGNED") || this.matches(typeName, "INT2 UNSIGNED ZEROFILL")) {
            return SchemaBuilder.int32();
        }
        if (this.matches(typeName, "INT UNSIGNED") || this.matches(typeName, "INT UNSIGNED ZEROFILL") || this.matches(typeName, "INT4 UNSIGNED") || this.matches(typeName, "INT4 UNSIGNED ZEROFILL")) {
            return SchemaBuilder.int64();
        }
        if (this.matches(typeName, "BIGINT UNSIGNED") || this.matches(typeName, "BIGINT UNSIGNED ZEROFILL") || this.matches(typeName, "INT8 UNSIGNED") || this.matches(typeName, "INT8 UNSIGNED ZEROFILL")) {
            switch (this.bigIntUnsignedMode) {
                case LONG: {
                    return SchemaBuilder.int64();
                }
                case PRECISE: {
                    return Decimal.builder(0);
                }
            }
        }
        return super.schemaBuilder(column);
    }

    @Override
    public ValueConverter converter(Column column, Field fieldDefn) {
        String typeName = column.typeName().toUpperCase();
        if (this.matches(typeName, "JSON")) {
            return data -> this.convertJson(column, fieldDefn, data);
        }
        if (this.matches(typeName, "GEOMETRY") || this.matches(typeName, "LINESTRING") || this.matches(typeName, "POLYGON") || this.matches(typeName, "MULTIPOINT") || this.matches(typeName, "MULTILINESTRING") || this.matches(typeName, "MULTIPOLYGON") || this.isGeometryCollection(typeName)) {
            return data -> this.convertGeometry(column, fieldDefn, data);
        }
        if (this.matches(typeName, "POINT")) {
            return data -> this.convertPoint(column, fieldDefn, data);
        }
        if (this.matches(typeName, "YEAR")) {
            return data -> this.convertYearToInt(column, fieldDefn, data);
        }
        if (this.matches(typeName, "ENUM")) {
            List<String> options = this.extractEnumAndSetOptions(column);
            return data -> this.convertEnumToString(options, column, fieldDefn, data);
        }
        if (this.matches(typeName, "SET")) {
            List<String> options = this.extractEnumAndSetOptions(column);
            return data -> this.convertSetToString(options, column, fieldDefn, data);
        }
        if (this.matches(typeName, "TINYINT UNSIGNED") || this.matches(typeName, "TINYINT UNSIGNED ZEROFILL") || this.matches(typeName, "INT1 UNSIGNED") || this.matches(typeName, "INT1 UNSIGNED ZEROFILL")) {
            return data -> this.convertUnsignedTinyint(column, fieldDefn, data);
        }
        if (this.matches(typeName, "SMALLINT UNSIGNED") || this.matches(typeName, "SMALLINT UNSIGNED ZEROFILL") || this.matches(typeName, "INT2 UNSIGNED") || this.matches(typeName, "INT2 UNSIGNED ZEROFILL")) {
            return data -> this.convertUnsignedSmallint(column, fieldDefn, data);
        }
        if (this.matches(typeName, "MEDIUMINT UNSIGNED") || this.matches(typeName, "MEDIUMINT UNSIGNED ZEROFILL") || this.matches(typeName, "INT3 UNSIGNED") || this.matches(typeName, "INT3 UNSIGNED ZEROFILL") || this.matches(typeName, "MIDDLEINT UNSIGNED") || this.matches(typeName, "MIDDLEINT UNSIGNED ZEROFILL")) {
            return data -> this.convertUnsignedMediumint(column, fieldDefn, data);
        }
        if (this.matches(typeName, "INT UNSIGNED") || this.matches(typeName, "INT UNSIGNED ZEROFILL") || this.matches(typeName, "INT4 UNSIGNED") || this.matches(typeName, "INT4 UNSIGNED ZEROFILL")) {
            return data -> this.convertUnsignedInt(column, fieldDefn, data);
        }
        if (this.matches(typeName, "BIGINT UNSIGNED") || this.matches(typeName, "BIGINT UNSIGNED ZEROFILL") || this.matches(typeName, "INT8 UNSIGNED") || this.matches(typeName, "INT8 UNSIGNED ZEROFILL")) {
            switch (this.bigIntUnsignedMode) {
                case LONG: {
                    return data -> this.convertBigInt(column, fieldDefn, data);
                }
                case PRECISE: {
                    return data -> this.convertUnsignedBigint(column, fieldDefn, data);
                }
            }
        }
        switch (column.jdbcType()) {
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: 
            case 70: 
            case 2005: 
            case 2009: 
            case 2011: {
                Charset charset = this.charsetFor(column);
                if (charset != null) {
                    this.logger.debug("Using {} charset by default for column: {}", (Object)charset, (Object)column);
                    return data -> this.convertString(column, fieldDefn, charset, data);
                }
                this.logger.warn("Using UTF-8 charset by default for column without charset: {}", (Object)column);
                return data -> this.convertString(column, fieldDefn, StandardCharsets.UTF_8, data);
            }
            case 92: {
                if (this.adaptiveTimeMicrosecondsPrecisionMode) {
                    return data -> this.convertDurationToMicroseconds(column, fieldDefn, data);
                }
            }
            case 93: {
                return ((ValueConverter)data -> this.convertTimestampToLocalDateTime(column, fieldDefn, data)).and(super.converter(column, fieldDefn));
            }
        }
        return super.converter(column, fieldDefn);
    }

    protected Charset charsetFor(Column column) {
        String mySqlCharsetName = column.charsetName();
        if (mySqlCharsetName == null) {
            this.logger.warn("Column is missing a character set: {}", (Object)column);
            return null;
        }
        String encoding = CharsetMapping.getJavaEncodingForMysqlCharset(mySqlCharsetName);
        if (encoding == null) {
            this.logger.debug("Column uses MySQL character set '{}', which has no mapping to a Java character set, will try it in lowercase", (Object)mySqlCharsetName);
            encoding = CharsetMapping.getJavaEncodingForMysqlCharset(mySqlCharsetName.toLowerCase());
        }
        if (encoding == null) {
            this.logger.warn("Column uses MySQL character set '{}', which has no mapping to a Java character set", (Object)mySqlCharsetName);
        } else {
            try {
                return Charset.forName(encoding);
            }
            catch (IllegalCharsetNameException e) {
                this.logger.error("Unable to load Java charset '{}' for column with MySQL character set '{}'", (Object)encoding, (Object)mySqlCharsetName);
            }
        }
        return null;
    }

    protected Object convertJson(Column column, Field fieldDefn, Object data) {
        return this.convertValue(column, fieldDefn, data, "{}", r -> {
            if (data instanceof byte[]) {
                if (((byte[])data).length == 0) {
                    r.deliver(column.isOptional() ? null : "{}");
                } else {
                    try {
                        r.deliver(JsonBinary.parseAsString((byte[])data));
                    }
                    catch (IOException e) {
                        this.parsingErrorHandler.error("Failed to parse and read a JSON value on '" + column + "' value " + Arrays.toString((byte[])data), e);
                        r.deliver(column.isOptional() ? null : "{}");
                    }
                }
            } else if (data instanceof String) {
                r.deliver(data);
            }
        });
    }

    protected Object convertString(Column column, Field fieldDefn, Charset columnCharset, Object data) {
        return this.convertValue(column, fieldDefn, data, "", r -> {
            if (data instanceof byte[]) {
                r.deliver(new String((byte[])data, columnCharset));
            } else if (data instanceof String) {
                r.deliver(data);
            }
        });
    }

    protected Object convertYearToInt(Column column, Field fieldDefn, Object data) {
        return this.convertValue(column, fieldDefn, data, 0, r -> {
            Object mutData = data;
            if (data instanceof Year) {
                r.deliver(MySqlValueConverters.adjustTemporal(Year.of(((Year)data).getValue())).get(ChronoField.YEAR));
            } else if (data instanceof Date) {
                r.deliver(((Date)data).getYear() + 1900);
            } else if (data instanceof String) {
                mutData = Integer.valueOf((String)data);
            }
            if (mutData instanceof Number) {
                r.deliver(MySqlValueConverters.adjustTemporal(Year.of(((Number)mutData).intValue())).get(ChronoField.YEAR));
            }
        });
    }

    protected Object convertEnumToString(List<String> options, Column column, Field fieldDefn, Object data) {
        return this.convertValue(column, fieldDefn, data, "", r -> {
            if (data instanceof String) {
                r.deliver(data);
            } else if (data instanceof Integer) {
                if (options != null) {
                    int index;
                    int value = (Integer)data;
                    if (value == 0) {
                        r.deliver("");
                    }
                    if ((index = value - 1) < options.size() && index >= 0) {
                        r.deliver(options.get(index));
                    }
                } else {
                    r.deliver(null);
                }
            }
        });
    }

    protected Object convertSetToString(List<String> options, Column column, Field fieldDefn, Object data) {
        return this.convertValue(column, fieldDefn, data, "", r -> {
            if (data instanceof String) {
                r.deliver(data);
            } else if (data instanceof Long) {
                long indexes = (Long)data;
                r.deliver(this.convertSetValue(column, indexes, options));
            }
        });
    }

    protected boolean matches(String upperCaseTypeName, String upperCaseMatch) {
        if (upperCaseTypeName == null) {
            return false;
        }
        return upperCaseMatch.equals(upperCaseTypeName) || upperCaseTypeName.startsWith(upperCaseMatch + "(");
    }

    protected boolean isGeometryCollection(String upperCaseTypeName) {
        if (upperCaseTypeName == null) {
            return false;
        }
        return upperCaseTypeName.equals("GEOMETRYCOLLECTION") || upperCaseTypeName.equals("GEOMCOLLECTION") || upperCaseTypeName.endsWith(".GEOMCOLLECTION");
    }

    protected List<String> extractEnumAndSetOptions(Column column) {
        return MySqlAntlrDdlParser.extractEnumAndSetOptions(column.enumValues());
    }

    protected String extractEnumAndSetOptionsAsString(Column column) {
        return Strings.join((CharSequence)",", this.extractEnumAndSetOptions(column));
    }

    protected String convertSetValue(Column column, long indexes, List<String> options) {
        StringBuilder sb = new StringBuilder();
        int index = 0;
        boolean first = true;
        int optionLen = options.size();
        while (indexes != 0L) {
            if (indexes % 2L != 0L) {
                if (first) {
                    first = false;
                } else {
                    sb.append(',');
                }
                if (index < optionLen) {
                    sb.append(options.get(index));
                } else {
                    this.logger.warn("Found unexpected index '{}' on column {}", (Object)index, (Object)column);
                }
            }
            ++index;
            indexes >>>= 1;
        }
        return sb.toString();
    }

    protected Object convertPoint(Column column, Field fieldDefn, Object data) {
        MySqlGeometry empty = MySqlGeometry.createEmpty();
        return this.convertValue(column, fieldDefn, data, Geometry.createValue(fieldDefn.schema(), empty.getWkb(), empty.getSrid()), r -> {
            if (data instanceof byte[]) {
                MySqlGeometry mySqlGeometry = MySqlGeometry.fromBytes((byte[])data);
                if (mySqlGeometry.isPoint()) {
                    r.deliver(Point.createValue(fieldDefn.schema(), mySqlGeometry.getWkb(), mySqlGeometry.getSrid()));
                } else {
                    throw new ConnectException("Failed to parse and read a value of type POINT on " + column);
                }
            }
        });
    }

    protected Object convertGeometry(Column column, Field fieldDefn, Object data) {
        MySqlGeometry empty = MySqlGeometry.createEmpty();
        return this.convertValue(column, fieldDefn, data, Geometry.createValue(fieldDefn.schema(), empty.getWkb(), empty.getSrid()), r -> {
            if (data instanceof byte[] && data instanceof byte[]) {
                MySqlGeometry mySqlGeometry = MySqlGeometry.fromBytes((byte[])data);
                r.deliver(Geometry.createValue(fieldDefn.schema(), mySqlGeometry.getWkb(), mySqlGeometry.getSrid()));
            }
        });
    }

    @Override
    protected ByteBuffer toByteBuffer(Column column, byte[] data) {
        if (column.jdbcType() == -2 && data.length < column.length()) {
            data = Arrays.copyOf(data, column.length());
        }
        return super.toByteBuffer(column, data);
    }

    protected Object convertUnsignedTinyint(Column column, Field fieldDefn, Object data) {
        return this.convertValue(column, fieldDefn, data, (short)0, r -> {
            if (data instanceof Short) {
                r.deliver(MySqlUnsignedIntegerConverter.convertUnsignedTinyint((Short)data));
            } else if (data instanceof Number) {
                r.deliver(MySqlUnsignedIntegerConverter.convertUnsignedTinyint(((Number)data).shortValue()));
            } else {
                r.deliver(this.convertSmallInt(column, fieldDefn, data));
            }
        });
    }

    protected Object convertUnsignedSmallint(Column column, Field fieldDefn, Object data) {
        return this.convertValue(column, fieldDefn, data, 0, r -> {
            if (data instanceof Integer) {
                r.deliver(MySqlUnsignedIntegerConverter.convertUnsignedSmallint((Integer)data));
            } else if (data instanceof Number) {
                r.deliver(MySqlUnsignedIntegerConverter.convertUnsignedSmallint(((Number)data).intValue()));
            } else {
                r.deliver(this.convertInteger(column, fieldDefn, data));
            }
        });
    }

    protected Object convertUnsignedMediumint(Column column, Field fieldDefn, Object data) {
        return this.convertValue(column, fieldDefn, data, 0, r -> {
            if (data instanceof Integer) {
                r.deliver(MySqlUnsignedIntegerConverter.convertUnsignedMediumint((Integer)data));
            } else if (data instanceof Number) {
                r.deliver(MySqlUnsignedIntegerConverter.convertUnsignedMediumint(((Number)data).intValue()));
            } else {
                r.deliver(this.convertInteger(column, fieldDefn, data));
            }
        });
    }

    protected Object convertUnsignedInt(Column column, Field fieldDefn, Object data) {
        return this.convertValue(column, fieldDefn, data, 0L, r -> {
            if (data instanceof Long) {
                r.deliver(MySqlUnsignedIntegerConverter.convertUnsignedInteger((Long)data));
            } else if (data instanceof Number) {
                r.deliver(MySqlUnsignedIntegerConverter.convertUnsignedInteger(((Number)data).longValue()));
            } else {
                r.deliver(this.convertBigInt(column, fieldDefn, data));
            }
        });
    }

    protected Object convertUnsignedBigint(Column column, Field fieldDefn, Object data) {
        return this.convertValue(column, fieldDefn, data, 0L, r -> {
            if (data instanceof BigDecimal) {
                r.deliver(MySqlUnsignedIntegerConverter.convertUnsignedBigint((BigDecimal)data));
            } else if (data instanceof Number) {
                r.deliver(MySqlUnsignedIntegerConverter.convertUnsignedBigint(new BigDecimal(((Number)data).toString())));
            } else if (data instanceof String) {
                r.deliver(MySqlUnsignedIntegerConverter.convertUnsignedBigint(new BigDecimal((String)data)));
            } else {
                r.deliver(this.convertNumeric(column, fieldDefn, data));
            }
        });
    }

    protected Object convertDurationToMicroseconds(Column column, Field fieldDefn, Object data) {
        return this.convertValue(column, fieldDefn, data, 0L, r -> {
            try {
                if (data instanceof Duration) {
                    r.deliver(((Duration)data).toNanos() / 1000L);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        });
    }

    protected Object convertTimestampToLocalDateTime(Column column, Field fieldDefn, Object data) {
        if (data == null && !fieldDefn.schema().isOptional()) {
            return null;
        }
        if (!(data instanceof Timestamp)) {
            return data;
        }
        return ((Timestamp)data).toLocalDateTime();
    }

    public static Duration stringToDuration(String timeString) {
        Matcher matcher = TIME_FIELD_PATTERN.matcher(timeString);
        if (!matcher.matches()) {
            throw new RuntimeException("Unexpected format for TIME column: " + timeString);
        }
        long hours = Long.parseLong(matcher.group(1));
        long minutes = Long.parseLong(matcher.group(2));
        long seconds = Long.parseLong(matcher.group(3));
        long nanoSeconds = 0L;
        String microSecondsString = matcher.group(5);
        if (microSecondsString != null) {
            nanoSeconds = Long.parseLong(Strings.justifyLeft(microSecondsString, 9, '0'));
        }
        if (hours >= 0L) {
            return Duration.ofHours(hours).plusMinutes(minutes).plusSeconds(seconds).plusNanos(nanoSeconds);
        }
        return Duration.ofHours(hours).minusMinutes(minutes).minusSeconds(seconds).minusNanos(nanoSeconds);
    }

    public static LocalDate stringToLocalDate(String dateString, Column column, Table table) {
        Matcher matcher = DATE_FIELD_PATTERN.matcher(dateString);
        if (!matcher.matches()) {
            throw new RuntimeException("Unexpected format for DATE column: " + dateString);
        }
        int year = Integer.parseInt(matcher.group(1));
        int month = Integer.parseInt(matcher.group(2));
        int day = Integer.parseInt(matcher.group(3));
        if (year == 0 || month == 0 || day == 0) {
            LOGGER.warn("Invalid value '{}' stored in column '{}' of table '{}' converted to empty value", new Object[]{dateString, column.name(), table.id()});
            return null;
        }
        return LocalDate.of(year, month, day);
    }

    public static boolean containsZeroValuesInDatePart(String timestampString, Column column, Table table) {
        Matcher matcher = TIMESTAMP_FIELD_PATTERN.matcher(timestampString);
        if (!matcher.matches()) {
            throw new RuntimeException("Unexpected format for DATE column: " + timestampString);
        }
        int year = Integer.parseInt(matcher.group(1));
        int month = Integer.parseInt(matcher.group(2));
        int day = Integer.parseInt(matcher.group(3));
        if (year == 0 || month == 0 || day == 0) {
            LOGGER.warn("Invalid value '{}' stored in column '{}' of table '{}' converted to empty value", new Object[]{timestampString, column.name(), table.id()});
            return true;
        }
        return false;
    }

    public static void defaultParsingErrorHandler(String message, Exception exception) {
        throw new DebeziumException(message, exception);
    }

    @FunctionalInterface
    public static interface ParsingErrorHandler {
        public void error(String var1, Exception var2);
    }
}

