/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.org.apache.kafka.trogdor.common;

import com.ververica.cdc.connectors.shaded.com.fasterxml.jackson.databind.JsonNode;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.utils.Scheduler;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.utils.Utils;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.trogdor.common.JsonUtil;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.trogdor.common.Node;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.trogdor.common.Topology;
import java.io.File;
import java.io.IOException;

public interface Platform {
    public String name();

    public Node curNode();

    public Topology topology();

    public Scheduler scheduler();

    public String runCommand(String[] var1) throws IOException;

    public static class Config {
        public static final String TROGDOR_AGENT_PORT = "trogdor.agent.port";
        public static final String TROGDOR_COORDINATOR_PORT = "trogdor.coordinator.port";
        public static final String TROGDOR_COORDINATOR_HEARTBEAT_MS = "trogdor.coordinator.heartbeat.ms";
        public static final int TROGDOR_COORDINATOR_HEARTBEAT_MS_DEFAULT = 60000;

        public static Platform parse(String curNodeName, String path) throws Exception {
            JsonNode root = JsonUtil.JSON_SERDE.readTree(new File(path));
            JsonNode platformNode = root.get("platform");
            if (platformNode == null) {
                throw new RuntimeException("Expected to find a 'platform' field in the root JSON configuration object");
            }
            String platformName = platformNode.textValue();
            return (Platform)Utils.newParameterizedInstance(platformName, String.class, curNodeName, Scheduler.class, Scheduler.SYSTEM, JsonNode.class, root);
        }
    }
}

