/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.org.apache.kafka.common.metrics;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.MetricName;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.metrics.CompoundStat;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.metrics.KafkaMetric;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.metrics.MeasurableStat;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.metrics.MetricConfig;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.metrics.Metrics;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.metrics.Quota;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.metrics.QuotaViolationException;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.metrics.Stat;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.metrics.stats.TokenBucket;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.utils.Time;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public final class Sensor {
    private final Metrics registry;
    private final String name;
    private final Sensor[] parents;
    private final List<StatAndConfig> stats;
    private final Map<MetricName, KafkaMetric> metrics;
    private final MetricConfig config;
    private final Time time;
    private volatile long lastRecordTime;
    private final long inactiveSensorExpirationTimeMs;
    private final Object metricLock;
    private final RecordingLevel recordingLevel;

    Sensor(Metrics registry, String name, Sensor[] parents, MetricConfig config, Time time, long inactiveSensorExpirationTimeSeconds, RecordingLevel recordingLevel) {
        this.registry = registry;
        this.name = Objects.requireNonNull(name);
        this.parents = parents == null ? new Sensor[]{} : parents;
        this.metrics = new LinkedHashMap<MetricName, KafkaMetric>();
        this.stats = new ArrayList<StatAndConfig>();
        this.config = config;
        this.time = time;
        this.inactiveSensorExpirationTimeMs = TimeUnit.MILLISECONDS.convert(inactiveSensorExpirationTimeSeconds, TimeUnit.SECONDS);
        this.lastRecordTime = time.milliseconds();
        this.recordingLevel = recordingLevel;
        this.metricLock = new Object();
        this.checkForest(new HashSet<Sensor>());
    }

    private void checkForest(Set<Sensor> sensors) {
        if (!sensors.add(this)) {
            throw new IllegalArgumentException("Circular dependency in sensors: " + this.name() + " is its own parent.");
        }
        for (Sensor parent : this.parents) {
            parent.checkForest(sensors);
        }
    }

    public String name() {
        return this.name;
    }

    List<Sensor> parents() {
        return Collections.unmodifiableList(Arrays.asList(this.parents));
    }

    public boolean shouldRecord() {
        return this.recordingLevel.shouldRecord(this.config.recordLevel().id);
    }

    public void record() {
        if (this.shouldRecord()) {
            this.recordInternal(1.0, this.time.milliseconds(), true);
        }
    }

    public void record(double value) {
        if (this.shouldRecord()) {
            this.recordInternal(value, this.time.milliseconds(), true);
        }
    }

    public void record(double value, long timeMs) {
        if (this.shouldRecord()) {
            this.recordInternal(value, timeMs, true);
        }
    }

    public void record(double value, long timeMs, boolean checkQuotas) {
        if (this.shouldRecord()) {
            this.recordInternal(value, timeMs, checkQuotas);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recordInternal(double value, long timeMs, boolean checkQuotas) {
        this.lastRecordTime = timeMs;
        Sensor[] sensorArray = this;
        synchronized (this) {
            Object object = this.metricLock();
            synchronized (object) {
                for (StatAndConfig statAndConfig : this.stats) {
                    statAndConfig.stat.record(statAndConfig.config(), value, timeMs);
                }
            }
            if (checkQuotas) {
                this.checkQuotas(timeMs);
            }
            // ** MonitorExit[var6_4] (shouldn't be in output)
            for (Sensor parent : this.parents) {
                parent.record(value, timeMs, checkQuotas);
            }
            return;
        }
    }

    public void checkQuotas() {
        this.checkQuotas(this.time.milliseconds());
    }

    public void checkQuotas(long timeMs) {
        for (KafkaMetric metric : this.metrics.values()) {
            Quota quota;
            MetricConfig config = metric.config();
            if (config == null || (quota = config.quota()) == null) continue;
            double value = metric.measurableValue(timeMs);
            if (!(metric.measurable() instanceof TokenBucket ? value < 0.0 : !quota.acceptable(value))) continue;
            throw new QuotaViolationException(metric, value, quota.bound());
        }
    }

    public boolean add(CompoundStat stat) {
        return this.add(stat, null);
    }

    public synchronized boolean add(CompoundStat stat, MetricConfig config) {
        if (this.hasExpired()) {
            return false;
        }
        MetricConfig statConfig = config == null ? this.config : config;
        this.stats.add(new StatAndConfig(Objects.requireNonNull(stat), () -> statConfig));
        Object lock = this.metricLock();
        for (CompoundStat.NamedMeasurable m : stat.stats()) {
            KafkaMetric metric = new KafkaMetric(lock, m.name(), m.stat(), statConfig, this.time);
            if (this.metrics.containsKey(metric.metricName())) continue;
            this.registry.registerMetric(metric);
            this.metrics.put(metric.metricName(), metric);
        }
        return true;
    }

    public boolean add(MetricName metricName, MeasurableStat stat) {
        return this.add(metricName, stat, null);
    }

    public synchronized boolean add(MetricName metricName, MeasurableStat stat, MetricConfig config) {
        if (this.hasExpired()) {
            return false;
        }
        if (this.metrics.containsKey(metricName)) {
            return true;
        }
        MetricConfig statConfig = config == null ? this.config : config;
        KafkaMetric metric = new KafkaMetric(this.metricLock(), Objects.requireNonNull(metricName), Objects.requireNonNull(stat), statConfig, this.time);
        this.registry.registerMetric(metric);
        this.metrics.put(metric.metricName(), metric);
        this.stats.add(new StatAndConfig(Objects.requireNonNull(stat), metric::config));
        return true;
    }

    public synchronized boolean hasMetrics() {
        return !this.metrics.isEmpty();
    }

    public boolean hasExpired() {
        return this.time.milliseconds() - this.lastRecordTime > this.inactiveSensorExpirationTimeMs;
    }

    synchronized List<KafkaMetric> metrics() {
        return Collections.unmodifiableList(new ArrayList<KafkaMetric>(this.metrics.values()));
    }

    private Object metricLock() {
        return this.metricLock;
    }

    public static enum RecordingLevel {
        INFO(0, "INFO"),
        DEBUG(1, "DEBUG"),
        TRACE(2, "TRACE");

        private static final RecordingLevel[] ID_TO_TYPE;
        private static final int MIN_RECORDING_LEVEL_KEY = 0;
        public static final int MAX_RECORDING_LEVEL_KEY;
        public final String name;
        public final short id;

        private RecordingLevel(int id, String name) {
            this.id = (short)id;
            this.name = name;
        }

        public static RecordingLevel forId(int id) {
            if (id < 0 || id > MAX_RECORDING_LEVEL_KEY) {
                throw new IllegalArgumentException(String.format("Unexpected RecordLevel id `%d`, it should be between `%d` and `%d` (inclusive)", id, 0, MAX_RECORDING_LEVEL_KEY));
            }
            return ID_TO_TYPE[id];
        }

        public static RecordingLevel forName(String name) {
            return RecordingLevel.valueOf(name.toUpperCase(Locale.ROOT));
        }

        public boolean shouldRecord(int configId) {
            if (configId == RecordingLevel.INFO.id) {
                return this.id == RecordingLevel.INFO.id;
            }
            if (configId == RecordingLevel.DEBUG.id) {
                return this.id == RecordingLevel.INFO.id || this.id == RecordingLevel.DEBUG.id;
            }
            if (configId == RecordingLevel.TRACE.id) {
                return true;
            }
            throw new IllegalStateException("Did not recognize recording level " + configId);
        }

        static {
            int maxRL = -1;
            for (RecordingLevel level : RecordingLevel.values()) {
                maxRL = Math.max(maxRL, level.id);
            }
            RecordingLevel[] idToName = new RecordingLevel[maxRL + 1];
            RecordingLevel[] recordingLevelArray = RecordingLevel.values();
            int n = recordingLevelArray.length;
            for (int i = 0; i < n; ++i) {
                RecordingLevel level;
                idToName[level.id] = level = recordingLevelArray[i];
            }
            ID_TO_TYPE = idToName;
            MAX_RECORDING_LEVEL_KEY = maxRL;
        }
    }

    private static class StatAndConfig {
        private final Stat stat;
        private final Supplier<MetricConfig> configSupplier;

        StatAndConfig(Stat stat, Supplier<MetricConfig> configSupplier) {
            this.stat = stat;
            this.configSupplier = configSupplier;
        }

        public Stat stat() {
            return this.stat;
        }

        public MetricConfig config() {
            return this.configSupplier.get();
        }
    }
}

