/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.mysql.source.offset;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.errors.ConnectException;
import io.debezium.connector.mysql.GtidSet;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class BinlogOffset
implements Comparable<BinlogOffset>,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String BINLOG_FILENAME_OFFSET_KEY = "file";
    public static final String BINLOG_POSITION_OFFSET_KEY = "pos";
    public static final String EVENTS_TO_SKIP_OFFSET_KEY = "event";
    public static final String ROWS_TO_SKIP_OFFSET_KEY = "row";
    public static final String GTID_SET_KEY = "gtids";
    public static final String TIMESTAMP_KEY = "ts_sec";
    public static final String SERVER_ID_KEY = "server_id";
    public static final BinlogOffset INITIAL_OFFSET = new BinlogOffset("", 0L);
    public static final BinlogOffset NO_STOPPING_OFFSET = new BinlogOffset("", Long.MIN_VALUE);
    private final Map<String, String> offset;

    public BinlogOffset(Map<String, String> offset) {
        this.offset = offset;
    }

    public BinlogOffset(String filename, long position) {
        this(filename, position, 0L, 0L, 0L, null, null);
    }

    public BinlogOffset(String filename, long position, long restartSkipEvents, long restartSkipRows, long binlogEpochSecs, @Nullable String restartGtidSet, @Nullable Integer serverId) {
        HashMap<String, String> offsetMap = new HashMap<String, String>();
        offsetMap.put(BINLOG_FILENAME_OFFSET_KEY, filename);
        offsetMap.put(BINLOG_POSITION_OFFSET_KEY, String.valueOf(position));
        offsetMap.put(EVENTS_TO_SKIP_OFFSET_KEY, String.valueOf(restartSkipEvents));
        offsetMap.put(ROWS_TO_SKIP_OFFSET_KEY, String.valueOf(restartSkipRows));
        offsetMap.put(TIMESTAMP_KEY, String.valueOf(binlogEpochSecs));
        if (restartGtidSet != null) {
            offsetMap.put(GTID_SET_KEY, restartGtidSet);
        }
        if (serverId != null) {
            offsetMap.put(SERVER_ID_KEY, String.valueOf(serverId));
        }
        this.offset = offsetMap;
    }

    public Map<String, String> getOffset() {
        return this.offset;
    }

    public String getFilename() {
        return this.offset.get(BINLOG_FILENAME_OFFSET_KEY);
    }

    public long getPosition() {
        return this.longOffsetValue(this.offset, BINLOG_POSITION_OFFSET_KEY);
    }

    public long getRestartSkipEvents() {
        return this.longOffsetValue(this.offset, EVENTS_TO_SKIP_OFFSET_KEY);
    }

    public long getRestartSkipRows() {
        return this.longOffsetValue(this.offset, ROWS_TO_SKIP_OFFSET_KEY);
    }

    public String getGtidSet() {
        return this.offset.get(GTID_SET_KEY);
    }

    public long getTimestamp() {
        return this.longOffsetValue(this.offset, TIMESTAMP_KEY);
    }

    public Long getServerId() {
        return this.longOffsetValue(this.offset, SERVER_ID_KEY);
    }

    private long longOffsetValue(Map<String, ?> values, String key) {
        Object obj = values.get(key);
        if (obj == null) {
            return 0L;
        }
        if (obj instanceof Number) {
            return ((Number)obj).longValue();
        }
        try {
            return Long.parseLong(obj.toString());
        }
        catch (NumberFormatException e) {
            throw new ConnectException("Source offset '" + key + "' parameter value " + obj + " could not be converted to a long");
        }
    }

    @Override
    public int compareTo(BinlogOffset that) {
        long targetServerId;
        if (NO_STOPPING_OFFSET.equals(that) && NO_STOPPING_OFFSET.equals(this)) {
            return 0;
        }
        if (NO_STOPPING_OFFSET.equals(this)) {
            return 1;
        }
        if (NO_STOPPING_OFFSET.equals(that)) {
            return -1;
        }
        String gtidSetStr = this.getGtidSet();
        String targetGtidSetStr = that.getGtidSet();
        if (StringUtils.isNotEmpty((CharSequence)targetGtidSetStr)) {
            if (StringUtils.isNotEmpty((CharSequence)gtidSetStr)) {
                GtidSet gtidSet = new GtidSet(gtidSetStr);
                GtidSet targetGtidSet = new GtidSet(targetGtidSetStr);
                if (gtidSet.equals(targetGtidSet)) {
                    long restartSkipEvents = this.getRestartSkipEvents();
                    long targetRestartSkipEvents = that.getRestartSkipEvents();
                    return Long.compare(restartSkipEvents, targetRestartSkipEvents);
                }
                return gtidSet.isContainedWithin(targetGtidSet) ? -1 : 1;
            }
            return -1;
        }
        if (StringUtils.isNotEmpty((CharSequence)gtidSetStr)) {
            return 1;
        }
        long serverId = this.getServerId();
        if (serverId != (targetServerId = that.getServerId().longValue())) {
            long timestamp = this.getTimestamp();
            long targetTimestamp = that.getTimestamp();
            return Long.compare(timestamp, targetTimestamp);
        }
        if (this.getFilename().compareToIgnoreCase(that.getFilename()) != 0) {
            return this.getFilename().compareToIgnoreCase(that.getFilename());
        }
        if (this.getPosition() != that.getPosition()) {
            return Long.compare(this.getPosition(), that.getPosition());
        }
        if (this.getRestartSkipEvents() != that.getRestartSkipEvents()) {
            return Long.compare(this.getRestartSkipEvents(), that.getRestartSkipEvents());
        }
        return Long.compare(this.getRestartSkipRows(), that.getRestartSkipRows());
    }

    public boolean isAtOrBefore(BinlogOffset that) {
        return this.compareTo(that) <= 0;
    }

    public boolean isBefore(BinlogOffset that) {
        return this.compareTo(that) < 0;
    }

    public boolean isAtOrAfter(BinlogOffset that) {
        return this.compareTo(that) >= 0;
    }

    public boolean isAfter(BinlogOffset that) {
        return this.compareTo(that) > 0;
    }

    public String toString() {
        return this.offset.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BinlogOffset)) {
            return false;
        }
        BinlogOffset that = (BinlogOffset)o;
        return this.offset.equals(that.offset);
    }

    public int hashCode() {
        return Objects.hashCode(this.offset);
    }
}

