/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.util;

public class RunningStats {
    protected int _numSamples;
    protected double _mean;
    protected double _varianceSum;
    protected double _max = Double.NEGATIVE_INFINITY;
    protected double _min = Double.POSITIVE_INFINITY;

    public void addSample(double sample) {
        ++this._numSamples;
        double deltaToOld = sample - this._mean;
        this._mean += deltaToOld / (double)this._numSamples;
        double deltaToNew = sample - this._mean;
        this._varianceSum += deltaToOld * deltaToNew;
        if (sample < this._min) {
            this._min = sample;
        }
        if (sample > this._max) {
            this._max = sample;
        }
    }

    public double getMin() {
        return this._min;
    }

    public double getMax() {
        return this._max;
    }

    public double getVariance() {
        if (this.getNumSamples() == 0) {
            return 0.0;
        }
        return this._varianceSum / (double)this.getNumSamples();
    }

    public int getNumSamples() {
        return this._numSamples;
    }

    public double getMean() {
        return this._mean;
    }

    public double getStandardDeviation() {
        return Math.sqrt(this.getVariance());
    }
}

