/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.util;

import com.google.common.collect.Maps;
import com.samskivert.util.StringUtil;
import com.threerings.util.Log;
import com.threerings.util.MessageBundle;
import java.util.HashMap;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class MessageManager {
    public static final String GLOBAL_BUNDLE = "global";
    protected String _prefix;
    protected Locale _locale;
    protected ClassLoader _loader;
    protected HashMap<String, MessageBundle> _cache = Maps.newHashMap();
    protected MessageBundle _global;
    protected static final String MBUNDLE_CLASS_KEY = "msgbundle_class";

    public MessageManager(String resourcePrefix) {
        this._prefix = resourcePrefix;
        this._locale = Locale.getDefault();
        Log.log.debug((Object)("Using locale: " + this._locale + "."), new Object[0]);
        if (!this._prefix.endsWith(".")) {
            this._prefix = this._prefix + ".";
        }
        this._global = this.getBundle(GLOBAL_BUNDLE);
    }

    public Locale getLocale() {
        return this._locale;
    }

    public void setLocale(Locale locale) {
        this.setLocale(locale, false);
    }

    public void setLocale(Locale locale, boolean updateGlobal) {
        this._locale = locale;
        this._cache.clear();
        if (updateGlobal) {
            this._global = this.getBundle(GLOBAL_BUNDLE);
        }
    }

    public void setPrefix(String resourcePrefix) {
        this._prefix = resourcePrefix;
        this._global = this.getBundle(GLOBAL_BUNDLE);
    }

    public void setClassLoader(ClassLoader loader) {
        this._loader = loader;
    }

    public MessageBundle getBundle(String path) {
        MessageBundle bundle = this._cache.get(path);
        if (bundle != null) {
            return bundle;
        }
        ResourceBundle rbundle = this.loadBundle(this._prefix + path);
        MessageBundle customBundle = null;
        if (rbundle != null) {
            String mbclass = null;
            try {
                mbclass = rbundle.getString(MBUNDLE_CLASS_KEY).trim();
                if (!StringUtil.isBlank((String)mbclass)) {
                    customBundle = (MessageBundle)Class.forName(mbclass).newInstance();
                }
            }
            catch (MissingResourceException mre) {
            }
            catch (Throwable t) {
                Log.log.warning((Object)"Failure instantiating custom message bundle", new Object[]{"mbclass", mbclass, "error", t});
            }
        }
        bundle = this.createBundle(path, rbundle, customBundle);
        this._cache.put(path, bundle);
        return bundle;
    }

    protected MessageBundle createBundle(String path, ResourceBundle rbundle, MessageBundle customBundle) {
        if (customBundle == null) {
            customBundle = new MessageBundle();
        }
        this.initBundle(customBundle, path, rbundle);
        return customBundle;
    }

    protected void initBundle(MessageBundle bundle, String path, ResourceBundle rbundle) {
        MessageBundle parentBundle = this._global;
        if (rbundle != null) {
            try {
                parentBundle = this.getBundle(rbundle.getString("__parent"));
            }
            catch (MissingResourceException mre) {
                // empty catch block
            }
        }
        bundle.init(this, path, rbundle, parentBundle);
    }

    protected ResourceBundle loadBundle(String path) {
        try {
            if (this._loader != null) {
                return ResourceBundle.getBundle(path, this._locale, this._loader);
            }
            return ResourceBundle.getBundle(path, this._locale);
        }
        catch (MissingResourceException mre) {
            Log.log.warning((Object)"Unable to resolve resource bundle", new Object[]{"path", path, "locale", this._locale, mre});
            return null;
        }
    }
}

